﻿/*
SQLyog Community Edition- MySQL GUI v7.14 
MySQL - 5.1.32-enterprise-gpl-pro : Database - com
*********************************************************************
*/
/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

CREATE DATABASE /*!32312 IF NOT EXISTS*/`com` /*!40100 DEFAULT CHARACTER SET utf8 */;

USE `com`;

/*Table structure for table `COMTNPROGRMLIST` */

CREATE TABLE `COMTNPROGRMLIST` (
  `PROGRM_FILE_NM` varchar(50) NOT NULL DEFAULT '',
  `PROGRM_STRE_PATH` varchar(100) NOT NULL,
  `PROGRM_KOREANNM` varchar(50) DEFAULT NULL,
  `PROGRM_DC` mediumtext,
  `URL` varchar(100) NOT NULL,
  PRIMARY KEY (`PROGRM_FILE_NM`),
  UNIQUE KEY `PROGRMLIST_PK` (`PROGRM_FILE_NM`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNSCHDULINFO` */

CREATE TABLE `COMTNSCHDULINFO` (
  `SCHDUL_ID` varchar(20) NOT NULL,
  `SCHDUL_SE` char(1) DEFAULT NULL,
  `SCHDUL_DEPT_ID` varchar(20) DEFAULT NULL,
  `SCHDUL_KIND_CODE` varchar(20) DEFAULT NULL,
  `SCHDUL_BGNDE` char(12) DEFAULT NULL,
  `SCHDUL_ENDDE` char(12) DEFAULT NULL,
  `SCHDUL_NM` varchar(255) DEFAULT NULL,
  `SCHDUL_CN` varchar(2500) DEFAULT NULL,
  `SCHDUL_PLACE` varchar(255) DEFAULT NULL,
  `SCHDUL_IPCR_CODE` char(1) DEFAULT NULL,
  `SCHDUL_CHARGER_ID` varchar(20) DEFAULT NULL,
  `ATCH_FILE_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `REPTIT_SE_CODE` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`SCHDUL_ID`),
  UNIQUE KEY `COMTNSCHDULINFO_PK` (`SCHDUL_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTCADMINISTCODE` */

CREATE TABLE `COMTCADMINISTCODE` (
  `ADMINIST_ZONE_SE` char(1) NOT NULL,
  `ADMINIST_ZONE_CODE` varchar(10) NOT NULL,
  `ADMINIST_ZONE_NM` varchar(60) DEFAULT NULL,
  `UPPER_ADMINIST_ZONE_CODE` varchar(10) DEFAULT NULL,
  `CREAT_DE` varchar(8) DEFAULT NULL,
  `ABL_DE` varchar(8) DEFAULT NULL,
  `USE_AT` char(1) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`ADMINIST_ZONE_SE`,`ADMINIST_ZONE_CODE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTCCMMNCLCODE` */

CREATE TABLE `COMTCCMMNCLCODE` (
  `CL_CODE` char(3) NOT NULL,
  `CL_CODE_NM` varchar(60) DEFAULT NULL,
  `CL_CODE_DC` varchar(200) DEFAULT NULL,
  `USE_AT` char(1) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`CL_CODE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTCCMMNCODE` */

CREATE TABLE `COMTCCMMNCODE` (
  `CODE_ID` varchar(6) NOT NULL,
  `CODE_ID_NM` varchar(60) DEFAULT NULL,
  `CODE_ID_DC` varchar(200) DEFAULT NULL,
  `CL_CODE` char(3) DEFAULT NULL,
  `USE_AT` char(1) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`CODE_ID`),
  KEY `COMTCCMMNCODE_FK` (`CL_CODE`),
  CONSTRAINT `COMTCCMMNCODE_ibfk_1` FOREIGN KEY (`CL_CODE`) REFERENCES `COMTCCMMNCLCODE` (`CL_CODE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTCCMMNDETAILCODE` */

CREATE TABLE `COMTCCMMNDETAILCODE` (
  `CODE_ID` varchar(6) NOT NULL,
  `CODE` varchar(15) NOT NULL,
  `CODE_NM` varchar(60) DEFAULT NULL,
  `CODE_DC` varchar(200) DEFAULT NULL,
  `USE_AT` char(1) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`CODE_ID`,`CODE`),
  CONSTRAINT `COMTCCMMNDETAILCODE_ibfk_1` FOREIGN KEY (`CODE_ID`) REFERENCES `COMTCCMMNCODE` (`CODE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTCZIP` */

CREATE TABLE `COMTCZIP` (
  `ZIP` char(6) NOT NULL,
  `SN` decimal(6,0) NOT NULL DEFAULT '0',
  `CTPRVN_NM` varchar(20) DEFAULT NULL,
  `SIGNGU_NM` varchar(20) DEFAULT NULL,
  `EMD_NM` varchar(30) DEFAULT NULL,
  `LI_BULD_NM` varchar(60) DEFAULT NULL,
  `LNBR_DONG_HO` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`ZIP`,`SN`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTECOPSEQ` */

CREATE TABLE `COMTECOPSEQ` (
  `table_name` varchar(16) NOT NULL,
  `next_id` decimal(30,0) NOT NULL,
  PRIMARY KEY (`table_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTHCONFMHISTORY` */

CREATE TABLE `COMTHCONFMHISTORY` (
  `CONFM_NUMBER` decimal(8,0) NOT NULL,
  `CONFM_RQESTER_ID` varchar(20) NOT NULL,
  `CONFMER_ID` varchar(20) DEFAULT NULL,
  `CONFM_DE` char(8) DEFAULT NULL,
  `CONFM_TY_CODE` char(4) NOT NULL,
  `CONFM_STTUS_CODE` char(4) NOT NULL,
  `OPERT_TY_CODE` char(4) DEFAULT NULL,
  `OPERT_ID` varchar(20) DEFAULT NULL,
  `TRGET_JOB_TY_CODE` char(3) DEFAULT NULL,
  `TRGET_JOB_ID` char(20) DEFAULT NULL,
  PRIMARY KEY (`CONFM_NUMBER`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTHEMPLYRINFOCHANGEDTLS` */

CREATE TABLE `COMTHEMPLYRINFOCHANGEDTLS` (
  `GROUP_ID` char(20) DEFAULT NULL,
  `ORGNZT_ID` char(20) NOT NULL,
  `EMPLYR_ID` varchar(20) NOT NULL,
  `EMPL_NO` varchar(20) NOT NULL,
  `SEXDSTN_CODE` char(1) DEFAULT NULL,
  `BRTH` char(8) DEFAULT NULL,
  `FXNUM` varchar(15) DEFAULT NULL,
  `HOMEADRES` varchar(100) NOT NULL,
  `HOMEEND_TELNO` varchar(5) DEFAULT NULL,
  `AREA_NO` varchar(5) DEFAULT NULL,
  `DETAIL_ADRES` varchar(100) NOT NULL,
  `ZIP` char(6) NOT NULL,
  `OFFM_TELNO` varchar(15) DEFAULT NULL,
  `MOBLPHON_NO` varchar(15) NOT NULL,
  `EMAIL_ADRES` varchar(50) DEFAULT NULL,
  `HOMEMIDDLE_TELNO` varchar(5) DEFAULT NULL,
  `INSTT_CODE` varchar(15) DEFAULT NULL,
  `EMPLYR_STTUS_CODE` varchar(15) NOT NULL,
  `UNIQ_ID` char(20) DEFAULT NULL,
  `CHANGE_DE` datetime NOT NULL,
  PRIMARY KEY (`EMPLYR_ID`,`CHANGE_DE`),
  KEY `COMTHEMPLYRINFOCHANGEDTLS_FK` (`EMPLYR_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTHPROGRMCHANGEDTLS` */

CREATE TABLE `COMTHPROGRMCHANGEDTLS` (
  `PROGRM_FILE_NM` varchar(50) NOT NULL,
  `RQESTER_NO` decimal(10,0) NOT NULL DEFAULT '0',
  `RQESTER_ID` varchar(20) NOT NULL,
  `CHANGERQESTER_CN` mediumtext,
  `RQESTER_PROCESS_CN` mediumtext,
  `OPETR_ID` varchar(20) DEFAULT NULL,
  `PROCESS_STTUS_CODE` varchar(15) NOT NULL,
  `PROCESS_DE` date DEFAULT NULL,
  `RQESTER_DE` date DEFAULT NULL,
  `RQESTER_SJ` varchar(50) NOT NULL,
  PRIMARY KEY (`PROGRM_FILE_NM`,`RQESTER_NO`),
  UNIQUE KEY `COMTHPROGRMCHANGEDTLS_PK` (`PROGRM_FILE_NM`,`RQESTER_NO`),
  KEY `COMTHPROGRMCHANGEDTLS_FK1` (`PROGRM_FILE_NM`),
  CONSTRAINT `COMTHPROGRMCHANGEDTLS_ibfk_1` FOREIGN KEY (`PROGRM_FILE_NM`) REFERENCES `COMTNPROGRMLIST` (`PROGRM_FILE_NM`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTHSYSHIST` */

CREATE TABLE `COMTHSYSHIST` (
  `HIST_ID` char(20) NOT NULL,
  `FRST_REGISTER_PNTTM` date DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `HIST_SE_CODE` char(6) NOT NULL,
  `HIST_CN` varchar(2500) NOT NULL,
  `SYS_NM` varchar(200) NOT NULL,
  `ATCH_FILE_ID` char(20) DEFAULT NULL,
  PRIMARY KEY (`HIST_ID`),
  UNIQUE KEY `COMTHSYSHIST_PK` (`HIST_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNAUTHORGROUPINFO` */

CREATE TABLE `COMTNAUTHORGROUPINFO` (
  `GROUP_ID` varchar(20) NOT NULL DEFAULT '',
  `GROUP_NM` varchar(50) NOT NULL,
  `GROUP_CREAT_DE` date NOT NULL,
  `GROUP_DC` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`GROUP_ID`),
  UNIQUE KEY `AUTHORGROUPINFO_PK` (`GROUP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNAUTHORINFO` */

CREATE TABLE `COMTNAUTHORINFO` (
  `AUTHOR_CODE` varchar(30) NOT NULL DEFAULT '',
  `AUTHOR_NM` varchar(50) NOT NULL,
  `AUTHOR_DC` varchar(100) DEFAULT NULL,
  `AUTHOR_CREAT_DE` date NOT NULL,
  PRIMARY KEY (`AUTHOR_CODE`),
  KEY `COMTNAUTHORINFO_PK` (`AUTHOR_CODE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNAUTHORROLERELATE` */

CREATE TABLE `COMTNAUTHORROLERELATE` (
  `AUTHOR_CODE` varchar(30) NOT NULL,
  `ROLE_CODE` varchar(50) NOT NULL DEFAULT '',
  `CREAT_DT` date DEFAULT NULL,
  PRIMARY KEY (`AUTHOR_CODE`,`ROLE_CODE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNBBSMASTER` */

CREATE TABLE `COMTNBBSMASTER` (
  `BBS_ID` char(20) NOT NULL,
  `BBS_TY_CODE` char(6) NOT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  `USE_AT` char(1) NOT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `BBS_ATTRB_CODE` char(6) NOT NULL,
  `BBS_NM` varchar(120) NOT NULL,
  `REPLY_POSBL_AT` char(1) DEFAULT NULL,
  `FILE_ATCH_POSBL_AT` char(1) NOT NULL,
  `POSBL_ATCH_FILE_NUMBER` decimal(2,0) NOT NULL,
  `POSBL_ATCH_FILE_SIZE` varchar(8) DEFAULT NULL,
  `BBS_INTRCN` varchar(2400) DEFAULT NULL,
  `TMPLAT_ID` char(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime NOT NULL,
  PRIMARY KEY (`BBS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNBBS` */

CREATE TABLE `COMTNBBS` (
  `NTT_ID` decimal(20,0) NOT NULL,
  `BBS_ID` char(20) NOT NULL,
  `NTCR_ID` varchar(20) DEFAULT NULL,
  `SORT_ORDR` decimal(8,0) DEFAULT NULL,
  `NTCR_NM` varchar(20) DEFAULT NULL,
  `PASSWORD` varchar(2000) DEFAULT NULL,
  `NTT_SJ` varchar(2400) DEFAULT NULL,
  `NTT_CN` mediumtext,
  `INQIRE_CO` decimal(9,0) DEFAULT NULL,
  `USE_AT` char(1) NOT NULL,
  `NTCE_BGNDE` char(8) DEFAULT NULL,
  `NTCE_ENDDE` char(8) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `REPLY_AT` char(1) DEFAULT NULL,
  `PARNTS` decimal(10,0) DEFAULT NULL,
  `NTT_NO` decimal(10,0) DEFAULT NULL,
  `REPLY_LC` decimal(8,0) DEFAULT NULL,
  `ATCH_FILE_ID` char(20) DEFAULT NULL,
  PRIMARY KEY (`NTT_ID`,`BBS_ID`),
  KEY `R_14` (`BBS_ID`),
  CONSTRAINT `COMTNBBS_ibfk_1` FOREIGN KEY (`BBS_ID`) REFERENCES `COMTNBBSMASTER` (`BBS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNBBSUSE` */

CREATE TABLE `COMTNBBSUSE` (
  `FRST_REGISTER_PNTTM` date NOT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `USE_AT` char(1) NOT NULL,
  `REGIST_SE_CODE` char(6) DEFAULT NULL,
  `BBS_ID` char(20) NOT NULL,
  `TRGET_ID` char(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`BBS_ID`,`TRGET_ID`) USING BTREE,
  CONSTRAINT `COMTNBBSUSE_ibfk_1` FOREIGN KEY (`BBS_ID`) REFERENCES `COMTNBBSMASTER` (`BBS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNCLUB` */

CREATE TABLE `COMTNCLUB` (
  `CLB_ID` char(20) NOT NULL,
  `CLB_NM` varchar(120) NOT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  `USE_AT` char(1) NOT NULL,
  `FRST_REGISTER_PNTTM` date NOT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `CLB_INTRCN` varchar(2400) DEFAULT NULL,
  `REGIST_SE_CODE` char(6) DEFAULT NULL,
  `TMPLAT_ID` char(20) DEFAULT NULL,
  `CMMNTY_ID` char(20) NOT NULL,
  PRIMARY KEY (`CLB_ID`,`CMMNTY_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNCLUBUSER` */

CREATE TABLE `COMTNCLUBUSER` (
  `CLB_ID` char(20) NOT NULL,
  `SBSCRB_DE` date DEFAULT NULL,
  `SECSN_DE` char(8) DEFAULT NULL,
  `OPRTR_AT` char(1) NOT NULL,
  `FRST_REGISTER_PNTTM` date NOT NULL,
  `USE_AT` char(1) NOT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `CMMNTY_ID` char(20) NOT NULL,
  `EMPLYR_ID` varchar(20) NOT NULL,
  PRIMARY KEY (`CLB_ID`,`CMMNTY_ID`,`EMPLYR_ID`),
  KEY `R_281` (`EMPLYR_ID`),
  CONSTRAINT `COMTNCLUBUSER_ibfk_1` FOREIGN KEY (`CLB_ID`, `CMMNTY_ID`) REFERENCES `COMTNCLUB` (`CLB_ID`, `CMMNTY_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNCMMNTY` */

CREATE TABLE `COMTNCMMNTY` (
  `CMMNTY_ID` char(20) NOT NULL,
  `CMMNTY_NM` varchar(120) NOT NULL,
  `USE_AT` char(1) NOT NULL,
  `FRST_REGISTER_PNTTM` date NOT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `CMMNTY_INTRCN` varchar(2400) DEFAULT NULL,
  `REGIST_SE_CODE` char(6) DEFAULT NULL,
  `TMPLAT_ID` char(20) DEFAULT NULL,
  PRIMARY KEY (`CMMNTY_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNCMMNTYUSER` */

CREATE TABLE `COMTNCMMNTYUSER` (
  `CMMNTY_ID` char(20) NOT NULL,
  `SBSCRB_DE` date DEFAULT NULL,
  `SECSN_DE` char(8) DEFAULT NULL,
  `MNGR_AT` char(1) NOT NULL,
  `FRST_REGISTER_PNTTM` date NOT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `USE_AT` char(1) DEFAULT NULL,
  `EMPLYR_ID` varchar(20) NOT NULL,
  PRIMARY KEY (`CMMNTY_ID`,`EMPLYR_ID`),
  KEY `R_278` (`EMPLYR_ID`),
  CONSTRAINT `COMTNCMMNTYUSER_ibfk_1` FOREIGN KEY (`CMMNTY_ID`) REFERENCES `COMTNCMMNTY` (`CMMNTY_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNCNSLTLIST` */

CREATE TABLE `COMTNCNSLTLIST` (
  `OTHBC_AT` char(1) DEFAULT NULL,
  `CNSLT_SJ` varchar(250) DEFAULT NULL,
  `CNSLT_CN` varchar(2500) DEFAULT NULL,
  `INQIRE_CO` decimal(10,0) DEFAULT NULL,
  `MANAGT_CN` varchar(2500) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `CNSLT_ID` char(20) NOT NULL,
  `EMAIL_ADRES` varchar(50) DEFAULT NULL,
  `EMAIL_ANSWER_AT` char(1) DEFAULT NULL,
  `QNA_PROCESS_STTUS_CODE` char(1) DEFAULT NULL,
  `WRITNG_PASSWORD` varchar(20) DEFAULT NULL,
  `TELNO` char(18) DEFAULT NULL,
  `MBTLNUM` char(18) DEFAULT NULL,
  `AREA_NO` varchar(5) DEFAULT NULL,
  `MIDDLE_TELNO` varchar(5) DEFAULT NULL,
  `END_TELNO` varchar(5) DEFAULT NULL,
  `FIRST_MOBLPHON_NO` varchar(5) DEFAULT NULL,
  `MIDDLE_MBTLNUM` varchar(5) DEFAULT NULL,
  `END_MBTLNUM` varchar(5) DEFAULT NULL,
  `WRTER_NM` char(18) DEFAULT NULL,
  `WRITNG_DE` datetime DEFAULT NULL,
  `MANAGT_DE` datetime DEFAULT NULL,
  `ATCH_FILE_ID` char(20) DEFAULT NULL,
  PRIMARY KEY (`CNSLT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNCPYRHTINFO` */

CREATE TABLE `COMTNCPYRHTINFO` (
  `CPYRHT_ID` char(20) NOT NULL,
  `CPYRHT_PRTC_POLICY_CN` varchar(2500) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  UNIQUE KEY `COMTNCPYRHTINFO_PK` (`CPYRHT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNDIARYINFO` */

CREATE TABLE `COMTNDIARYINFO` (
  `DIARY_ID` char(20) NOT NULL,
  `SCHDUL_ID` varchar(20) NOT NULL,
  `DIARY_PROCS_PTE` decimal(3,0) DEFAULT NULL,
  `DIARY_NM` varchar(255) DEFAULT NULL,
  `DRCT_MATTER` varchar(2500) DEFAULT NULL,
  `PARTCLR_MATTER` varchar(2500) DEFAULT NULL,
  `ATCH_FILE_ID` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`DIARY_ID`,`SCHDUL_ID`),
  UNIQUE KEY `COMTNDIARYINFO_PK` (`DIARY_ID`,`SCHDUL_ID`),
  KEY `COMTNDIARYINFO_FK1` (`SCHDUL_ID`),
  CONSTRAINT `COMTNDIARYINFO_ibfk_1` FOREIGN KEY (`SCHDUL_ID`) REFERENCES `COMTNSCHDULINFO` (`SCHDUL_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNEMPLYRINFO` */

CREATE TABLE `COMTNEMPLYRINFO` (
  `EMPLYR_ID` varchar(20) NOT NULL,
  `EMPLYR_NM` varchar(60) NOT NULL,
  `PASSWORD` varchar(100) NOT NULL,
  `EMPL_NO` varchar(20) NOT NULL,
  `IHIDNUM` char(13) DEFAULT NULL,
  `SEXDSTN_CODE` char(1) DEFAULT NULL,
  `BRTH` char(8) DEFAULT NULL,
  `FXNUM` varchar(10) DEFAULT NULL,
  `HOMEADRES` varchar(100) NOT NULL,
  `PASSWORD_HINT` varchar(100) DEFAULT NULL,
  `PASSWORD_CNSR` varchar(100) DEFAULT NULL,
  `HOMEEND_TELNO` varchar(5) DEFAULT NULL,
  `AREA_NO` varchar(5) DEFAULT NULL,
  `DETAIL_ADRES` varchar(100) NOT NULL,
  `ZIP` char(6) NOT NULL,
  `OFFM_TELNO` varchar(15) DEFAULT NULL,
  `MOBLPHON_NO` varchar(15) NOT NULL,
  `EMAIL_ADRES` varchar(50) DEFAULT NULL,
  `OFCPS_NM` varchar(50) DEFAULT NULL,
  `HOMEMIDDLE_TELNO` varchar(5) DEFAULT NULL,
  `GROUP_ID` char(20) DEFAULT NULL,
  `ORGNZT_ID` char(20) NOT NULL,
  `INSTT_CODE` varchar(15) DEFAULT NULL,
  `EMPLYR_STTUS_CODE` varchar(15) NOT NULL,
  `SBSCRB_DE` date DEFAULT NULL,
  `UNIQ_ID` char(20) NOT NULL,
  `SUB_DN` varchar(150) DEFAULT NULL,
  PRIMARY KEY (`EMPLYR_ID`),
  UNIQUE KEY `EMPLYRINFO_PK` (`EMPLYR_ID`),
  KEY `EMPLYRINFO_FK1` (`ORGNZT_ID`),
  KEY `EMPLYRINFO_FK2` (`GROUP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNEMPLYRSCRTYESTBS` */

CREATE TABLE `COMTNEMPLYRSCRTYESTBS` (
  `SCRTY_ESTBSTRGET_ID` varchar(20) NOT NULL,
  `MBER_TY_CODE` varchar(15) DEFAULT NULL,
  `AUTHOR_CODE` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`SCRTY_ESTBSTRGET_ID`),
  KEY `FK_COMTNEMPLYRSCRTYESTBS` (`AUTHOR_CODE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNENTRPRSMBER` */

CREATE TABLE `COMTNENTRPRSMBER` (
  `ENTRPRSMBER_ID` varchar(20) NOT NULL,
  `ENTRPRS_SE_CODE` char(15) DEFAULT NULL,
  `BIZRNO` char(10) NOT NULL,
  `JURIRNO` char(13) DEFAULT NULL,
  `CMPNY_NM` varchar(50) NOT NULL,
  `CXFC` varchar(60) DEFAULT NULL,
  `ZIP` char(6) DEFAULT NULL,
  `ADRES` varchar(100) NOT NULL,
  `ENTRPRS_MIDDLE_TELNO` varchar(5) NOT NULL,
  `FXNUM` varchar(15) DEFAULT NULL,
  `INDUTY_CODE` char(15) DEFAULT NULL,
  `APPLCNT_NM` varchar(60) NOT NULL,
  `APPLCNT_IHIDNUM` char(13) DEFAULT NULL,
  `SBSCRB_DE` date NOT NULL,
  `ENTRPRS_MBER_STTUS` varchar(15) DEFAULT NULL,
  `ENTRPRS_MBER_PASSWORD` varchar(100) NOT NULL,
  `ENTRPRS_MBER_PASSWORD_HINT` varchar(100) DEFAULT NULL,
  `ENTRPRS_MBER_PASSWORD_CNSR` varchar(100) DEFAULT NULL,
  `GROUP_ID` char(20) DEFAULT NULL,
  `DETAIL_ADRES` varchar(100) DEFAULT NULL,
  `ENTRPRS_END_TELNO` varchar(5) NOT NULL,
  `AREA_NO` varchar(5) NOT NULL,
  `APPLCNT_EMAIL_ADRES` varchar(50) NOT NULL,
  `UNIQ_ID` char(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNEVENTINFO` */

CREATE TABLE `COMTNEVENTINFO` (
  `EVENT_ID` char(20) NOT NULL,
  `BSNS_YEAR` char(4) DEFAULT NULL,
  `BSNS_CODE` varchar(2) DEFAULT NULL,
  `EVENT_SVC_BEGIN_DE` char(8) DEFAULT NULL,
  `SVC_USE_NMPR_CO` decimal(10,0) DEFAULT NULL,
  `CHARGER_NM` varchar(50) DEFAULT NULL,
  `EVENT_CN` varchar(1000) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `EVENT_SVC_END_DE` char(18) DEFAULT NULL,
  `EVENT_TY_CODE` char(18) DEFAULT NULL,
  `PRPARETG_CN` varchar(2500) DEFAULT NULL,
  `EVENT_CONFM_AT` char(2) DEFAULT NULL,
  `EVENT_CONFM_DE` char(8) DEFAULT NULL,
  UNIQUE KEY `COMTNEVENTINFO_PK` (`EVENT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNEXTRLHRINFO` */

CREATE TABLE `COMTNEXTRLHRINFO` (
  `SEXDSTN_CODE` char(1) DEFAULT NULL,
  `EXTRL_HR_NM` varchar(50) DEFAULT NULL,
  `EMAIL_ADRES` varchar(50) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `OCCP_TY_CODE` varchar(4) DEFAULT NULL,
  `PSITN_INSTT_NM` varchar(100) DEFAULT NULL,
  `EXTRL_HR_ID` char(20) NOT NULL,
  `EVENT_ID` char(20) NOT NULL,
  `BRTH` char(8) DEFAULT NULL,
  `AREA_NO` varchar(5) DEFAULT NULL,
  `MIDDLE_TELNO` varchar(5) DEFAULT NULL,
  `END_TELNO` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`EXTRL_HR_ID`,`EVENT_ID`),
  KEY `COMTNEXTRLHRINFO_FK` (`EVENT_ID`),
  CONSTRAINT `COMTNEXTRLHRINFO_ibfk_1` FOREIGN KEY (`EVENT_ID`) REFERENCES `COMTNEVENTINFO` (`EVENT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNFAQINFO` */

CREATE TABLE `COMTNFAQINFO` (
  `FAQ_ID` char(20) NOT NULL,
  `QESTN_SJ` varchar(1000) DEFAULT NULL,
  `QESTN_CN` varchar(2500) DEFAULT NULL,
  `ANSWER_CN` varchar(2500) DEFAULT NULL,
  `INQIRE_CO` decimal(10,0) DEFAULT NULL,
  `ATCH_FILE_ID` char(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date NOT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  `LAST_UPDUSR_PNTTM` date NOT NULL,
  `LAST_UPDUSR_ID` varchar(20) NOT NULL,
  PRIMARY KEY (`FAQ_ID`),
  UNIQUE KEY `COMTNFAQINFO_PK` (`FAQ_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNFILE` */

CREATE TABLE `COMTNFILE` (
  `ATCH_FILE_ID` varchar(20) NOT NULL,
  `CREAT_DT` date NOT NULL,
  `USE_AT` char(1) DEFAULT NULL,
  PRIMARY KEY (`ATCH_FILE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNFILEDETAIL` */

CREATE TABLE `COMTNFILEDETAIL` (
  `ATCH_FILE_ID` varchar(20) NOT NULL,
  `FILE_SN` varchar(10) NOT NULL,
  `FILE_STRE_COURS` varchar(2000) NOT NULL,
  `STRE_FILE_NM` varchar(255) NOT NULL,
  `ORIGNL_FILE_NM` varchar(255) DEFAULT NULL,
  `FILE_EXTSN` varchar(20) NOT NULL,
  `FILE_MG` decimal(8,0) DEFAULT NULL,
  `FILE_CN` mediumtext,
  PRIMARY KEY (`ATCH_FILE_ID`,`FILE_SN`),
  CONSTRAINT `COMTNFILEDETAIL_ibfk_1` FOREIGN KEY (`ATCH_FILE_ID`) REFERENCES `COMTNFILE` (`ATCH_FILE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNGNRLMBER` */

CREATE TABLE `COMTNGNRLMBER` (
  `PASSWORD` varchar(100) NOT NULL,
  `PASSWORD_HINT` varchar(100) DEFAULT NULL,
  `PASSWORD_CNSR` varchar(100) DEFAULT NULL,
  `IHIDNUM` char(13) DEFAULT NULL,
  `MBER_NM` varchar(60) NOT NULL,
  `ZIP` char(6) NOT NULL,
  `ADRES` varchar(100) NOT NULL,
  `AREA_NO` varchar(5) DEFAULT NULL,
  `MBER_STTUS` varchar(15) DEFAULT NULL,
  `DETAIL_ADRES` varchar(100) NOT NULL,
  `END_TELNO` varchar(5) DEFAULT NULL,
  `MBER_ID` varchar(20) NOT NULL DEFAULT '',
  `MOBLPHON_NO` varchar(15) NOT NULL,
  `GROUP_ID` char(20) DEFAULT NULL,
  `MBER_FXNUM` varchar(10) DEFAULT NULL,
  `MBER_EMAIL_ADRES` varchar(50) DEFAULT NULL,
  `MIDDLE_TELNO` varchar(5) DEFAULT NULL,
  `SBSCRB_DE` date DEFAULT NULL,
  `SEXDSTN_CODE` char(1) DEFAULT NULL,
  `UNIQ_ID` char(20) NOT NULL,
  PRIMARY KEY (`MBER_ID`),
  UNIQUE KEY `GNRLMBER_PK` (`MBER_ID`),
  KEY `GNRLMBER_FK1` (`GROUP_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNHPCMINFO` */

CREATE TABLE `COMTNHPCMINFO` (
  `HPCM_ID` char(20) NOT NULL,
  `HPCM_SE_CODE` char(1) DEFAULT NULL,
  `HPCM_DF` varchar(1000) DEFAULT NULL,
  `HPCM_DC` varchar(2500) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`HPCM_ID`),
  UNIQUE KEY `COMTNHPCMINFO_PK` (`HPCM_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNLOGINLOG` */

CREATE TABLE `COMTNLOGINLOG` (
  `LOG_ID` char(20) NOT NULL,
  `LOGIN_ID` varchar(20) DEFAULT NULL,
  `LOGIN_IP` varchar(128) DEFAULT NULL,
  `LOGIN_MTHD` char(4) DEFAULT NULL,
  `ERR_OCCRR_AT` char(1) DEFAULT NULL,
  `ERROR_CODE` char(3) DEFAULT NULL,
  `CREAT_DT` date DEFAULT NULL,
  PRIMARY KEY (`LOG_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNMENUCREATDTLS` */

CREATE TABLE `COMTNMENUCREATDTLS` (
  `AUTHOR_CODE` varchar(30) NOT NULL,
  `MENU_NO` decimal(20,0) NOT NULL,
  `MAPCREAT_ID` char(30) DEFAULT NULL,
  PRIMARY KEY (`AUTHOR_CODE`,`MENU_NO`),
  CONSTRAINT `R_303` FOREIGN KEY (`AUTHOR_CODE`) REFERENCES `COMTNAUTHORINFO` (`AUTHOR_CODE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNMENUINFO` */

CREATE TABLE `COMTNMENUINFO` (
  `MENU_NM` varchar(50) NOT NULL,
  `UPPER_MENU_NO` decimal(20,0) DEFAULT NULL,
  `MENU_NO` decimal(20,0) NOT NULL DEFAULT '0',
  `MENU_ORDR` decimal(20,0) NOT NULL,
  `MENU_DC` varchar(100) DEFAULT NULL,
  `RELATE_IMAGE_PATH` varchar(100) DEFAULT NULL,
  `RELATE_IMAGE_NM` varchar(50) DEFAULT NULL,
  `PROGRM_FILE_NM` varchar(50) NOT NULL,
  PRIMARY KEY (`MENU_NO`),
  UNIQUE KEY `MENUINFO_PK` (`MENU_NO`),
  KEY `MENUINFO_FK2` (`UPPER_MENU_NO`),
  KEY `COMTNMENUINFO_ibfk_1` (`PROGRM_FILE_NM`),
  CONSTRAINT `COMTNMENUINFO_ibfk_1` FOREIGN KEY (`PROGRM_FILE_NM`) REFERENCES `COMTNPROGRMLIST` (`PROGRM_FILE_NM`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNMTGINFO` */

CREATE TABLE `COMTNMTGINFO` (
  `MTG_ID` char(20) NOT NULL,
  `MTG_NM` varchar(250) DEFAULT NULL,
  `MTG_MTR_CN` varchar(1000) DEFAULT NULL,
  `MTG_SN` decimal(10,0) DEFAULT NULL,
  `MTG_CO` decimal(5,0) DEFAULT NULL,
  `MTG_DE` char(8) DEFAULT NULL,
  `MTG_PLACE` varchar(250) DEFAULT NULL,
  `MTG_BEGIN_TIME` char(14) DEFAULT NULL,
  `MTG_END_TIME` char(14) DEFAULT NULL,
  `CLSDR_MTG_AT` char(1) DEFAULT NULL,
  `READNG_BEGIN_DE` char(8) DEFAULT NULL,
  `READNG_AT` char(1) DEFAULT NULL,
  `MTG_RESULT_CN` varchar(1000) DEFAULT NULL,
  `MTG_RESULT_ENNC` char(1) DEFAULT NULL,
  `ETC_MATTER` varchar(1000) DEFAULT NULL,
  `MNGT_DEPT_ID` varchar(20) DEFAULT NULL,
  `MNAER_ID` varchar(20) DEFAULT NULL,
  `MNAER_DEPT_ID` varchar(20) DEFAULT NULL,
  `MTN_AT` char(1) DEFAULT NULL,
  `NONATDRN_CO` decimal(10,0) DEFAULT NULL,
  `ATDRN_CO` decimal(10,0) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`MTG_ID`),
  UNIQUE KEY `COMTNMTGINFO_PK` (`MTG_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNNCRD` */

CREATE TABLE `COMTNNCRD` (
  `NCRD_ID` char(20) NOT NULL,
  `NCRD_TRGTER_ID` varchar(20) DEFAULT NULL,
  `NM` varchar(50) NOT NULL,
  `TELNO` varchar(20) DEFAULT NULL,
  `EMAIL_ADRES` varchar(50) DEFAULT NULL,
  `ADRES` varchar(100) DEFAULT NULL,
  `OFCPS_NM` varchar(50) DEFAULT NULL,
  `CLSF_NM` varchar(50) DEFAULT NULL,
  `CMPNY_NM` varchar(50) DEFAULT NULL,
  `DEPT_NM` varchar(50) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date NOT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `REMARK` varchar(2500) DEFAULT NULL,
  `EXTRL_USER_AT` char(1) NOT NULL,
  `MBTLNUM` varchar(20) DEFAULT NULL,
  `DETAIL_ADRES` varchar(100) DEFAULT NULL,
  `NATION_NO` varchar(10) DEFAULT NULL,
  `AREA_NO` varchar(5) DEFAULT NULL,
  `MIDDLE_TELNO` varchar(5) DEFAULT NULL,
  `END_TELNO` varchar(5) DEFAULT NULL,
  `IDNTFC_NO` varchar(10) DEFAULT NULL,
  `MIDDLE_MBTLNUM` varchar(10) DEFAULT NULL,
  `END_MBTLNUM` varchar(10) DEFAULT NULL,
  `OTHBC_AT` char(1) NOT NULL,
  PRIMARY KEY (`NCRD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNNCRDUSER` */

CREATE TABLE `COMTNNCRDUSER` (
  `NCRD_ID` varchar(20) NOT NULL,
  `CREAT_DT` date NOT NULL,
  `REGIST_SE_CODE` char(6) NOT NULL,
  `USE_AT` char(1) NOT NULL,
  `EMPLYR_ID` varchar(20) NOT NULL,
  PRIMARY KEY (`NCRD_ID`,`EMPLYR_ID`),
  CONSTRAINT `COMTNNCRDUSER_ibfk_1` FOREIGN KEY (`NCRD_ID`) REFERENCES `COMTNNCRD` (`NCRD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNNEWSINFO` */

CREATE TABLE `COMTNNEWSINFO` (
  `NEWS_ID` char(20) NOT NULL,
  `NEWS_SJ` varchar(100) DEFAULT NULL,
  `NEWS_CN` varchar(2500) DEFAULT NULL,
  `NEWS_ORIGIN` varchar(250) DEFAULT NULL,
  `NTCE_DE` char(8) DEFAULT NULL,
  `ATCH_FILE_ID` char(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date NOT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  `LAST_UPDUSR_PNTTM` date NOT NULL,
  `LAST_UPDUSR_ID` varchar(20) NOT NULL,
  PRIMARY KEY (`NEWS_ID`),
  UNIQUE KEY `COMTNNEWSINFO_PK` (`NEWS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNNTTSTATS` */

CREATE TABLE `COMTNNTTSTATS` (
  `NTCE_CO` decimal(10,0) DEFAULT NULL,
  `AVRG_RDCNT` decimal(10,0) DEFAULT NULL,
  `TOP_RDCNT` decimal(10,0) DEFAULT NULL,
  `MUMM_RDCNT` decimal(10,0) DEFAULT NULL,
  `TOP_NTCEPERSON__ID` varchar(20) DEFAULT NULL,
  `STATS_ID` char(18) NOT NULL DEFAULT '',
  PRIMARY KEY (`STATS_ID`),
  UNIQUE KEY `NTTSTATS_PK` (`STATS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNORGNZTINFO` */

CREATE TABLE `COMTNORGNZTINFO` (
  `ORGNZT_ID` char(20) NOT NULL DEFAULT '',
  `ORGNZT_NM` varchar(20) NOT NULL,
  `ORGNZT_DC` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`ORGNZT_ID`),
  UNIQUE KEY `ORGNZTINFO_PK` (`ORGNZT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNQAINFO` */

CREATE TABLE `COMTNQAINFO` (
  `QA_ID` char(20) NOT NULL,
  `QESTN_SJ` varchar(250) DEFAULT NULL,
  `QESTN_CN` varchar(2500) DEFAULT NULL,
  `WRITNG_DE` char(8) DEFAULT NULL,
  `INQIRE_CO` decimal(10,0) DEFAULT NULL,
  `AREA_NO` varchar(5) DEFAULT NULL,
  `MIDDLE_TELNO` varchar(5) DEFAULT NULL,
  `END_TELNO` varchar(5) DEFAULT NULL,
  `EMAIL_ADRES` varchar(100) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `WRTER_NM` varchar(20) DEFAULT NULL,
  `ANSWER_CN` varchar(2500) DEFAULT NULL,
  `WRITNG_PASSWORD` varchar(20) DEFAULT NULL,
  `ANSWER_DE` char(8) DEFAULT NULL,
  `EMAIL_ANSWER_AT` char(1) DEFAULT NULL,
  `QNA_PROCESS_STTUS_CODE` char(1) DEFAULT NULL,
  PRIMARY KEY (`QA_ID`),
  UNIQUE KEY `COMTNQAINFO_PK` (`QA_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNQUSTNRTMPLAT` */

CREATE TABLE `COMTNQUSTNRTMPLAT` (
  `QESTNR_TMPLAT_ID` char(20) NOT NULL,
  `QESTNR_TMPLAT_TY` varchar(100) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `QESTNR_TMPLAT_IMAGE` blob,
  `QESTNR_TMPLAT_CN` varchar(2000) DEFAULT NULL,
  `QESTNR_TMPLAT_COURS` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`QESTNR_TMPLAT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNQESTNRINFO` */

CREATE TABLE `COMTNQESTNRINFO` (
  `QESTNR_ID` char(20) NOT NULL,
  `QESTNR_SJ` varchar(250) DEFAULT NULL,
  `QESTNR_PURPS` varchar(1000) DEFAULT NULL,
  `QESTNR_WRITNG_GUIDANCE_CN` varchar(2000) DEFAULT NULL,
  `QESTNR_BEGIN_DE` char(8) DEFAULT NULL,
  `QESTNR_END_DE` char(8) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `QESTNR_TRGET` varchar(1000) DEFAULT NULL,
  `QESTNR_TMPLAT_ID` char(20) NOT NULL,
  PRIMARY KEY (`QESTNR_ID`,`QESTNR_TMPLAT_ID`),
  KEY `COMTNQESTNRINFO_FK` (`QESTNR_TMPLAT_ID`),
  CONSTRAINT `COMTNQESTNRINFO_ibfk_1` FOREIGN KEY (`QESTNR_TMPLAT_ID`) REFERENCES `COMTNQUSTNRTMPLAT` (`QESTNR_TMPLAT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNQUSTNRQESITM` */

CREATE TABLE `COMTNQUSTNRQESITM` (
  `QESTNR_QESITM_ID` char(20) NOT NULL,
  `QESTNR_ID` char(20) NOT NULL,
  `FRST_REGISTER_PNTTM` datetime NOT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `QESTN_SN` decimal(10,0) DEFAULT NULL,
  `QESTN_TY_CODE` char(1) DEFAULT NULL,
  `QESTN_CN` varchar(2500) DEFAULT NULL,
  `MXMM_CHOISE_CO` decimal(5,0) DEFAULT NULL,
  `QESTNR_TMPLAT_ID` char(20) NOT NULL,
  PRIMARY KEY (`QESTNR_ID`,`QESTNR_QESITM_ID`,`QESTNR_TMPLAT_ID`),
  KEY `COMTNQUSTNRQESITM_FK` (`QESTNR_ID`,`QESTNR_TMPLAT_ID`),
  CONSTRAINT `COMTNQUSTNRQESITM_ibfk_1` FOREIGN KEY (`QESTNR_ID`, `QESTNR_TMPLAT_ID`) REFERENCES `COMTNQESTNRINFO` (`QESTNR_ID`, `QESTNR_TMPLAT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNQUSTNRIEM` */

CREATE TABLE `COMTNQUSTNRIEM` (
  `QESTNR_QESITM_ID` char(20) NOT NULL,
  `QESTNR_ID` char(20) NOT NULL,
  `IEM_SN` decimal(5,0) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `QUSTNR_IEM_ID` char(20) NOT NULL DEFAULT '',
  `IEM_CN` varchar(1000) DEFAULT NULL,
  `ETC_ANSWER_AT` char(1) DEFAULT NULL,
  `QESTNR_TMPLAT_ID` char(20) NOT NULL,
  PRIMARY KEY (`QESTNR_TMPLAT_ID`,`QESTNR_ID`,`QESTNR_QESITM_ID`,`QUSTNR_IEM_ID`),
  KEY `COMTNQUSTNRIEM_FK` (`QESTNR_QESITM_ID`,`QESTNR_ID`,`QESTNR_TMPLAT_ID`),
  KEY `R_9` (`QESTNR_ID`,`QESTNR_QESITM_ID`,`QESTNR_TMPLAT_ID`),
  CONSTRAINT `COMTNQUSTNRIEM_ibfk_1` FOREIGN KEY (`QESTNR_ID`, `QESTNR_QESITM_ID`, `QESTNR_TMPLAT_ID`) REFERENCES `COMTNQUSTNRQESITM` (`QESTNR_ID`, `QESTNR_QESITM_ID`, `QESTNR_TMPLAT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNQUSTNRRESPONDINFO` */

CREATE TABLE `COMTNQUSTNRRESPONDINFO` (
  `QESTNR_ID` char(20) NOT NULL,
  `QESTNR_RESPOND_ID` char(20) NOT NULL,
  `SEXDSTN_CODE` char(1) DEFAULT NULL,
  `OCCP_TY_CODE` varchar(250) DEFAULT NULL,
  `RESPOND_NM` varchar(50) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `QESTNR_TMPLAT_ID` char(20) NOT NULL,
  `BRTH` char(8) DEFAULT NULL,
  `AREA_NO` varchar(5) DEFAULT NULL,
  `MIDDLE_TELNO` varchar(5) DEFAULT NULL,
  `END_TELNO` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`QESTNR_TMPLAT_ID`,`QESTNR_ID`,`QESTNR_RESPOND_ID`),
  KEY `COMTNQUSTNRRESPONDINFO_FK` (`QESTNR_ID`,`QESTNR_TMPLAT_ID`),
  CONSTRAINT `COMTNQUSTNRRESPONDINFO_ibfk_1` FOREIGN KEY (`QESTNR_ID`, `QESTNR_TMPLAT_ID`) REFERENCES `COMTNQESTNRINFO` (`QESTNR_ID`, `QESTNR_TMPLAT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNQUSTNRRSPNSRESULT` */

CREATE TABLE `COMTNQUSTNRRSPNSRESULT` (
  `QESTNR_QESITM_ID` char(20) NOT NULL,
  `QESTNR_ID` char(20) NOT NULL,
  `RESPOND_ANSWER_CN` varchar(1000) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `RESPOND_NM` varchar(50) DEFAULT NULL,
  `ETC_ANSWER_CN` varchar(1000) DEFAULT NULL,
  `QESTNR_TMPLAT_ID` char(20) NOT NULL,
  `QUSTNR_IEM_ID` char(20) DEFAULT NULL,
  `QESTNR_QESRSPNS_ID` char(20) NOT NULL,
  KEY `COMTNQUSTNRRSPNSRESULT_FK` (`QESTNR_QESITM_ID`,`QESTNR_ID`,`QESTNR_TMPLAT_ID`,`QUSTNR_IEM_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNRECOMENDSITEINFO` */

CREATE TABLE `COMTNRECOMENDSITEINFO` (
  `RECOMEND_SITE_ID` char(20) NOT NULL,
  `RECOMEND_SITE_URL` varchar(250) DEFAULT NULL,
  `RECOMEND_SITE_NM` varchar(100) DEFAULT NULL,
  `RECOMEND_SITE_DC` varchar(1000) DEFAULT NULL,
  `RECOMEND_RESN_CN` varchar(1000) DEFAULT NULL,
  `RECOMEND_CONFM_AT` char(1) DEFAULT NULL,
  `CONFM_DE` char(8) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`RECOMEND_SITE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNRESTDE` */

CREATE TABLE `COMTNRESTDE` (
  `RESTDE_NO` decimal(6,0) NOT NULL DEFAULT '0',
  `RESTDE_DE` char(8) CHARACTER SET latin1 DEFAULT NULL,
  `RESTDE_NM` varchar(50) DEFAULT NULL,
  `RESTDE_DC` varchar(200) DEFAULT NULL,
  `RESTDE_SE_CODE` varchar(2) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`RESTDE_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNROLEINFO` */

CREATE TABLE `COMTNROLEINFO` (
  `ROLE_CODE` varchar(50) NOT NULL,
  `ROLE_NM` varchar(50) DEFAULT NULL,
  `ROLE_PTN` varchar(300) DEFAULT NULL,
  `ROLE_DC` varchar(100) DEFAULT NULL,
  `ROLE_TYP` varchar(50) DEFAULT NULL,
  `ROLE_SORT` int(11) DEFAULT NULL,
  `ROLE_CREAT_DE` date DEFAULT NULL,
  PRIMARY KEY (`ROLE_CODE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNROLES_HIERARCHY` */

CREATE TABLE `COMTNROLES_HIERARCHY` (
  `PARENT_ROLE` varchar(30) NOT NULL,
  `CHILD_ROLE` varchar(30) NOT NULL,
  PRIMARY KEY (`PARENT_ROLE`,`CHILD_ROLE`),
  KEY `FK_ROLES2` (`CHILD_ROLE`),
  CONSTRAINT `FK_ROLES1` FOREIGN KEY (`PARENT_ROLE`) REFERENCES `COMTNAUTHORINFO` (`AUTHOR_CODE`),
  CONSTRAINT `FK_ROLES2` FOREIGN KEY (`CHILD_ROLE`) REFERENCES `COMTNAUTHORINFO` (`AUTHOR_CODE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNSITELIST` */

CREATE TABLE `COMTNSITELIST` (
  `SITE_URL` varchar(100) DEFAULT NULL,
  `SITE_ID` char(20) NOT NULL,
  `SITE_NM` varchar(100) DEFAULT NULL,
  `SITE_DC` varchar(1000) DEFAULT NULL,
  `SITE_THEMA_CL_CODE` varchar(2) DEFAULT NULL,
  `ACTVTY_AT` char(1) DEFAULT NULL,
  `USE_AT` char(1) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` datetime DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` datetime DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`SITE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNSITEMAP` */

CREATE TABLE `COMTNSITEMAP` (
  `MAPCREAT_ID` char(35) NOT NULL DEFAULT '',
  `CREAT_OPERTOR_ID` varchar(20) NOT NULL,
  `MAP_FILE_NM` varchar(50) NOT NULL,
  `MAP_FILE_PATH` varchar(100) NOT NULL,
  PRIMARY KEY (`MAPCREAT_ID`),
  UNIQUE KEY `SITEMAP_PK` (`MAPCREAT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNSTPLATINFO` */

CREATE TABLE `COMTNSTPLATINFO` (
  `USE_STPLAT_ID` char(20) NOT NULL,
  `INFO_PROVD_AGRE_CN` mediumtext,
  `USE_STPLAT_CN` mediumtext,
  `FRST_REGISTER_PNTTM` date DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `USE_STPLAT_NM` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`USE_STPLAT_ID`),
  UNIQUE KEY `COMTNSTPLATINFO_PK` (`USE_STPLAT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNSYSLOG` */

CREATE TABLE `COMTNSYSLOG` (
  `REQUST_ID` char(20) NOT NULL,
  `JOB_SE_CODE` char(3) DEFAULT NULL,
  `OCCRRNC_DE` char(8) DEFAULT NULL,
  `SRVC_NM` varchar(200) DEFAULT NULL,
  `METHOD_NM` varchar(200) DEFAULT NULL,
  `PROCESS_SE_CODE` char(3) DEFAULT NULL,
  `PROCESS_CO` decimal(10,0) DEFAULT NULL,
  `PROCESS_TIME` varchar(10) DEFAULT NULL,
  `ERROR_SE` char(1) DEFAULT NULL,
  `ERROR_CODE` char(3) DEFAULT NULL,
  `ERROR_CO` decimal(10,0) DEFAULT NULL,
  `RSPNS_CODE` char(3) DEFAULT NULL,
  `INSTT_CODE` char(7) DEFAULT NULL,
  `TRGET_MENU_NM` varchar(200) DEFAULT NULL,
  `RQESTER_IP` varchar(128) DEFAULT NULL,
  `RQESTER_ID` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`REQUST_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNTMPLATINFO` */

CREATE TABLE `COMTNTMPLATINFO` (
  `TMPLAT_ID` char(20) NOT NULL,
  `TMPLAT_NM` varchar(120) DEFAULT NULL,
  `TMPLAT_COURS` varchar(2000) DEFAULT NULL,
  `USE_AT` char(1) NOT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  `FRST_REGISTER_PNTTM` date NOT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  `TMPLAT_SE_CODE` char(6) DEFAULT NULL,
  PRIMARY KEY (`TMPLAT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNTRSMRCVLOG` */

CREATE TABLE `COMTNTRSMRCVLOG` (
  `REQUST_ID` char(20) NOT NULL,
  `OCCRRNC_DE` char(8) DEFAULT NULL,
  `TRSMRCV_SE_CODE` char(3) DEFAULT NULL,
  `INTEG_ID` char(8) DEFAULT NULL,
  `PROVD_INSTT_ID` char(8) DEFAULT NULL,
  `PROVD_SYS_ID` char(8) DEFAULT NULL,
  `PROVD_SVC_ID` char(8) DEFAULT NULL,
  `REQUST_INSTT_ID` char(8) DEFAULT NULL,
  `REQUST_SYS_ID` char(8) DEFAULT NULL,
  `REQUST_TRNSMIT_TM` char(14) DEFAULT NULL,
  `REQUST_RECPTN_TM` char(14) DEFAULT NULL,
  `RSPNS_TRNSMIT_TM` char(14) DEFAULT NULL,
  `RSPNS_RECPTN_TM` char(14) DEFAULT NULL,
  `RESULT_CODE` char(4) DEFAULT NULL,
  `RESULT_MESSAGE` varchar(4000) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date DEFAULT NULL,
  `RQESTER_ID` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`REQUST_ID`),
  UNIQUE KEY `COMTNTRSMRCVLOG_PK` (`REQUST_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNUSERLOG` */

CREATE TABLE `COMTNUSERLOG` (
  `OCCRRNC_DE` char(8) NOT NULL,
  `RQESTER_ID` varchar(20) NOT NULL,
  `SRVC_NM` varchar(200) NOT NULL,
  `METHOD_NM` varchar(200) NOT NULL,
  `CREAT_CO` decimal(10,0) DEFAULT NULL,
  `UPDT_CO` decimal(10,0) DEFAULT NULL,
  `INQIRE_CO` decimal(10,0) DEFAULT NULL,
  `DELETE_CO` decimal(10,0) DEFAULT NULL,
  `OUTPT_CO` decimal(10,0) DEFAULT NULL,
  `ERROR_CO` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`OCCRRNC_DE`,`RQESTER_ID`,`SRVC_NM`,`METHOD_NM`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNWEBLOG` */

CREATE TABLE `COMTNWEBLOG` (
  `REQUST_ID` char(20) NOT NULL,
  `OCCRRNC_DE` char(8) DEFAULT NULL,
  `URL` varchar(100) DEFAULT NULL,
  `RQESTER_IP` varchar(128) DEFAULT NULL,
  `RQESTER_ID` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`REQUST_ID`),
  KEY `COMTNEWBLOG_PK` (`REQUST_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='웹로그';

/*Table structure for table `COMTNWORDDICARYINFO` */

CREATE TABLE `COMTNWORDDICARYINFO` (
  `WORD_ID` char(20) NOT NULL,
  `WORD_NM` varchar(250) DEFAULT NULL,
  `ENG_NM` varchar(60) DEFAULT NULL,
  `WORD_DC` varchar(2500) DEFAULT NULL,
  `SYNONM` varchar(100) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date DEFAULT NULL,
  `FRST_REGISTER_ID` varchar(20) DEFAULT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`WORD_ID`),
  UNIQUE KEY `COMTNWORDDICARYINFO_PK` (`WORD_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTSBBSSUMMARY` */

CREATE TABLE `COMTSBBSSUMMARY` (
  `OCCRRNC_DE` char(8) NOT NULL,
  `STATS_SE` varchar(10) NOT NULL,
  `STATS_DETAIL_SE` varchar(10) NOT NULL,
  `CREAT_CO` decimal(10,0) DEFAULT NULL,
  `TOT_INQIRE_CO` decimal(10,0) DEFAULT NULL,
  `AVRG_INQIRE_CO` decimal(10,0) DEFAULT NULL,
  `MXMM_INQIRE_BBS_ID` varchar(20) DEFAULT NULL,
  `MUMM_INQIRE_BBS_ID` varchar(20) DEFAULT NULL,
  `TOP_NTCEPERSON_ID` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`OCCRRNC_DE`,`STATS_SE`,`STATS_DETAIL_SE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTSSYSLOGSUMMARY` */

CREATE TABLE `COMTSSYSLOGSUMMARY` (
  `OCCRRNC_DE` char(8) NOT NULL,
  `SRVC_NM` varchar(200) NOT NULL,
  `METHOD_NM` varchar(200) NOT NULL,
  `CREAT_CO` decimal(10,0) DEFAULT NULL,
  `UPDT_CO` decimal(10,0) DEFAULT NULL,
  `INQIRE_CO` decimal(10,0) DEFAULT NULL,
  `DELETE_CO` decimal(10,0) DEFAULT NULL,
  `OUTPT_CO` decimal(10,0) DEFAULT NULL,
  `ERROR_CO` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`OCCRRNC_DE`,`SRVC_NM`,`METHOD_NM`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTSTRSMRCVLOGSUMMARY` */

CREATE TABLE `COMTSTRSMRCVLOGSUMMARY` (
  `OCCRRNC_DE` char(8) NOT NULL,
  `TRSMRCV_SE_CODE` char(3) NOT NULL,
  `PROVD_INSTT_ID` char(8) NOT NULL,
  `PROVD_SYS_ID` char(8) NOT NULL,
  `PROVD_SVC_ID` char(8) NOT NULL,
  `REQUST_INSTT_ID` char(8) NOT NULL,
  `REQUST_SYS_ID` char(8) NOT NULL,
  `INQIRE_CO` decimal(10,0) DEFAULT NULL,
  `ERROR_CO` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`OCCRRNC_DE`,`TRSMRCV_SE_CODE`,`PROVD_INSTT_ID`,`PROVD_SYS_ID`,`PROVD_SVC_ID`,`REQUST_INSTT_ID`,`REQUST_SYS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTSUSERSUMMARY` */

CREATE TABLE `COMTSUSERSUMMARY` (
  `OCCRRNC_DE` char(8) NOT NULL,
  `STATS_SE` varchar(10) NOT NULL,
  `STATS_DETAIL_SE` varchar(10) NOT NULL,
  `USER_CO` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`OCCRRNC_DE`,`STATS_SE`,`STATS_DETAIL_SE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTSWEBLOGSUMMARY` */

CREATE TABLE `COMTSWEBLOGSUMMARY` (
  `OCCRRNC_DE` char(8) NOT NULL,
  `URL` varchar(100) NOT NULL,
  `INQIRE_CO` decimal(10,0) DEFAULT NULL,
  PRIMARY KEY (`OCCRRNC_DE`,`URL`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTHEMAILDSPTCHMANAGE` */

CREATE TABLE `COMTHEMAILDSPTCHMANAGE` (
  `MSSAGE_ID` char(20) NOT NULL DEFAULT '',
  `DSPTCHPERSON` varchar(40) NOT NULL,
  `RECPTNPERSON` varchar(40) NOT NULL,
  `SJ` varchar(50) NOT NULL,
  `SNDNG_RESULT_CODE` varchar(15) DEFAULT NULL,
  `EMAIL_CN` mediumtext,
  `SNDNG_DE` date NOT NULL,
  `ATCH_FILE_ID` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`MSSAGE_ID`),
  UNIQUE KEY `COMTHEMAILDSPTCHMANAGE_PK` (`MSSAGE_ID`),
  KEY `COMTHEMAILDSPTCHMANAGE_FK1` (`DSPTCHPERSON`),
  KEY `COMTHEMAILDSPTCHMANAGE_FK2` (`ATCH_FILE_ID`),
  CONSTRAINT `COMTHEMAILDSPTCHMANAGE_ibfk_1` FOREIGN KEY (`DSPTCHPERSON`) REFERENCES `COMTNEMPLYRINFO` (`EMPLYR_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `COMTNANSWER` */

CREATE TABLE `COMTNANSWER` (
  `NTT_ID` decimal(20,0) NOT NULL,
  `BBS_ID` char(20) NOT NULL,
  `WRTER_ID` varchar(20) DEFAULT NULL,
  `ANSWER_CN` varchar(1000) DEFAULT NULL,
  `USE_AT` char(1) NOT NULL,
  `WRTER_NM` varchar(20) DEFAULT NULL,
  `FRST_REGISTER_PNTTM` date NOT NULL,
  `FRST_REGISTER_ID` varchar(20) NOT NULL,
  `LAST_UPDUSR_PNTTM` date DEFAULT NULL,
  `LAST_UPDUSR_ID` varchar(20) DEFAULT NULL,
  `ANSWER_NO` decimal(9,0) NOT NULL,
  PRIMARY KEY (`NTT_ID`,`BBS_ID`,`ANSWER_NO`),
  CONSTRAINT `COMTNANSWER_ibfk_1` FOREIGN KEY (`NTT_ID`, `BBS_ID`) REFERENCES `COMTNBBS` (`NTT_ID`, `BBS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `IDS` */

CREATE TABLE `IDS` (
  `TABLE_NAME` varchar(16) NOT NULL,
  `NEXT_ID` decimal(30,0) NOT NULL,
  PRIMARY KEY (`TABLE_NAME`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `IMGTEMP` */

CREATE TABLE `IMGTEMP` (
  `ORG_CODE` varchar(7) NOT NULL DEFAULT '',
  `ERNCSL_SE` varchar(2) NOT NULL DEFAULT '',
  `IMG_INFO` mediumblob NOT NULL,
  `IMG_TYPE` varchar(16) DEFAULT NULL,
  PRIMARY KEY (`ORG_CODE`,`ERNCSL_SE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


/*View structure for table `COMVNUSERMASTER` */
DROP VIEW IF EXISTS `COMVNUSERMASTER`;
CREATE VIEW `COMVNUSERMASTER` AS select `COMTNGNRLMBER`.`UNIQ_ID` AS `UNIQ_ID`,`COMTNGNRLMBER`.`MBER_ID` AS `USER_ID`,`COMTNGNRLMBER`.`PASSWORD` AS `PASSWORD`,`COMTNGNRLMBER`.`MBER_NM` AS `USER_NM`,`COMTNGNRLMBER`.`ZIP` AS `USER_ZIP`,`COMTNGNRLMBER`.`ADRES` AS `USER_ADRES`,`COMTNGNRLMBER`.`MBER_EMAIL_ADRES` AS `USER_EMAIL`,'GNR' AS `USER_SE`,'' AS `ORGNZT_ID` from `COMTNGNRLMBER` union all select `COMTNENTRPRSMBER`.`UNIQ_ID` AS `UNIQ_ID`,`COMTNENTRPRSMBER`.`ENTRPRSMBER_ID` AS `ENTRPRSMBER_ID`,`COMTNENTRPRSMBER`.`ENTRPRS_MBER_PASSWORD` AS `ENTRPRS_MBER_PASSWORD`,`COMTNENTRPRSMBER`.`CMPNY_NM` AS `CMPNY_NM`,`COMTNENTRPRSMBER`.`ZIP` AS `ZIP`,`COMTNENTRPRSMBER`.`ADRES` AS `ADRES`,`COMTNENTRPRSMBER`.`APPLCNT_EMAIL_ADRES` AS `APPLCNT_EMAIL_ADRES`,'ENT' AS `USER_SE`,'' AS `ORGNZT_ID` from `COMTNENTRPRSMBER` union all select `COMTNEMPLYRINFO`.`UNIQ_ID` AS `UNIQ_ID`,`COMTNEMPLYRINFO`.`EMPLYR_ID` AS `EMPLYR_ID`,`COMTNEMPLYRINFO`.`PASSWORD` AS `PASSWORD`,`COMTNEMPLYRINFO`.`EMPLYR_NM` AS `EMPLYR_NM`,`COMTNEMPLYRINFO`.`ZIP` AS `ZIP`,`COMTNEMPLYRINFO`.`HOMEADRES` AS `HOMEADRES`,`COMTNEMPLYRINFO`.`EMAIL_ADRES` AS `EMAIL_ADRES`,'USR' AS `USER_SE`,`COMTNEMPLYRINFO`.`ORGNZT_ID` AS `ORGNZT_ID` from `COMTNEMPLYRINFO` order by `UNIQ_ID`; 

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;