
CREATE TABLE COMTNSYSTEMCNTC
(
  CNTC_ID              CHAR(8 BYTE)             NOT NULL,
  CNTC_NM              VARCHAR2(300 BYTE),
  PROVD_INSTT_ID       CHAR(8 BYTE),
  PROVD_SYS_ID         CHAR(8 BYTE),
  PROVD_SVC_ID         CHAR(8 BYTE),
  REQUST_INSTT_ID      CHAR(8 BYTE),
  REQUST_SYS_ID        CHAR(8 BYTE),
  CONFM_AT             CHAR(1 BYTE),
  USE_AT               CHAR(1 BYTE),
  VALID_BEGIN_DE       CHAR(8 BYTE),
  VALID_END_DE         CHAR(8 BYTE),
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE,
  CNTC_TYPE            VARCHAR2(180 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNINSTTCODERECPTNLOG
(
  OCCRR_DE             CHAR(8 BYTE)             NOT NULL,
  INSTT_CODE           CHAR(7 BYTE)             NOT NULL,
  OPERT_SN             INTEGER                  NOT NULL,
  CHANGE_SE_CODE       VARCHAR2(2 BYTE),
  PROCESS_SE           VARCHAR2(2 BYTE),
  ETC_CODE             CHAR(2 BYTE),
  ALL_INSTT_NM         VARCHAR2(765 BYTE),
  LOWEST_INSTT_NM      VARCHAR2(300 BYTE),
  INSTT_ABRV_NM        VARCHAR2(180 BYTE),
  ODR                  CHAR(1 BYTE),
  ORD                  CHAR(3 BYTE),
  INSTT_ODR            CHAR(2 BYTE),
  UPPER_INSTT_CODE     CHAR(7 BYTE),
  BEST_INSTT_CODE      CHAR(7 BYTE),
  REPRSNT_INSTT_CODE   CHAR(7 BYTE),
  INSTT_TY_LCLAS       CHAR(2 BYTE),
  INSTT_TY_MCLAS       CHAR(2 BYTE),
  INSTT_TY_SCLAS       CHAR(2 BYTE),
  TELNO                VARCHAR2(20 BYTE),
  FXNUM                VARCHAR2(20 BYTE),
  CREAT_DE             CHAR(8 BYTE),
  ABL_DE               CHAR(8 BYTE),
  ABL_ENNC             CHAR(1 BYTE),
  CHANGEDE             CHAR(8 BYTE),
  CHANGE_TIME          VARCHAR2(6 BYTE),
  BSIS_DE              CHAR(8 BYTE),
  SORT_ORDR            NUMBER(8),
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNINSTTCODE
(
  INSTT_CODE           CHAR(7 BYTE)             NOT NULL,
  ALL_INSTT_NM         VARCHAR2(765 BYTE),
  LOWEST_INSTT_NM      VARCHAR2(300 BYTE),
  INSTT_ABRV_NM        VARCHAR2(180 BYTE),
  ODR                  CHAR(1 BYTE),
  ORD                  CHAR(3 BYTE),
  INSTT_ODR            CHAR(2 BYTE),
  UPPER_INSTT_CODE     CHAR(7 BYTE),
  BEST_INSTT_CODE      CHAR(7 BYTE),
  REPRSNT_INSTT_CODE   CHAR(7 BYTE),
  INSTT_TY_LCLAS       CHAR(2 BYTE),
  INSTT_TY_MCLAS       CHAR(2 BYTE),
  INSTT_TY_SCLAS       CHAR(2 BYTE),
  TELNO                VARCHAR2(20 BYTE),
  FXNUM                VARCHAR2(20 BYTE),
  CREAT_DE             CHAR(8 BYTE),
  ABL_DE               CHAR(8 BYTE),
  ABL_ENNC             CHAR(1 BYTE),
  CHANGEDE             CHAR(8 BYTE),
  CHANGE_TIME          VARCHAR2(6 BYTE),
  BSIS_DE              CHAR(8 BYTE),
  SORT_ORDR            NUMBER(8),
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNCNTCMESSAGE
(
  CNTC_MESSAGE_ID        VARCHAR2(20 BYTE)      NOT NULL,
  CNTC_MESSAGE_NM        VARCHAR2(300 BYTE),
  UPPER_CNTC_MESSAGE_ID  VARCHAR2(20 BYTE),
  USE_AT                 CHAR(1 BYTE),
  FRST_REGISTER_ID       VARCHAR2(20 BYTE),
  FRST_REGISTER_PNTTM    DATE,
  LAST_UPDUSR_ID         VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM      DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNCNTCINSTT
(
  INSTT_ID             VARCHAR2(20 BYTE)        NOT NULL,
  INSTT_NM             VARCHAR2(300 BYTE),
  USE_AT               CHAR(1 BYTE),
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTCADMINISTCODERECPTNLOG
(
  OCCRR_DE                 CHAR(8 BYTE)         NOT NULL,
  ADMINIST_ZONE_SE         CHAR(1 BYTE)         NOT NULL,
  ADMINIST_ZONE_CODE       VARCHAR2(10 BYTE)    NOT NULL,
  OPERT_SN                 INTEGER              NOT NULL,
  CHANGE_SE_CODE           VARCHAR2(2 BYTE),
  PROCESS_SE               VARCHAR2(2 BYTE),
  ADMINIST_ZONE_NM         VARCHAR2(180 BYTE),
  LOWEST_ADMINIST_ZONE_NM  VARCHAR2(180 BYTE),
  CTPRVN_CODE              VARCHAR2(2 BYTE),
  SIGNGU_CODE              VARCHAR2(3 BYTE),
  EMD_CODE                 VARCHAR2(3 BYTE),
  LI_CODE                  VARCHAR2(2 BYTE),
  CREAT_DE                 CHAR(8 BYTE),
  ABL_DE                   CHAR(8 BYTE),
  ABL_ENNC                 CHAR(1 BYTE),
  FRST_REGISTER_ID         VARCHAR2(20 BYTE),
  FRST_REGISTER_PNTTM      DATE,
  LAST_UPDUSR_ID           VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM        DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNADBK
(
  ADBKUSER_ID  CHAR(20 BYTE)                    NOT NULL,
  ADBK_ID      CHAR(20 BYTE),
  EMPLYR_ID    VARCHAR2(20 CHAR),
  NCRD_ID      CHAR(20 BYTE),
  NM           VARCHAR2(20 CHAR),
  EMAIL_ADRES  VARCHAR2(50 CHAR),
  HOME_TELNO   VARCHAR2(15 CHAR),
  MOBLPHON_NO  VARCHAR2(15 CHAR),
  FXNUM        VARCHAR2(15 CHAR),
  OFFM_TELNO   VARCHAR2(15 CHAR)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNBKMKMENUMANAGERESULT
(
  MENU_ID           NUMBER(20)                  NOT NULL,
  EMPLYR_ID         VARCHAR2(20 CHAR)           NOT NULL,
  MENU_NM           VARCHAR2(60 CHAR)           NOT NULL,
  PROGRM_STRE_PATH  VARCHAR2(100 CHAR)          NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNADBKMANAGE
(
  ADBK_ID              CHAR(20 BYTE)            NOT NULL,
  ADBK_NM              VARCHAR2(50 CHAR)        NOT NULL,
  OTHBC_SCOPE          VARCHAR2(20 CHAR)        NOT NULL,
  USE_AT               CHAR(1 BYTE)             NOT NULL,
  WRTER_ID             VARCHAR2(20 CHAR),
  TRGET_ORGNZT_ID      CHAR(20 BYTE),
  FRST_REGISTER_PNTTM  DATE                     NOT NULL,
  LAST_UPDUSR_PNTTM    DATE,
  FRST_REGISTER_ID     VARCHAR2(20 CHAR)        NOT NULL,
  LAST_UPDUSR_ID       VARCHAR2(20 CHAR)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNONLINEPOLLRESULT
(
  POLL_ID              CHAR(20 BYTE)            NOT NULL,
  POLL_IEM_ID          CHAR(20 BYTE)            NOT NULL,
  POLL_RESULT_ID       CHAR(20 BYTE)            NOT NULL,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNONLINEPOLLMANAGE
(
  POLL_ID              CHAR(20 BYTE)            NOT NULL,
  POLL_NM              VARCHAR2(255 CHAR),
  POLL_BEGIN_DE        DATE,
  POLL_END_DE          DATE,
  POLL_KIND_CODE       CHAR(3 BYTE),
  POLL_DSUSE_YN        CHAR(1 BYTE),
  POLL_AUTO_DSUSE_YN   CHAR(1 BYTE),
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNONLINEPOLLITEM
(
  POLL_ID              CHAR(20 BYTE)            NOT NULL,
  POLL_IEM_ID          CHAR(20 BYTE)            NOT NULL,
  POLL_IEM_NM          VARCHAR2(255 CHAR),
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNRECENTSRCHWRD
(
  SRCHWRD_MANAGE_ID    CHAR(20 BYTE)            NOT NULL,
  SRCHWRD_ID           CHAR(20 BYTE)            NOT NULL,
  SRCHWRD_NM           CHAR(255 CHAR)           NOT NULL,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNRECENTSRCHWRDMANAGE
(
  SRCHWRD_MANAGE_ID      CHAR(20 BYTE)          NOT NULL,
  SRCHWRD_MANAGE_NM      VARCHAR2(255 CHAR)     NOT NULL,
  SRCHWRD_MANAGE_URL     VARCHAR2(255 BYTE)     NOT NULL,
  SRCHWRD_MANAGE_USE_YN  CHAR(1 BYTE)           NOT NULL,
  FRST_REGISTER_ID       VARCHAR2(20 BYTE),
  FRST_REGISTER_PNTTM    DATE,
  LAST_UPDUSR_ID         VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM      DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNPOPUPMANAGE
(
  POPUP_ID             VARCHAR2(20 BYTE)        NOT NULL,
  POPUP_TITLE_NM       VARCHAR2(1024 CHAR)      DEFAULT NULL,
  FILE_URL             VARCHAR2(1024 BYTE)      DEFAULT NULL,
  POPUP_HLC            VARCHAR2(10 BYTE)        DEFAULT NULL,
  POPUP_WLC            VARCHAR2(10 BYTE)        DEFAULT NULL,
  POPUP_HSIZE          VARCHAR2(10 BYTE)        DEFAULT NULL,
  POPUP_WSIZE          VARCHAR2(10 BYTE)        DEFAULT NULL,
  NTCE_BGNDE           VARCHAR2(12 BYTE)        DEFAULT NULL,
  NTCE_ENDDE           VARCHAR2(12 BYTE)        DEFAULT NULL,
  STOP_VEW_AT          CHAR(1 BYTE)             DEFAULT NULL,
  NTCE_AT              CHAR(1 BYTE)             DEFAULT NULL,
  FRST_REGISTER_PNTTM  DATE                     DEFAULT NULL,
  FRST_REGISTER_ID     CHAR(20 BYTE)            DEFAULT NULL,
  LAST_UPDUSR_PNTTM    DATE                     DEFAULT NULL,
  LAST_UPDUSR_ID       CHAR(20 BYTE)            DEFAULT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNUNITYLINK
(
  UNITY_LINK_ID        CHAR(20 BYTE)            NOT NULL,
  UNITY_LINK_SE_CODE   CHAR(3 BYTE)             NOT NULL,
  UNITY_LINK_NM        VARCHAR2(255 CHAR),
  UNITY_LINK_URL       VARCHAR2(255 CHAR),
  UNITY_LINK_DC        VARCHAR2(2500 CHAR),
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNONLINEMANUAL
(
  ONLINE_MNL_ID        CHAR(20 BYTE)            NOT NULL,
  ONLINE_MNL_NM        VARCHAR2(255 CHAR)       NOT NULL,
  ONLINE_MNL_SE_CODE   CHAR(3 BYTE),
  ONLINE_MNL_DF        CLOB,
  ONLINE_MNL_DC        CLOB,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNINDVDLINFOPOLICY
(
  INDVDL_INFO_ID       CHAR(20 BYTE)            NOT NULL,
  INDVDL_INFO_NM       VARCHAR2(255 CHAR)       NOT NULL,
  INDVDL_INFO_DC       VARCHAR2(2500 BYTE),
  INDVDL_INFO_YN       CHAR(1 BYTE),
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNADMINISTRATIONWORD
(
  ADMINIST_WORD_ID      CHAR(20 BYTE)           NOT NULL,
  ADMINIST_WORD_NM      VARCHAR2(255 CHAR),
  ADMINIST_WORD_ENG_NM  VARCHAR2(255 CHAR),
  ADMINIST_WORD_ABRV    VARCHAR2(255 CHAR),
  THEMA_RELM            VARCHAR2(255 CHAR),
  WORD_DOMN             VARCHAR2(255 CHAR),
  STD_WORD              VARCHAR2(255 CHAR),
  ADMINIST_WORD_DF      VARCHAR2(2500 CHAR),
  ADMINIST_WORD_DC      VARCHAR2(2500 CHAR),
  FRST_REGISTER_ID      VARCHAR2(20 BYTE),
  FRST_REGISTER_PNTTM   DATE,
  LAST_UPDUSR_ID        VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM     DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNREPRTSTATS
(
  REPRT_ID             CHAR(6 BYTE)             NOT NULL,
  REPRT_NM             VARCHAR2(20 CHAR),
  REPRT_TY             CHAR(2 BYTE),
  REPRT_STTUS          CHAR(2 BYTE),
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE COMTNREPRTSTATS IS '';

COMMENT ON COLUMN COMTNREPRTSTATS.REPRT_ID IS 'ID';

COMMENT ON COLUMN COMTNREPRTSTATS.REPRT_NM IS '';

COMMENT ON COLUMN COMTNREPRTSTATS.REPRT_TY IS '';

COMMENT ON COLUMN COMTNREPRTSTATS.REPRT_STTUS IS 'Ȳ';

COMMENT ON COLUMN COMTNREPRTSTATS.FRST_REGISTER_ID IS 'ʵID';

COMMENT ON COLUMN COMTNREPRTSTATS.FRST_REGISTER_PNTTM IS 'ʵϽ';

COMMENT ON COLUMN COMTNREPRTSTATS.LAST_UPDUSR_ID IS 'ID';

COMMENT ON COLUMN COMTNREPRTSTATS.LAST_UPDUSR_PNTTM IS '';


CREATE TABLE COMTNINTNETSVC
(
  INTNET_SVC_ID        CHAR(20 BYTE)            NOT NULL,
  INTNET_SVC_NM        VARCHAR2(20 CHAR),
  INTNET_SVC_DC        VARCHAR2(2000 BYTE),
  REFLCT_AT            CHAR(1 BYTE),
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE COMTNINTNETSVC IS 'ͳݼ';

COMMENT ON COLUMN COMTNINTNETSVC.INTNET_SVC_ID IS 'ͳݼID';

COMMENT ON COLUMN COMTNINTNETSVC.INTNET_SVC_NM IS 'ͳݼ񽺸';

COMMENT ON COLUMN COMTNINTNETSVC.INTNET_SVC_DC IS 'ͳݼ񽺼';

COMMENT ON COLUMN COMTNINTNETSVC.REFLCT_AT IS 'ݿ';

COMMENT ON COLUMN COMTNINTNETSVC.FRST_REGISTER_ID IS 'ʵID';

COMMENT ON COLUMN COMTNINTNETSVC.FRST_REGISTER_PNTTM IS 'ʵϽ';

COMMENT ON COLUMN COMTNINTNETSVC.LAST_UPDUSR_ID IS 'ID';

COMMENT ON COLUMN COMTNINTNETSVC.LAST_UPDUSR_PNTTM IS '';


CREATE TABLE COMTNMAINIMAGE
(
  IMAGE_ID             CHAR(20 BYTE)            NOT NULL,
  IMAGE_NM             VARCHAR2(20 CHAR),
  IMAGE                VARCHAR2(60 CHAR),
  IMAGE_FILE           VARCHAR2(60 CHAR),
  IMAGE_DC             VARCHAR2(200 CHAR),
  REFLCT_AT            CHAR(1 BYTE),
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE COMTNMAINIMAGE IS '̹';

COMMENT ON COLUMN COMTNMAINIMAGE.IMAGE_ID IS '̹ID';

COMMENT ON COLUMN COMTNMAINIMAGE.IMAGE_NM IS '̹';

COMMENT ON COLUMN COMTNMAINIMAGE.IMAGE IS '̹';

COMMENT ON COLUMN COMTNMAINIMAGE.IMAGE_FILE IS '̹';

COMMENT ON COLUMN COMTNMAINIMAGE.IMAGE_DC IS '̹';

COMMENT ON COLUMN COMTNMAINIMAGE.REFLCT_AT IS 'ݿ';

COMMENT ON COLUMN COMTNMAINIMAGE.FRST_REGISTER_ID IS 'ʵID';

COMMENT ON COLUMN COMTNMAINIMAGE.FRST_REGISTER_PNTTM IS 'ʵϽ';

COMMENT ON COLUMN COMTNMAINIMAGE.LAST_UPDUSR_ID IS 'ID';

COMMENT ON COLUMN COMTNMAINIMAGE.LAST_UPDUSR_PNTTM IS '';


CREATE TABLE COMTNLOGINSCRINIMAGE
(
  IMAGE_ID             CHAR(20 BYTE)            NOT NULL,
  IMAGE_NM             VARCHAR2(20 CHAR),
  IMAGE                VARCHAR2(60 CHAR),
  IMAGE_FILE           VARCHAR2(60 CHAR),
  IMAGE_DC             VARCHAR2(200 CHAR),
  REFLCT_AT            CHAR(1 BYTE),
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE COMTNLOGINSCRINIMAGE IS 'αȭ̹';

COMMENT ON COLUMN COMTNLOGINSCRINIMAGE.IMAGE_ID IS '̹ID';

COMMENT ON COLUMN COMTNLOGINSCRINIMAGE.IMAGE_NM IS '̹';

COMMENT ON COLUMN COMTNLOGINSCRINIMAGE.IMAGE IS '̹';

COMMENT ON COLUMN COMTNLOGINSCRINIMAGE.IMAGE_FILE IS '̹';

COMMENT ON COLUMN COMTNLOGINSCRINIMAGE.IMAGE_DC IS '̹';

COMMENT ON COLUMN COMTNLOGINSCRINIMAGE.REFLCT_AT IS 'ݿ';

COMMENT ON COLUMN COMTNLOGINSCRINIMAGE.FRST_REGISTER_ID IS 'ʵID';

COMMENT ON COLUMN COMTNLOGINSCRINIMAGE.FRST_REGISTER_PNTTM IS 'ʵϽ';

COMMENT ON COLUMN COMTNLOGINSCRINIMAGE.LAST_UPDUSR_ID IS 'ID';

COMMENT ON COLUMN COMTNLOGINSCRINIMAGE.LAST_UPDUSR_PNTTM IS '';


CREATE TABLE COMTNBANNER
(
  BANNER_ID            CHAR(20 BYTE)            NOT NULL,
  BANNER_NM            VARCHAR2(60 CHAR),
  LINK_URL             VARCHAR2(255 CHAR),
  BANNER_IMAGE         VARCHAR2(60 CHAR),
  BANNER_IMAGE_FILE    VARCHAR2(60 CHAR),
  BANNER_DC            VARCHAR2(200 CHAR),
  SORT_ORDR            NUMBER(8),
  REFLCT_AT            CHAR(1 BYTE),
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE COMTNBANNER IS '';

COMMENT ON COLUMN COMTNBANNER.BANNER_ID IS 'ID';

COMMENT ON COLUMN COMTNBANNER.BANNER_NM IS 'ʸ';

COMMENT ON COLUMN COMTNBANNER.LINK_URL IS 'ũURL';

COMMENT ON COLUMN COMTNBANNER.BANNER_IMAGE IS '̹';

COMMENT ON COLUMN COMTNBANNER.BANNER_IMAGE_FILE IS '̹';

COMMENT ON COLUMN COMTNBANNER.BANNER_DC IS 'ʼ';

COMMENT ON COLUMN COMTNBANNER.SORT_ORDR IS 'ļ';

COMMENT ON COLUMN COMTNBANNER.REFLCT_AT IS 'ݿ';

COMMENT ON COLUMN COMTNBANNER.FRST_REGISTER_ID IS 'ʵID';

COMMENT ON COLUMN COMTNBANNER.FRST_REGISTER_PNTTM IS 'ʵϽ';

COMMENT ON COLUMN COMTNBANNER.LAST_UPDUSR_ID IS 'ID';

COMMENT ON COLUMN COMTNBANNER.LAST_UPDUSR_PNTTM IS '';


CREATE TABLE COMTNSCRAP
(
  SCRAP_ID             CHAR(20 BYTE)            NOT NULL,
  NTT_ID               NUMBER(20)               NOT NULL,
  BBS_ID               CHAR(20 BYTE)            NOT NULL,
  SCRAP_NM             VARCHAR2(300 BYTE)       NOT NULL,
  USE_AT               CHAR(1 BYTE)             NOT NULL,
  FRST_REGISTER_PNTTM  DATE                     NOT NULL,
  LAST_UPDUSR_PNTTM    DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE)        NOT NULL,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNSTSFDG
(
  STSFDG_NO            NUMBER(20)               NOT NULL,
  NTT_ID               NUMBER(20)               NOT NULL,
  BBS_ID               CHAR(20 BYTE)            NOT NULL,
  WRTER_ID             VARCHAR2(20 BYTE),
  WRTER_NM             VARCHAR2(60 BYTE),
  PASSWORD             VARCHAR2(2000 BYTE),
  STSFDG               NUMBER(1)                NOT NULL,
  STSFDG_CN            VARCHAR2(600 BYTE),
  USE_AT               CHAR(1 BYTE)             NOT NULL,
  FRST_REGISTER_PNTTM  DATE                     NOT NULL,
  LAST_UPDUSR_PNTTM    DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE)        NOT NULL,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNCOMMENT
(
  COMMENT_NO           NUMBER(20)               NOT NULL,
  NTT_ID               NUMBER(20)               NOT NULL,
  BBS_ID               CHAR(20 BYTE)            NOT NULL,
  WRTER_ID             VARCHAR2(20 BYTE),
  WRTER_NM             VARCHAR2(60 BYTE),
  PASSWORD             VARCHAR2(2000 BYTE),
  COMMENT_CN           VARCHAR2(600 BYTE)       NOT NULL,
  USE_AT               CHAR(1 BYTE)             NOT NULL,
  FRST_REGISTER_PNTTM  DATE                     NOT NULL,
  LAST_UPDUSR_PNTTM    DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE)        NOT NULL,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNBBSMASTEROPTN
(
  BBS_ID               CHAR(20 BYTE)            NOT NULL,
  COMMENT_AT           CHAR(1 BYTE)             NOT NULL,
  STSFDG_AT            CHAR(1 BYTE)             NOT NULL,
  FRST_REGISTER_PNTTM  DATE                     NOT NULL,
  LAST_UPDUSR_PNTTM    DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE)        NOT NULL,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNSMSRECPTN
(
  SMS_ID         CHAR(20 BYTE)                  NOT NULL,
  RECPTN_TELNO   VARCHAR2(12 BYTE)              NOT NULL,
  RESULT_CODE    VARCHAR2(4 BYTE),
  RESULT_MSSAGE  VARCHAR2(4000 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNNTFCINFO
(
  NTFC_NO              NUMBER(20)               NOT NULL,
  NTFC_SJ              VARCHAR2(180 BYTE)       NOT NULL,
  NTFC_CN              VARCHAR2(300 BYTE)       NOT NULL,
  NTFC_TIME            CHAR(14 BYTE)            NOT NULL,
  BH_NTFC_INTRVL       VARCHAR2(20 BYTE)        NOT NULL,
  FRST_REGISTER_PNTTM  DATE                     NOT NULL,
  LAST_UPDUSR_PNTTM    DATE,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE)        NOT NULL,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNSMS
(
  SMS_ID               CHAR(20 BYTE)            NOT NULL,
  TRNSMIT_TELNO        VARCHAR2(12 BYTE)        NOT NULL,
  TRNSMIT_CN           VARCHAR2(240 BYTE)       NOT NULL,
  FRST_REGISTER_PNTTM  DATE                     NOT NULL,
  FRST_REGISTER_ID     VARCHAR2(20 BYTE)        NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMTNINDVDLPGEESTBS
(
  EMPLYR_ID        VARCHAR2(20 BYTE)            NOT NULL,
  TITLE_BAR_COLOR  CHAR(7 BYTE),
  SORT_MTHD        CHAR(1 BYTE)                 DEFAULT 'R',
  SORT_CNT         NUMBER(11)                   DEFAULT 2
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE COMTNINDVDLPGEESTBS IS '   ŸƲ ,  迭 , 迭 ϰ Ѵ.';

COMMENT ON COLUMN COMTNINDVDLPGEESTBS.EMPLYR_ID IS 'ID';

COMMENT ON COLUMN COMTNINDVDLPGEESTBS.TITLE_BAR_COLOR IS 'ŸƲ ÷';

COMMENT ON COLUMN COMTNINDVDLPGEESTBS.SORT_MTHD IS '迭   R,  C';

COMMENT ON COLUMN COMTNINDVDLPGEESTBS.SORT_CNT IS '迭 ';


CREATE TABLE COMTNINDVDLPGECNTNTS
(
  CNTNTS_ID        CHAR(20 BYTE)                NOT NULL,
  CNTNTS_NM        VARCHAR2(100 BYTE)           NOT NULL,
  CNTC_URL         VARCHAR2(256 BYTE)           NOT NULL,
  CNTNTS_USE_AT    CHAR(1 BYTE)                 NOT NULL,
  CNTNTS_LINK_URL  VARCHAR2(256 BYTE)           NOT NULL,
  CNTNTS_DC        VARCHAR2(1000 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE COMTNINDVDLPGECNTNTS IS 'ڰ  ߰   ڰ Ѵ.';

COMMENT ON COLUMN COMTNINDVDLPGECNTNTS.CNTNTS_ID IS 'ID';

COMMENT ON COLUMN COMTNINDVDLPGECNTNTS.CNTNTS_NM IS ' ';

COMMENT ON COLUMN COMTNINDVDLPGECNTNTS.CNTC_URL IS ' ȭ鿡 ǥ  ִ JSP,do URL';

COMMENT ON COLUMN COMTNINDVDLPGECNTNTS.CNTNTS_USE_AT IS ' 뿩, Y , N ';

COMMENT ON COLUMN COMTNINDVDLPGECNTNTS.CNTNTS_LINK_URL IS '󼼺  URL';

COMMENT ON COLUMN COMTNINDVDLPGECNTNTS.CNTNTS_DC IS ' ';


CREATE TABLE COMTNCNTNTSLIST
(
  EMPLYR_ID  VARCHAR2(20 BYTE)                  NOT NULL,
  CNTNTS_ID  CHAR(20 BYTE)                      NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE COMTNCNTNTSLIST IS ' ߰  ';

COMMENT ON COLUMN COMTNCNTNTSLIST.EMPLYR_ID IS 'ID';

COMMENT ON COLUMN COMTNCNTNTSLIST.CNTNTS_ID IS 'ID';


CREATE TABLE COMTNDTAUSESTATS
(
  DTA_USE_STATS_ID     CHAR(20 BYTE)            NOT NULL,
  BBS_ID               VARCHAR2(20 BYTE),
  NTT_ID               NUMBER(8),
  ATCH_FILE_ID         VARCHAR2(20 BYTE),
  FILE_SN              VARCHAR2(10 BYTE),
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE COMTNDTAUSESTATS IS 'ڷ̿Ȳ';

COMMENT ON COLUMN COMTNDTAUSESTATS.DTA_USE_STATS_ID IS 'ڷ̿ȲID';

COMMENT ON COLUMN COMTNDTAUSESTATS.BBS_ID IS 'ԽID';

COMMENT ON COLUMN COMTNDTAUSESTATS.NTT_ID IS 'ԽñID';

COMMENT ON COLUMN COMTNDTAUSESTATS.ATCH_FILE_ID IS '÷ID';

COMMENT ON COLUMN COMTNDTAUSESTATS.FILE_SN IS 'Ͽ';

COMMENT ON COLUMN COMTNDTAUSESTATS.FRST_REGISTER_ID IS 'ʵID';

COMMENT ON COLUMN COMTNDTAUSESTATS.FRST_REGISTER_PNTTM IS 'ʵϽ';

COMMENT ON COLUMN COMTNDTAUSESTATS.LAST_UPDUSR_ID IS 'ID';

COMMENT ON COLUMN COMTNDTAUSESTATS.LAST_UPDUSR_PNTTM IS '';


CREATE TABLE COMTNLOGINPOLICY
(
  EMPLYR_ID            VARCHAR2(20 BYTE)        NOT NULL,
  IP_INFO              VARCHAR2(23 BYTE),
  DPLCT_PERM_AT        CHAR(1 BYTE),
  LMTT_AT              CHAR(1 BYTE),
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE COMTNLOGINPOLICY IS 'αå';

COMMENT ON COLUMN COMTNLOGINPOLICY.EMPLYR_ID IS ' ID';

COMMENT ON COLUMN COMTNLOGINPOLICY.IP_INFO IS 'IP';

COMMENT ON COLUMN COMTNLOGINPOLICY.DPLCT_PERM_AT IS 'ߺ뿩';

COMMENT ON COLUMN COMTNLOGINPOLICY.LMTT_AT IS 'ѿ';

COMMENT ON COLUMN COMTNLOGINPOLICY.FRST_REGISTER_ID IS 'ʵID';

COMMENT ON COLUMN COMTNLOGINPOLICY.FRST_REGISTER_PNTTM IS 'ʵϽ';

COMMENT ON COLUMN COMTNLOGINPOLICY.LAST_UPDUSR_ID IS 'ID';

COMMENT ON COLUMN COMTNLOGINPOLICY.LAST_UPDUSR_PNTTM IS '';


CREATE TABLE COMTNUSERABSNCE
(
  EMPLYR_ID            VARCHAR2(20 BYTE)        NOT NULL,
  USER_ABSNCE_AT       CHAR(1 BYTE),
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE COMTNUSERABSNCE IS 'ں';

COMMENT ON COLUMN COMTNUSERABSNCE.EMPLYR_ID IS ' ID';

COMMENT ON COLUMN COMTNUSERABSNCE.USER_ABSNCE_AT IS 'ں翩';

COMMENT ON COLUMN COMTNUSERABSNCE.FRST_REGISTER_ID IS 'ʵID';

COMMENT ON COLUMN COMTNUSERABSNCE.FRST_REGISTER_PNTTM IS 'ʵϽ';

COMMENT ON COLUMN COMTNUSERABSNCE.LAST_UPDUSR_ID IS 'ID';

COMMENT ON COLUMN COMTNUSERABSNCE.LAST_UPDUSR_PNTTM IS '';


CREATE UNIQUE INDEX COMTCADMINISTCODERECPTNLOG_PK ON COMTCADMINISTCODERECPTNLOG
(OCCRR_DE, ADMINIST_ZONE_SE, ADMINIST_ZONE_CODE, OPERT_SN)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX PK_COMTNBANNER ON COMTNBANNER
(BANNER_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX COMTNBBSMASTEROPTN_PK ON COMTNBBSMASTEROPTN
(BBS_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX COMTNCNTCINSTT_PK ON COMTNCNTCINSTT
(INSTT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX COMTNCNTCMESSAGE_PK ON COMTNCNTCMESSAGE
(CNTC_MESSAGE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX FK1_COMTNCNTNTSLIST ON COMTNCNTNTSLIST
(EMPLYR_ID)
LOGGING
NOPARALLEL;


CREATE INDEX FK2_COMTNCNTNTSLIST ON COMTNCNTNTSLIST
(CNTNTS_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX COMTNCOMMENT_PK ON COMTNCOMMENT
(COMMENT_NO)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX PK_COMTNDTAUSESTATS ON COMTNDTAUSESTATS
(DTA_USE_STATS_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX PK_COMTNINDVDLPGECNTNTS ON COMTNINDVDLPGECNTNTS
(CNTNTS_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX PK_COMTNINDVDLPGEESTBS ON COMTNINDVDLPGEESTBS
(EMPLYR_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX COMTNINSTTCODE_PK ON COMTNINSTTCODE
(INSTT_CODE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX COMTNINSTTCODERECPTNLOG_PK ON COMTNINSTTCODERECPTNLOG
(OCCRR_DE, INSTT_CODE, OPERT_SN)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX PK_COMTNINTNETSVC ON COMTNINTNETSVC
(INTNET_SVC_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX PK_COMTNLOGINPOLICY ON COMTNLOGINPOLICY
(EMPLYR_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX PK_COMTNLOGINSCRINIMAGE ON COMTNLOGINSCRINIMAGE
(IMAGE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX PK_COMTNMAINIMAGE ON COMTNMAINIMAGE
(IMAGE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX COMTNNTFCINFO_PK ON COMTNNTFCINFO
(NTFC_NO)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX PK_COMTNREPRTSTATS ON COMTNREPRTSTATS
(REPRT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX COMTNSCRAP_PK ON COMTNSCRAP
(SCRAP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX COMTNSMS_PK ON COMTNSMS
(SMS_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX COMTNSMSRECPTN_PK ON COMTNSMSRECPTN
(SMS_ID, RECPTN_TELNO)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX COMTNSTSFDG_PK ON COMTNSTSFDG
(STSFDG_NO)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX COMTNSYSTEMCNTC_PK ON COMTNSYSTEMCNTC
(CNTC_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX PK_COMTNUSERABSNCE ON COMTNUSERABSNCE
(EMPLYR_ID)
LOGGING
NOPARALLEL;


CREATE TABLE COMTNCNTCSYSTEM
(
  INSTT_ID             VARCHAR2(20 BYTE)        NOT NULL,
  SYS_ID               VARCHAR2(20 BYTE)        NOT NULL,
  SYS_NM               VARCHAR2(765 BYTE),
  SYS_IP               VARCHAR2(23 BYTE),
  USE_AT               CHAR(1 BYTE),
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;



CREATE TABLE COMTNCNTCMESSAGEITEM
(
  CNTC_MESSAGE_ID      VARCHAR2(20 BYTE)        NOT NULL,
  ITEM_ID              VARCHAR2(20 BYTE)        NOT NULL,
  ITEM_NM              VARCHAR2(300 BYTE),
  ITEM_TYPE            VARCHAR2(150 BYTE),
  ITEM_LT              INTEGER,
  USE_AT               CHAR(1 BYTE),
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;



CREATE UNIQUE INDEX COMTNCNTCMESSAGEITEM_PK ON COMTNCNTCMESSAGEITEM
(CNTC_MESSAGE_ID, ITEM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX COMTNCNTCSYSTEM_PK ON COMTNCNTCSYSTEM
(INSTT_ID, SYS_ID)
LOGGING
NOPARALLEL;


CREATE TABLE COMTNCNTCSERVICE
(
  INSTT_ID             VARCHAR2(20 BYTE)        NOT NULL,
  SYS_ID               VARCHAR2(20 BYTE)        NOT NULL,
  SVC_ID               VARCHAR2(20 BYTE)        NOT NULL,
  SVC_NM               VARCHAR2(765 BYTE),
  REQUEST_MESSAGE_ID   VARCHAR2(20 BYTE),
  RSPNS_MESSAGE_ID     VARCHAR2(20 BYTE),
  USE_AT               CHAR(1 BYTE),
  FRST_REGISTER_ID     VARCHAR2(20 BYTE),
  FRST_REGISTER_PNTTM  DATE,
  LAST_UPDUSR_ID       VARCHAR2(20 BYTE),
  LAST_UPDUSR_PNTTM    DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX COMTNCNTCSERVICE_PK ON COMTNCNTCSERVICE
(INSTT_ID, SYS_ID, SVC_ID)
LOGGING
NOPARALLEL;


ALTER TABLE COMTNSYSTEMCNTC ADD (
  CONSTRAINT COMTNSYSTEMCNTC_PK PRIMARY KEY (CNTC_ID)
);


ALTER TABLE COMTNINSTTCODERECPTNLOG ADD (
  CONSTRAINT COMTNINSTTCODERECPTNLOG_PK PRIMARY KEY (OCCRR_DE, INSTT_CODE, OPERT_SN)
);

ALTER TABLE COMTNINSTTCODE ADD (
  CONSTRAINT COMTNINSTTCODE_PK PRIMARY KEY (INSTT_CODE)
);


ALTER TABLE COMTNCNTCMESSAGE ADD (
  CONSTRAINT COMTNCNTCMESSAGE_PK PRIMARY KEY (CNTC_MESSAGE_ID)
);


ALTER TABLE COMTNCNTCINSTT ADD (
  CONSTRAINT COMTNCNTCINSTT_PK PRIMARY KEY (INSTT_ID)
);


ALTER TABLE COMTCADMINISTCODERECPTNLOG ADD (
  CONSTRAINT COMTCADMINISTCODERECPTNLOG_PK PRIMARY KEY (OCCRR_DE, ADMINIST_ZONE_SE, ADMINIST_ZONE_CODE, OPERT_SN)
);


ALTER TABLE COMTNADBK ADD (
  PRIMARY KEY (ADBKUSER_ID)
);


ALTER TABLE COMTNBKMKMENUMANAGERESULT ADD (
  PRIMARY KEY (MENU_ID, EMPLYR_ID)
);


ALTER TABLE COMTNADBKMANAGE ADD (
  PRIMARY KEY (ADBK_ID)
);


ALTER TABLE COMTNONLINEPOLLRESULT ADD (
  PRIMARY KEY (POLL_ID, POLL_IEM_ID, POLL_RESULT_ID)
);


ALTER TABLE COMTNONLINEPOLLMANAGE ADD (
  PRIMARY KEY (POLL_ID)
);


ALTER TABLE COMTNONLINEPOLLITEM ADD (
  PRIMARY KEY (POLL_ID, POLL_IEM_ID)
);


ALTER TABLE COMTNRECENTSRCHWRD ADD (
  PRIMARY KEY (SRCHWRD_MANAGE_ID, SRCHWRD_ID)
);


ALTER TABLE COMTNRECENTSRCHWRDMANAGE ADD (
  PRIMARY KEY (SRCHWRD_MANAGE_ID)
);


ALTER TABLE COMTNPOPUPMANAGE ADD (
  PRIMARY KEY (POPUP_ID)
);


ALTER TABLE COMTNUNITYLINK ADD (
  PRIMARY KEY (UNITY_LINK_ID)
);


ALTER TABLE COMTNONLINEMANUAL ADD (
  PRIMARY KEY (ONLINE_MNL_ID)
);


ALTER TABLE COMTNINDVDLINFOPOLICY ADD (
  PRIMARY KEY (INDVDL_INFO_ID)
);


ALTER TABLE COMTNADMINISTRATIONWORD ADD (
  PRIMARY KEY (ADMINIST_WORD_ID)
);


ALTER TABLE COMTNREPRTSTATS ADD (
  CONSTRAINT PK_COMTNREPRTSTATS PRIMARY KEY (REPRT_ID)
);


ALTER TABLE COMTNINTNETSVC ADD (
  CONSTRAINT PK_COMTNINTNETSVC PRIMARY KEY (INTNET_SVC_ID)
);


ALTER TABLE COMTNMAINIMAGE ADD (
  CONSTRAINT PK_COMTNMAINIMAGE PRIMARY KEY (IMAGE_ID)
);


ALTER TABLE COMTNLOGINSCRINIMAGE ADD (
  CONSTRAINT PK_COMTNLOGINSCRINIMAGE PRIMARY KEY (IMAGE_ID)
);


ALTER TABLE COMTNBANNER ADD (
  CONSTRAINT PK_COMTNBANNER PRIMARY KEY (BANNER_ID)
);


ALTER TABLE COMTNSCRAP ADD (
  CONSTRAINT COMTNSCRAP_PK PRIMARY KEY (SCRAP_ID)
);


ALTER TABLE COMTNSTSFDG ADD (
  CONSTRAINT COMTNSTSFDG_PK PRIMARY KEY (STSFDG_NO)
);


ALTER TABLE COMTNCOMMENT ADD (
  CONSTRAINT COMTNCOMMENT_PK PRIMARY KEY (COMMENT_NO)
);


ALTER TABLE COMTNBBSMASTEROPTN ADD (
  CONSTRAINT COMTNBBSMASTEROPTN_PK PRIMARY KEY (BBS_ID)
);


ALTER TABLE COMTNSMSRECPTN ADD (
  CONSTRAINT COMTNSMSRECPTN_PK PRIMARY KEY (SMS_ID, RECPTN_TELNO)
);


ALTER TABLE COMTNNTFCINFO ADD (
  CONSTRAINT COMTNNTFCINFO_PK PRIMARY KEY (NTFC_NO)
);


ALTER TABLE COMTNSMS ADD (
  CONSTRAINT COMTNSMS_PK PRIMARY KEY (SMS_ID)
);


ALTER TABLE COMTNINDVDLPGEESTBS ADD (
  CONSTRAINT PK_COMTNINDVDLPGEESTBS PRIMARY KEY (EMPLYR_ID)
);


ALTER TABLE COMTNINDVDLPGECNTNTS ADD (
  CONSTRAINT PK_COMTNINDVDLPGECNTNTS PRIMARY KEY (CNTNTS_ID)
);


ALTER TABLE COMTNDTAUSESTATS ADD (
  CONSTRAINT PK_COMTNDTAUSESTATS PRIMARY KEY (DTA_USE_STATS_ID)
);


ALTER TABLE COMTNLOGINPOLICY ADD (
  CONSTRAINT PK_COMTNLOGINPOLICY PRIMARY KEY (EMPLYR_ID)
);


ALTER TABLE COMTNUSERABSNCE ADD (
  CONSTRAINT PK_COMTNUSERABSNCE PRIMARY KEY (EMPLYR_ID)
);


ALTER TABLE COMTNCNTCSYSTEM ADD (
  CONSTRAINT COMTNCNTCSYSTEM_PK PRIMARY KEY (INSTT_ID, SYS_ID)
);


ALTER TABLE COMTNCNTCMESSAGEITEM ADD (
  CONSTRAINT COMTNCNTCMESSAGEITEM_PK PRIMARY KEY (CNTC_MESSAGE_ID, ITEM_ID)
);


ALTER TABLE COMTNCNTCSERVICE ADD (
  CONSTRAINT COMTNCNTCSERVICE_PK PRIMARY KEY (INSTT_ID, SYS_ID, SVC_ID)
);


ALTER TABLE COMTNCNTCSYSTEM ADD (
  CONSTRAINT COMTNCNTCSYSTEM_FK FOREIGN KEY (INSTT_ID) 
    REFERENCES COMTNCNTCINSTT (INSTT_ID));


ALTER TABLE COMTNCNTCMESSAGEITEM ADD (
  CONSTRAINT COMTNCNTCMESSAGEITEM_FK FOREIGN KEY (CNTC_MESSAGE_ID) 
    REFERENCES COMTNCNTCMESSAGE (CNTC_MESSAGE_ID));


ALTER TABLE COMTNCNTCSERVICE ADD (
  CONSTRAINT COMTNCNTCSERVICE_FK FOREIGN KEY (INSTT_ID, SYS_ID) 
    REFERENCES COMTNCNTCSYSTEM (INSTT_ID,SYS_ID));



