CREATE TABLE COMTNPROGRMLIST
(
	PROGRM_FILE_NM        VARCHAR(180)  NOT NULL ,
	PROGRM_STRE_PATH      VARCHAR(300)  NOT NULL ,
	PROGRM_KOREAN_NM      VARCHAR(180)  NULL ,
	PROGRM_DC             VARCHAR(600)  NULL ,
	URL                   VARCHAR(300)  NOT NULL ,
CONSTRAINT  COMTNPROGRMLIST_PK PRIMARY KEY (PROGRM_FILE_NM)
);

CREATE TABLE COMTHPROGRMCHANGEDTLS
(
	PROGRM_FILE_NM        VARCHAR(180)  NOT NULL ,
	REQUST_NO             NUMERIC(10)  NOT NULL ,
	RQESTER_ID            VARCHAR(60)  NOT NULL ,
	CHANGE_REQUST_CN      VARCHAR(3000)  NULL ,
	REQUST_PROCESS_CN     STRING  NULL ,
	OPETR_ID              VARCHAR(60)  NULL ,
	PROCESS_STTUS_CODE    VARCHAR(45)  NOT NULL ,
	PROCESS_DE            CHAR(20)  NULL ,
	RQESTDE               CHAR(20)  NULL ,
	REQUST_SJ             VARCHAR(180)  NOT NULL ,
CONSTRAINT  COMTHPROGRMCHANGEDTLS_PK PRIMARY KEY (PROGRM_FILE_NM,REQUST_NO)
);

CREATE TABLE COMTNPOPUPMANAGE
(
	POPUP_ID              VARCHAR(60)  NOT NULL ,
	POPUP_SJ_NM           VARCHAR(3072)  NULL ,
	FILE_URL              VARCHAR(3072)  NULL ,
	POPUP_WIDTH_LC        VARCHAR(60)  NULL ,
	POPUP_WIDTH_SIZE      NUMERIC  NULL ,
	NTCE_BGNDE            CHAR(20)  NULL ,
	NTCE_ENDDE            CHAR(20)  NULL ,
	STOPVEW_SETUP_AT      CHAR(1)  NULL ,
	NTCE_AT               CHAR(1)  NULL ,
	POPUP_VRTICL_LC       VARCHAR(60)  NULL ,
	POPUP_VRTICL_SIZE     NUMERIC  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNPOPUPMANAGE_PK PRIMARY KEY (POPUP_ID)
);

CREATE TABLE COMTNBANNER
(
	BANNER_ID             CHAR(20)  NOT NULL ,
	BANNER_NM             VARCHAR(180)  NOT NULL ,
	LINK_URL              VARCHAR(765)  NOT NULL ,
	BANNER_IMAGE          VARCHAR(180)  NOT NULL ,
	BANNER_DC             VARCHAR(600)  NULL ,
	REFLCT_AT             CHAR(1)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	BANNER_IMAGE_FILE     VARCHAR(180)  NULL ,
	SORT_ORDR             NUMERIC(8)  NULL ,
CONSTRAINT  COMTNBANNER_PK PRIMARY KEY (BANNER_ID)
);

CREATE TABLE COMTNLOGINSCRINIMAGE
(
	IMAGE_ID              CHAR(20)  NOT NULL ,
	IMAGE_NM              VARCHAR(60)  NOT NULL ,
	REFLCT_AT             CHAR(1)  NOT NULL ,
	IMAGE                 VARCHAR(180)  NOT NULL ,
	IMAGE_DC              VARCHAR(600)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	IMAGE_FILE            VARCHAR(180)  NULL ,
CONSTRAINT  COMTNLOGINSCRINIMAGE_PK PRIMARY KEY (IMAGE_ID)
);

CREATE TABLE COMTNORGNZTINFO
(
	ORGNZT_ID             CHAR(20)  NOT NULL ,
	ORGNZT_NM             VARCHAR(60)  NOT NULL ,
	ORGNZT_DC             VARCHAR(300)  NULL ,
CONSTRAINT  COMTNORGNZTINFO_PK PRIMARY KEY (ORGNZT_ID)
);

CREATE TABLE COMTNAUTHORGROUPINFO
(
	GROUP_ID              CHAR(20)  NOT NULL ,
	GROUP_NM              VARCHAR(180)  NOT NULL ,
	GROUP_CREAT_DE        CHAR(40)  NOT NULL ,
	GROUP_DC              VARCHAR(300)  NULL ,
CONSTRAINT  COMTNAUTHORGROUPINFO_PK PRIMARY KEY (GROUP_ID)
);

CREATE TABLE COMTNEMPLYRINFO
(
	EMPLYR_ID             VARCHAR(60)  NOT NULL ,
	ORGNZT_ID             CHAR(20)  NULL ,
	USER_NM               VARCHAR(180)  NOT NULL ,
	PASSWORD              VARCHAR(600)  NOT NULL ,
	EMPL_NO               VARCHAR(60)  NULL ,
	IHIDNUM               VARCHAR(600)  NULL ,
	SEXDSTN_CODE          CHAR(1)  NULL ,
	BRTHDY                CHAR(20)  NULL ,
	FXNUM                 VARCHAR(60)  NULL ,
	HOUSE_ADRES           VARCHAR(300)  NOT NULL ,
	PASSWORD_HINT         VARCHAR(300)  NOT NULL ,
	PASSWORD_CNSR         VARCHAR(300)  NOT NULL ,
	HOUSE_END_TELNO       VARCHAR(12)  NOT NULL ,
	AREA_NO               VARCHAR(12)  NOT NULL ,
	DETAIL_ADRES          VARCHAR(300)  NULL ,
	ZIP                   VARCHAR(18)  NOT NULL ,
	OFFM_TELNO            VARCHAR(60)  NULL ,
	MBTLNUM               VARCHAR(60)  NULL ,
	EMAIL_ADRES           VARCHAR(150)  NULL ,
	OFCPS_NM              VARCHAR(180)  NULL ,
	HOUSE_MIDDLE_TELNO    VARCHAR(12)  NOT NULL ,
	GROUP_ID              CHAR(20)  NULL ,
	PSTINST_CODE          CHAR(8)  NULL ,
	EMPLYR_STTUS_CODE     CHAR(1)  NOT NULL ,
	ESNTL_ID              CHAR(20)  NOT NULL ,
	CRTFC_DN_VALUE        VARCHAR(300)  NULL ,
	SBSCRB_DE             DATETIME  NULL ,
	LOCK_AT               CHAR(1) NULL,
	LOCK_CNT              NUMERIC(3) NULL,
	LOCK_LAST_PNTTM       DATETIME NULL,
	CHG_PWD_LAST_PNTTM    DATETIME NULL,
CONSTRAINT  COMTNEMPLYRINFO_PK PRIMARY KEY (EMPLYR_ID)
);

CREATE TABLE COMTNFILE
(
	ATCH_FILE_ID          CHAR(20)  NOT NULL ,
	CREAT_DT              DATETIME  NOT NULL ,
	USE_AT                CHAR(1)  NULL ,
CONSTRAINT  COMTNFILE_PK PRIMARY KEY (ATCH_FILE_ID)
);

CREATE TABLE COMTHEMAILDSPTCHMANAGE
(
	MSSAGE_ID             VARCHAR(60)  NOT NULL ,
	EMAIL_CN              STRING  NULL ,
	SNDR                  VARCHAR(150)  NOT NULL ,
	RCVER                 VARCHAR(150)  NOT NULL ,
	SJ                    VARCHAR(180)  NOT NULL ,
	SNDNG_RESULT_CODE     CHAR(1)  NULL ,
	DSPTCH_DT             CHAR(20)  NOT NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
CONSTRAINT  COMTHEMAILDSPTCHMANAGE_PK PRIMARY KEY (MSSAGE_ID)
);

CREATE TABLE COMTNNTTSTATS
(
	STATS_ID              CHAR(18)  NOT NULL ,
	NTCE_CO               NUMERIC(10)  NULL ,
	AVRG_RDCNT            NUMERIC(10)  NULL ,
	TOP_RDCNT             NUMERIC(10)  NULL ,
	MUMM_RDCNT            NUMERIC(10)  NULL ,
	TOP_NTCR_ID           VARCHAR(60)  NULL ,
CONSTRAINT  COMTNNTTSTATS_PK PRIMARY KEY (STATS_ID)
);

CREATE TABLE COMTNSITELIST
(
	SITE_ID               CHAR(20)  NOT NULL ,
	SITE_NM               VARCHAR(300)  NULL ,
	SITE_URL              VARCHAR(300)  NULL ,
	SITE_DC               VARCHAR(3000)  NULL ,
	SITE_THEMA_CL_CODE    VARCHAR(6)  NULL ,
	ACTVTY_AT             CHAR(1)  NULL ,
	USE_AT                CHAR(1)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTNSITELIST_PK PRIMARY KEY (SITE_ID)
);

CREATE TABLE COMTNRECENTSRCHWRDMANAGE
(
	SRCHWRD_MANAGE_ID     CHAR(20)  NOT NULL ,
	SRCHWRD_MANAGE_NM     VARCHAR(765)  NULL ,
	SRCHWRD_CONECT_URL    VARCHAR(765)  NULL ,
	USER_SEARCH_AT        CHAR(1)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNRECENTSRCHWRDMANAGE_PK PRIMARY KEY (SRCHWRD_MANAGE_ID)
);

CREATE TABLE COMTNRECENTSRCHWRD
(
	SRCHWRD_MANAGE_ID     CHAR(20)  NOT NULL ,
	RECENT_SRCHWRD_ID     CHAR(20)  NOT NULL ,
	RECENT_SRCHWRD_NM     VARCHAR(765)  NULL ,
	RECENT_SRCHWRD_CO     NUMERIC(20)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNRECENTSRCHWRD_PK PRIMARY KEY (RECENT_SRCHWRD_ID)
);

CREATE TABLE COMTNPROXYINFO
(
	PROXY_ID              CHAR(20)  NOT NULL ,
	PROXY_NM              VARCHAR(180)  NULL ,
	PROXY_IP              VARCHAR(69)  NULL ,
	PROXY_PORT            VARCHAR(30)  NULL ,
	TRGET_SVC_NM          VARCHAR(765)  NULL ,
	SVC_DC                VARCHAR(6000)  NULL ,
	SVC_IP                VARCHAR(69)  NULL ,
	SVC_PORT              VARCHAR(30)  NULL ,
	SVC_STTUS             CHAR(2)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNPROXYINFO_PK PRIMARY KEY (PROXY_ID)
);

CREATE TABLE COMTNPROXYLOGINFO
(
	PROXY_ID              CHAR(20)  NOT NULL ,
	CLNT_IP               VARCHAR(69)  NULL ,
	CLNT_PORT             VARCHAR(30)  NULL ,
	CONECT_TIME           DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LOG_ID                CHAR(20)  NOT NULL ,
CONSTRAINT  COMTNPROXYLOGINFO_PK PRIMARY KEY (PROXY_ID,LOG_ID)
);

CREATE TABLE COMTNMAINIMAGE
(
	IMAGE_ID              CHAR(20)  NOT NULL ,
	IMAGE_NM              VARCHAR(60)  NOT NULL ,
	IMAGE                 VARCHAR(180)  NOT NULL ,
	IMAGE_DC              VARCHAR(600)  NULL ,
	REFLCT_AT             CHAR(1)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	IMAGE_FILE            VARCHAR(180)  NULL ,
CONSTRAINT  COMTNMAINIMAGE_PK PRIMARY KEY (IMAGE_ID)
);

CREATE TABLE COMTNUNITYLINK
(
	UNITY_LINK_ID         CHAR(20)  NOT NULL ,
	UNITY_LINK_GROUP      VARCHAR(765)  NULL ,
	UNITY_LINK_NM         VARCHAR(765)  NULL ,
	UNITY_LINK_URL        VARCHAR(765)  NULL ,
	UNITY_LINK_DC         VARCHAR(7500)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	UNITY_LINK_SE_CODE    CHAR(3)  NULL ,
CONSTRAINT  COMTNUNITYLINK_PK PRIMARY KEY (UNITY_LINK_ID)
);

CREATE TABLE COMTNUSERABSNCE
(
	EMPLYR_ID             VARCHAR(60)  NOT NULL ,
	USER_ABSNCE_AT        CHAR(1)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNUSERABSNCE_PK PRIMARY KEY (EMPLYR_ID)
);

CREATE TABLE COMTSSYSLOGSUMMARY
(
	OCCRRNC_DE            CHAR(8)  NOT NULL ,
	SVC_NM                VARCHAR(300)  NOT NULL ,
	METHOD_NM             VARCHAR(180)  NOT NULL ,
	CREAT_CO              NUMERIC(10)  NULL ,
	UPDT_CO               NUMERIC(10)  NULL ,
	RDCNT                 NUMERIC(10)  NULL ,
	DELETE_CO             NUMERIC(10)  NULL ,
	OUTPT_CO              NUMERIC(10)  NULL ,
	ERROR_CO              NUMERIC(10)  NULL ,
CONSTRAINT  COMTSSYSLOGSUMMARY_PK PRIMARY KEY (OCCRRNC_DE,SVC_NM,METHOD_NM)
);

CREATE TABLE COMTNSYSLOG
(
	REQUST_ID             VARCHAR(60)  NOT NULL ,
	JOB_SE_CODE           CHAR(3)  NULL ,
	INSTT_CODE            CHAR(7)  NULL ,
	OCCRRNC_DE            DATETIME  NULL ,
	RQESTER_IP            VARCHAR(69)  NULL ,
	RQESTER_ID            VARCHAR(60)  NULL ,
	TRGET_MENU_NM         VARCHAR(765)  NULL ,
	SVC_NM                VARCHAR(765)  NULL ,
	METHOD_NM             VARCHAR(180)  NULL ,
	PROCESS_SE_CODE       CHAR(3)  NULL ,
	PROCESS_CO            NUMERIC(10)  NULL ,
	PROCESS_TIME          VARCHAR(42)  NULL ,
	RSPNS_CODE            CHAR(3)  NULL ,
	ERROR_SE              CHAR(1)  NULL ,
	ERROR_CO              NUMERIC(10)  NULL ,
	ERROR_CODE            CHAR(3)  NULL ,
CONSTRAINT  COMTNSYSLOG_PK PRIMARY KEY (REQUST_ID)
);

CREATE TABLE COMTNBBSMASTER
(
	BBS_ID                CHAR(30)  NOT NULL ,
	BBS_NM                VARCHAR(765)  NOT NULL ,
	BBS_INTRCN            VARCHAR(7200)  NULL ,
	BBS_TY_CODE           CHAR(6)  NOT NULL ,
	REPLY_POSBL_AT        CHAR(1)  NULL ,
	FILE_ATCH_POSBL_AT    CHAR(1)  NOT NULL ,
	ATCH_POSBL_FILE_NUMBER  NUMERIC(2)  NOT NULL ,
	ATCH_POSBL_FILE_SIZE  NUMERIC(8)  NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	TMPLAT_ID             CHAR(20)  NULL ,
	CMMNTY_ID			CHAR(20) NULL,
	FRST_REGISTER_ID      VARCHAR(60)  NOT NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	BLOG_ID 					CHAR(20) NULL,
	BLOG_AT 					CHAR(2) NULL,
CONSTRAINT  COMTNBBSMASTER_PK PRIMARY KEY (BBS_ID)
);

CREATE TABLE COMTNBBS
(
	NTT_ID                NUMERIC(20)  NOT NULL ,
	BBS_ID                CHAR(30)  NOT NULL ,
	NTT_NO                NUMERIC(20)  NULL ,
	NTT_SJ                VARCHAR(6000)  NULL ,
	NTT_CN                STRING  NULL ,
	ANSWER_AT             CHAR(1)  NULL ,
	PARNTSCTT_NO          NUMERIC(10)  NULL ,
	ANSWER_LC             NUMERIC(8)  NULL ,
	SORT_ORDR             NUMERIC(8)  NULL ,
	RDCNT                 NUMERIC(10)  NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	NTCE_BGNDE            CHAR(20)  NULL ,
	NTCE_ENDDE            CHAR(20)  NULL ,
	NTCR_ID               VARCHAR(60)  NULL ,
	NTCR_NM               VARCHAR(60)  NULL ,
	PASSWORD              VARCHAR(600)  NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
	NOTICE_AT				CHAR(1) NULL,
	SJ_BOLD_AT				CHAR(1) NULL,
	SECRET_AT				CHAR(1) NULL,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NOT NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	BLOG_ID 					CHAR(20) NULL,
CONSTRAINT  COMTNBBS_PK PRIMARY KEY (NTT_ID,BBS_ID)
);

CREATE TABLE COMTNCOMMENT
(
	NTT_ID                NUMERIC(20)  NOT NULL ,
	BBS_ID                CHAR(30)  NOT NULL ,
	ANSWER_NO             NUMERIC(20)  NOT NULL ,
	WRTER_ID              VARCHAR(60)  NULL ,
	WRTER_NM              VARCHAR(60)  NULL ,
	ANSWER                VARCHAR(600)  NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NOT NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	PASSWORD              VARCHAR(600)  NULL ,
CONSTRAINT  COMTNCOMMENT_PK PRIMARY KEY (NTT_ID,BBS_ID,ANSWER_NO)
);

CREATE TABLE COMTNRECOMENDSITEINFO
(
	RECOMEND_SITE_ID      CHAR(20)  NOT NULL ,
	RECOMEND_SITE_NM      VARCHAR(300)  NULL ,
	RECOMEND_SITE_URL     VARCHAR(765)  NULL ,
	RECOMEND_SITE_DC      VARCHAR(3000)  NULL ,
	RECOMEND_RESN_CN      VARCHAR(3000)  NULL ,
	RECOMEND_CONFM_AT     CHAR(1)  NULL ,
	CONFM_DE              CHAR(20)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTNRECOMENDSITEINFO_PK PRIMARY KEY (RECOMEND_SITE_ID)
);

CREATE TABLE COMTNINTNETSVC
(
	INTNET_SVC_ID         CHAR(20)  NOT NULL ,
	INTNET_SVC_NM         VARCHAR(60)  NOT NULL ,
	INTNET_SVC_DC         VARCHAR(600)  NULL ,
	REFLCT_AT             CHAR(1)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNINTNETSVC_PK PRIMARY KEY (INTNET_SVC_ID)
);

CREATE TABLE COMTNCLUB
(
	CLB_ID                CHAR(20)  NOT NULL ,
	CMMNTY_ID             CHAR(20)  NOT NULL ,
	CLB_NM                VARCHAR(765)  NOT NULL ,
	CLB_INTRCN            VARCHAR(7200)  NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	REGIST_SE_CODE        CHAR(6)  NULL ,
	TMPLAT_ID             CHAR(20)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NOT NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTNCLUB_PK PRIMARY KEY (CLB_ID,CMMNTY_ID)
);

CREATE TABLE COMTNCLUBUSER
(
	CLB_ID                CHAR(20)  NOT NULL ,
	CMMNTY_ID             CHAR(20)  NOT NULL ,
	OPRTR_AT              CHAR(1)  NOT NULL ,
	SBSCRB_DE             DATETIME  NULL ,
	SECSN_DE              CHAR(20)  NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NOT NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	EMPLYR_ID             VARCHAR(60)  NOT NULL ,
CONSTRAINT  COMTNCLUBUSER_PK PRIMARY KEY (CLB_ID,CMMNTY_ID,EMPLYR_ID)
);

CREATE TABLE COMTNBACKUPOPERT
(
	BACKUP_OPERT_ID       VARCHAR(60)  NOT NULL ,
	BACKUP_OPERT_NM       VARCHAR(180)  NULL ,
	BACKUP_ORGINL_DRCTRY  VARCHAR(765)  NULL ,
	BACKUP_STRE_DRCTRY    VARCHAR(765)  NULL ,
	CMPRS_SE              VARCHAR(6)  NULL ,
	EXECUT_CYCLE          VARCHAR(6)  NULL ,
	EXECUT_SCHDUL_DE      CHAR(20)  NULL ,
	EXECUT_SCHDUL_HOUR    CHAR(2)  NULL ,
	EXECUT_SCHDUL_MNT     CHAR(2)  NULL ,
	EXECUT_SCHDUL_SECND   CHAR(2)  NULL ,
	USE_AT                CHAR(1)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NOT NULL ,
CONSTRAINT  COMTNBACKUPOPERT_PK PRIMARY KEY (BACKUP_OPERT_ID)
);

CREATE TABLE COMTNBACKUPSCHDULDFK
(
	BACKUP_OPERT_ID       VARCHAR(60)  NOT NULL ,
	EXECUT_SCHDUL_DFK_SE  CHAR(1)  NOT NULL ,
CONSTRAINT  COMTNBACKUPSCHDULDFK_PK PRIMARY KEY (BACKUP_OPERT_ID,EXECUT_SCHDUL_DFK_SE)
);

CREATE TABLE COMTNCMMNTY
(
	CMMNTY_ID             CHAR(20)  NOT NULL ,
	CMMNTY_NM             VARCHAR(765)  NOT NULL ,
	CMMNTY_INTRCN         VARCHAR(7200)  NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	REGIST_SE_CODE        CHAR(6)  NULL ,
	TMPLAT_ID             CHAR(20)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NOT NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTNCMMNTY_PK PRIMARY KEY (CMMNTY_ID)
);

CREATE TABLE COMTNCMMNTYUSER
(
	CMMNTY_ID             CHAR(20)  NOT NULL ,
	EMPLYR_ID             VARCHAR(60)  NOT NULL ,
	MNGR_AT               CHAR(1)  NOT NULL ,
	MBER_STTUS			VARCHAR(15) NULL,
	SBSCRB_DE             DATETIME  NULL ,
	SECSN_DE              CHAR(20)  NULL ,
	USE_AT                CHAR(1)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NOT NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTNCMMNTYUSER_PK PRIMARY KEY (CMMNTY_ID,EMPLYR_ID)
);

CREATE TABLE COMTNFILEDETAIL
(
	ATCH_FILE_ID          CHAR(20)  NOT NULL ,
	FILE_SN               NUMERIC(10)  NOT NULL ,
	FILE_STRE_COURS       VARCHAR(6000)  NOT NULL ,
	STRE_FILE_NM          VARCHAR(765)  NOT NULL ,
	ORIGNL_FILE_NM        VARCHAR(765)  NULL ,
	FILE_EXTSN            VARCHAR(60)  NOT NULL ,
	FILE_CN               STRING  NULL ,
	FILE_SIZE             NUMERIC(8)  NULL ,
CONSTRAINT  COMTNFILEDETAIL_PK PRIMARY KEY (ATCH_FILE_ID,FILE_SN)
);

CREATE TABLE COMTNLOGINPOLICY
(
	EMPLYR_ID             VARCHAR(60)  NOT NULL ,
	IP_INFO               VARCHAR(69)  NOT NULL ,
	DPLCT_PERM_AT         CHAR(1)  NOT NULL ,
	LMTT_AT               CHAR(1)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNLOGINPOLICY_PK PRIMARY KEY (EMPLYR_ID)
);

CREATE TABLE COMTNQUSTNRTMPLAT
(
	QUSTNR_TMPLAT_ID      CHAR(20)  NOT NULL ,
	QUSTNR_TMPLAT_TY      VARCHAR(300)  NULL ,
	QUSTNR_TMPLAT_DC      VARCHAR(6000)  NULL ,
	QUSTNR_TMPLAT_PATH_NM  VARCHAR(300)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	QUSTNR_TMPLAT_IMAGE_INFO  BIT VARYING  NULL ,
CONSTRAINT  COMTNQUSTNRTMPLAT_PK PRIMARY KEY (QUSTNR_TMPLAT_ID)
);

CREATE TABLE COMTNQESTNRINFO
(
	QUSTNR_TMPLAT_ID      CHAR(20)  NOT NULL ,
	QESTNR_ID             CHAR(20)  NOT NULL ,
	QUSTNR_SJ             VARCHAR(765)  NULL ,
	QUSTNR_PURPS          VARCHAR(3000)  NULL ,
	QUSTNR_WRITNG_GUIDANCE_CN  VARCHAR(6000)  NULL ,
	QUSTNR_TRGET          VARCHAR(3000)  NULL ,
	QUSTNR_BGNDE          CHAR(20)  NULL ,
	QUSTNR_ENDDE          CHAR(20)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTNQESTNRINFO_PK PRIMARY KEY (QUSTNR_TMPLAT_ID,QESTNR_ID)
);

CREATE TABLE COMTNQUSTNRRESPONDINFO
(
	QUSTNR_TMPLAT_ID      CHAR(20)  NOT NULL ,
	QESTNR_ID             CHAR(20)  NOT NULL ,
	QUSTNR_RESPOND_ID     CHAR(20)  NOT NULL ,
	SEXDSTN_CODE          CHAR(1)  NULL ,
	OCCP_TY_CODE          CHAR(1)  NULL ,
	RESPOND_NM            VARCHAR(150)  NULL ,
	BRTHDY                CHAR(20)  NULL ,
	AREA_NO               VARCHAR(12)  NULL ,
	MIDDLE_TELNO          VARCHAR(12)  NULL ,
	END_TELNO             VARCHAR(12)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTNQUSTNRRESPONDINFO_PK PRIMARY KEY (QUSTNR_TMPLAT_ID,QESTNR_ID,QUSTNR_RESPOND_ID)
);

CREATE TABLE COMTCADMINISTCODE
(
	ADMINIST_ZONE_SE      CHAR(1)  NOT NULL ,
	ADMINIST_ZONE_CODE    VARCHAR(30)  NOT NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	ADMINIST_ZONE_NM      VARCHAR(180)  NULL ,
	UPPER_ADMINIST_ZONE_CODE  VARCHAR(30)  NULL ,
	CREAT_DE              CHAR(20)  NULL ,
	ABL_DE                CHAR(20)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTCADMINISTCODE_PK PRIMARY KEY (ADMINIST_ZONE_SE,ADMINIST_ZONE_CODE)
);

CREATE TABLE COMTNUSERLOG
(
	OCCRRNC_DE            CHAR(8)  NOT NULL ,
	RQESTER_ID            VARCHAR(60)  NOT NULL ,
	SVC_NM                VARCHAR(765)  NOT NULL ,
	METHOD_NM             VARCHAR(180)  NOT NULL ,
	CREAT_CO              NUMERIC(10)  NULL ,
	UPDT_CO               NUMERIC(10)  NULL ,
	RDCNT                 NUMERIC(10)  NULL ,
	DELETE_CO             NUMERIC(10)  NULL ,
	OUTPT_CO              NUMERIC(10)  NULL ,
	ERROR_CO              NUMERIC(10)  NULL ,
CONSTRAINT  COMTNUSERLOG_PK PRIMARY KEY (OCCRRNC_DE,RQESTER_ID,SVC_NM,METHOD_NM)
);

CREATE TABLE COMTSTRSMRCVLOGSUMMARY
(
	OCCRRNC_DE            CHAR(20)  NOT NULL ,
	TRSMRCV_SE_CODE       CHAR(3)  NOT NULL ,
	PROVD_INSTT_ID        CHAR(8)  NOT NULL ,
	PROVD_SYS_ID          CHAR(8)  NOT NULL ,
	PROVD_SVC_ID          CHAR(8)  NOT NULL ,
	REQUST_INSTT_ID       CHAR(8)  NOT NULL ,
	REQUST_SYS_ID         CHAR(8)  NOT NULL ,
	RDCNT                 NUMERIC(10)  NULL ,
	ERROR_CO              NUMERIC(10)  NULL ,
CONSTRAINT  COMTSTRSMRCVLOGSUMMARY_PK PRIMARY KEY (OCCRRNC_DE,TRSMRCV_SE_CODE,PROVD_INSTT_ID,PROVD_SYS_ID,PROVD_SVC_ID,REQUST_INSTT_ID,REQUST_SYS_ID)
);

CREATE TABLE COMTCCMMNCLCODE
(
	CL_CODE               CHAR(3)  NOT NULL ,
	CL_CODE_NM            VARCHAR(180)  NULL ,
	CL_CODE_DC            VARCHAR(600)  NULL ,
	USE_AT                CHAR(1)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTCCMMNCLCODE_PK PRIMARY KEY (CL_CODE)
);

CREATE TABLE COMTCCMMNCODE
(
	CODE_ID               VARCHAR(18)  NOT NULL ,
	CODE_ID_NM            VARCHAR(180)  NULL ,
	CODE_ID_DC            VARCHAR(600)  NULL ,
	USE_AT                CHAR(1)  NULL ,
	CL_CODE               CHAR(3)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTCCMMNCODE_PK PRIMARY KEY (CODE_ID)
);

CREATE TABLE COMTCCMMNDETAILCODE
(
	CODE_ID               VARCHAR(18)  NOT NULL ,
	CODE                  VARCHAR(45)  NOT NULL ,
	CODE_NM               VARCHAR(180)  NULL ,
	CODE_DC               VARCHAR(600)  NULL ,
	USE_AT                CHAR(1)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTCCMMNDETAILCODE_PK PRIMARY KEY (CODE_ID,CODE)
);

CREATE TABLE COMTSBBSSUMMARY
(
	OCCRRNC_DE            CHAR(20)  NOT NULL ,
	STATS_SE              VARCHAR(30)  NOT NULL ,
	DETAIL_STATS_SE       VARCHAR(30)  NOT NULL ,
	CREAT_CO              NUMERIC(10)  NULL ,
	TOT_RDCNT             NUMERIC(10)  NULL ,
	AVRG_RDCNT            NUMERIC(10)  NULL ,
	TOP_INQIRE_BBSCTT_ID  VARCHAR(60)  NULL ,
	MUMM_INQIRE_BBSCTT_ID  VARCHAR(60)  NULL ,
	TOP_NTCR_ID           VARCHAR(60)  NULL ,
CONSTRAINT  COMTSBBSSUMMARY_PK PRIMARY KEY (OCCRRNC_DE,STATS_SE,DETAIL_STATS_SE)
);

CREATE TABLE COMTCZIP
(
	ZIP                   VARCHAR(18)  NOT NULL ,
	SN                    NUMERIC(10)  NOT NULL ,
	CTPRVN_NM             VARCHAR(60)  NULL ,
	SIGNGU_NM             VARCHAR(60)  NULL ,
	EMD_NM                VARCHAR(180)  NULL ,
	LI_BULD_NM            VARCHAR(180)  NULL ,
	LNBR_DONG_HO          VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTCZIP_PK PRIMARY KEY (ZIP,SN)
);

CREATE TABLE COMTRDNMADRZIP
(
	RDMN_CODE             VARCHAR(36) NOT NULL,
	SN                    INT, 
	CTPRVN_NM             VARCHAR(60) NULL,
	SIGNGU_NM             VARCHAR(60) NULL,
	RDMN                  VARCHAR(180) NULL,
	BDNBR_MNNM            VARCHAR(15) NULL,
	BDNBR_SLNO            VARCHAR(15) NULL,
	BULD_NM               VARCHAR(180) NULL,
	DETAIL_BULD_NM        VARCHAR(180) NULL,
	ZIP                   VARCHAR(18) NOT NULL,
	FRST_REGIST_PNTTM     DATETIME NULL,
	FRST_REGISTER_ID      VARCHAR(60) NULL,
	LAST_UPDT_PNTTM       DATETIME NULL,
	LAST_UPDUSR_ID        VARCHAR(60) NULL,
CONSTRAINT  COMTRDNMADRZIP_PK PRIMARY KEY (SN)
);

CREATE TABLE COMTNNCRD
(
	NCRD_ID               CHAR(20)  NOT NULL ,
	NCRD_TRGTER_ID        VARCHAR(60)  NULL ,
	NM                    VARCHAR(150)  NOT NULL ,
	TELNO                 VARCHAR(60)  NULL ,
	NATION_NO             VARCHAR(30)  NULL ,
	AREA_NO               VARCHAR(12)  NULL ,
	MIDDLE_TELNO          VARCHAR(12)  NULL ,
	END_TELNO             VARCHAR(12)  NULL ,
	MBTLNUM               VARCHAR(60)  NULL ,
	IDNTFC_NO             VARCHAR(30)  NULL ,
	MIDDLE_MBTLNUM        VARCHAR(12)  NULL ,
	END_MBTLNUM           VARCHAR(12)  NULL ,
	EMAIL_ADRES           VARCHAR(150)  NULL ,
	CMPNY_NM              VARCHAR(180)  NULL ,
	DEPT_NM               VARCHAR(180)  NULL ,
	ADRES                 VARCHAR(300)  NULL ,
	DETAIL_ADRES          VARCHAR(300)  NULL ,
	OFCPS_NM              VARCHAR(180)  NULL ,
	CLSF_NM               VARCHAR(180)  NULL ,
	EXTRL_USER_AT         CHAR(1)  NULL ,
	OTHBC_AT              CHAR(1)  NOT NULL ,
	RM                    VARCHAR(7500)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTNNCRD_PK PRIMARY KEY (NCRD_ID)
);

CREATE TABLE COMTNNCRDUSER
(
	NCRD_ID               CHAR(20)  NOT NULL ,
	REGIST_SE_CODE        CHAR(6)  NOT NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	CREAT_DT              DATETIME  NOT NULL ,
	EMPLYR_ID             VARCHAR(60)  NOT NULL ,
CONSTRAINT  COMTNNCRDUSER_PK PRIMARY KEY (NCRD_ID,EMPLYR_ID)
);

CREATE TABLE COMTNENTRPRSMBER
(
	ENTRPRS_MBER_ID       VARCHAR(60)  NOT NULL ,
	ENTRPRS_SE_CODE       CHAR(8)  NULL ,
	BIZRNO                VARCHAR(30)  NULL ,
	JURIRNO               VARCHAR(39)  NULL ,
	CMPNY_NM              VARCHAR(180)  NOT NULL ,
	CXFC                  VARCHAR(150)  NULL ,
	ZIP                   VARCHAR(18)  NOT NULL ,
	ADRES                 VARCHAR(300)  NOT NULL ,
	ENTRPRS_MIDDLE_TELNO  VARCHAR(12)  NOT NULL ,
	FXNUM                 VARCHAR(60)  NULL ,
	INDUTY_CODE           CHAR(1)  NULL ,
	APPLCNT_NM            VARCHAR(150)  NOT NULL ,
	APPLCNT_IHIDNUM       VARCHAR(600)  NULL ,
	SBSCRB_DE             DATETIME  NULL ,
	ENTRPRS_MBER_STTUS    VARCHAR(45)  NULL ,
	ENTRPRS_MBER_PASSWORD  VARCHAR(600)  NULL ,
	ENTRPRS_MBER_PASSWORD_HINT  VARCHAR(300)  NOT NULL ,
	ENTRPRS_MBER_PASSWORD_CNSR  VARCHAR(300)  NOT NULL ,
	GROUP_ID              CHAR(20)  NULL ,
	DETAIL_ADRES          VARCHAR(300)  NULL ,
	ENTRPRS_END_TELNO     VARCHAR(12)  NOT NULL ,
	AREA_NO               VARCHAR(12)  NOT NULL ,
	APPLCNT_EMAIL_ADRES   VARCHAR(150)  NOT NULL ,
	ESNTL_ID              CHAR(20)  NOT NULL ,
	LOCK_AT               CHAR(1) NULL,
	LOCK_CNT              NUMERIC(3) NULL,
	LOCK_LAST_PNTTM       DATETIME NULL,
	CHG_PWD_LAST_PNTTM    DATETIME NULL,
CONSTRAINT  COMTNENTRPRSMBER_PK PRIMARY KEY (ENTRPRS_MBER_ID)
);

CREATE TABLE COMTNGNRLMBER
(
	MBER_ID               VARCHAR(60)  NOT NULL ,
	PASSWORD              VARCHAR(600)  NOT NULL ,
	PASSWORD_HINT         VARCHAR(300)  NULL ,
	PASSWORD_CNSR         VARCHAR(300)  NULL ,
	IHIDNUM               VARCHAR(600)  NULL ,
	MBER_NM               VARCHAR(150)  NOT NULL ,
	ZIP                   VARCHAR(18)  NOT NULL ,
	ADRES                 VARCHAR(300)  NOT NULL ,
	AREA_NO               VARCHAR(12)  NOT NULL ,
	MBER_STTUS            VARCHAR(45)  NULL ,
	DETAIL_ADRES          VARCHAR(300)  NULL ,
	END_TELNO             VARCHAR(12)  NOT NULL ,
	MBTLNUM               VARCHAR(60)  NOT NULL ,
	GROUP_ID              CHAR(20)  NULL ,
	MBER_FXNUM            VARCHAR(60)  NULL ,
	MBER_EMAIL_ADRES      VARCHAR(150)  NULL ,
	MIDDLE_TELNO          VARCHAR(12)  NOT NULL ,
	SBSCRB_DE             DATETIME  NULL ,
	SEXDSTN_CODE          CHAR(1)  NULL ,
	ESNTL_ID              CHAR(20)  NOT NULL ,
	LOCK_AT               CHAR(1) NULL,
	LOCK_CNT              NUMERIC(3) NULL,
	LOCK_LAST_PNTTM       DATETIME NULL,
	CHG_PWD_LAST_PNTTM    DATETIME NULL,
CONSTRAINT  COMTNGNRLMBER_PK PRIMARY KEY (MBER_ID)
);

CREATE TABLE COMTNAUTHORINFO
(
	AUTHOR_CODE           VARCHAR(90)  NOT NULL ,
	AUTHOR_NM             VARCHAR(180)  NOT NULL ,
	AUTHOR_DC             VARCHAR(600)  NULL ,
	AUTHOR_CREAT_DE       CHAR(40)  NOT NULL ,
CONSTRAINT  COMTNAUTHORINFO_PK PRIMARY KEY (AUTHOR_CODE)
);

CREATE TABLE COMTNEMPLYRSCRTYESTBS
(
	SCRTY_DTRMN_TRGET_ID  VARCHAR(60)  NOT NULL ,
	MBER_TY_CODE          CHAR(5)  NULL ,
	AUTHOR_CODE           VARCHAR(90)  NOT NULL ,
CONSTRAINT  COMTNEMPLYRSCRTYESTBS_PK PRIMARY KEY (SCRTY_DTRMN_TRGET_ID)	
);
CREATE INDEX COMTNEMPLYRSCRTYESTBS_i04 ON COMTNEMPLYRSCRTYESTBS(AUTHOR_CODE  ASC);

CREATE TABLE COMTNQAINFO
(
	QA_ID                 CHAR(20)  NOT NULL ,
	QESTN_SJ              VARCHAR(765)  NULL ,
	QESTN_CN              VARCHAR(7500)  NULL ,
	WRITNG_DE             CHAR(20)  NULL ,
	RDCNT                 NUMERIC(10)  NULL ,
	EMAIL_ADRES           VARCHAR(150)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	QNA_PROCESS_STTUS_CODE  CHAR(1)  NULL ,
	WRTER_NM              VARCHAR(60)  NULL ,
	ANSWER_CN             VARCHAR(7500)  NULL ,
	WRITNG_PASSWORD       VARCHAR(60)  NULL ,
	ANSWER_DE             CHAR(20)  NULL ,
	EMAIL_ANSWER_AT       CHAR(1)  NULL ,
	AREA_NO               VARCHAR(12)  NULL ,
	MIDDLE_TELNO          VARCHAR(12)  NULL ,
	END_TELNO             VARCHAR(12)  NULL ,
CONSTRAINT  COMTNQAINFO_PK PRIMARY KEY (QA_ID)
);

CREATE TABLE COMTSWEBLOGSUMMARY
(
	OCCRRNC_DE            CHAR(8)  NOT NULL ,
	URL                   VARCHAR(600)  NOT NULL ,
	RDCNT                 NUMERIC(10)  NULL ,
CONSTRAINT  COMTSWEBLOGSUMMARY_PK PRIMARY KEY (OCCRRNC_DE,URL)
);

CREATE TABLE COMTNROLES_HIERARCHY
(
	PARNTS_ROLE           VARCHAR(90)  NOT NULL ,
	CHLDRN_ROLE           VARCHAR(90)  NOT NULL ,
CONSTRAINT  COMTNROLES_HIERARCHY_PK PRIMARY KEY (PARNTS_ROLE,CHLDRN_ROLE)
);
CREATE UNIQUE INDEX COMTNROLES_HIERARCHY_i01 ON COMTNROLES_HIERARCHY(PARNTS_ROLE  ASC);

CREATE TABLE COMTNROLEINFO
(
	ROLE_CODE             VARCHAR(150)  NOT NULL ,
	ROLE_NM               VARCHAR(180)  NOT NULL ,
	ROLE_PTTRN            VARCHAR(900)  NULL ,
	ROLE_DC               VARCHAR(600)  NULL ,
	ROLE_TY               VARCHAR(240)  NULL ,
	ROLE_SORT             VARCHAR(30)  NULL ,
	ROLE_CREAT_DE         CHAR(40)  NOT NULL ,
CONSTRAINT  COMTNROLEINFO_PK PRIMARY KEY (ROLE_CODE)
);

CREATE TABLE COMTNAUTHORROLERELATE
(
	AUTHOR_CODE           VARCHAR(90)  NOT NULL ,
	ROLE_CODE             VARCHAR(150)  NOT NULL ,
	CREAT_DT              DATETIME  NULL ,
CONSTRAINT  COMTNAUTHORROLERELATE_PK PRIMARY KEY (AUTHOR_CODE,ROLE_CODE)
);

CREATE TABLE COMTNLOGINLOG
(
	LOG_ID                CHAR(20)  NOT NULL ,
	CONECT_ID             VARCHAR(60)  NULL ,
	CONECT_IP             VARCHAR(69)  NULL ,
	CONECT_MTHD           CHAR(4)  NULL ,
	ERROR_OCCRRNC_AT      CHAR(1)  NULL ,
	ERROR_CODE            CHAR(3)  NULL ,
	CREAT_DT              DATETIME  NULL ,
CONSTRAINT  COMTNLOGINLOG_PK PRIMARY KEY (LOG_ID)
);

CREATE TABLE COMTNWEBLOG
(
	REQUST_ID             VARCHAR(60)  NOT NULL ,
	OCCRRNC_DE            DATETIME  NULL ,
	URL                   VARCHAR(600)  NULL ,
	RQESTER_ID            VARCHAR(60)  NULL ,
	RQESTER_IP            VARCHAR(69)  NULL ,
CONSTRAINT  COMTNWEBLOG_PK PRIMARY KEY (REQUST_ID)
);

CREATE TABLE COMTNEVENTINFO
(
	EVENT_ID              CHAR(20)  NOT NULL ,
	BSNS_YEAR             CHAR(4)  NULL ,
	BSNS_CODE             VARCHAR(6)  NULL ,
	EVENT_CN              VARCHAR(3000)  NULL ,
	EVENT_SVC_BGNDE       CHAR(20)  NULL ,
	SVC_USE_NMPR_CO       NUMERIC(10)  NULL ,
	CHARGER_NM            VARCHAR(150)  NULL ,
	PRPARETG_CN           VARCHAR(7500)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	EVENT_SVC_ENDDE       CHAR(20)  NULL ,
	EVENT_TY_CODE         CHAR(1)  NULL ,
	EVENT_CONFM_AT        CHAR(1)  NULL ,
	EVENT_CONFM_DE        CHAR(20)  NULL ,
CONSTRAINT  COMTNEVENTINFO_PK PRIMARY KEY (EVENT_ID)
);

CREATE TABLE COMTNEXTRLHRINFO
(
	EVENT_ID              CHAR(20)  NOT NULL ,
	EXTRL_HR_ID           CHAR(20)  NOT NULL ,
	SEXDSTN_CODE          CHAR(1)  NULL ,
	EXTRL_HR_NM           VARCHAR(180)  NULL ,
	OCCP_TY_CODE          CHAR(1)  NULL ,
	PSITN_INSTT_NM        VARCHAR(300)  NULL ,
	BRTHDY                CHAR(20)  NULL ,
	AREA_NO               VARCHAR(12)  NULL ,
	MIDDLE_TELNO          VARCHAR(12)  NULL ,
	END_TELNO             VARCHAR(12)  NULL ,
	EMAIL_ADRES           VARCHAR(150)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTNEXTRLHRINFO_PK PRIMARY KEY (EVENT_ID,EXTRL_HR_ID)
);

CREATE TABLE COMTNBBSUSE
(
	BBS_ID                CHAR(30)  NOT NULL ,
	TRGET_ID              CHAR(20)  NOT NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	REGIST_SE_CODE        CHAR(6)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NOT NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTNBBSUSE_PK PRIMARY KEY (BBS_ID,TRGET_ID)
);

CREATE TABLE COMTNSTPLATINFO
(
	USE_STPLAT_ID         CHAR(20)  NOT NULL ,
	USE_STPLAT_NM         VARCHAR(300)  NULL ,
	USE_STPLAT_CN         STRING  NULL ,
	INFO_PROVD_AGRE_CN    STRING  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTNSTPLATINFO_PK PRIMARY KEY (USE_STPLAT_ID)
);

CREATE TABLE COMTNQUSTNRQESITM
(
	QESTNR_ID             CHAR(20)  NOT NULL ,
	QUSTNR_QESITM_ID      CHAR(20)  NOT NULL ,
	QUSTNR_TMPLAT_ID      CHAR(20)  NOT NULL ,
	QESTN_SN              NUMERIC(10)  NULL ,
	QESTN_TY_CODE         CHAR(1)  NULL ,
	QESTN_CN              VARCHAR(7500)  NULL ,
	MXMM_CHOISE_CO        NUMERIC(5)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NOT NULL ,
	LAST_UPDT_PNTTM       DATETIME  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NOT NULL ,
CONSTRAINT  COMTNQUSTNRQESITM_PK PRIMARY KEY (QESTNR_ID,QUSTNR_QESITM_ID,QUSTNR_TMPLAT_ID)
);

CREATE TABLE COMTNQUSTNRRSPNSRESULT
(
	QUSTNR_RSPNS_RESULT_ID  CHAR(20)  NOT NULL ,
	QESTNR_ID             CHAR(20)  NOT NULL ,
	QUSTNR_QESITM_ID      CHAR(20)  NOT NULL ,
	QUSTNR_TMPLAT_ID      CHAR(20)  NOT NULL ,
	RESPOND_ANSWER_CN     VARCHAR(3000)  NULL ,
	ETC_ANSWER_CN         VARCHAR(3000)  NULL ,
	RESPOND_NM            VARCHAR(150)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	QUSTNR_IEM_ID         VARCHAR(60)  NULL ,
CONSTRAINT  COMTNQUSTNRRSPNSRESULT_PK PRIMARY KEY (QUSTNR_RSPNS_RESULT_ID,QESTNR_ID,QUSTNR_QESITM_ID,QUSTNR_TMPLAT_ID)
);

CREATE TABLE COMTNADBKMANAGE
(
	ADBK_ID               CHAR(20)  NOT NULL ,
	ADBK_NM               VARCHAR(150)  NOT NULL ,
	OTHBC_SCOPE           VARCHAR(60)  NOT NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	WRTER_ID              VARCHAR(60)  NULL ,
	TRGET_ORGNZT_ID       CHAR(20)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTNADBKMANAGE_PK PRIMARY KEY (ADBK_ID)
);

CREATE TABLE COMTNADBK
(
	EMPLYR_ID             VARCHAR(60) NULL ,
	NCRD_ID               CHAR(20)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	ADBK_CONSTNT_ID       CHAR(20)  NOT NULL ,
	NM                    VARCHAR(150)  NULL ,
	EMAIL_ADRES           VARCHAR(150)  NULL ,
	MBTLNUM               VARCHAR(60)  NULL ,
	FXNUM                 VARCHAR(60)  NULL ,
	OFFM_TELNO            VARCHAR(60)  NULL ,
	HOUSE_TELNO           VARCHAR(60)  NULL ,
	ADBK_ID               CHAR(20)  NOT NULL ,
CONSTRAINT  COMTNADBK_PK PRIMARY KEY (ADBK_CONSTNT_ID,ADBK_ID)
);

CREATE TABLE COMTNQUSTNRIEM
(
	QUSTNR_TMPLAT_ID      CHAR(20)  NOT NULL ,
	QESTNR_ID             CHAR(20)  NOT NULL ,
	QUSTNR_QESITM_ID      CHAR(20)  NOT NULL ,
	QUSTNR_IEM_ID         VARCHAR(60)  NOT NULL ,
	IEM_SN                NUMERIC(5)  NULL ,
	IEM_CN                VARCHAR(3000)  NULL ,
	ETC_ANSWER_AT         CHAR(1)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTNQUSTNRIEM_PK PRIMARY KEY (QUSTNR_TMPLAT_ID,QESTNR_ID,QUSTNR_QESITM_ID,QUSTNR_IEM_ID)
);

CREATE TABLE COMTNADMINISTRATIONWORD
(
	ADMINIST_WORD_ID      CHAR(20)  NOT NULL ,
	ADMINIST_WORD_NM      VARCHAR(765)  NULL ,
	ADMINIST_WORD_ENG_NM  VARCHAR(765)  NULL ,
	ADMINIST_WORD_ABRV_NM  VARCHAR(765)  NULL ,
	THEMA_RELM            VARCHAR(765)  NULL ,
	WORD_SE               VARCHAR(765)  NULL ,
	RELATE_STD_WORD       VARCHAR(765)  NULL ,
	ADMINIST_WORD_DFN     VARCHAR(7500)  NULL ,
	ADMINIST_WORD_DC      VARCHAR(12000)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNADMINISTRATIONWORD_PK PRIMARY KEY (ADMINIST_WORD_ID)
);

CREATE TABLE COMTNONLINEMANUAL
(
	ONLINE_MNL_ID         CHAR(20)  NOT NULL ,
	ONLINE_MNL_SE_CODE    CHAR(3)  NULL ,
	ONLINE_MNL_DFN        STRING  NULL ,
	ONLINE_MNL_DC         STRING  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	ONLINE_MNL_NM         VARCHAR(765)  NULL ,
CONSTRAINT  COMTNONLINEMANUAL_PK PRIMARY KEY (ONLINE_MNL_ID)
);

CREATE TABLE COMTSUSERSUMMARY
(
	OCCRRNC_DE            CHAR(20)  NOT NULL ,
	STATS_SE              VARCHAR(30)  NOT NULL ,
	DETAIL_STATS_SE       VARCHAR(30)  NOT NULL ,
	USER_CO               NUMERIC(10)  NULL ,
CONSTRAINT  COMTSUSERSUMMARY_PK PRIMARY KEY (OCCRRNC_DE,STATS_SE,DETAIL_STATS_SE)
);

CREATE TABLE COMTNFAQINFO
(
	FAQ_ID                CHAR(20)  NOT NULL ,
	QESTN_SJ              VARCHAR(765)  NULL ,
	QESTN_CN              VARCHAR(7500)  NULL ,
	ANSWER_CN             VARCHAR(7500)  NULL ,
	RDCNT                 NUMERIC(10)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NOT NULL ,
	LAST_UPDT_PNTTM       DATETIME  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NOT NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
	QNA_PROCESS_STTUS_CODE  CHAR(1)  NULL ,
CONSTRAINT  COMTNFAQINFO_PK PRIMARY KEY (FAQ_ID)
);

CREATE TABLE COMTNMTGINFO
(
	MTG_ID                CHAR(20)  NOT NULL ,
	MTG_NM                VARCHAR(765)  NULL ,
	MTG_MTR_CN            VARCHAR(3000)  NULL ,
	MTG_SN                NUMERIC(10)  NULL ,
	MTG_CO                NUMERIC(5)  NULL ,
	MTG_DE                CHAR(20)  NULL ,
	MTG_PLACE             VARCHAR(765)  NULL ,
	MTG_BEGIN_TM          VARCHAR(42)  NULL ,
	MTG_END_TM            VARCHAR(42)  NULL ,
	CLSDR_MTG_AT          CHAR(1)  NULL ,
	READNG_BGNDE          CHAR(20)  NULL ,
	READNG_AT             CHAR(1)  NULL ,
	MTG_RESULT_CN         VARCHAR(3000)  NULL ,
	MTG_RESULT_ENNC       CHAR(1)  NULL ,
	ETC_MATTER            VARCHAR(3000)  NULL ,
	MNGT_DEPT_ID          VARCHAR(60)  NULL ,
	MNAER_ID              VARCHAR(60)  NULL ,
	MNAER_DEPT_ID         VARCHAR(60)  NULL ,
	MTG_AT                CHAR(1)  NULL ,
	NONATDRN_CO           NUMERIC(10)  NULL ,
	ATDRN_CO              NUMERIC(10)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTNMTGINFO_PK PRIMARY KEY (MTG_ID)
);

CREATE TABLE COMTNREPRTSTATS
(
	REPRT_ID              CHAR(6)  NOT NULL ,
	REPRT_NM              VARCHAR(60)  NOT NULL ,
	REPRT_STTUS           CHAR(2)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NOT NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	REPRT_TY              CHAR(2)  NULL ,
CONSTRAINT  COMTNREPRTSTATS_PK PRIMARY KEY (REPRT_ID)
);

CREATE TABLE COMTNSMS
(
	SMS_ID                CHAR(20)  NOT NULL ,
	TRNSMIS_TELNO         VARCHAR(36)  NOT NULL ,
	TRNSMIS_CN            VARCHAR(240)  NOT NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NOT NULL ,
CONSTRAINT  COMTNSMS_PK PRIMARY KEY (SMS_ID)
);

CREATE TABLE COMTNSMSRECPTN
(
	SMS_ID                CHAR(20)  NOT NULL ,
	RECPTN_TELNO          VARCHAR(36)  NOT NULL ,
	RESULT_CODE           VARCHAR(12)  NULL ,
	RESULT_MSSAGE         VARCHAR(12000)  NULL ,
CONSTRAINT  COMTNSMSRECPTN_PK PRIMARY KEY (SMS_ID,RECPTN_TELNO)
);

CREATE TABLE COMTNCPYRHTINFO
(
	CPYRHT_ID             CHAR(20)  NOT NULL ,
	CPYRHT_PRTC_POLICY_CN  VARCHAR(7500)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTNCPYRHTINFO_PK PRIMARY KEY (CPYRHT_ID)
);

CREATE TABLE COMTNSCHDULINFO
(
	SCHDUL_ID             CHAR(20)  NOT NULL ,
	SCHDUL_SE             CHAR(1)  NULL ,
	SCHDUL_DEPT_ID        VARCHAR(60)  NULL ,
	SCHDUL_KND_CODE       CHAR(1)  NULL ,
	SCHDUL_BGNDE          CHAR(20)  NULL ,
	SCHDUL_ENDDE          CHAR(20)  NULL ,
	SCHDUL_NM             VARCHAR(765)  NULL ,
	SCHDUL_CN             VARCHAR(7500)  NULL ,
	SCHDUL_PLACE          VARCHAR(765)  NULL ,
	SCHDUL_IPCR_CODE      CHAR(1)  NULL ,
	SCHDUL_CHARGER_ID     VARCHAR(60)  NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	REPTIT_SE_CODE        CHAR(1)  NULL ,
CONSTRAINT  COMTNSCHDULINFO_PK PRIMARY KEY (SCHDUL_ID)
);

CREATE TABLE COMTNDIARYINFO
(
	SCHDUL_ID             CHAR(20)  NOT NULL ,
	DIARY_ID              CHAR(20)  NOT NULL ,
	DIARY_PROGRSRT        NUMERIC(3)  NULL ,
	DIARY_NM              VARCHAR(765)  NULL ,
	DRCT_MATTER           VARCHAR(7500)  NULL ,
	PARTCLR_MATTER        VARCHAR(7500)  NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTNDIARYINFO_PK PRIMARY KEY (SCHDUL_ID,DIARY_ID)
);

CREATE TABLE COMTNONLINEPOLLMANAGE
(
	POLL_ID               CHAR(20)  NOT NULL ,
	POLL_NM               VARCHAR(765)  NULL ,
	POLL_BGNDE            CHAR(10)  NULL ,
	POLL_ENDDE            CHAR(10)  NULL ,
	POLL_KND              CHAR(3)  NULL ,
	POLL_DSUSE_ENNC       CHAR(1)  NULL ,
	POLL_ATMC_DSUSE_ENNC  CHAR(1)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNONLINEPOLLMANAGE_PK PRIMARY KEY (POLL_ID)
);

CREATE TABLE COMTNONLINEPOLLIEM
(
	POLL_IEM_NM           VARCHAR(765)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	POLL_IEM_ID           CHAR(20)  NOT NULL ,
	POLL_ID               CHAR(20)  NOT NULL ,
CONSTRAINT  COMTNONLINEPOLLIEM_PK PRIMARY KEY (POLL_ID,POLL_IEM_ID)
);

CREATE TABLE COMTNONLINEPOLLRESULT
(
	POLL_RESULT_ID        CHAR(20)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	POLL_IEM_ID           CHAR(20)  NOT NULL ,
	POLL_ID               CHAR(20)  NOT NULL ,
CONSTRAINT  COMTNONLINEPOLLRESULT_PK PRIMARY KEY (POLL_RESULT_ID,POLL_IEM_ID,POLL_ID)
);

CREATE TABLE COMTNWORDDICARYINFO
(
	WORD_ID               CHAR(20)  NOT NULL ,
	WORD_NM               VARCHAR(765)  NULL ,
	ENG_NM                VARCHAR(180)  NULL ,
	WORD_DC               VARCHAR(12000)  NULL ,
	SYNONM                VARCHAR(300)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTNWORDDICARYINFO_PK PRIMARY KEY (WORD_ID)
);

CREATE TABLE COMTNCNTCSERVICE
(
	INSTT_ID              VARCHAR(60)  NOT NULL ,
	SYS_ID                VARCHAR(60)  NOT NULL ,
	SVC_ID                VARCHAR(60)  NOT NULL ,
	SVC_NM                VARCHAR(765)  NULL ,
	REQUST_MSSAGE_ID      VARCHAR(60)  NULL ,
	RSPNS_MSSAGE_ID       VARCHAR(60)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	USE_AT                CHAR(1)  NULL ,
CONSTRAINT  COMTNCNTCSERVICE_PK PRIMARY KEY (INSTT_ID,SYS_ID,SVC_ID)
);

CREATE TABLE COMTNHPCMINFO
(
	HPCM_ID               CHAR(20)  NOT NULL ,
	HPCM_SE_CODE          CHAR(1)  NULL ,
	HPCM_DFN              VARCHAR(3000)  NULL ,
	HPCM_DC               VARCHAR(7500)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTNHPCMINFO_PK PRIMARY KEY (HPCM_ID)
);

CREATE TABLE COMTNNEWSINFO
(
	NEWS_ID               CHAR(20)  NOT NULL ,
	NEWS_SJ               VARCHAR(300)  NULL ,
	NEWS_CN               VARCHAR(7500)  NULL ,
	NEWS_ORIGIN           VARCHAR(750)  NULL ,
	NTCE_AT               CHAR(1)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NOT NULL ,
	LAST_UPDT_PNTTM       DATETIME  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NOT NULL ,
	NTCE_DE               CHAR(20)  NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
CONSTRAINT  COMTNNEWSINFO_PK PRIMARY KEY (NEWS_ID)
);

CREATE TABLE COMTNCNSLTLIST
(
	CNSLT_ID              CHAR(20)  NOT NULL ,
	CNSLT_SJ              VARCHAR(765)  NULL ,
	OTHBC_AT              CHAR(1)  NULL ,
	EMAIL_ADRES           VARCHAR(150)  NULL ,
	CNSLT_CN              VARCHAR(7500)  NULL ,
	MANAGT_CN             VARCHAR(7500)  NULL ,
	MANAGT_DE             CHAR(20)  NULL ,
	RDCNT                 NUMERIC(10)  NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	AREA_NO               VARCHAR(12)  NULL ,
	MIDDLE_TELNO          VARCHAR(12)  NULL ,
	END_TELNO             VARCHAR(12)  NULL ,
	FRST_MBTLNUM          VARCHAR(12)  NULL ,
	MIDDLE_MBTLNUM        VARCHAR(12)  NULL ,
	END_MBTLNUM           VARCHAR(12)  NULL ,
	WRITNG_DE             CHAR(20)  NULL ,
	WRTER_NM              VARCHAR(60)  NULL ,
	EMAIL_ANSWER_AT       CHAR(1)  NULL ,
	QNA_PROCESS_STTUS_CODE  CHAR(1)  NULL ,
	WRITNG_PASSWORD       VARCHAR(60)  NULL ,
CONSTRAINT  COMTNCNSLTLIST_PK PRIMARY KEY (CNSLT_ID)
);

CREATE TABLE COMTNMENUINFO
(
	MENU_NM               VARCHAR(180)  NOT NULL ,
	PROGRM_FILE_NM        VARCHAR(180)  NOT NULL ,
	MENU_NO               NUMERIC(20)  NOT NULL ,
	UPPER_MENU_NO         NUMERIC(20)  NULL ,
	MENU_ORDR             NUMERIC(5)  NOT NULL ,
	MENU_DC               VARCHAR(750)  NULL ,
	RELATE_IMAGE_PATH     VARCHAR(300)  NULL ,
	RELATE_IMAGE_NM       VARCHAR(180)  NULL ,
CONSTRAINT  COMTNMENUINFO_PK PRIMARY KEY (MENU_NO)
);

CREATE TABLE COMTNSITEMAP
(
	MAPNG_CREAT_ID        VARCHAR(90)  NOT NULL ,
	CREATR_ID             VARCHAR(60)  NOT NULL ,
	MAPNG_FILE_NM         VARCHAR(180)  NOT NULL ,
	MAPNG_FILE_PATH       VARCHAR(300)  NOT NULL ,
CONSTRAINT  COMTNSITEMAP_PK PRIMARY KEY (MAPNG_CREAT_ID)
);

CREATE TABLE COMTNMENUCREATDTLS
(
	MENU_NO               NUMERIC(20)  NOT NULL ,
	AUTHOR_CODE           VARCHAR(90)  NOT NULL ,
	MAPNG_CREAT_ID        VARCHAR(90)  NULL ,
CONSTRAINT  COMTNMENUCREATDTLS_PK PRIMARY KEY (MENU_NO,AUTHOR_CODE)
);

CREATE TABLE COMTHEMPLYRINFOCHANGEDTLS
(
	EMPLYR_ID             VARCHAR(60)  NOT NULL ,
	CHANGE_DE             CHAR(20)  NULL ,
	ORGNZT_ID             CHAR(20)  NULL ,
	GROUP_ID              CHAR(20)  NULL ,
	EMPL_NO               VARCHAR(60)  NULL ,
	SEXDSTN_CODE          CHAR(1)  NULL ,
	BRTHDY                CHAR(20)  NULL ,
	FXNUM                 VARCHAR(60)  NULL ,
	HOUSE_ADRES           VARCHAR(300)  NULL ,
	HOUSE_END_TELNO       VARCHAR(12)  NULL ,
	AREA_NO               VARCHAR(12)  NULL ,
	DETAIL_ADRES          VARCHAR(300)  NULL ,
	ZIP                   VARCHAR(18)  NULL ,
	OFFM_TELNO            VARCHAR(60)  NULL ,
	MBTLNUM               VARCHAR(60)  NULL ,
	EMAIL_ADRES           VARCHAR(150)  NULL ,
	HOUSE_MIDDLE_TELNO    VARCHAR(12)  NULL ,
	PSTINST_CODE          CHAR(8)  NULL ,
	EMPLYR_STTUS_CODE     CHAR(1)  NULL ,
	ESNTL_ID              CHAR(20)  NULL ,
CONSTRAINT  COMTHEMPLYRINFOCHANGEDTLS_PK PRIMARY KEY (EMPLYR_ID,CHANGE_DE)
);

CREATE TABLE COMTNNTFCINFO
(
	NTCN_NO               NUMERIC(20)  NOT NULL ,
	NTCN_SJ               VARCHAR(180)  NOT NULL ,
	NTCN_CN               VARCHAR(300)  NOT NULL ,
	NTCN_TM               VARCHAR(42)  NOT NULL ,
	BH_NTCN_INTRVL        VARCHAR(60)  NOT NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTNNTFCINFO_PK PRIMARY KEY (NTCN_NO)
);

CREATE TABLE COMTNCNTCSYSTEM
(
	INSTT_ID              VARCHAR(60)  NOT NULL ,
	SYS_ID                VARCHAR(60)  NOT NULL ,
	SYS_NM                VARCHAR(765)  NULL ,
	SYS_IP                VARCHAR(69)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	USE_AT                CHAR(1)  NULL ,
CONSTRAINT  COMTNCNTCSYSTEM_PK PRIMARY KEY (INSTT_ID,SYS_ID)
);

CREATE TABLE COMTNBBSMASTEROPTN
(
	BBS_ID                CHAR(30)  NOT NULL ,
	ANSWER_AT             CHAR(1)  NOT NULL ,
	STSFDG_AT             CHAR(1)  NOT NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTNBBSMASTEROPTN_PK PRIMARY KEY (BBS_ID)
);

CREATE TABLE COMTNANSWER
(
	NTT_ID                NUMERIC(20)  NOT NULL ,
	BBS_ID                CHAR(30)  NOT NULL ,
	WRTER_ID              VARCHAR(60)  NULL ,
	ANSWER                VARCHAR(600)  NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	WRTER_NM              VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NOT NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	ANSWER_NO             NUMERIC(20)  NOT NULL ,
CONSTRAINT  COMTNANSWER_PK PRIMARY KEY (NTT_ID,BBS_ID,ANSWER_NO)
);

CREATE TABLE COMTNTRSMRCVLOG
(
	REQUST_ID             VARCHAR(60)  NOT NULL ,
	OCCRRNC_DE            CHAR(20)  NULL ,
	TRSMRCV_SE_CODE       CHAR(3)  NULL ,
	CNTC_ID               CHAR(8)  NULL ,
	PROVD_INSTT_ID        CHAR(8)  NULL ,
	PROVD_SYS_ID          CHAR(8)  NULL ,
	PROVD_SVC_ID          CHAR(8)  NULL ,
	REQUST_INSTT_ID       CHAR(8)  NULL ,
	REQUST_SYS_ID         CHAR(8)  NULL ,
	REQUST_TRNSMIT_TM     VARCHAR(42)  NULL ,
	REQUST_RECPTN_TM      VARCHAR(42)  NULL ,
	RSPNS_TRNSMIT_TM      VARCHAR(42)  NULL ,
	RSPNS_RECPTN_TM       VARCHAR(42)  NULL ,
	RESULT_CODE           VARCHAR(12)  NULL ,
	RESULT_MSSAGE         VARCHAR(12000)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	RQESTER_ID            VARCHAR(60)  NULL ,
CONSTRAINT  COMTNTRSMRCVLOG_PK PRIMARY KEY (REQUST_ID)
);

CREATE TABLE COMTNDAMCALRES
(
	ORGNZT_ID             VARCHAR(20)  NULL ,
	EXPERT_ID             CHAR(20)  NULL ,
	KNWLDG_TY_CODE        VARCHAR(9)  NULL ,
	EMPLYR_ID             VARCHAR(60)  NULL ,
	KNWLDG_NM             VARCHAR(180)  NULL ,
	KNWLDG_CN             VARCHAR(7500)  NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
	PARNTS_KNWLDG_ID      CHAR(20)  NULL ,
	ANSWER_DP             NUMERIC(20)  NULL ,
	ANSWER_ORDR           NUMERIC(20)  NULL ,
	ANSWER_GROUP_NO       NUMERIC(20)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	KNWLDG_ID             CHAR(20)  NOT NULL ,
CONSTRAINT  COMTNDAMCALRES_PK PRIMARY KEY (KNWLDG_ID)
);

CREATE TABLE COMTNBACKUPRESULT
(
	BACKUP_RESULT_ID      VARCHAR(60)  NOT NULL ,
	BACKUP_OPERT_ID       VARCHAR(60)  NOT NULL ,
	BACKUP_FILE           VARCHAR(765)  NULL ,
	STTUS                 VARCHAR(6)  NULL ,
	ERROR_INFO            VARCHAR(6000)  NULL ,
	EXECUT_BEGIN_TM       VARCHAR(42)  NULL ,
	EXECUT_END_TM         VARCHAR(42)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NOT NULL ,
CONSTRAINT  COMTNBACKUPRESULT_PK PRIMARY KEY (BACKUP_RESULT_ID)
);

CREATE TABLE COMTHTRSMRCVMNTRNGLOGINFO
(
	LOG_ID                CHAR(20)  NOT NULL ,
	CNTC_ID               CHAR(8)  NOT NULL ,
	TEST_CLASS_NM         VARCHAR(765)  NULL ,
	MNGR_NM               VARCHAR(180)  NULL ,
	MNGR_EMAIL_ADRES      VARCHAR(150)  NULL ,
	MNTRNG_STTUS          CHAR(2)  NULL ,
	LOG_INFO              VARCHAR(6000)  NULL ,
	CREAT_DT              DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NOT NULL ,
CONSTRAINT  COMTHTRSMRCVMNTRNGLOGINFO_PK PRIMARY KEY (LOG_ID)
);

CREATE TABLE COMTNSCRAP
(
	SCRAP_ID              CHAR(20)  NOT NULL ,
	NTT_ID                NUMERIC(20)  NOT NULL ,
	BBS_ID                CHAR(30)  NOT NULL ,
	SCRAP_NM              VARCHAR(300)  NOT NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTNSCRAP_PK PRIMARY KEY (SCRAP_ID)
);

CREATE TABLE COMTNCNTCINSTT
(
	INSTT_ID              VARCHAR(60)  NOT NULL ,
	INSTT_NM              VARCHAR(300)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	USE_AT                CHAR(1)  NULL ,
CONSTRAINT  COMTNCNTCINSTT_PK PRIMARY KEY (INSTT_ID)
);

CREATE TABLE COMTHSYSHIST
(
	HIST_ID               CHAR(20)  NOT NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NOT NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	HIST_SE_CODE          CHAR(6)  NOT NULL ,
	HIST_CN               VARCHAR(7500)  NOT NULL ,
	SYS_NM                VARCHAR(765)  NOT NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
CONSTRAINT  COMTHSYSHIST_PK PRIMARY KEY (HIST_ID)
);

CREATE TABLE COMTNHTTPMON
(
	SYS_ID                VARCHAR(60)  NOT NULL ,
	SITE_URL              VARCHAR(300)  NULL ,
	WEBSVC_KND            VARCHAR(30)  NULL ,
	HTTP_STTUS_CODE       VARCHAR(9)  NULL ,
	CREAT_DT              DATETIME  NULL ,
	MNGR_NM               VARCHAR(180)  NULL ,
	MNGR_EMAIL_ADRES      VARCHAR(150)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	DELETE_AT			  CHAR(1)	NULL ,
CONSTRAINT  COMTNHTTPMON_PK PRIMARY KEY (SYS_ID)
);

CREATE TABLE COMTHHTTPMONLOGINFO
(
	SYS_ID                VARCHAR(60)  NOT NULL ,
	SITE_URL              VARCHAR(300)  NULL ,
	WEBSVC_KND            VARCHAR(30)  NULL ,
	HTTP_STTUS_CODE       VARCHAR(9)  NULL ,
	CREAT_DT              DATETIME  NULL ,
	LOG_INFO              VARCHAR(6000)  NULL ,
	MNGR_NM               VARCHAR(180)  NULL ,
	MNGR_EMAIL_ADRES      VARCHAR(150)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LOG_ID                CHAR(20)  NOT NULL ,
CONSTRAINT  COMTHHTTPMONLOGINFO_PK PRIMARY KEY (SYS_ID,LOG_ID)
);

CREATE TABLE COMTHDBMNTRNGLOGINFO
(
	DATA_SOURC_NM         VARCHAR(180)  NOT NULL ,
	SERVER_NM             VARCHAR(180)  NULL ,
	DBMS_KND              VARCHAR(6)  NULL ,
	CECK_SQL              VARCHAR(750)  NULL ,
	MNGR_NM               VARCHAR(180)  NULL ,
	MNGR_EMAIL_ADRES      VARCHAR(150)  NULL ,
	MNTRNG_STTUS          CHAR(2)  NULL ,
	LOG_INFO              VARCHAR(6000)  NULL ,
	CREAT_DT              DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	LAST_UPDT_PNTTM       DATETIME  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LOG_ID                CHAR(20)  NOT NULL ,
CONSTRAINT  COMTHDBMNTRNGLOGINFO_PK PRIMARY KEY (LOG_ID)
);

CREATE TABLE COMTHCONFMHISTORY
(
	CONFM_NO              NUMERIC(8)  NOT NULL ,
	CONFM_RQESTER_ID      VARCHAR(60)  NOT NULL ,
	CONFMER_ID            VARCHAR(60)  NULL ,
	CONFM_DE              CHAR(20)  NULL ,
	CONFM_TY_CODE         CHAR(4)  NOT NULL ,
	CONFM_STTUS_CODE      CHAR(4)  NOT NULL ,
	OPERT_TY_CODE         CHAR(4)  NULL ,
	OPERT_ID              VARCHAR(60)  NULL ,
	TRGET_JOB_TY_CODE     CHAR(3)  NULL ,
	TRGET_JOB_ID          CHAR(20)  NULL ,
CONSTRAINT  COMTHCONFMHISTORY_PK PRIMARY KEY (CONFM_NO)
);

CREATE TABLE COMTNDAMMAPTEAM
(
	ORGNZT_ID             VARCHAR(20)  NOT NULL ,
	ORGNZT_NM             VARCHAR(60)  NULL ,
	CL_DE                 CHAR(20)  NULL ,
	KNWLDG_URL            VARCHAR(765)  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNDAMMAPTEAM_PK PRIMARY KEY (ORGNZT_ID)
);

CREATE TABLE COMTNTMPLATINFO
(
	TMPLAT_ID             CHAR(20)  NOT NULL ,
	TMPLAT_NM             VARCHAR(765)  NULL ,
	TMPLAT_COURS          VARCHAR(6000)  NULL ,
	USE_AT                CHAR(1)  NULL ,
	TMPLAT_SE_CODE        CHAR(6)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNTMPLATINFO_PK PRIMARY KEY (TMPLAT_ID)
);

CREATE TABLE COMTNINDVDLPGECNTNTS
(
	CNTNTS_ID             VARCHAR(60)  NOT NULL ,
	CNTNTS_NM             VARCHAR(300)  NOT NULL ,
	CNTC_URL              VARCHAR(765)  NOT NULL ,
	CNTNTS_USE_AT         CHAR(1)  NOT NULL ,
	CNTNTS_LINK_URL       VARCHAR(3000)  NULL ,
	CNTNTS_DC             VARCHAR(750)  NULL ,
CONSTRAINT  COMTNINDVDLPGECNTNTS_PK PRIMARY KEY (CNTNTS_ID)
);

CREATE TABLE COMTNINDVDLPGEESTBS
(
	EMPLYR_ID             VARCHAR(60)  NOT NULL ,
	UPEND_IMAGE           VARCHAR(3072)  NULL ,
	TITLEBAR_COLOR        CHAR(7)  NULL ,
	ALGN_MTHD             CHAR(1)  NULL ,
	ALGN_CO               NUMERIC(10)  NULL ,
CONSTRAINT  COMTNINDVDLPGEESTBS_PK PRIMARY KEY (EMPLYR_ID)
);

CREATE TABLE COMTNCNTNTSLIST
(
	CNTNTS_ID             VARCHAR(60)  NOT NULL ,
	EMPLYR_ID             VARCHAR(60)  NOT NULL ,
CONSTRAINT  COMTNCNTNTSLIST_PK PRIMARY KEY (CNTNTS_ID,EMPLYR_ID)
);

CREATE TABLE COMTNCNTCMESSAGE
(
	CNTC_MSSAGE_ID        VARCHAR(60)  NOT NULL ,
	CNTC_MSSAGE_NM        VARCHAR(300)  NULL ,
	UPPER_CNTC_MSSAGE_ID  VARCHAR(60)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	USE_AT                CHAR(1)  NULL ,
CONSTRAINT  COMTNCNTCMESSAGE_PK PRIMARY KEY (CNTC_MSSAGE_ID)
);

CREATE TABLE COMTNCNTCMESSAGEITEM
(
	CNTC_MSSAGE_ID        VARCHAR(60)  NOT NULL ,
	IEM_ID                VARCHAR(60)  NOT NULL ,
	IEM_NM                VARCHAR(300)  NULL ,
	IEM_TY                VARCHAR(150)  NULL ,
	IEM_LT                NUMERIC(8)  NULL ,
	USE_AT                CHAR(1)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNCNTCMESSAGEITEM_PK PRIMARY KEY (CNTC_MSSAGE_ID,IEM_ID)
);

CREATE TABLE COMTNBKMKMENUMANAGERESULT
(
	MENU_ID               NUMERIC(20)  NOT NULL ,
	EMPLYR_ID             VARCHAR(60)  NOT NULL ,
	MENU_NM               VARCHAR(180)  NOT NULL ,
	PROGRM_STRE_PATH      VARCHAR(300)  NOT NULL ,
CONSTRAINT  COMTNBKMKMENUMANAGERESULT_PK PRIMARY KEY (MENU_ID,EMPLYR_ID)
);

CREATE TABLE COMTNSYSTEMCNTC
(
	CNTC_ID               CHAR(8)  NOT NULL ,
	CNTC_NM               VARCHAR(300)  NULL ,
	PROVD_INSTT_ID        CHAR(8)  NULL ,
	PROVD_SYS_ID          CHAR(8)  NULL ,
	PROVD_SVC_ID          CHAR(8)  NULL ,
	REQUST_INSTT_ID       CHAR(8)  NULL ,
	REQUST_SYS_ID         CHAR(8)  NULL ,
	CONFM_AT              CHAR(1)  NULL ,
	USE_AT                CHAR(1)  NULL ,
	VALID_BGNDE           CHAR(20)  NULL ,
	VALID_ENDDE           CHAR(20)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	CNTC_TY               VARCHAR(180)  NULL ,
CONSTRAINT  COMTNSYSTEMCNTC_PK PRIMARY KEY (CNTC_ID)
);

CREATE TABLE COMTNINDVDLINFOPOLICY
(
	INDVDL_INFO_POLICY_ID  CHAR(20)  NOT NULL ,
	INDVDL_INFO_POLICY_CN  VARCHAR(7500)  NULL ,
	INDVDL_INFO_POLICY_AGRE_AT  CHAR(1)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	INDVDL_INFO_POLICY_NM  VARCHAR(765)  NULL ,
CONSTRAINT  COMTNINDVDLINFOPOLICY_PK PRIMARY KEY (INDVDL_INFO_POLICY_ID)
);

CREATE TABLE COMTNBNDTMANAGE
(
	BNDT_ID               VARCHAR(60)  NOT NULL ,
	BNDT_DE               CHAR(8)  NOT NULL ,
	RM                    VARCHAR(7500)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNBNDTMANAGE_PK PRIMARY KEY (BNDT_ID,BNDT_DE)
);

CREATE TABLE COMTNBNDTCECKMANAGE
(
	BNDT_CECK_SE          CHAR(2)  NOT NULL ,
	BNDT_CECK_CODE        VARCHAR(30)  NOT NULL ,
	BNDT_CECK_CODE_NM     VARCHAR(765)  NOT NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNBNDTCECKMANAGE_PK PRIMARY KEY (BNDT_CECK_CODE,BNDT_CECK_SE)
);

CREATE TABLE COMTNBNDTDIARY
(
	BNDT_ID               VARCHAR(60)  NOT NULL ,
	BNDT_DE               CHAR(8)  NOT NULL ,
	BNDT_CECK_SE          CHAR(2)  NOT NULL ,
	BNDT_CECK_CODE        VARCHAR(30)  NOT NULL ,
	CHCK_STTUS            VARCHAR(3000)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNBNDTDIARY_PK PRIMARY KEY (BNDT_ID,BNDT_DE,BNDT_CECK_SE,BNDT_CECK_CODE)
);

CREATE TABLE COMTNBATCHRESULT
(
	BATCH_RESULT_ID       VARCHAR(60)  NOT NULL ,
	BATCH_SCHDUL_ID       VARCHAR(60)  NOT NULL ,
	BATCH_OPERT_ID        VARCHAR(60)  NOT NULL ,
	PARAMTR               VARCHAR(750)  NULL ,
	STTUS                 VARCHAR(6)  NULL ,
	ERROR_INFO            VARCHAR(6000)  NULL ,
	EXECUT_BEGIN_TM       VARCHAR(42)  NULL ,
	EXECUT_END_TM         VARCHAR(42)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
CONSTRAINT  COMTNBATCHRESULT_PK PRIMARY KEY (BATCH_RESULT_ID)
);

CREATE TABLE COMTNSTSFDG
(
	STSFDG_NO             NUMERIC(20)  NOT NULL ,
	NTT_ID                NUMERIC(20)  NOT NULL ,
	BBS_ID                CHAR(30)  NOT NULL ,
	WRTER_ID              VARCHAR(60)  NULL ,
	WRTER_NM              VARCHAR(60)  NULL ,
	PASSWORD              VARCHAR(600)  NULL ,
	STSFDG                NUMERIC(1)  NOT NULL ,
	STSFDG_CN             VARCHAR(600)  NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTNSTSFDG_PK PRIMARY KEY (STSFDG_NO)
);

CREATE TABLE COMTNBATCHOPERT
(
	BATCH_OPERT_ID        VARCHAR(60)  NOT NULL ,
	BATCH_OPERT_NM        VARCHAR(180)  NULL ,
	BATCH_PROGRM          VARCHAR(765)  NULL ,
	PARAMTR               VARCHAR(750)  NULL ,
	USE_AT                CHAR(1)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NOT NULL ,
CONSTRAINT  COMTNBATCHOPERT_PK PRIMARY KEY (BATCH_OPERT_ID)
);

CREATE TABLE COMTNFILESYSMNTRNG
(
	FILE_SYS_ID           CHAR(20)  NOT NULL ,
	FILE_SYS_NM           VARCHAR(180)  NOT NULL ,
	FILE_SYS_MANAGE_NM    VARCHAR(765)  NOT NULL ,
	FILE_SYS_SIZE         NUMERIC(8)  NOT NULL ,
	FILE_SYS_THRHLD       NUMERIC(8)  NOT NULL ,
	FILE_SYS_USGQTY       NUMERIC(8)  NULL ,
	MNGR_NM               VARCHAR(180)  NULL ,
	MNGR_EMAIL_ADRES      VARCHAR(150)  NULL ,
	MNTRNG_STTUS          CHAR(2)  NULL ,
	CREAT_DT              DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNFILESYSMNTRNG_PK PRIMARY KEY (FILE_SYS_ID)
);

CREATE TABLE COMTNFILESYSMNTRNGLOGINFO
(
	FILE_SYS_ID           CHAR(20)  NOT NULL ,
	FILE_SYS_NM           VARCHAR(180)  NOT NULL ,
	FILE_SYS_MANAGE_NM    VARCHAR(765)  NOT NULL ,
	FILE_SYS_SIZE         NUMERIC(8)  NOT NULL ,
	FILE_SYS_THRHLD       NUMERIC(8)  NOT NULL ,
	FILE_SYS_USGQTY       NUMERIC(8)  NULL ,
	MNTRNG_STTUS          CHAR(2)  NULL ,
	LOG_INFO              VARCHAR(6000)  NULL ,
	CREAT_DT              DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LOG_ID                CHAR(20)  NOT NULL ,
CONSTRAINT  COMTNFILESYSMNTRNGLOGINFO_PK PRIMARY KEY (FILE_SYS_ID,LOG_ID)
);

CREATE TABLE COMTNBATCHSCHDUL
(
	BATCH_SCHDUL_ID       VARCHAR(60)  NOT NULL ,
	BATCH_OPERT_ID        VARCHAR(60)  NOT NULL ,
	EXECUT_CYCLE          VARCHAR(6)  NULL ,
	EXECUT_SCHDUL_DE      CHAR(20)  NULL ,
	EXECUT_SCHDUL_HOUR    CHAR(2)  NULL ,
	EXECUT_SCHDUL_MNT     CHAR(2)  NULL ,
	EXECUT_SCHDUL_SECND   CHAR(2)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NOT NULL ,
CONSTRAINT  COMTNBATCHSCHDUL_PK PRIMARY KEY (BATCH_SCHDUL_ID)
);

CREATE TABLE COMTNBATCHSCHDULDFK
(
	BATCH_SCHDUL_ID       VARCHAR(60)  NOT NULL ,
	EXECUT_SCHDUL_DFK_SE  CHAR(1)  NOT NULL ,
CONSTRAINT  COMTNBATCHSCHDULDFK_PK PRIMARY KEY (BATCH_SCHDUL_ID,EXECUT_SCHDUL_DFK_SE)
);

CREATE TABLE COMTNCTSNNMANAGE
(
	CTSNN_ID              VARCHAR(60)  NOT NULL ,
	USER_ID               VARCHAR(60)  NOT NULL ,
	CTSNN_CODE            CHAR(2)  NOT NULL ,
	REQST_DE              CHAR(20)  NOT NULL ,
	CTSNN_NM              VARCHAR(765)  NOT NULL ,
	TRGTER_NM             VARCHAR(60)  NOT NULL ,
	BRTHDY                CHAR(20)  NOT NULL ,
	OCCRRNC_DE            CHAR(20)  NOT NULL ,
	RELATE                CHAR(2)  NOT NULL ,
	RM                    VARCHAR(7500)  NULL ,
	SANCTNER_ID           VARCHAR(60)  NOT NULL ,
	CONFM_AT              CHAR(1)  NULL ,
	SANCTN_DT             DATETIME  NULL ,
	RETURN_RESN           VARCHAR(3000)  NULL ,
	INFRML_SANCTN_ID      CHAR(20)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNCTSNNMANAGE_PK PRIMARY KEY (CTSNN_ID)
);

CREATE TABLE COMTCADMINISTCODERECPTNLOG
(
	OCCRRNC_DE            CHAR(20)  NOT NULL ,
	ADMINIST_ZONE_SE      CHAR(1)  NOT NULL ,
	ADMINIST_ZONE_CODE    VARCHAR(30)  NOT NULL ,
	OPERT_SN              NUMERIC(10)  NOT NULL ,
	CHANGE_SE_CODE        VARCHAR(6)  NULL ,
	PROCESS_SE            VARCHAR(6)  NULL ,
	ADMINIST_ZONE_NM      VARCHAR(180)  NULL ,
	LOWEST_ADMINIST_ZONE_NM  VARCHAR(180)  NULL ,
	CTPRVN_CODE           VARCHAR(6)  NULL ,
	SIGNGU_CODE           VARCHAR(9)  NULL ,
	EMD_CODE              VARCHAR(9)  NULL ,
	LI_CODE               VARCHAR(6)  NULL ,
	CREAT_DE              CHAR(20)  NULL ,
	ABL_DE                CHAR(20)  NULL ,
	ABL_ENNC              CHAR(1)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTCADMINISTCODERECPTNLOG_PK PRIMARY KEY (OCCRRNC_DE,ADMINIST_ZONE_SE,ADMINIST_ZONE_CODE,OPERT_SN)
);

CREATE TABLE COMTNTROBLINFO
(
	TROBL_ID              CHAR(20)  NOT NULL ,
	TROBL_NM              VARCHAR(180)  NULL ,
	TROBL_KND             CHAR(2)  NULL ,
	TROBL_DC              VARCHAR(6000)  NULL ,
	TROBL_OCCRRNC_TIME    VARCHAR(42)  NULL ,
	TROBL_RQESTER_NM      VARCHAR(180)  NULL ,
	TROBL_REQUST_TIME     VARCHAR(42)  NULL ,
	TROBL_PROCESS_RESULT  VARCHAR(6000)  NULL ,
	TROBL_OPETR_NM        VARCHAR(180)  NULL ,
	TROBL_PROCESS_TIME    VARCHAR(42)  NULL ,
	PROCESS_STTUS         CHAR(1)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNTROBLINFO_PK PRIMARY KEY (TROBL_ID)
);

CREATE TABLE COMTNDAMKNOIFM
(
	KNWLDG_ID             CHAR(20)  NOT NULL ,
	KNWLDG_TY_CODE        VARCHAR(9)  NULL ,
	ORGNZT_ID             VARCHAR(20)  NULL ,
	EXPERT_ID             CHAR(20)  NULL ,
	EMPLYR_ID             VARCHAR(60)  NULL ,
	KNWLDG_NM             VARCHAR(180)  NULL ,
	KNWLDG_CN             VARCHAR(7500)  NULL ,
	KWRD                  VARCHAR(300)  NULL ,
	OTHBC_AT              CHAR(1)  NULL ,
	KNWLDG_EVL            CHAR(1)  NULL ,
	COLCT_DE              CHAR(20)  NULL ,
	EVL_DE                CHAR(20)  NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	DSUSE_DE              CHAR(20)  NULL ,
CONSTRAINT  COMTNDAMKNOIFM_PK PRIMARY KEY (KNWLDG_ID)
);

CREATE TABLE COMTNDAMMAPKNO
(
	KNWLDG_TY_CODE        VARCHAR(9)  NOT NULL ,
	ORGNZT_ID             VARCHAR(20)  NULL ,
	EXPERT_ID             CHAR(20)  NULL ,
	KNWLDG_TY_NM          VARCHAR(180)  NULL ,
	CL_DE                 CHAR(20)  NULL ,
	KNWLDG_URL            VARCHAR(765)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNDAMMAPKNO_PK PRIMARY KEY (KNWLDG_TY_CODE)
);

CREATE TABLE COMTNDAMPRO
(
	EXPERT_ID             CHAR(20)  NOT NULL ,
	KNWLDG_TY_CODE        VARCHAR(9)  NOT NULL ,
	EXPERT_GRAD           CHAR(1)  NOT NULL ,
	EXPERT_CONFM_DE       CHAR(20)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	EXPERT_DC             VARCHAR(6000)  NULL ,
CONSTRAINT  COMTNDAMPRO_PK PRIMARY KEY (EXPERT_ID,KNWLDG_TY_CODE,EXPERT_GRAD)
);

CREATE TABLE COMTNINFRMLSANCTN
(
	INFRML_SANCTN_ID      CHAR(20)  NOT NULL ,
	JOB_SE_CODE           CHAR(3)  NOT NULL ,
	APPLCNT_ID            VARCHAR(60)  NOT NULL ,
	REQST_DE              CHAR(20)  NOT NULL ,
	SANCTNER_ID           VARCHAR(60)  NOT NULL ,
	CONFM_AT              CHAR(1)  NOT NULL ,
	SANCTN_DT             DATETIME  NULL ,
	RETURN_RESN           VARCHAR(3000)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNINFRMLSANCTN_PK PRIMARY KEY (INFRML_SANCTN_ID)
);

CREATE TABLE COMTNDBMNTRNG
(
	DATA_SOURC_NM         VARCHAR(180)  NOT NULL ,
	SERVER_NM             VARCHAR(180)  NULL ,
	DBMS_KND              VARCHAR(6)  NULL ,
	CECK_SQL              VARCHAR(750)  NULL ,
	MNGR_NM               VARCHAR(180)  NULL ,
	MNGR_EMAIL_ADRES      VARCHAR(150)  NULL ,
	MNTRNG_STTUS          CHAR(2)  NULL ,
	CREAT_DT              DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NOT NULL ,
CONSTRAINT  COMTNDBMNTRNG_PK PRIMARY KEY (DATA_SOURC_NM)
);

CREATE TABLE COMTNTRSMRCVMNTRNG
(
	CNTC_ID               CHAR(8)  NOT NULL ,
	TEST_CLASS_NM         VARCHAR(765)  NULL ,
	MNGR_NM               VARCHAR(180)  NULL ,
	MNGR_EMAIL_ADRES      VARCHAR(150)  NULL ,
	MNTRNG_STTUS          CHAR(2)  NULL ,
	CREAT_DT              DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NOT NULL ,
CONSTRAINT  COMTNTRSMRCVMNTRNG_PK PRIMARY KEY (CNTC_ID)
);

CREATE TABLE COMTNDEPTJOB
(
	DEPT_JOB_ID           CHAR(20)  NOT NULL ,
	DEPT_JOBBX_ID         CHAR(6)  NOT NULL ,
	DEPT_JOB_NM           VARCHAR(765)  NOT NULL ,
	DEPT_JOB_CN           VARCHAR(7500)  NOT NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
	CHARGER_ID            VARCHAR(60)  NOT NULL ,
	PRIORT                CHAR(1)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NOT NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNDEPTJOB_PK PRIMARY KEY (DEPT_JOB_ID)
);

CREATE TABLE COMTNLEADERSCHDUL
(
	SCHDUL_ID             CHAR(20)  NOT NULL ,
	SCHDUL_SE             CHAR(1)  NULL ,
	SCHDUL_NM             VARCHAR(765)  NOT NULL ,
	SCHDUL_CN             VARCHAR(7500)  NOT NULL ,
	SCHDUL_PLACE          VARCHAR(765)  NULL ,
	LEADER_ID             VARCHAR(60)  NOT NULL ,
	REPTIT_SE_CODE        CHAR(1)  NULL ,
	SCHDUL_BGNDE          CHAR(20)  NULL ,
	SCHDUL_ENDDE          CHAR(20)  NULL ,
	SCHDUL_CHARGER_ID     VARCHAR(60)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NOT NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNLEADERSCHDUL_PK PRIMARY KEY (SCHDUL_ID)
);

CREATE TABLE COMTNLEADERSCHDULDE
(
	SCHDUL_ID             CHAR(20)  NOT NULL ,
	SCHDUL_DE             CHAR(8)  NOT NULL ,
CONSTRAINT  COMTNLEADERSCHDULDE_PK PRIMARY KEY (SCHDUL_ID,SCHDUL_DE)
);

CREATE TABLE COMTNDEPTJOBBX
(
	DEPT_JOBBX_ID         CHAR(6)  NOT NULL ,
	DEPT_JOBBX_NM         VARCHAR(765)  NOT NULL ,
	DEPT_ID               VARCHAR(60)  NOT NULL ,
	INDICT_ORDR           NUMERIC(6)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NOT NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNDEPTJOBBX_PK PRIMARY KEY (DEPT_JOBBX_ID)
);

CREATE TABLE COMTNDTAUSESTATS
(
	DTA_USE_STATS_ID      CHAR(20)  NOT NULL ,
	BBS_ID                CHAR(30)  NOT NULL ,
	NTT_ID                NUMERIC(20)  NOT NULL ,
	ATCH_FILE_ID          CHAR(20)  NOT NULL ,
	FILE_SN               NUMERIC(10)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNDTAUSESTATS_PK PRIMARY KEY (DTA_USE_STATS_ID)
);

CREATE TABLE COMTNINSTTCODE
(
	INSTT_CODE            CHAR(7)  NOT NULL ,
	ALL_INSTT_NM          VARCHAR(765)  NULL ,
	LOWEST_INSTT_NM       VARCHAR(300)  NULL ,
	INSTT_ABRV_NM         VARCHAR(150)  NULL ,
	ODR                   CHAR(1)  NULL ,
	ORD                   CHAR(3)  NULL ,
	INSTT_ODR             CHAR(2)  NULL ,
	UPPER_INSTT_CODE      CHAR(7)  NULL ,
	BEST_INSTT_CODE       CHAR(7)  NULL ,
	REPRSNT_INSTT_CODE    CHAR(7)  NULL ,
	INSTT_TY_LCLAS        CHAR(2)  NULL ,
	INSTT_TY_MLSFC        CHAR(2)  NULL ,
	INSTT_TY_SCLAS        CHAR(2)  NULL ,
	TELNO                 VARCHAR(60)  NULL ,
	FXNUM                 VARCHAR(60)  NULL ,
	CREAT_DE              CHAR(20)  NULL ,
	ABL_DE                CHAR(20)  NULL ,
	ABL_ENNC              CHAR(1)  NULL ,
	CHANGE_DE             CHAR(20)  NULL ,
	CHANGE_TIME           VARCHAR(18)  NULL ,
	BSIS_DE               CHAR(20)  NULL ,
	SORT_ORDR             NUMERIC(8)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNINSTTCODE_PK PRIMARY KEY (INSTT_CODE)
);

CREATE TABLE COMTNINSTTCODERECPTNLOG
(
	OCCRRNC_DE            CHAR(20)  NOT NULL ,
	INSTT_CODE            CHAR(7)  NOT NULL ,
	OPERT_SN              NUMERIC(10)  NOT NULL ,
	CHANGE_SE_CODE        VARCHAR(6)  NULL ,
	PROCESS_SE            VARCHAR(6)  NULL ,
	ETC_CODE              CHAR(2)  NULL ,
	ALL_INSTT_NM          VARCHAR(765)  NULL ,
	LOWEST_INSTT_NM       VARCHAR(300)  NULL ,
	INSTT_ABRV_NM         VARCHAR(150)  NULL ,
	ODR                   CHAR(1)  NULL ,
	ORD                   CHAR(3)  NULL ,
	INSTT_ODR             CHAR(2)  NULL ,
	UPPER_INSTT_CODE      CHAR(7)  NULL ,
	BEST_INSTT_CODE       CHAR(7)  NULL ,
	REPRSNT_INSTT_CODE    CHAR(7)  NULL ,
	INSTT_TY_LCLAS        CHAR(2)  NULL ,
	INSTT_TY_MLSFC        CHAR(2)  NULL ,
	INSTT_TY_SCLAS        CHAR(2)  NULL ,
	TELNO                 VARCHAR(60)  NULL ,
	FXNUM                 VARCHAR(60)  NULL ,
	CREAT_DE              CHAR(20)  NULL ,
	ABL_DE                CHAR(20)  NULL ,
	ABL_ENNC              CHAR(1)  NULL ,
	CHANGE_DE             CHAR(20)  NULL ,
	CHANGE_TIME           VARCHAR(18)  NULL ,
	BSIS_DE               CHAR(20)  NULL ,
	SORT_ORDR             NUMERIC(8)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNINSTTCODERECPTNLOG_PK PRIMARY KEY (OCCRRNC_DE,INSTT_CODE,OPERT_SN)
);

CREATE TABLE COMTNINDVDLYRYCMANAGE
(
	OCCRRNC_YEAR          CHAR(4)  NOT NULL ,
	YRYC_OCCRRNC_CO       NUMERIC(5,1)  NULL ,
	USE_YRYC_CO           NUMERIC(5,1)  NULL ,
	REMNDR_YRYC_CO        NUMERIC(5,1)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	USER_ID               VARCHAR(60)  NOT NULL ,
CONSTRAINT  COMTNINDVDLYRYCMANAGE_PK PRIMARY KEY (OCCRRNC_YEAR,USER_ID)
);

CREATE TABLE COMTNNTWRKSVCMNTRNG
(
	SYS_IP                VARCHAR(69)  NOT NULL ,
	SYS_PORT              NUMERIC(5)  NOT NULL ,
	SYS_NM                VARCHAR(765)  NOT NULL ,
	MNGR_NM               VARCHAR(180)  NULL ,
	MNGR_EMAIL_ADRES      VARCHAR(150)  NULL ,
	MNTRNG_STTUS          CHAR(2)  NULL ,
	CREAT_DT              DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NOT NULL ,
	LAST_UPDT_PNTTM       DATETIME  NOT NULL ,
CONSTRAINT  COMTNNTWRKSVCMNTRNG_PK PRIMARY KEY (SYS_IP,SYS_PORT)
);

CREATE TABLE COMTNNTWRKSVCMNTRNGLOGINFO
(
	SYS_IP                VARCHAR(69)  NOT NULL ,
	SYS_PORT              NUMERIC(5)  NOT NULL ,
	SYS_NM                VARCHAR(765)  NOT NULL ,
	MNTRNG_STTUS          CHAR(2)  NULL ,
	LOG_INFO              VARCHAR(6000)  NULL ,
	CREAT_DT              DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NOT NULL ,
	LAST_UPDT_PNTTM       DATETIME  NOT NULL ,
	LOG_ID                CHAR(20)  NOT NULL ,
CONSTRAINT  COMTNNTWRKSVCMNTRNGLOGINFO_PK PRIMARY KEY (SYS_IP,SYS_PORT,LOG_ID)
);

CREATE TABLE COMTNSERVEREQPMNINFO
(
	SERVER_EQPMN_ID       VARCHAR(60)  NOT NULL ,
	SERVER_EQPMN_NM       VARCHAR(180)  NULL ,
	SERVER_EQPMN_IP       VARCHAR(69)  NULL ,
	SERVER_EQPMN_MNGR     VARCHAR(180)  NULL ,
	MNGR_EMAIL_ADRES      VARCHAR(150)  NULL ,
	OPERSYSM_INFO         VARCHAR(6000)  NULL ,
	CPU_INFO              VARCHAR(6000)  NULL ,
	MORY_INFO             VARCHAR(6000)  NULL ,
	HDDISK                CHAR(18)  NULL ,
	ETC_INFO              VARCHAR(750)  NULL ,
	RGSDE                 DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNSERVEREQPMNINFO_PK PRIMARY KEY (SERVER_EQPMN_ID)
);

CREATE TABLE COMTNSYNCHRNSERVERINFO
(
	SERVER_ID             CHAR(20)  NOT NULL ,
	SERVER_NM             VARCHAR(180)  NULL ,
	SERVER_IP             VARCHAR(69)  NULL ,
	SERVER_PORT           VARCHAR(30)  NULL ,
	FTP_ID                VARCHAR(60)  NULL ,
	FTP_PASSWORD          VARCHAR(60)  NULL ,
	SYNCHRN_LC            VARCHAR(765)  NULL ,
	REFLCT_AT             CHAR(1)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNSYNCHRNSERVERINFO_PK PRIMARY KEY (SERVER_ID)
);

CREATE TABLE COMTNSERVERINFO
(
	SERVER_ID             CHAR(20)  NOT NULL ,
	SERVER_NM             VARCHAR(180)  NULL ,
	SERVER_KND            CHAR(2)  NULL ,
	RGSDE                 DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNSERVERINFO_PK PRIMARY KEY (SERVER_ID)
);

CREATE TABLE COMTNSERVEREQPMNRELATE
(
	SERVER_EQPMN_ID       VARCHAR(60)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	SERVER_ID             CHAR(20)  NOT NULL ,
CONSTRAINT  COMTNSERVEREQPMNRELATE_PK PRIMARY KEY (SERVER_EQPMN_ID,SERVER_ID)
);

CREATE TABLE COMTNSERVERRESRCELOGINFO
(
	SERVER_EQPMN_ID       VARCHAR(60)  NOT NULL ,
	CPU_USE_RT            NUMERIC(3)  NULL ,
	MORY_USE_RT           NUMERIC(3)  NULL ,
	SVC_STTUS             CHAR(2)  NULL ,
	LOG_INFO              VARCHAR(6000)  NULL ,
	CREAT_DT              DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	SERVER_ID             CHAR(20)  NOT NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LOG_ID                CHAR(20)  NOT NULL ,
CONSTRAINT  COMTNSERVERRESRCELOGINFO_PK PRIMARY KEY (SERVER_EQPMN_ID,SERVER_ID,LOG_ID)
);

CREATE TABLE COMTNVCATNMANAGE
(
	APPLCNT_ID            VARCHAR(60)  NOT NULL ,
	VCATN_SE              CHAR(2)  NOT NULL ,
	BGNDE                 CHAR(8)  NOT NULL ,
	ENDDE                 CHAR(8)  NOT NULL ,
	VCATN_RESN            VARCHAR(600)  NOT NULL ,
	REQST_DE              CHAR(20)  NOT NULL ,
	OCCRRNC_YEAR          CHAR(4)  NULL ,
	SANCTNER_ID           VARCHAR(60)  NULL ,
	CONFM_AT              CHAR(1)  NULL ,
	SANCTN_DT             DATETIME  NULL ,
	RETURN_RESN           VARCHAR(3000)  NULL ,
	INFRML_SANCTN_ID      CHAR(20)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	NOON_SE               CHAR(1)  NULL ,
CONSTRAINT  COMTNVCATNMANAGE_PK PRIMARY KEY (APPLCNT_ID,VCATN_SE,BGNDE,ENDDE)
);

CREATE TABLE COMTNMEMOTODO
(
	TODO_ID               CHAR(20)  NOT NULL ,
	TODO_SJ               VARCHAR(765)  NOT NULL ,
	TODO_BEGIN_TIME       VARCHAR(42)  NOT NULL ,
	TODO_END_TIME         VARCHAR(42)  NOT NULL ,
	WRTER_ID              VARCHAR(60)  NOT NULL ,
	TODO_CN               VARCHAR(7500)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NOT NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNMEMOTODO_PK PRIMARY KEY (TODO_ID)
);

CREATE TABLE COMTNNOTE
(
	NOTE_ID               CHAR(20)  NOT NULL ,
	NOTE_SJ               VARCHAR(765)  NULL ,
	NOTE_CN               VARCHAR(12000)  NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNNOTE_PK PRIMARY KEY (NOTE_ID)
);

CREATE TABLE COMTNNOTETRNSMIT
(
	NOTE_ID               CHAR(20)  NOT NULL ,
	NOTE_TRNSMIT_ID       CHAR(20)  NOT NULL ,
	TRNSMITER_ID          CHAR(20)  NULL ,
	DELETE_AT             CHAR(8)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNNOTETRNSMIT_PK PRIMARY KEY (NOTE_ID,NOTE_TRNSMIT_ID)
);

CREATE TABLE COMTNNOTERECPTN
(
	NOTE_ID               CHAR(20)  NOT NULL ,
	NOTE_TRNSMIT_ID       CHAR(20)  NOT NULL ,
	NOTE_RECPTN_ID        CHAR(20)  NOT NULL ,
	RCVER_ID              CHAR(20)  NULL ,
	OPEN_YN               CHAR(1)  NULL ,
	RECPTN_SE             CHAR(1)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNNOTERECPTN_PK PRIMARY KEY (NOTE_ID,NOTE_TRNSMIT_ID,NOTE_RECPTN_ID)
);

CREATE TABLE COMTNEVENTMANAGE
(
	EVENT_ID              CHAR(20)  NOT NULL ,
	EVENT_SE              VARCHAR(6)  NOT NULL ,
	EVENT_NM              VARCHAR(180)  NOT NULL ,
	EVENT_PURPS           VARCHAR(600)  NOT NULL ,
	EVENT_BGNDE           CHAR(20)  NOT NULL ,
	EVENT_ENDDE           CHAR(20)  NOT NULL ,
	EVENT_AUSPC_INSTT_NM  VARCHAR(180)  NULL ,
	EVENT_MNGT_INSTT_NM   VARCHAR(180)  NULL ,
	EVENT_PLACE           VARCHAR(600)  NOT NULL ,
	EVENT_CN              VARCHAR(3000)  NULL ,
	CT_OCCRRNC_AT         CHAR(1)  NULL ,
	PARTCPT_CT            NUMERIC(16)  NULL ,
	PSNCPA                NUMERIC(10)  NOT NULL ,
	REFRN_URL             VARCHAR(3072)  NULL ,
	RCEPT_BGNDE           CHAR(20)  NOT NULL ,
	RCEPT_ENDDE           CHAR(20)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNEVENTMANAGE_PK PRIMARY KEY (EVENT_ID)
);

CREATE TABLE COMTNEVENTATDRN
(
	APPLCNT_ID            VARCHAR(60)  NOT NULL ,
	EVENT_ID              CHAR(20)  NOT NULL ,
	REQST_DE              CHAR(20)  NOT NULL ,
	SANCTNER_ID           VARCHAR(60)  NOT NULL ,
	CONFM_AT              CHAR(1)  NULL ,
	SANCTN_DT             DATETIME  NULL ,
	RETURN_RESN           VARCHAR(3000)  NULL ,
	INFRML_SANCTN_ID      CHAR(20)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNEVENTATDRN_PK PRIMARY KEY (APPLCNT_ID,EVENT_ID)
);

CREATE TABLE IMGTEMP
(
	ORGNZT_CODE           VARCHAR(30)  NOT NULL ,
	ERNCSL_SE             VARCHAR(6)  NOT NULL ,
	IMAGE_INFO            BIT VARYING  NOT NULL ,
	IMAGE_TY              VARCHAR(60)  NULL ,
CONSTRAINT  IMGTEMP_PK PRIMARY KEY (ORGNZT_CODE,ERNCSL_SE)
);

CREATE TABLE IDS
(
	IDGEN_TABLE_NM        VARCHAR(60)  NOT NULL ,
	IDGEN_NEXT_ID         NUMERIC(30)  NOT NULL ,
CONSTRAINT  IDS_PK PRIMARY KEY (IDGEN_TABLE_NM)
);

CREATE TABLE COMTNWIKMNTHNGREPRT
(
	REPRT_ID              CHAR(6)  NOT NULL ,
	REPRT_SE              CHAR(1)  NOT NULL ,
	REPRT_SJ              VARCHAR(765)  NOT NULL ,
	REPORT_DE             CHAR(20)  NOT NULL ,
	WRTER_ID              VARCHAR(60)  NOT NULL ,
	REPORTR_ID            VARCHAR(60)  NOT NULL ,
	REPORT_BGNDE          CHAR(20)  NOT NULL ,
	REPORT_ENDDE          CHAR(20)  NOT NULL ,
	THSWIK_REPORT_CN      STRING  NOT NULL ,
	NEXTWIK_REPORT_CN     STRING  NOT NULL ,
	PARTCLR_MATTER        VARCHAR(7500)  NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
	CONFM_DT              VARCHAR(42)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NOT NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNWIKMNTHNGREPRT_PK PRIMARY KEY (REPRT_ID)
);

CREATE TABLE COMTNTWITTER
(
	USER_ID               VARCHAR(60)  NOT NULL ,
	CNSMR_KEY             VARCHAR(150)  NOT NULL ,
	CNSMR_SECRET          VARCHAR(150)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNTWITTER_PK PRIMARY KEY (USER_ID)
);

CREATE TABLE COMTNWIKIBKMK
(
	WIKI_BKMK_ID          CHAR(20)  NOT NULL ,
	USER_ID               VARCHAR(60)  NOT NULL ,
	WIKI_BKMK_NM          VARCHAR(3000)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNWIKIBKMK_PK PRIMARY KEY (WIKI_BKMK_ID,USER_ID)
);

CREATE TABLE COMTNRWARDMANAGE
(
	RWARD_ID              CHAR(20)  NOT NULL ,
	RWARDWNR_ID           VARCHAR(60)  NOT NULL ,
	RWARD_CODE            CHAR(2)  NOT NULL ,
	RWARD_DE              CHAR(20)  NOT NULL ,
	RWARD_NM              VARCHAR(765)  NOT NULL ,
	PBLEN_CN              VARCHAR(3000)  NULL ,
	SANCTNER_ID           VARCHAR(60)  NOT NULL ,
	CONFM_AT              CHAR(1)  NULL ,
	SANCTN_DT             DATETIME  NULL ,
	RETURN_RESN           VARCHAR(3000)  NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
	INFRML_SANCTN_ID      CHAR(20)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNRWARDMANAGE_PK PRIMARY KEY (RWARD_ID)
);

CREATE TABLE COMTNRSS
(
	RSS_ID                CHAR(20)  NOT NULL ,
	TRGET_SVC_NM          VARCHAR(765)  NOT NULL ,
	TRGET_SVC_TABLE       VARCHAR(765)  NOT NULL ,
	TRGET_SVC_LIST_CO     NUMERIC(5)  NOT NULL ,
	HDER_TITLE            VARCHAR(765)  NOT NULL ,
	HDER_LINK             VARCHAR(765)  NOT NULL ,
	HDER_DC               VARCHAR(12000)  NOT NULL ,
	HDER_TAG              VARCHAR(765)  NULL ,
	HDER_ETC              VARCHAR(750)  NULL ,
	BDT_TITLE             VARCHAR(765)  NULL ,
	BDT_LINK              VARCHAR(765)  NULL ,
	BDT_DC                VARCHAR(12000)  NULL ,
	BDT_TAG               VARCHAR(765)  NULL ,
	BDT_ETC_TAG           VARCHAR(765)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNRSS_PK PRIMARY KEY (RSS_ID)
);

CREATE TABLE COMTNRESTDE
(
	RESTDE_NO             NUMERIC(6)  NOT NULL ,
	RESTDE                CHAR(8)  NULL ,
	RESTDE_NM             VARCHAR(180)  NULL ,
	RESTDE_DC             VARCHAR(600)  NULL ,
	RESTDE_SE_CODE        VARCHAR(6)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
CONSTRAINT  COMTNRESTDE_PK PRIMARY KEY (RESTDE_NO)
);

CREATE TABLE COMTNPROCESSMON
(
	PROCS_ID              CHAR(20)  NOT NULL ,
	PROCS_NM              VARCHAR(180)  NULL ,
	PROCS_STTUS           VARCHAR(9)  NULL ,
	CREAT_DT              DATETIME  NULL ,
	MNGR_NM               VARCHAR(180)  NULL ,
	MNGR_EMAIL_ADRES      VARCHAR(150)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNPROCESSMON_PK PRIMARY KEY (PROCS_ID)
);

CREATE TABLE COMTNPROCESSMONLOGINFO
(
	PROCS_ID              CHAR(20)  NOT NULL ,
	PROCS_NM              VARCHAR(180)  NULL ,
	PROCS_STTUS           VARCHAR(9)  NULL ,
	CREAT_DT              DATETIME  NULL ,
	LOG_INFO              VARCHAR(6000)  NULL ,
	MNGR_NM               VARCHAR(180)  NULL ,
	MNGR_EMAIL_ADRES      VARCHAR(150)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	LOG_ID                CHAR(20)  NOT NULL ,
CONSTRAINT  COMTNPROCESSMONLOGINFO_PK PRIMARY KEY (PROCS_ID,LOG_ID)
);

CREATE TABLE COMTNNTWRKINFO
(
	NTWRK_ID              CHAR(20)  NOT NULL ,
	NTWRK_IP              VARCHAR(69)  NULL ,
	GTWY                  VARCHAR(69)  NULL ,
	SUBNET                VARCHAR(69)  NULL ,
	DOMN_NM_SERVER        VARCHAR(69)  NULL ,
	MANAGE_IEM            CHAR(2)  NULL ,
	USER_NM               VARCHAR(180)  NULL ,
	USE_AT                CHAR(1)  NULL ,
	RGSDE                 DATETIME  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNNTWRKINFO_PK PRIMARY KEY (NTWRK_ID)
);

CREATE  VIEW COMVNUSERMASTER ( ESNTL_ID,USER_ID,PASSWORD,USER_NM,USER_ZIP,USER_ADRES,USER_EMAIL,GROUP_ID, USER_SE, ORGNZT_ID ) 
AS  SELECT ESNTL_ID, MBER_ID,PASSWORD,MBER_NM,ZIP,ADRES,MBER_EMAIL_ADRES,' ','GNR' AS USER_SE, ' ' ORGNZT_ID
		FROM COMTNGNRLMBER
	UNION ALL
		SELECT ESNTL_ID,EMPLYR_ID,PASSWORD,USER_NM,ZIP,HOUSE_ADRES,EMAIL_ADRES,GROUP_ID ,'USR' AS USER_SE, ORGNZT_ID
		FROM COMTNEMPLYRINFO
	UNION ALL
		SELECT ESNTL_ID,ENTRPRS_MBER_ID,ENTRPRS_MBER_PASSWORD,CMPNY_NM,ZIP,ADRES,APPLCNT_EMAIL_ADRES,' ' ,'ENT' AS USER_SE, ' ' ORGNZT_ID
		FROM COMTNENTRPRSMBER ORDER BY ESNTL_ID;

CREATE TABLE COMTNMEMOREPRT
(
	REPRT_SJ              VARCHAR(765)  NOT NULL ,
	REPORT_DE             CHAR(20)  NOT NULL ,
	WRTER_ID              VARCHAR(60)  NOT NULL ,
	REPORTR_ID            VARCHAR(60)  NOT NULL ,
	REPORT_CN             VARCHAR(7500)  NOT NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
	DRCT_MATTER           VARCHAR(7500)  NULL ,
	DRCT_MATTER_REGIST_DT  VARCHAR(42)  NULL ,
	REPORTR_INQIRE_DT     VARCHAR(42)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NOT NULL ,
	FRST_REGIST_PNTTM     DATETIME  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	REPRT_ID              CHAR(6)  NOT NULL ,
CONSTRAINT  COMTNMEMOREPRT_PK PRIMARY KEY (REPRT_ID)
);

CREATE TABLE COMTNMTGPLACEMANAGE
(
	MTGRUM_ID             CHAR(20)  NOT NULL ,
	MTGRUM_NM             VARCHAR(765)  NOT NULL ,
	OPN_BEGIN_TM          VARCHAR(18)  NOT NULL ,
	OPN_END_TM            VARCHAR(18)  NOT NULL ,
	ACEPTNC_POSBL_NMPR    NUMERIC(10)  NOT NULL ,
	LC_SE                 CHAR(5)  NULL ,
	LC_DETAIL             VARCHAR(600)  NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNMTGPLACEMANAGE_PK PRIMARY KEY (MTGRUM_ID)
);

CREATE TABLE COMTNMTGPLACERESVE
(
	RESVE_ID              CHAR(20)  NOT NULL ,
	MTGRUM_ID             CHAR(20)  NOT NULL ,
	MTG_SJ                VARCHAR(300)  NOT NULL ,
	RSVCTM_ID             VARCHAR(60)  NOT NULL ,
	RESVE_DE              CHAR(8)  NOT NULL ,
	RESVE_BEGIN_TM        VARCHAR(42)  NOT NULL ,
	RESVE_END_TM          VARCHAR(42)  NOT NULL ,
	ATNDNC_NMPR           NUMERIC(10)  NULL ,
	MTG_CN                VARCHAR(7500)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNMTGPLACERESVE_PK PRIMARY KEY (RESVE_ID)
);

CREATE TABLE COMTNFXTRSMANAGE
(
	FXTRS_CODE            CHAR(14)  NOT NULL ,
	FXTRS_NM              VARCHAR(300)  NOT NULL ,
	MAKR_NM               VARCHAR(300)  NULL ,
	PRICE                 NUMERIC(16)  NULL ,
CONSTRAINT  COMTNFXTRSMANAGE_PK PRIMARY KEY (FXTRS_CODE)
);

CREATE TABLE COMTNMTGPLACEFXTRS
(
	MTGRUM_ID             CHAR(20)  NOT NULL ,
	FXTRS_CODE            CHAR(14)  NOT NULL ,
	QY                    NUMERIC(20)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
CONSTRAINT  COMTNMTGPLACEFXTRS_PK PRIMARY KEY (MTGRUM_ID,FXTRS_CODE)
);

CREATE TABLE COMTECOPSEQ
(
	TABLE_NAME            VARCHAR(60)  NOT NULL ,
	NEXT_ID               NUMERIC(30)  NULL ,
CONSTRAINT  COMTECOPSEQ_PK PRIMARY KEY (TABLE_NAME)
);

CREATE TABLE COMTNANNVRSRYMANAGE
(
	ANNVRSRY_ID           VARCHAR(60)  NOT NULL ,
	USER_ID               VARCHAR(60)  NOT NULL ,
	ANNVRSRY_SE           VARCHAR(6)  NOT NULL ,
	ANNVRSRY_NM           VARCHAR(765)  NOT NULL ,
	ANNVRSRY              CHAR(20)  NOT NULL ,
	CLDR_SE               CHAR(1)  NOT NULL ,
	ANNVRSRY_NTCN_SETUP   CHAR(1)  NULL ,
	ANNVRSRY_NTCN_BGNDE   CHAR(20)  NULL ,
	MEMO                  VARCHAR(3000)  NULL ,
	FRST_REGISTER_ID      VARCHAR(60)  NULL ,
	FRST_REGIST_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID        VARCHAR(60)  NULL ,
	LAST_UPDT_PNTTM       DATETIME  NULL ,
	REPTIT_AT             CHAR(1)  NULL ,
CONSTRAINT  COMTNANNVRSRYMANAGE_PK PRIMARY KEY (ANNVRSRY_ID)
);

CREATE TABLE J_ATTACHFILE 
(
	FILE_ID VARCHAR(13) NOT NULL,
	FILE_SEQ INTEGER NOT NULL,
	FILE_NAME VARCHAR(100) NOT NULL,
	FILE_SIZE INTEGER,
	FILE_MASK VARCHAR(100),
	DOWNLOAD_COUNT INTEGER,
	DOWNLOAD_EXPIRE_DATE VARCHAR(8),
	DOWNLOAD_LIMIT_COUNT INTEGER,
	REG_DATE DATETIME,
	DELETE_YN VARCHAR(1),
CONSTRAINT  J_ATTACHFILE_PK PRIMARY KEY (FILE_ID, FILE_SEQ)
);

CREATE TABLE COMTNROUGHMAP (
    ROUGHMAP_ID       VARCHAR(75) NOT NULL,
    ROUGHMAPSJ        VARCHAR(75) NOT NULL,
    ROUGHMAPADDRESS   VARCHAR(200)NULL,
    LA                VARCHAR(48) NULL,
    LO                VARCHAR(48) NULL,
    MARKERLA          VARCHAR(48) NULL,
    MARKERLO          VARCHAR(48) NULL,
    INFOWINDOW        VARCHAR(20) NULL,
    ZOOMLEVEL         VARCHAR(10) NULL,
    FRST_REGIST_PNTTM DATETIME NULL,
    FRST_REGISTER_ID  VARCHAR(20) NULL,
    LAST_UPDT_PNTTM   DATETIME NULL,
    LAST_UPDUSR_ID    VARCHAR(20) NULL
 );
 
 CREATE TABLE COMTNPRIVACYLOG
(
    REQUST_ID            VARCHAR(20) NOT NULL,
    INQIRE_DT            DATETIME NOT NULL,
    SRVC_NM              VARCHAR(500) NULL,
    INQIRE_INFO          VARCHAR(100) NULL,
    RQESTER_ID           VARCHAR(20) NULL,
    RQESTER_IP           VARCHAR(23) NULL,
CONSTRAINT  REQUST_ID_PK PRIMARY KEY (REQUST_ID)
)
;

CREATE TABLE COMTNCOMMUTE (
     WRKTM_ID           CHAR(20) NOT NULL,
     EMPLYR_ID          VARCHAR(20) NOT NULL,
     ORGNZT_ID          VARCHAR(20) NULL,
     WRKT_DT            VARCHAR(10) NOT NULL, 
     WRK_START_TIME     VARCHAR(14) NULL, 
     WRK_END_TIME       VARCHAR(14) NULL, 
     WRK_HOURS          CHAR(2) NULL, 
     OVTMWRK_HOURS      CHAR(2) NULL,
     WRK_START_STATUS   VARCHAR(10) NULL, 
     WRK_END_STATUS     VARCHAR(10) NULL, 
     RM                 VARCHAR(100) NULL,
     FRST_REGISTER_ID   VARCHAR(20) NULL,
     FRST_REGIST_PNTTM  DATETIME NULL,
     LAST_UPDUSR_ID     VARCHAR(20) NULL,
     LAST_UPDT_PNTTM    DATETIME NULL,
 PRIMARY KEY (EMPLYR_ID, WRKT_DT)
);

CREATE TABLE COMTNBLOG
(
	BLOG_ID             CHAR(20)  NOT NULL ,
	BLOG_NM             VARCHAR(765)  NOT NULL ,
	BLOG_INTRCN         VARCHAR(7200)  NULL ,
	USE_AT              CHAR(1)  NOT NULL ,
	REGIST_SE_CODE      CHAR(6)  NULL ,
	TMPLAT_ID           CHAR(20)  NULL ,
	FRST_REGIST_PNTTM   DATETIME  NOT NULL ,
	FRST_REGISTER_ID    VARCHAR(60)  NOT NULL ,
	LAST_UPDT_PNTTM     DATETIME  NULL ,
	LAST_UPDUSR_ID      VARCHAR(60)  NULL ,
	BBS_ID 			CHAR(30) DEFAULT NULL,
  	BLOG_AT 			CHAR(1) DEFAULT NULL,
	PRIMARY KEY (BLOG_ID)
);

CREATE TABLE COMTNBLOGUSER
(
	BLOG_ID               CHAR(20) NOT NULL,
	EMPLYR_ID             VARCHAR(60) NOT NULL,
	MNGR_AT               CHAR(1) NOT NULL,
	MBER_STTUS		  VARCHAR(45) NULL,
	SBSCRB_DE             DATETIME NULL,
	SECSN_DE              CHAR(20) NULL,
	USE_AT                CHAR(1) NULL,
	FRST_REGIST_PNTTM     DATETIME NOT NULL,
	FRST_REGISTER_ID      VARCHAR(60) NOT NULL,
	LAST_UPDT_PNTTM       DATETIME NULL,
	LAST_UPDUSR_ID        VARCHAR(60) NULL,
	CONSTRAINT COMTNBLOGUSER_PK PRIMARY KEY (BLOG_ID,EMPLYR_ID),
	CONSTRAINT COMTNBLOGUSER_FK1 FOREIGN KEY (BLOG_ID) REFERENCES COMTNBLOG(BLOG_ID)
);

CREATE TABLE COMTCMOBILEIDSERVICE
(
	SVCCODE			VARCHAR(50)		NOT NULL,
	PRESENTTYPE		INTEGER			NOT NULL DEFAULT 1,
	ENCRYPTTYPE		INTEGER			NOT NULL DEFAULT 2,
	KEYTYPE			INTEGER			NOT NULL DEFAULT 2,
	AUTHTYPE		VARCHAR(50)		DEFAULT NULL,
	SPNAME			VARCHAR(100)	NOT NULL,
	SERVICENAME		VARCHAR(100)	NOT NULL,
	ATTRLIST		VARCHAR(100)	DEFAULT NULL,
	PREDLIST		VARCHAR(100)	DEFAULT NULL,
	CALLBACKURL		VARCHAR(100)	DEFAULT NULL,
	REGDT			TIMESTAMP		NOT NULL DEFAULT CURRENT_TIMESTAMP(),
	UDTDT			TIMESTAMP		NULL DEFAULT NULL,
	PRIMARY KEY (SVCCODE)
);

CREATE TABLE COMTSMOBILEIDTRXINFO
(
	TRXCODE			VARCHAR(50)		NOT NULL,
	SVCCODE			VARCHAR(50)		NOT NULL,
	OPMODE			VARCHAR(50)		NOT NULL,
	DEVICEID		VARCHAR(100)	DEFAULT NULL,
	BRANCHNAME		VARCHAR(100)	DEFAULT NULL,
	NONCE			VARCHAR(100)	DEFAULT NULL,
	ZKPNONCE		VARCHAR(100)	DEFAULT NULL,
	VPVERIFYRESULT	VARCHAR(1)		NOT NULL DEFAULT 'N',
	TRXSTSCODE		VARCHAR(4)		NOT NULL DEFAULT '0001',
	PROFILESENDDT	TIMESTAMP		NULL DEFAULT NULL,
	IMGSENDDT		TIMESTAMP		NULL DEFAULT NULL,
	VPRECEPTDT		TIMESTAMP		NULL DEFAULT NULL,
	ERRORCN			VARCHAR(4000)	DEFAULT NULL,
	REGDT			TIMESTAMP		NOT NULL DEFAULT CURRENT_TIMESTAMP(),
	UDTDT			TIMESTAMP		NULL DEFAULT NULL,
	VPNAME			VARCHAR(50),
	PRIMARY KEY (TRXCODE)
);