CREATE TABLE COMTNPROGRMLIST
(
	PROGRM_FILE_NM        VARCHAR2(60)  NOT NULL ,
	PROGRM_STRE_PATH      VARCHAR2(100)  NOT NULL ,
	PROGRM_KOREAN_NM      VARCHAR2(60)  NULL ,
	PROGRM_DC             VARCHAR2(200)  NULL ,
	URL                   VARCHAR2(100)  NOT NULL ,
CONSTRAINT  COMTNPROGRMLIST_PK PRIMARY KEY (PROGRM_FILE_NM)
);



CREATE TABLE COMTHPROGRMCHANGEDTLS
(
	PROGRM_FILE_NM        VARCHAR2(60)  NOT NULL ,
	REQUST_NO             NUMBER(10)  NOT NULL ,
	RQESTER_ID            VARCHAR2(20)  NOT NULL ,
	CHANGE_REQUST_CN      VARCHAR2(1000)  NULL ,
	REQUST_PROCESS_CN     CLOB  NULL ,
	OPETR_ID              VARCHAR2(20)  NULL ,
	PROCESS_STTUS_CODE    VARCHAR2(15)  NOT NULL ,
	PROCESS_DE            CHAR(20)  NULL ,
	RQESTDE               CHAR(20)  NULL ,
	REQUST_SJ             VARCHAR2(60)  NOT NULL ,
CONSTRAINT  COMTHPROGRMCHANGEDTLS_PK PRIMARY KEY (PROGRM_FILE_NM,REQUST_NO),
CONSTRAINT  COMTHPROGRMCHANGEDTLS_FK1 FOREIGN KEY (PROGRM_FILE_NM) REFERENCES COMTNPROGRMLIST(PROGRM_FILE_NM) ON DELETE CASCADE
);

CREATE TABLE COMTNROUGHMAP (
    ROUGHMAP_ID       VARCHAR(75)   NOT NULL,
    ROUGHMAPSJ        VARCHAR(75)   NOT NULL,
    ROUGHMAPADDRESS   VARCHAR(200)  NULL,
    LA                VARCHAR(48)   NULL,
    LO                VARCHAR(48)   NULL,
    MARKERLA          VARCHAR(48)   NULL,
    MARKERLO          VARCHAR(48)   NULL,
    INFOWINDOW        VARCHAR(20)   NULL,
    ZOOMLEVEL         VARCHAR(10)   NULL,
    FRST_REGIST_PNTTM DATE          NULL,
    FRST_REGISTER_ID  VARCHAR(20)   NULL,
    LAST_UPDT_PNTTM   DATE          NULL,
    LAST_UPDUSR_ID    VARCHAR(20)   NULL
 );

CREATE INDEX COMTHPROGRMCHANGEDTLS_i01 ON COMTHPROGRMCHANGEDTLS
(PROGRM_FILE_NM  ASC);



CREATE TABLE COMTNPOPUPMANAGE
(
	POPUP_ID              VARCHAR2(20)  NOT NULL ,
	POPUP_SJ_NM           VARCHAR2(1024)  NULL ,
	FILE_URL              VARCHAR2(1024)  NULL ,
	POPUP_WIDTH_LC        VARCHAR2(20)  NULL ,
	POPUP_WIDTH_SIZE      NUMBER  NULL ,
	NTCE_BGNDE            CHAR(20)  NULL ,
	NTCE_ENDDE            CHAR(20)  NULL ,
	STOPVEW_SETUP_AT      CHAR(1)  NULL ,
	NTCE_AT               CHAR(1)  NULL ,
	POPUP_VRTICL_LC       VARCHAR2(20)  NULL ,
	POPUP_VRTICL_SIZE     NUMBER  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNPOPUPMANAGE_PK PRIMARY KEY (POPUP_ID)
);



CREATE TABLE COMTNBANNER
(
	BANNER_ID             CHAR(20)  NOT NULL ,
	BANNER_NM             VARCHAR2(60)  NOT NULL ,
	LINK_URL              VARCHAR2(255)  NOT NULL ,
	BANNER_IMAGE          VARCHAR2(60)  NOT NULL ,
	BANNER_DC             VARCHAR2(200)  NULL ,
	REFLCT_AT             CHAR(1)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	BANNER_IMAGE_FILE     VARCHAR2(60)  NULL ,
	SORT_ORDR             NUMBER(8)  NULL ,
CONSTRAINT  COMTNBANNER_PK PRIMARY KEY (BANNER_ID)
);



CREATE TABLE COMTNLOGINSCRINIMAGE
(
	IMAGE_ID              CHAR(20)  NOT NULL ,
	IMAGE_NM              VARCHAR2(20)  NOT NULL ,
	REFLCT_AT             CHAR(1)  NOT NULL ,
	IMAGE                 VARCHAR2(60)  NOT NULL ,
	IMAGE_DC              VARCHAR2(200)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	IMAGE_FILE            VARCHAR2(60)  NULL ,
CONSTRAINT  COMTNLOGINSCRINIMAGE_PK PRIMARY KEY (IMAGE_ID)
);



CREATE TABLE COMTNORGNZTINFO
(
	ORGNZT_ID             CHAR(20)  NOT NULL ,
	ORGNZT_NM             VARCHAR2(20)  NOT NULL ,
	ORGNZT_DC             VARCHAR2(100)  NULL ,
CONSTRAINT  COMTNORGNZTINFO_PK PRIMARY KEY (ORGNZT_ID)
);



CREATE TABLE COMTNAUTHORGROUPINFO
(
	GROUP_ID              CHAR(20)  NOT NULL ,
	GROUP_NM              VARCHAR2(60)  NOT NULL ,
	GROUP_CREAT_DE        CHAR(20)  NOT NULL ,
	GROUP_DC              VARCHAR2(100)  NULL ,
CONSTRAINT  COMTNAUTHORGROUPINFO_PK PRIMARY KEY (GROUP_ID)
);



CREATE TABLE COMTNEMPLYRINFO
(
	EMPLYR_ID             VARCHAR2(20)  NOT NULL ,
	ORGNZT_ID             CHAR(20)  NULL ,
	USER_NM               VARCHAR2(60)  NOT NULL ,
	PASSWORD              VARCHAR2(200)  NOT NULL ,
	EMPL_NO               VARCHAR2(20)  NULL ,
	IHIDNUM               VARCHAR2(200)  NULL ,
	SEXDSTN_CODE          CHAR(1)  NULL ,
	BRTHDY                CHAR(20)  NULL ,
	FXNUM                 VARCHAR2(20)  NULL ,
	HOUSE_ADRES           VARCHAR2(100)  NOT NULL ,
	PASSWORD_HINT         VARCHAR2(100)  NOT NULL ,
	PASSWORD_CNSR         VARCHAR2(100)  NOT NULL ,
	HOUSE_END_TELNO       VARCHAR2(4)  NOT NULL ,
	AREA_NO               VARCHAR2(4)  NOT NULL ,
	DETAIL_ADRES          VARCHAR2(100)  NULL ,
	ZIP                   VARCHAR2(6)  NOT NULL ,
	OFFM_TELNO            VARCHAR2(20)  NULL ,
	MBTLNUM               VARCHAR2(20)  NULL ,
	EMAIL_ADRES           VARCHAR2(50)  NULL ,
	OFCPS_NM              VARCHAR2(60)  NULL ,
	HOUSE_MIDDLE_TELNO    VARCHAR2(4)  NOT NULL ,
	GROUP_ID              CHAR(20)  NULL ,
	PSTINST_CODE          CHAR(8)  NULL ,
	EMPLYR_STTUS_CODE     CHAR(1)  NOT NULL ,
	ESNTL_ID              CHAR(20)  NOT NULL ,
	CRTFC_DN_VALUE        VARCHAR2(100)  NULL ,
	SBSCRB_DE             DATE  NULL ,
	LOCK_AT               CHAR(1) NULL,
	LOCK_CNT              NUMBER(3) NULL,
	LOCK_LAST_PNTTM       DATE NULL,
	CHG_PWD_LAST_PNTTM       DATE NULL,
CONSTRAINT  COMTNEMPLYRINFO_PK PRIMARY KEY (EMPLYR_ID),
CONSTRAINT  COMTNEMPLYRINFO_FK2 FOREIGN KEY (ORGNZT_ID) REFERENCES COMTNORGNZTINFO(ORGNZT_ID) ON DELETE CASCADE,
CONSTRAINT  COMTNEMPLYRINFO_FK1 FOREIGN KEY (GROUP_ID) REFERENCES COMTNAUTHORGROUPINFO(GROUP_ID) ON DELETE CASCADE
);



CREATE INDEX COMTNEMPLYRINFO_i01 ON COMTNEMPLYRINFO
(ORGNZT_ID  ASC);



CREATE INDEX COMTNEMPLYRINFO_i02 ON COMTNEMPLYRINFO
(GROUP_ID  ASC);



CREATE TABLE COMTNFILE
(
	ATCH_FILE_ID          CHAR(20)  NOT NULL ,
	CREAT_DT              DATE  NOT NULL ,
	USE_AT                CHAR(1)  NULL ,
CONSTRAINT  COMTNFILE_PK PRIMARY KEY (ATCH_FILE_ID)
);



CREATE TABLE COMTHEMAILDSPTCHMANAGE
(
	MSSAGE_ID             VARCHAR2(20)  NOT NULL ,
	EMAIL_CN              CLOB  NULL ,
	SNDR                  VARCHAR2(50)  NOT NULL ,
	RCVER                 VARCHAR2(50)  NOT NULL ,
	SJ                    VARCHAR2(60)  NOT NULL ,
	SNDNG_RESULT_CODE     CHAR(1)  NULL ,
	DSPTCH_DT             CHAR(20)  NOT NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
CONSTRAINT  COMTHEMAILDSPTCHMANAGE_PK PRIMARY KEY (MSSAGE_ID),
CONSTRAINT  COMTHEMAILDSPTCHMANAGE_FK1 FOREIGN KEY (ATCH_FILE_ID) REFERENCES COMTNFILE(ATCH_FILE_ID)
);



CREATE INDEX COMTHEMAILDSPTCHMANAGE_i01 ON COMTHEMAILDSPTCHMANAGE
(SNDR  ASC);







CREATE TABLE COMTNNTTSTATS
(
	STATS_ID              CHAR(18)  NOT NULL ,
	NTCE_CO               NUMBER(10)  NULL ,
	AVRG_RDCNT            NUMBER(10)  NULL ,
	TOP_RDCNT             NUMBER(10)  NULL ,
	MUMM_RDCNT            NUMBER(10)  NULL ,
	TOP_NTCR_ID           VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNNTTSTATS_PK PRIMARY KEY (STATS_ID)
);



CREATE TABLE COMTNSITELIST
(
	SITE_ID               CHAR(20)  NOT NULL ,
	SITE_NM               VARCHAR2(100)  NULL ,
	SITE_URL              VARCHAR2(100)  NULL ,
	SITE_DC               VARCHAR2(1000)  NULL ,
	SITE_THEMA_CL_CODE    VARCHAR2(2)  NULL ,
	ACTVTY_AT             CHAR(1)  NULL ,
	USE_AT                CHAR(1)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNSITELIST_PK PRIMARY KEY (SITE_ID)
);



CREATE TABLE COMTNRECENTSRCHWRDMANAGE
(
	SRCHWRD_MANAGE_ID     CHAR(20)  NOT NULL ,
	SRCHWRD_MANAGE_NM     VARCHAR2(255)  NULL ,
	SRCHWRD_CONECT_URL    VARCHAR2(255)  NULL ,
	USER_SEARCH_AT        CHAR(1)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNRECENTSRCHWRDMANAGE_PK PRIMARY KEY (SRCHWRD_MANAGE_ID)
);



CREATE TABLE COMTNRECENTSRCHWRD
(
	SRCHWRD_MANAGE_ID     CHAR(20)  NOT NULL ,
	RECENT_SRCHWRD_ID     CHAR(20)  NOT NULL ,
	RECENT_SRCHWRD_NM     VARCHAR2(255)  NULL ,
	RECENT_SRCHWRD_CO     NUMBER(20)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNRECENTSRCHWRD_PK PRIMARY KEY (RECENT_SRCHWRD_ID),
CONSTRAINT  COMTNRECENTSRCHWRD_FK1 FOREIGN KEY (SRCHWRD_MANAGE_ID) REFERENCES COMTNRECENTSRCHWRDMANAGE(SRCHWRD_MANAGE_ID)
);





CREATE TABLE COMTNPROXYINFO
(
	PROXY_ID              CHAR(20)  NOT NULL ,
	PROXY_NM              VARCHAR2(60)  NULL ,
	PROXY_IP              VARCHAR2(23)  NULL ,
	PROXY_PORT            VARCHAR2(10)  NULL ,
	TRGET_SVC_NM          VARCHAR2(255)  NULL ,
	SVC_DC                VARCHAR2(2000)  NULL ,
	SVC_IP                VARCHAR2(23)  NULL ,
	SVC_PORT              VARCHAR2(10)  NULL ,
	SVC_STTUS             CHAR(2)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNPROXYINFO_PK PRIMARY KEY (PROXY_ID)
);



CREATE TABLE COMTNPROXYLOGINFO
(
	PROXY_ID              CHAR(20)  NOT NULL ,
	CLNT_IP               VARCHAR2(23)  NULL ,
	CLNT_PORT             VARCHAR2(10)  NULL ,
	CONECT_TIME           DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LOG_ID                CHAR(20)  NOT NULL ,
CONSTRAINT  COMTNPROXYLOGINFO_PK PRIMARY KEY (PROXY_ID,LOG_ID),
CONSTRAINT  COMTNPROXYLOGINFO_FK1 FOREIGN KEY (PROXY_ID) REFERENCES COMTNPROXYINFO(PROXY_ID)
);



CREATE TABLE COMTNMAINIMAGE
(
	IMAGE_ID              CHAR(20)  NOT NULL ,
	IMAGE_NM              VARCHAR2(20)  NOT NULL ,
	IMAGE                 VARCHAR2(60)  NOT NULL ,
	IMAGE_DC              VARCHAR2(200)  NULL ,
	REFLCT_AT             CHAR(1)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	IMAGE_FILE            VARCHAR2(60)  NULL ,
CONSTRAINT  COMTNMAINIMAGE_PK PRIMARY KEY (IMAGE_ID)
);



CREATE TABLE COMTNUNITYLINK
(
	UNITY_LINK_ID         CHAR(20)  NOT NULL ,
	UNITY_LINK_GROUP      VARCHAR2(255)  NULL ,
	UNITY_LINK_NM         VARCHAR2(255)  NULL ,
	UNITY_LINK_URL        VARCHAR2(255)  NULL ,
	UNITY_LINK_DC         VARCHAR2(2500)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	UNITY_LINK_SE_CODE    CHAR(3)  NULL ,
CONSTRAINT  COMTNUNITYLINK_PK PRIMARY KEY (UNITY_LINK_ID)
);



CREATE TABLE COMTNUSERABSNCE
(
	EMPLYR_ID             VARCHAR2(20)  NOT NULL ,
	USER_ABSNCE_AT        CHAR(1)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNUSERABSNCE_PK PRIMARY KEY (EMPLYR_ID)
);



CREATE TABLE COMTSSYSLOGSUMMARY
(
	OCCRRNC_DE            CHAR(8)  NOT NULL ,
	SVC_NM                VARCHAR2(255)  NOT NULL ,
	METHOD_NM             VARCHAR2(60)  NOT NULL ,
	CREAT_CO              NUMBER(10)  NULL ,
	UPDT_CO               NUMBER(10)  NULL ,
	RDCNT                 NUMBER(10)  NULL ,
	DELETE_CO             NUMBER(10)  NULL ,
	OUTPT_CO              NUMBER(10)  NULL ,
	ERROR_CO              NUMBER(10)  NULL ,
CONSTRAINT  COMTSSYSLOGSUMMARY_PK PRIMARY KEY (OCCRRNC_DE,SVC_NM,METHOD_NM)
);



CREATE TABLE COMTNSYSLOG
(
	REQUST_ID             VARCHAR2(20)  NOT NULL ,
	JOB_SE_CODE           CHAR(3)  NULL ,
	INSTT_CODE            CHAR(7)  NULL ,
	OCCRRNC_DE            DATE  NULL ,
	RQESTER_IP            VARCHAR2(23)  NULL ,
	RQESTER_ID            VARCHAR2(20)  NULL ,
	TRGET_MENU_NM         VARCHAR2(255)  NULL ,
	SVC_NM                VARCHAR2(255)  NULL ,
	METHOD_NM             VARCHAR2(60)  NULL ,
	PROCESS_SE_CODE       CHAR(3)  NULL ,
	PROCESS_CO            NUMBER(10)  NULL ,
	PROCESS_TIME          VARCHAR2(14)  NULL ,
	RSPNS_CODE            CHAR(3)  NULL ,
	ERROR_SE              CHAR(1)  NULL ,
	ERROR_CO              NUMBER(10)  NULL ,
	ERROR_CODE            CHAR(3)  NULL ,
CONSTRAINT  COMTNSYSLOG_PK PRIMARY KEY (REQUST_ID)
);



CREATE TABLE COMTNBBSMASTER
(
	BBS_ID                CHAR(30)  NOT NULL ,
	BBS_NM                VARCHAR2(255)  NOT NULL ,
	BBS_INTRCN            VARCHAR2(2400)  NULL ,
	BBS_TY_CODE           CHAR(6)  NOT NULL ,
	REPLY_POSBL_AT        CHAR(1)  NULL ,
	FILE_ATCH_POSBL_AT    CHAR(1)  NOT NULL ,
	ATCH_POSBL_FILE_NUMBER  NUMBER(2)  NOT NULL ,
	ATCH_POSBL_FILE_SIZE  NUMBER(8)  NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	TMPLAT_ID             CHAR(20)  NULL ,
	CMMNTY_ID				CHAR(20) NULL,
	FRST_REGISTER_ID      VARCHAR2(20)  NOT NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	BLOG_ID 					CHAR(20) NULL,
	BLOG_AT 					CHAR(2) NULL,
CONSTRAINT  COMTNBBSMASTER_PK PRIMARY KEY (BBS_ID)
);



CREATE TABLE COMTNBBS
(
	NTT_ID                NUMBER(20)  NOT NULL ,
	BBS_ID                CHAR(30)  NOT NULL ,
	NTT_NO                NUMBER(20)  NULL ,
	NTT_SJ                VARCHAR2(2000)  NULL ,
	NTT_CN                CLOB  NULL ,
	ANSWER_AT             CHAR(1)  NULL ,
	PARNTSCTT_NO          NUMBER(10)  NULL ,
	ANSWER_LC             NUMBER(8)  NULL ,
	SORT_ORDR             NUMBER(8)  NULL ,
	RDCNT                 NUMBER(10)  NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	NTCE_BGNDE            CHAR(20)  NULL ,
	NTCE_ENDDE            CHAR(20)  NULL ,
	NTCR_ID               VARCHAR2(20)  NULL ,
	NTCR_NM               VARCHAR2(20)  NULL ,
	PASSWORD              VARCHAR2(200)  NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
	NOTICE_AT				CHAR(1) NULL,
	SJ_BOLD_AT				CHAR(1) NULL,
	SECRET_AT				CHAR(1) NULL,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NOT NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	BLOG_ID 					CHAR(20) NULL,
CONSTRAINT  COMTNBBS_PK PRIMARY KEY (NTT_ID,BBS_ID),
CONSTRAINT  COMTNBBS_FK1 FOREIGN KEY (BBS_ID) REFERENCES COMTNBBSMASTER(BBS_ID)
);



CREATE INDEX COMTNBBS_i01 ON COMTNBBS
(BBS_ID  ASC);



CREATE TABLE COMTNCOMMENT
(
	NTT_ID                NUMBER(20)  NOT NULL ,
	BBS_ID                CHAR(30)  NOT NULL ,
	ANSWER_NO             NUMBER(20)  NOT NULL ,
	WRTER_ID              VARCHAR2(20)  NULL ,
	WRTER_NM              VARCHAR2(20)  NULL ,
	ANSWER                VARCHAR2(200)  NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NOT NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	PASSWORD              VARCHAR2(200)  NULL ,
CONSTRAINT  COMTNCOMMENT_PK PRIMARY KEY (NTT_ID,BBS_ID,ANSWER_NO),
CONSTRAINT  COMTNCOMMENT_FK1 FOREIGN KEY (NTT_ID,BBS_ID) REFERENCES COMTNBBS(NTT_ID,BBS_ID)
);



CREATE INDEX COMTNCOMMENT_i01 ON COMTNCOMMENT
(NTT_ID  ASC,BBS_ID  ASC);



CREATE TABLE COMTNRECOMENDSITEINFO
(
	RECOMEND_SITE_ID      CHAR(20)  NOT NULL ,
	RECOMEND_SITE_NM      VARCHAR2(100)  NULL ,
	RECOMEND_SITE_URL     VARCHAR2(255)  NULL ,
	RECOMEND_SITE_DC      VARCHAR2(1000)  NULL ,
	RECOMEND_RESN_CN      VARCHAR2(1000)  NULL ,
	RECOMEND_CONFM_AT     CHAR(1)  NULL ,
	CONFM_DE              CHAR(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNRECOMENDSITEINFO_PK PRIMARY KEY (RECOMEND_SITE_ID)
);



CREATE TABLE COMTNINTNETSVC
(
	INTNET_SVC_ID         CHAR(20)  NOT NULL ,
	INTNET_SVC_NM         VARCHAR2(20)  NOT NULL ,
	INTNET_SVC_DC         VARCHAR2(200)  NULL ,
	REFLCT_AT             CHAR(1)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNINTNETSVC_PK PRIMARY KEY (INTNET_SVC_ID)
);



CREATE TABLE COMTNCLUB
(
	CLB_ID                CHAR(20)  NOT NULL ,
	CMMNTY_ID             CHAR(20)  NOT NULL ,
	CLB_NM                VARCHAR2(255)  NOT NULL ,
	CLB_INTRCN            VARCHAR2(2400)  NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	REGIST_SE_CODE        CHAR(6)  NULL ,
	TMPLAT_ID             CHAR(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NOT NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNCLUB_PK PRIMARY KEY (CLB_ID,CMMNTY_ID)
);



CREATE TABLE COMTNCLUBUSER
(
	CLB_ID                CHAR(20)  NOT NULL ,
	CMMNTY_ID             CHAR(20)  NOT NULL ,
	OPRTR_AT              CHAR(1)  NOT NULL ,
	SBSCRB_DE             DATE  NULL ,
	SECSN_DE              CHAR(20)  NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NOT NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	EMPLYR_ID             VARCHAR2(20)  NOT NULL ,
CONSTRAINT  COMTNCLUBUSER_PK PRIMARY KEY (CLB_ID,CMMNTY_ID,EMPLYR_ID),
CONSTRAINT  COMTNCLUBUSER_FK1 FOREIGN KEY (CLB_ID,CMMNTY_ID) REFERENCES COMTNCLUB(CLB_ID,CMMNTY_ID)
);



CREATE INDEX COMTNCLUBUSER_i01 ON COMTNCLUBUSER
(CLB_ID  ASC,CMMNTY_ID  ASC);



CREATE TABLE COMTNBACKUPOPERT
(
	BACKUP_OPERT_ID       VARCHAR2(20)  NOT NULL ,
	BACKUP_OPERT_NM       VARCHAR2(60)  NULL ,
	BACKUP_ORGINL_DRCTRY  VARCHAR2(255)  NULL ,
	BACKUP_STRE_DRCTRY    VARCHAR2(255)  NULL ,
	CMPRS_SE              VARCHAR2(2)  NULL ,
	EXECUT_CYCLE          VARCHAR2(2)  NULL ,
	EXECUT_SCHDUL_DE      CHAR(20)  NULL ,
	EXECUT_SCHDUL_HOUR    CHAR(2)  NULL ,
	EXECUT_SCHDUL_MNT     CHAR(2)  NULL ,
	EXECUT_SCHDUL_SECND   CHAR(2)  NULL ,
	USE_AT                CHAR(1)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NOT NULL ,
CONSTRAINT  COMTNBACKUPOPERT_PK PRIMARY KEY (BACKUP_OPERT_ID)
);



CREATE TABLE COMTNBACKUPSCHDULDFK
(
	BACKUP_OPERT_ID       VARCHAR2(20)  NOT NULL ,
	EXECUT_SCHDUL_DFK_SE  CHAR(1)  NOT NULL ,
CONSTRAINT  COMTNBACKUPSCHDULDFK_PK PRIMARY KEY (BACKUP_OPERT_ID,EXECUT_SCHDUL_DFK_SE),
CONSTRAINT  COMTNBACKUPSCHDULDFK_FK1 FOREIGN KEY (BACKUP_OPERT_ID) REFERENCES COMTNBACKUPOPERT(BACKUP_OPERT_ID)
);



CREATE TABLE COMTNCMMNTY
(
	CMMNTY_ID             CHAR(20)  NOT NULL ,
	CMMNTY_NM             VARCHAR2(255)  NOT NULL ,
	CMMNTY_INTRCN         VARCHAR2(2400)  NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	REGIST_SE_CODE        CHAR(6)  NULL ,
	TMPLAT_ID             CHAR(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NOT NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNCMMNTY_PK PRIMARY KEY (CMMNTY_ID)
);



CREATE TABLE COMTNCMMNTYUSER
(
	CMMNTY_ID             CHAR(20)  NOT NULL ,
	EMPLYR_ID             VARCHAR2(20)  NOT NULL ,
	MNGR_AT               CHAR(1)  NOT NULL ,
	MBER_STTUS			VARCHAR2(15) NULL,
	SBSCRB_DE             DATE  NULL ,
	SECSN_DE              CHAR(20)  NULL ,
	USE_AT                CHAR(1)  NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NOT NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNCMMNTYUSER_PK PRIMARY KEY (CMMNTY_ID,EMPLYR_ID),
CONSTRAINT  COMTNCMMNTYUSER_FK1 FOREIGN KEY (CMMNTY_ID) REFERENCES COMTNCMMNTY(CMMNTY_ID)
);



CREATE INDEX COMTNCMMNTYUSER_i01 ON COMTNCMMNTYUSER
(CMMNTY_ID  ASC);



CREATE TABLE COMTNFILEDETAIL
(
	ATCH_FILE_ID          CHAR(20)  NOT NULL ,
	FILE_SN               NUMBER(10)  NOT NULL ,
	FILE_STRE_COURS       VARCHAR2(2000)  NOT NULL ,
	STRE_FILE_NM          VARCHAR2(255)  NOT NULL ,
	ORIGNL_FILE_NM        VARCHAR2(255)  NULL ,
	FILE_EXTSN            VARCHAR2(20)  NOT NULL ,
	FILE_CN               CLOB  NULL ,
	FILE_SIZE             NUMBER(8)  NULL ,
CONSTRAINT  COMTNFILEDETAIL_PK PRIMARY KEY (ATCH_FILE_ID,FILE_SN),
CONSTRAINT  COMTNFILEDETAIL_FK1 FOREIGN KEY (ATCH_FILE_ID) REFERENCES COMTNFILE(ATCH_FILE_ID)
);



CREATE INDEX COMTNFILEDETAIL_i01 ON COMTNFILEDETAIL
(ATCH_FILE_ID  ASC);



CREATE TABLE COMTNLOGINPOLICY
(
	EMPLYR_ID             VARCHAR2(20)  NOT NULL ,
	IP_INFO               VARCHAR2(23)  NOT NULL ,
	DPLCT_PERM_AT         CHAR(1)  NOT NULL ,
	LMTT_AT               CHAR(1)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNLOGINPOLICY_PK PRIMARY KEY (EMPLYR_ID)
);



CREATE TABLE COMTNQUSTNRTMPLAT
(
	QUSTNR_TMPLAT_ID      CHAR(20)  NOT NULL ,
	QUSTNR_TMPLAT_TY      VARCHAR2(100)  NULL ,
	QUSTNR_TMPLAT_DC      VARCHAR2(2000)  NULL ,
	QUSTNR_TMPLAT_PATH_NM  VARCHAR2(100)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	QUSTNR_TMPLAT_IMAGE_INFO  BLOB  NULL ,
CONSTRAINT  COMTNQUSTNRTMPLAT_PK PRIMARY KEY (QUSTNR_TMPLAT_ID)
);



CREATE TABLE COMTNQESTNRINFO
(
	QUSTNR_TMPLAT_ID      CHAR(20)  NOT NULL ,
	QESTNR_ID             CHAR(20)  NOT NULL ,
	QUSTNR_SJ             VARCHAR2(255)  NULL ,
	QUSTNR_PURPS          VARCHAR2(1000)  NULL ,
	QUSTNR_WRITNG_GUIDANCE_CN  VARCHAR2(2000)  NULL ,
	QUSTNR_TRGET          VARCHAR2(1000)  NULL ,
	QUSTNR_BGNDE          CHAR(20)  NULL ,
	QUSTNR_ENDDE          CHAR(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNQESTNRINFO_PK PRIMARY KEY (QUSTNR_TMPLAT_ID,QESTNR_ID),
CONSTRAINT  COMTNQESTNRINFO_FK1 FOREIGN KEY (QUSTNR_TMPLAT_ID) REFERENCES COMTNQUSTNRTMPLAT(QUSTNR_TMPLAT_ID)
);



CREATE INDEX COMTNQESTNRINFO_i01 ON COMTNQESTNRINFO
(QUSTNR_TMPLAT_ID  ASC);



CREATE TABLE COMTNQUSTNRRESPONDINFO
(
	QUSTNR_TMPLAT_ID      CHAR(20)  NOT NULL ,
	QESTNR_ID             CHAR(20)  NOT NULL ,
	QUSTNR_RESPOND_ID     CHAR(20)  NOT NULL ,
	SEXDSTN_CODE          CHAR(1)  NULL ,
	OCCP_TY_CODE          CHAR(1)  NULL ,
	RESPOND_NM            VARCHAR2(50)  NULL ,
	BRTHDY                CHAR(20)  NULL ,
	AREA_NO               VARCHAR2(4)  NULL ,
	MIDDLE_TELNO          VARCHAR2(4)  NULL ,
	END_TELNO             VARCHAR2(4)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNQUSTNRRESPONDINFO_PK PRIMARY KEY (QUSTNR_TMPLAT_ID,QESTNR_ID,QUSTNR_RESPOND_ID),
CONSTRAINT  COMTNQUSTNRRESPONDINFO_FK1 FOREIGN KEY (QUSTNR_TMPLAT_ID,QESTNR_ID) REFERENCES COMTNQESTNRINFO(QUSTNR_TMPLAT_ID,QESTNR_ID)
);



CREATE INDEX COMTNQUSTNRRESPONDINFO_i01 ON COMTNQUSTNRRESPONDINFO
(QESTNR_ID  ASC,QUSTNR_TMPLAT_ID  ASC);



CREATE TABLE COMTCADMINISTCODE
(
	ADMINIST_ZONE_SE      CHAR(1)  NOT NULL ,
	ADMINIST_ZONE_CODE    VARCHAR2(10)  NOT NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	ADMINIST_ZONE_NM      VARCHAR2(60)  NULL ,
	UPPER_ADMINIST_ZONE_CODE  VARCHAR2(10)  NULL ,
	CREAT_DE              CHAR(20)  NULL ,
	ABL_DE                CHAR(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTCADMINISTCODE_PK PRIMARY KEY (ADMINIST_ZONE_SE,ADMINIST_ZONE_CODE)
);



CREATE TABLE COMTNUSERLOG
(
	OCCRRNC_DE            CHAR(8)  NOT NULL ,
	RQESTER_ID            VARCHAR2(20)  NOT NULL ,
	SVC_NM                VARCHAR2(255)  NOT NULL ,
	METHOD_NM             VARCHAR2(60)  NOT NULL ,
	CREAT_CO              NUMBER(10)  NULL ,
	UPDT_CO               NUMBER(10)  NULL ,
	RDCNT                 NUMBER(10)  NULL ,
	DELETE_CO             NUMBER(10)  NULL ,
	OUTPT_CO              NUMBER(10)  NULL ,
	ERROR_CO              NUMBER(10)  NULL ,
CONSTRAINT  COMTNUSERLOG_PK PRIMARY KEY (OCCRRNC_DE,RQESTER_ID,SVC_NM,METHOD_NM)
);



CREATE TABLE COMTSTRSMRCVLOGSUMMARY
(
	OCCRRNC_DE            CHAR(20)  NOT NULL ,
	TRSMRCV_SE_CODE       CHAR(3)  NOT NULL ,
	PROVD_INSTT_ID        CHAR(8)  NOT NULL ,
	PROVD_SYS_ID          CHAR(8)  NOT NULL ,
	PROVD_SVC_ID          CHAR(8)  NOT NULL ,
	REQUST_INSTT_ID       CHAR(8)  NOT NULL ,
	REQUST_SYS_ID         CHAR(8)  NOT NULL ,
	RDCNT                 NUMBER(10)  NULL ,
	ERROR_CO              NUMBER(10)  NULL ,
CONSTRAINT  COMTSTRSMRCVLOGSUMMARY_PK PRIMARY KEY (OCCRRNC_DE,TRSMRCV_SE_CODE,PROVD_INSTT_ID,PROVD_SYS_ID,PROVD_SVC_ID,REQUST_INSTT_ID,REQUST_SYS_ID)
);



CREATE TABLE COMTCCMMNCLCODE
(
	CL_CODE               CHAR(3)  NOT NULL ,
	CL_CODE_NM            VARCHAR2(60)  NULL ,
	CL_CODE_DC            VARCHAR2(200)  NULL ,
	USE_AT                CHAR(1)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTCCMMNCLCODE_PK PRIMARY KEY (CL_CODE)
);



CREATE TABLE COMTCCMMNCODE
(
	CODE_ID               VARCHAR2(6)  NOT NULL ,
	CODE_ID_NM            VARCHAR2(60)  NULL ,
	CODE_ID_DC            VARCHAR2(200)  NULL ,
	USE_AT                CHAR(1)  NULL ,
	CL_CODE               CHAR(3)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTCCMMNCODE_PK PRIMARY KEY (CODE_ID),
CONSTRAINT  COMTCCMMNCODE_FK1 FOREIGN KEY (CL_CODE) REFERENCES COMTCCMMNCLCODE(CL_CODE) ON DELETE CASCADE
);



CREATE INDEX COMTCCMMNCODE_i01 ON COMTCCMMNCODE
(CL_CODE  ASC);



CREATE TABLE COMTCCMMNDETAILCODE
(
	CODE_ID               VARCHAR2(6)  NOT NULL ,
	CODE                  VARCHAR2(15)  NOT NULL ,
	CODE_NM               VARCHAR2(60)  NULL ,
	CODE_DC               VARCHAR2(200)  NULL ,
	USE_AT                CHAR(1)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTCCMMNDETAILCODE_PK PRIMARY KEY (CODE_ID,CODE),
CONSTRAINT  COMTCCMMNDETAILCODE_FK1 FOREIGN KEY (CODE_ID) REFERENCES COMTCCMMNCODE(CODE_ID)
);



CREATE INDEX COMTCCMMNDETAILCODE_i01 ON COMTCCMMNDETAILCODE
(CODE_ID  ASC);



CREATE TABLE COMTSBBSSUMMARY
(
	OCCRRNC_DE            CHAR(20)  NOT NULL ,
	STATS_SE              VARCHAR2(10)  NOT NULL ,
	DETAIL_STATS_SE       VARCHAR2(10)  NOT NULL ,
	CREAT_CO              NUMBER(10)  NULL ,
	TOT_RDCNT             NUMBER(10)  NULL ,
	AVRG_RDCNT            NUMBER(10)  NULL ,
	TOP_INQIRE_BBSCTT_ID  VARCHAR2(20)  NULL ,
	MUMM_INQIRE_BBSCTT_ID  VARCHAR2(20)  NULL ,
	TOP_NTCR_ID           VARCHAR2(20)  NULL ,
CONSTRAINT  COMTSBBSSUMMARY_PK PRIMARY KEY (OCCRRNC_DE,STATS_SE,DETAIL_STATS_SE)
);



CREATE TABLE COMTCZIP
(
	ZIP                   VARCHAR2(6)  NOT NULL ,
	SN                    NUMBER(10)  NOT NULL ,
	CTPRVN_NM             VARCHAR2(20)  NULL ,
	SIGNGU_NM             VARCHAR2(20)  NULL ,
	EMD_NM                VARCHAR2(60)  NULL ,
	LI_BULD_NM            VARCHAR2(60)  NULL ,
	LNBR_DONG_HO          VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTCZIP_PK PRIMARY KEY (ZIP,SN)
);



CREATE TABLE COMTRDNMADRZIP
(
	RDMN_CODE             VARCHAR2(12) NOT NULL,
	SN                    NUMBER(10) NOT NULL,
	CTPRVN_NM             VARCHAR2(20) NULL,
	SIGNGU_NM             VARCHAR2(20) NULL,
	RDMN                  VARCHAR2(60) NULL,
	BDNBR_MNNM            VARCHAR2(5) NULL,
	BDNBR_SLNO            VARCHAR2(5) NULL,
	BULD_NM               VARCHAR2(60) NULL,
	DETAIL_BULD_NM        VARCHAR2(60) NULL,
	ZIP                   VARCHAR2(6) NOT NULL,
	FRST_REGIST_PNTTM     DATE NULL,
	FRST_REGISTER_ID      VARCHAR2(20) NULL,
	LAST_UPDT_PNTTM       DATE NULL,
	LAST_UPDUSR_ID        VARCHAR2(20) NULL,
CONSTRAINT  COMTRDNMADRZIP_PK PRIMARY KEY (SN)
);



CREATE TABLE COMTNNCRD
(
	NCRD_ID               CHAR(20)  NOT NULL ,
	NCRD_TRGTER_ID        VARCHAR2(20)  NULL ,
	NM                    VARCHAR2(50)  NOT NULL ,
	TELNO                 VARCHAR2(20)  NULL ,
	NATION_NO             VARCHAR2(10)  NULL ,
	AREA_NO               VARCHAR2(4)  NULL ,
	MIDDLE_TELNO          VARCHAR2(4)  NULL ,
	END_TELNO             VARCHAR2(4)  NULL ,
	MBTLNUM               VARCHAR2(20)  NULL ,
	IDNTFC_NO             VARCHAR2(10)  NULL ,
	MIDDLE_MBTLNUM        VARCHAR2(4)  NULL ,
	END_MBTLNUM           VARCHAR2(4)  NULL ,
	EMAIL_ADRES           VARCHAR2(50)  NULL ,
	CMPNY_NM              VARCHAR2(60)  NULL ,
	DEPT_NM               VARCHAR2(60)  NULL ,
	ADRES                 VARCHAR2(100)  NULL ,
	DETAIL_ADRES          VARCHAR2(100)  NULL ,
	OFCPS_NM              VARCHAR2(60)  NULL ,
	CLSF_NM               VARCHAR2(60)  NULL ,
	EXTRL_USER_AT         CHAR(1)  NULL ,
	OTHBC_AT              CHAR(1)  NOT NULL ,
	RM                    VARCHAR2(2500)  NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNNCRD_PK PRIMARY KEY (NCRD_ID)
);



CREATE TABLE COMTNNCRDUSER
(
	NCRD_ID               CHAR(20)  NOT NULL ,
	REGIST_SE_CODE        CHAR(6)  NOT NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	CREAT_DT              DATE  NOT NULL ,
	EMPLYR_ID             VARCHAR2(20)  NOT NULL ,
CONSTRAINT  COMTNNCRDUSER_PK PRIMARY KEY (NCRD_ID,EMPLYR_ID),
CONSTRAINT  COMTNNCRDUSER_FK1 FOREIGN KEY (NCRD_ID) REFERENCES COMTNNCRD(NCRD_ID)
);



CREATE INDEX COMTNNCRDUSER_i03 ON COMTNNCRDUSER
(NCRD_ID  ASC);



CREATE TABLE COMTNENTRPRSMBER
(
	ENTRPRS_MBER_ID       VARCHAR2(20)  NOT NULL ,
	ENTRPRS_SE_CODE       CHAR(8)  NULL ,
	BIZRNO                VARCHAR2(10)  NULL ,
	JURIRNO               VARCHAR2(13)  NULL ,
	CMPNY_NM              VARCHAR2(60)  NOT NULL ,
	CXFC                  VARCHAR2(50)  NULL ,
	ZIP                   VARCHAR2(6)  NOT NULL ,
	ADRES                 VARCHAR2(100)  NOT NULL ,
	ENTRPRS_MIDDLE_TELNO  VARCHAR2(4)  NOT NULL ,
	FXNUM                 VARCHAR2(20)  NULL ,
	INDUTY_CODE           CHAR(1)  NULL ,
	APPLCNT_NM            VARCHAR2(50)  NOT NULL ,
	APPLCNT_IHIDNUM       VARCHAR2(200)  NULL ,
	SBSCRB_DE             DATE  NULL ,
	ENTRPRS_MBER_STTUS    VARCHAR2(15)  NULL ,
	ENTRPRS_MBER_PASSWORD  VARCHAR2(200)  NULL ,
	ENTRPRS_MBER_PASSWORD_HINT  VARCHAR2(100)  NOT NULL ,
	ENTRPRS_MBER_PASSWORD_CNSR  VARCHAR2(100)  NOT NULL ,
	GROUP_ID              CHAR(20)  NULL ,
	DETAIL_ADRES          VARCHAR2(100)  NULL ,
	ENTRPRS_END_TELNO     VARCHAR2(4)  NOT NULL ,
	AREA_NO               VARCHAR2(4)  NOT NULL ,
	APPLCNT_EMAIL_ADRES   VARCHAR2(50)  NOT NULL ,
	ESNTL_ID              CHAR(20)  NOT NULL ,
	LOCK_AT               CHAR(1) NULL,
	LOCK_CNT              NUMBER(3) NULL,
	LOCK_LAST_PNTTM       DATE NULL,
	CHG_PWD_LAST_PNTTM    DATE NULL,
CONSTRAINT  COMTNENTRPRSMBER_PK PRIMARY KEY (ENTRPRS_MBER_ID),
CONSTRAINT  COMTNENTRPRSMBER_FK1 FOREIGN KEY (GROUP_ID) REFERENCES COMTNAUTHORGROUPINFO(GROUP_ID) ON DELETE CASCADE
);



CREATE INDEX COMTNENTRPRSMBER_i01 ON COMTNENTRPRSMBER
(GROUP_ID  ASC);



CREATE TABLE COMTNGNRLMBER
(
	MBER_ID               VARCHAR2(20)  NOT NULL ,
	PASSWORD              VARCHAR2(200)  NOT NULL ,
	PASSWORD_HINT         VARCHAR2(100)  NULL ,
	PASSWORD_CNSR         VARCHAR2(100)  NULL ,
	IHIDNUM               VARCHAR2(200)  NULL ,
	MBER_NM               VARCHAR2(50)  NOT NULL ,
	ZIP                   VARCHAR2(6)  NOT NULL ,
	ADRES                 VARCHAR2(100)  NOT NULL ,
	AREA_NO               VARCHAR2(4)  NOT NULL ,
	MBER_STTUS            VARCHAR2(15)  NULL ,
	DETAIL_ADRES          VARCHAR2(100)  NULL ,
	END_TELNO             VARCHAR2(4)  NOT NULL ,
	MBTLNUM               VARCHAR2(20)  NOT NULL ,
	GROUP_ID              CHAR(20)  NULL ,
	MBER_FXNUM            VARCHAR2(20)  NULL ,
	MBER_EMAIL_ADRES      VARCHAR2(50)  NULL ,
	MIDDLE_TELNO          VARCHAR2(4)  NOT NULL ,
	SBSCRB_DE             DATE  NULL ,
	SEXDSTN_CODE          CHAR(1)  NULL ,
	ESNTL_ID              CHAR(20)  NOT NULL ,
	LOCK_AT               CHAR(1) NULL,
	LOCK_CNT              NUMBER(3) NULL,
	LOCK_LAST_PNTTM       DATE NULL,
	CHG_PWD_LAST_PNTTM    DATE NULL,
CONSTRAINT  COMTNGNRLMBER_PK PRIMARY KEY (MBER_ID),
CONSTRAINT  COMTNGNRLMBER_FK1 FOREIGN KEY (GROUP_ID) REFERENCES COMTNAUTHORGROUPINFO(GROUP_ID) ON DELETE CASCADE
);



CREATE INDEX COMTNGNRLMBER_i01 ON COMTNGNRLMBER
(GROUP_ID  ASC);



CREATE TABLE COMTNAUTHORINFO
(
	AUTHOR_CODE           VARCHAR2(30)  NOT NULL ,
	AUTHOR_NM             VARCHAR2(60)  NOT NULL ,
	AUTHOR_DC             VARCHAR2(200)  NULL ,
	AUTHOR_CREAT_DE       CHAR(20)  NOT NULL ,
CONSTRAINT  COMTNAUTHORINFO_PK PRIMARY KEY (AUTHOR_CODE)
);



CREATE TABLE COMTNEMPLYRSCRTYESTBS
(
	SCRTY_DTRMN_TRGET_ID  VARCHAR2(20)  NOT NULL ,
	MBER_TY_CODE          CHAR(5)  NULL ,
	AUTHOR_CODE           VARCHAR2(30)  NOT NULL ,
CONSTRAINT  COMTNEMPLYRSCRTYESTBS_PK PRIMARY KEY (SCRTY_DTRMN_TRGET_ID)	
);






CREATE INDEX COMTNEMPLYRSCRTYESTBS_i04 ON COMTNEMPLYRSCRTYESTBS
(AUTHOR_CODE  ASC);



CREATE TABLE COMTNQAINFO
(
	QA_ID                 CHAR(20)  NOT NULL ,
	QESTN_SJ              VARCHAR2(255)  NULL ,
	QESTN_CN              VARCHAR2(2500)  NULL ,
	WRITNG_DE             CHAR(20)  NULL ,
	RDCNT                 NUMBER(10)  NULL ,
	EMAIL_ADRES           VARCHAR2(50)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	QNA_PROCESS_STTUS_CODE  CHAR(1)  NULL ,
	WRTER_NM              VARCHAR2(20)  NULL ,
	ANSWER_CN             VARCHAR2(2500)  NULL ,
	WRITNG_PASSWORD       VARCHAR2(20)  NULL ,
	ANSWER_DE             CHAR(20)  NULL ,
	EMAIL_ANSWER_AT       CHAR(1)  NULL ,
	AREA_NO               VARCHAR2(4)  NULL ,
	MIDDLE_TELNO          VARCHAR2(4)  NULL ,
	END_TELNO             VARCHAR2(4)  NULL ,
CONSTRAINT  COMTNQAINFO_PK PRIMARY KEY (QA_ID)
);



CREATE TABLE COMTSWEBLOGSUMMARY
(
	OCCRRNC_DE            CHAR(8)  NOT NULL ,
	URL                   VARCHAR2(200)  NOT NULL ,
	RDCNT                 NUMBER(10)  NULL ,
CONSTRAINT  COMTSWEBLOGSUMMARY_PK PRIMARY KEY (OCCRRNC_DE,URL)
);



CREATE TABLE COMTNROLES_HIERARCHY
(
	PARNTS_ROLE           VARCHAR2(30)  NOT NULL ,
	CHLDRN_ROLE           VARCHAR2(30)  NOT NULL ,
CONSTRAINT  COMTNROLES_HIERARCHY_PK PRIMARY KEY (PARNTS_ROLE,CHLDRN_ROLE),
CONSTRAINT  COMTNROLES_HIERARCHY_FK1 FOREIGN KEY (PARNTS_ROLE) REFERENCES COMTNAUTHORINFO(AUTHOR_CODE) ON DELETE CASCADE,
CONSTRAINT  COMTNROLES_HIERARCHY_FK2 FOREIGN KEY (CHLDRN_ROLE) REFERENCES COMTNAUTHORINFO(AUTHOR_CODE) ON DELETE CASCADE
);



CREATE UNIQUE INDEX COMTNROLES_HIERARCHY_i01 ON COMTNROLES_HIERARCHY
(PARNTS_ROLE  ASC);



CREATE INDEX COMTNROLES_HIERARCHY_i02 ON COMTNROLES_HIERARCHY
(CHLDRN_ROLE  ASC);



CREATE TABLE COMTNROLEINFO
(
	ROLE_CODE             VARCHAR2(50)  NOT NULL ,
	ROLE_NM               VARCHAR2(60)  NOT NULL ,
	ROLE_PTTRN            VARCHAR2(300)  NULL ,
	ROLE_DC               VARCHAR2(200)  NULL ,
	ROLE_TY               VARCHAR2(80)  NULL ,
	ROLE_SORT             VARCHAR2(10)  NULL ,
	ROLE_CREAT_DE         CHAR(20)  NOT NULL ,
CONSTRAINT  COMTNROLEINFO_PK PRIMARY KEY (ROLE_CODE)
);



CREATE TABLE COMTNAUTHORROLERELATE
(
	AUTHOR_CODE           VARCHAR2(30)  NOT NULL ,
	ROLE_CODE             VARCHAR2(50)  NOT NULL ,
	CREAT_DT              DATE  NULL ,
CONSTRAINT  COMTNAUTHORROLERELATE_PK PRIMARY KEY (AUTHOR_CODE,ROLE_CODE),
CONSTRAINT  COMTNAUTHORROLERELATE_FK1 FOREIGN KEY (AUTHOR_CODE) REFERENCES COMTNAUTHORINFO(AUTHOR_CODE) ON DELETE CASCADE,
CONSTRAINT  COMTNAUTHORROLERELATE_FK2 FOREIGN KEY (ROLE_CODE) REFERENCES COMTNROLEINFO(ROLE_CODE) ON DELETE CASCADE
);



CREATE INDEX COMTNAUTHORROLERELATE_i01 ON COMTNAUTHORROLERELATE
(AUTHOR_CODE  ASC);



CREATE INDEX COMTNAUTHORROLERELATE_i02 ON COMTNAUTHORROLERELATE
(ROLE_CODE  ASC);



CREATE TABLE COMTNLOGINLOG
(
	LOG_ID                CHAR(20)  NOT NULL ,
	CONECT_ID             VARCHAR2(20)  NULL ,
	CONECT_IP             VARCHAR2(23)  NULL ,
	CONECT_MTHD           CHAR(4)  NULL ,
	ERROR_OCCRRNC_AT      CHAR(1)  NULL ,
	ERROR_CODE            CHAR(3)  NULL ,
	CREAT_DT              DATE  NULL ,
CONSTRAINT  COMTNLOGINLOG_PK PRIMARY KEY (LOG_ID)
);



CREATE TABLE COMTNWEBLOG
(
	REQUST_ID             VARCHAR2(20)  NOT NULL ,
	OCCRRNC_DE            DATE  NULL ,
	URL                   VARCHAR2(200)  NULL ,
	RQESTER_ID            VARCHAR2(20)  NULL ,
	RQESTER_IP            VARCHAR2(23)  NULL ,
CONSTRAINT  COMTNWEBLOG_PK PRIMARY KEY (REQUST_ID)
);



CREATE TABLE COMTNEVENTINFO
(
	EVENT_ID              CHAR(20)  NOT NULL ,
	BSNS_YEAR             CHAR(4)  NULL ,
	BSNS_CODE             VARCHAR2(2)  NULL ,
	EVENT_CN              VARCHAR2(1000)  NULL ,
	EVENT_SVC_BGNDE       CHAR(20)  NULL ,
	SVC_USE_NMPR_CO       NUMBER(10)  NULL ,
	CHARGER_NM            VARCHAR2(50)  NULL ,
	PRPARETG_CN           VARCHAR2(2500)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	EVENT_SVC_ENDDE       CHAR(20)  NULL ,
	EVENT_TY_CODE         CHAR(1)  NULL ,
	EVENT_CONFM_AT        CHAR(1)  NULL ,
	EVENT_CONFM_DE        CHAR(20)  NULL ,
CONSTRAINT  COMTNEVENTINFO_PK PRIMARY KEY (EVENT_ID)
);



CREATE TABLE COMTNEXTRLHRINFO
(
	EVENT_ID              CHAR(20)  NOT NULL ,
	EXTRL_HR_ID           CHAR(20)  NOT NULL ,
	SEXDSTN_CODE          CHAR(1)  NULL ,
	EXTRL_HR_NM           VARCHAR2(60)  NULL ,
	OCCP_TY_CODE          CHAR(1)  NULL ,
	PSITN_INSTT_NM        VARCHAR2(100)  NULL ,
	BRTHDY                CHAR(20)  NULL ,
	AREA_NO               VARCHAR2(4)  NULL ,
	MIDDLE_TELNO          VARCHAR2(4)  NULL ,
	END_TELNO             VARCHAR2(4)  NULL ,
	EMAIL_ADRES           VARCHAR2(50)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNEXTRLHRINFO_PK PRIMARY KEY (EVENT_ID,EXTRL_HR_ID),
CONSTRAINT  COMTNEXTRLHRINFO_FK1 FOREIGN KEY (EVENT_ID) REFERENCES COMTNEVENTINFO(EVENT_ID)
);



CREATE INDEX COMTNEXTRLHRINFO_i01 ON COMTNEXTRLHRINFO
(EVENT_ID  ASC);



CREATE TABLE COMTNBBSUSE
(
	BBS_ID                CHAR(30)  NOT NULL ,
	TRGET_ID              CHAR(20)  NOT NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	REGIST_SE_CODE        CHAR(6)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NOT NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNBBSUSE_PK PRIMARY KEY (BBS_ID,TRGET_ID),
CONSTRAINT  COMTNBBSUSE_FK1 FOREIGN KEY (BBS_ID) REFERENCES COMTNBBSMASTER(BBS_ID)
);



CREATE INDEX COMTNBBSUSE_i01 ON COMTNBBSUSE
(BBS_ID  ASC);



CREATE TABLE COMTNSTPLATINFO
(
	USE_STPLAT_ID         CHAR(20)  NOT NULL ,
	USE_STPLAT_NM         VARCHAR2(100)  NULL ,
	USE_STPLAT_CN         CLOB  NULL ,
	INFO_PROVD_AGRE_CN    CLOB  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNSTPLATINFO_PK PRIMARY KEY (USE_STPLAT_ID)
);



CREATE TABLE COMTNQUSTNRQESITM
(
	QESTNR_ID             CHAR(20)  NOT NULL ,
	QUSTNR_QESITM_ID      CHAR(20)  NOT NULL ,
	QUSTNR_TMPLAT_ID      CHAR(20)  NOT NULL ,
	QESTN_SN              NUMBER(10)  NULL ,
	QESTN_TY_CODE         CHAR(1)  NULL ,
	QESTN_CN              VARCHAR2(2500)  NULL ,
	MXMM_CHOISE_CO        NUMBER(5)  NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NOT NULL ,
	LAST_UPDT_PNTTM       DATE  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NOT NULL ,
CONSTRAINT  COMTNQUSTNRQESITM_PK PRIMARY KEY (QESTNR_ID,QUSTNR_QESITM_ID,QUSTNR_TMPLAT_ID),
CONSTRAINT  COMTNQUSTNRQESITM_FK1 FOREIGN KEY (QUSTNR_TMPLAT_ID,QESTNR_ID) REFERENCES COMTNQESTNRINFO(QUSTNR_TMPLAT_ID,QESTNR_ID)
);



CREATE INDEX COMTNQUSTNRQESITM_i02 ON COMTNQUSTNRQESITM
(QESTNR_ID  ASC,QUSTNR_TMPLAT_ID  ASC);



CREATE TABLE COMTNQUSTNRRSPNSRESULT
(
	QUSTNR_RSPNS_RESULT_ID  CHAR(20)  NOT NULL ,
	QESTNR_ID             CHAR(20)  NOT NULL ,
	QUSTNR_QESITM_ID      CHAR(20)  NOT NULL ,
	QUSTNR_TMPLAT_ID      CHAR(20)  NOT NULL ,
	RESPOND_ANSWER_CN     VARCHAR2(1000)  NULL ,
	ETC_ANSWER_CN         VARCHAR2(1000)  NULL ,
	RESPOND_NM            VARCHAR2(50)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	QUSTNR_IEM_ID         VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNQUSTNRRSPNSRESULT_PK PRIMARY KEY (QUSTNR_RSPNS_RESULT_ID,QESTNR_ID,QUSTNR_QESITM_ID,QUSTNR_TMPLAT_ID),
CONSTRAINT  COMTNQUSTNRRSPNSRESULT_FK1 FOREIGN KEY (QESTNR_ID,QUSTNR_QESITM_ID,QUSTNR_TMPLAT_ID) REFERENCES COMTNQUSTNRQESITM(QESTNR_ID,QUSTNR_QESITM_ID,QUSTNR_TMPLAT_ID)
);



CREATE INDEX COMTNQUSTNRRSPNSRESULT_i01 ON COMTNQUSTNRRSPNSRESULT
(QESTNR_ID  ASC,QUSTNR_QESITM_ID  ASC,QUSTNR_TMPLAT_ID  ASC);



CREATE TABLE COMTNADBKMANAGE
(
	ADBK_ID               CHAR(20)  NOT NULL ,
	ADBK_NM               VARCHAR2(50)  NOT NULL ,
	OTHBC_SCOPE           VARCHAR2(20)  NOT NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	WRTER_ID              VARCHAR2(20)  NULL ,
	TRGET_ORGNZT_ID       CHAR(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNADBKMANAGE_PK PRIMARY KEY (ADBK_ID)
);



CREATE TABLE COMTNADBK
(
	EMPLYR_ID             VARCHAR2(20) NULL ,
	NCRD_ID               CHAR(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	ADBK_CONSTNT_ID       CHAR(20)  NOT NULL ,
	NM                    VARCHAR2(50)  NULL ,
	EMAIL_ADRES           VARCHAR2(50)  NULL ,
	MBTLNUM               VARCHAR2(20)  NULL ,
	FXNUM                 VARCHAR2(20)  NULL ,
	OFFM_TELNO            VARCHAR2(20)  NULL ,
	HOUSE_TELNO           VARCHAR2(20)  NULL ,
	ADBK_ID               CHAR(20)  NOT NULL ,
CONSTRAINT  COMTNADBK_PK PRIMARY KEY (ADBK_CONSTNT_ID,ADBK_ID),
CONSTRAINT  COMTNADBK_FK1 FOREIGN KEY (ADBK_ID) REFERENCES COMTNADBKMANAGE(ADBK_ID) ON DELETE CASCADE
);



CREATE INDEX COMTNADBK_i01 ON COMTNADBK
(ADBK_ID  ASC);



CREATE TABLE COMTNQUSTNRIEM
(
	QUSTNR_TMPLAT_ID      CHAR(20)  NOT NULL ,
	QESTNR_ID             CHAR(20)  NOT NULL ,
	QUSTNR_QESITM_ID      CHAR(20)  NOT NULL ,
	QUSTNR_IEM_ID         VARCHAR2(20)  NOT NULL ,
	IEM_SN                NUMBER(5)  NULL ,
	IEM_CN                VARCHAR2(1000)  NULL ,
	ETC_ANSWER_AT         CHAR(1)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNQUSTNRIEM_PK PRIMARY KEY (QUSTNR_TMPLAT_ID,QESTNR_ID,QUSTNR_QESITM_ID,QUSTNR_IEM_ID),
CONSTRAINT  COMTNQUSTNRIEM_FK1 FOREIGN KEY (QESTNR_ID,QUSTNR_QESITM_ID,QUSTNR_TMPLAT_ID) REFERENCES COMTNQUSTNRQESITM(QESTNR_ID,QUSTNR_QESITM_ID,QUSTNR_TMPLAT_ID)
);



CREATE INDEX COMTNQUSTNRIEM_i01 ON COMTNQUSTNRIEM
(QUSTNR_QESITM_ID  ASC,QESTNR_ID  ASC,QUSTNR_TMPLAT_ID  ASC);



CREATE TABLE COMTNADMINISTRATIONWORD
(
	ADMINIST_WORD_ID      CHAR(20)  NOT NULL ,
	ADMINIST_WORD_NM      VARCHAR2(255)  NULL ,
	ADMINIST_WORD_ENG_NM  VARCHAR2(255)  NULL ,
	ADMINIST_WORD_ABRV_NM  VARCHAR2(255)  NULL ,
	THEMA_RELM            VARCHAR2(255)  NULL ,
	WORD_SE               VARCHAR2(255)  NULL ,
	RELATE_STD_WORD       VARCHAR2(255)  NULL ,
	ADMINIST_WORD_DFN     VARCHAR2(2500)  NULL ,
	ADMINIST_WORD_DC      VARCHAR2(4000)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNADMINISTRATIONWORD_PK PRIMARY KEY (ADMINIST_WORD_ID)
);



CREATE TABLE COMTNONLINEMANUAL
(
	ONLINE_MNL_ID         CHAR(20)  NOT NULL ,
	ONLINE_MNL_SE_CODE    CHAR(3)  NULL ,
	ONLINE_MNL_DFN        CLOB  NULL ,
	ONLINE_MNL_DC         CLOB  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	ONLINE_MNL_NM         VARCHAR2(255)  NULL ,
CONSTRAINT  COMTNONLINEMANUAL_PK PRIMARY KEY (ONLINE_MNL_ID)
);



CREATE TABLE COMTSUSERSUMMARY
(
	OCCRRNC_DE            CHAR(20)  NOT NULL ,
	STATS_SE              VARCHAR2(10)  NOT NULL ,
	DETAIL_STATS_SE       VARCHAR2(10)  NOT NULL ,
	USER_CO               NUMBER(10)  NULL ,
CONSTRAINT  COMTSUSERSUMMARY_PK PRIMARY KEY (OCCRRNC_DE,STATS_SE,DETAIL_STATS_SE)
);



CREATE TABLE COMTNFAQINFO
(
	FAQ_ID                CHAR(20)  NOT NULL ,
	QESTN_SJ              VARCHAR2(255)  NULL ,
	QESTN_CN              VARCHAR2(2500)  NULL ,
	ANSWER_CN             VARCHAR2(2500)  NULL ,
	RDCNT                 NUMBER(10)  NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NOT NULL ,
	LAST_UPDT_PNTTM       DATE  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NOT NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
	QNA_PROCESS_STTUS_CODE  CHAR(1)  NULL ,
CONSTRAINT  COMTNFAQINFO_PK PRIMARY KEY (FAQ_ID)
);





CREATE TABLE COMTNMTGINFO
(
	MTG_ID                CHAR(20)  NOT NULL ,
	MTG_NM                VARCHAR2(255)  NULL ,
	MTG_MTR_CN            VARCHAR2(1000)  NULL ,
	MTG_SN                NUMBER(10)  NULL ,
	MTG_CO                NUMBER(5)  NULL ,
	MTG_DE                CHAR(20)  NULL ,
	MTG_PLACE             VARCHAR2(255)  NULL ,
	MTG_BEGIN_TM          VARCHAR2(14)  NULL ,
	MTG_END_TM            VARCHAR2(14)  NULL ,
	CLSDR_MTG_AT          CHAR(1)  NULL ,
	READNG_BGNDE          CHAR(20)  NULL ,
	READNG_AT             CHAR(1)  NULL ,
	MTG_RESULT_CN         VARCHAR2(1000)  NULL ,
	MTG_RESULT_ENNC       CHAR(1)  NULL ,
	ETC_MATTER            VARCHAR2(1000)  NULL ,
	MNGT_DEPT_ID          VARCHAR2(20)  NULL ,
	MNAER_ID              VARCHAR2(20)  NULL ,
	MNAER_DEPT_ID         VARCHAR2(20)  NULL ,
	MTG_AT                CHAR(1)  NULL ,
	NONATDRN_CO           NUMBER(10)  NULL ,
	ATDRN_CO              NUMBER(10)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNMTGINFO_PK PRIMARY KEY (MTG_ID)
);



CREATE TABLE COMTNREPRTSTATS
(
	REPRT_ID              CHAR(6)  NOT NULL ,
	REPRT_NM              VARCHAR2(20)  NOT NULL ,
	REPRT_STTUS           CHAR(2)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NOT NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	REPRT_TY              CHAR(2)  NULL ,
CONSTRAINT  COMTNREPRTSTATS_PK PRIMARY KEY (REPRT_ID)
);



CREATE TABLE COMTNSMS
(
	SMS_ID                CHAR(20)  NOT NULL ,
	TRNSMIS_TELNO         VARCHAR2(12)  NOT NULL ,
	TRNSMIS_CN            VARCHAR2(80)  NOT NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NOT NULL ,
CONSTRAINT  COMTNSMS_PK PRIMARY KEY (SMS_ID)
);



CREATE TABLE COMTNSMSRECPTN
(
	SMS_ID                CHAR(20)  NOT NULL ,
	RECPTN_TELNO          VARCHAR2(12)  NOT NULL ,
	RESULT_CODE           VARCHAR2(4)  NULL ,
	RESULT_MSSAGE         VARCHAR2(4000)  NULL ,
CONSTRAINT  COMTNSMSRECPTN_PK PRIMARY KEY (SMS_ID,RECPTN_TELNO),
CONSTRAINT  COMTNSMSRECPTN_FK1 FOREIGN KEY (SMS_ID) REFERENCES COMTNSMS(SMS_ID)
);



CREATE INDEX COMTNSMSRECPTN_i01 ON COMTNSMSRECPTN
(SMS_ID  ASC);



CREATE TABLE COMTNCPYRHTINFO
(
	CPYRHT_ID             CHAR(20)  NOT NULL ,
	CPYRHT_PRTC_POLICY_CN  VARCHAR2(2500)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNCPYRHTINFO_PK PRIMARY KEY (CPYRHT_ID)
);



CREATE TABLE COMTNSCHDULINFO
(
	SCHDUL_ID             CHAR(20)  NOT NULL ,
	SCHDUL_SE             CHAR(1)  NULL ,
	SCHDUL_DEPT_ID        VARCHAR2(20)  NULL ,
	SCHDUL_KND_CODE       CHAR(1)  NULL ,
	SCHDUL_BGNDE          CHAR(20)  NULL ,
	SCHDUL_ENDDE          CHAR(20)  NULL ,
	SCHDUL_NM             VARCHAR2(255)  NULL ,
	SCHDUL_CN             VARCHAR2(2500)  NULL ,
	SCHDUL_PLACE          VARCHAR2(255)  NULL ,
	SCHDUL_IPCR_CODE      CHAR(1)  NULL ,
	SCHDUL_CHARGER_ID     VARCHAR2(20)  NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	REPTIT_SE_CODE        CHAR(1)  NULL ,
CONSTRAINT  COMTNSCHDULINFO_PK PRIMARY KEY (SCHDUL_ID)
);



CREATE TABLE COMTNDIARYINFO
(
	SCHDUL_ID             CHAR(20)  NOT NULL ,
	DIARY_ID              CHAR(20)  NOT NULL ,
	DIARY_PROGRSRT        NUMBER(3)  NULL ,
	DIARY_NM              VARCHAR2(255)  NULL ,
	DRCT_MATTER           VARCHAR2(2500)  NULL ,
	PARTCLR_MATTER        VARCHAR2(2500)  NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNDIARYINFO_PK PRIMARY KEY (SCHDUL_ID,DIARY_ID),
CONSTRAINT  COMTNDIARYINFO_FK1 FOREIGN KEY (SCHDUL_ID) REFERENCES COMTNSCHDULINFO(SCHDUL_ID)
);



CREATE INDEX COMTNDIARYINFO_i01 ON COMTNDIARYINFO
(SCHDUL_ID  ASC);



CREATE TABLE COMTNONLINEPOLLMANAGE
(
	POLL_ID               CHAR(20)  NOT NULL ,
	POLL_NM               VARCHAR2(255)  NULL ,
	POLL_BGNDE            CHAR(10)  NULL ,
	POLL_ENDDE            CHAR(10)  NULL ,
	POLL_KND              CHAR(3)  NULL ,
	POLL_DSUSE_ENNC       CHAR(1)  NULL ,
	POLL_ATMC_DSUSE_ENNC  CHAR(1)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNONLINEPOLLMANAGE_PK PRIMARY KEY (POLL_ID)
);



CREATE TABLE COMTNONLINEPOLLIEM
(
	POLL_IEM_NM           VARCHAR2(255)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	POLL_IEM_ID           CHAR(20)  NOT NULL ,
	POLL_ID               CHAR(20)  NOT NULL ,
CONSTRAINT  COMTNONLINEPOLLIEM_PK PRIMARY KEY (POLL_ID,POLL_IEM_ID),
CONSTRAINT  COMTNONLINEPOLLIEM_FK1 FOREIGN KEY (POLL_ID) REFERENCES COMTNONLINEPOLLMANAGE(POLL_ID)
);



CREATE INDEX COMTNONLINEPOLLIEM_i01 ON COMTNONLINEPOLLIEM
(POLL_ID  ASC);



CREATE TABLE COMTNONLINEPOLLRESULT
(
	POLL_RESULT_ID        CHAR(20)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	POLL_IEM_ID           CHAR(20)  NOT NULL ,
	POLL_ID               CHAR(20)  NOT NULL ,
CONSTRAINT  COMTNONLINEPOLLRESULT_PK PRIMARY KEY (POLL_RESULT_ID,POLL_IEM_ID,POLL_ID),
CONSTRAINT  COMTNONLINEPOLLRESULT_FK1 FOREIGN KEY (POLL_ID,POLL_IEM_ID) REFERENCES COMTNONLINEPOLLIEM(POLL_ID,POLL_IEM_ID)
);



CREATE INDEX COMTNONLINEPOLLRESULT_i01 ON COMTNONLINEPOLLRESULT
(POLL_IEM_ID  ASC,POLL_ID  ASC);



CREATE TABLE COMTNWORDDICARYINFO
(
	WORD_ID               CHAR(20)  NOT NULL ,
	WORD_NM               VARCHAR2(255)  NULL ,
	ENG_NM                VARCHAR2(60)  NULL ,
	WORD_DC               VARCHAR2(4000)  NULL ,
	SYNONM                VARCHAR2(100)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNWORDDICARYINFO_PK PRIMARY KEY (WORD_ID)
);



CREATE TABLE COMTNCNTCSERVICE
(
	INSTT_ID              VARCHAR2(20)  NOT NULL ,
	SYS_ID                VARCHAR2(20)  NOT NULL ,
	SVC_ID                VARCHAR2(20)  NOT NULL ,
	SVC_NM                VARCHAR2(255)  NULL ,
	REQUST_MSSAGE_ID      VARCHAR2(20)  NULL ,
	RSPNS_MSSAGE_ID       VARCHAR2(20)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	USE_AT                CHAR(1)  NULL ,
CONSTRAINT  COMTNCNTCSERVICE_PK PRIMARY KEY (INSTT_ID,SYS_ID,SVC_ID)
);



CREATE TABLE COMTNHPCMINFO
(
	HPCM_ID               CHAR(20)  NOT NULL ,
	HPCM_SE_CODE          CHAR(1)  NULL ,
	HPCM_DFN              VARCHAR2(1000)  NULL ,
	HPCM_DC               VARCHAR2(2500)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNHPCMINFO_PK PRIMARY KEY (HPCM_ID)
);



CREATE TABLE COMTNNEWSINFO
(
	NEWS_ID               CHAR(20)  NOT NULL ,
	NEWS_SJ               VARCHAR2(100)  NULL ,
	NEWS_CN               VARCHAR2(2500)  NULL ,
	NEWS_ORIGIN           VARCHAR2(250)  NULL ,
	NTCE_AT               CHAR(1)  NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NOT NULL ,
	LAST_UPDT_PNTTM       DATE  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NOT NULL ,
	NTCE_DE               CHAR(20)  NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
CONSTRAINT  COMTNNEWSINFO_PK PRIMARY KEY (NEWS_ID),
CONSTRAINT  COMTNNEWSINFO_FK1 FOREIGN KEY (ATCH_FILE_ID) REFERENCES COMTNFILE(ATCH_FILE_ID) ON DELETE CASCADE
);



CREATE INDEX COMTNNEWSINFO_i01 ON COMTNNEWSINFO
(ATCH_FILE_ID  ASC);



CREATE TABLE COMTNCNSLTLIST
(
	CNSLT_ID              CHAR(20)  NOT NULL ,
	CNSLT_SJ              VARCHAR2(255)  NULL ,
	OTHBC_AT              CHAR(1)  NULL ,
	EMAIL_ADRES           VARCHAR2(50)  NULL ,
	CNSLT_CN              VARCHAR2(2500)  NULL ,
	MANAGT_CN             VARCHAR2(2500)  NULL ,
	MANAGT_DE             CHAR(20)  NULL ,
	RDCNT                 NUMBER(10)  NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	AREA_NO               VARCHAR2(4)  NULL ,
	MIDDLE_TELNO          VARCHAR2(4)  NULL ,
	END_TELNO             VARCHAR2(4)  NULL ,
	FRST_MBTLNUM          VARCHAR2(4)  NULL ,
	MIDDLE_MBTLNUM        VARCHAR2(4)  NULL ,
	END_MBTLNUM           VARCHAR2(4)  NULL ,
	WRITNG_DE             CHAR(20)  NULL ,
	WRTER_NM              VARCHAR2(20)  NULL ,
	EMAIL_ANSWER_AT       CHAR(1)  NULL ,
	QNA_PROCESS_STTUS_CODE  CHAR(1)  NULL ,
	WRITNG_PASSWORD       VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNCNSLTLIST_PK PRIMARY KEY (CNSLT_ID)
);



CREATE TABLE COMTNMENUINFO
(
	MENU_NM               VARCHAR2(60)  NOT NULL ,
	PROGRM_FILE_NM        VARCHAR2(60)  NOT NULL ,
	MENU_NO               NUMBER(20)  NOT NULL ,
	UPPER_MENU_NO         NUMBER(20)  NULL ,
	MENU_ORDR             NUMBER(5)  NOT NULL ,
	MENU_DC               VARCHAR2(250)  NULL ,
	RELATE_IMAGE_PATH     VARCHAR2(100)  NULL ,
	RELATE_IMAGE_NM       VARCHAR2(60)  NULL ,
CONSTRAINT  COMTNMENUINFO_PK PRIMARY KEY (MENU_NO),
CONSTRAINT  COMTNMENUINFO_FK2 FOREIGN KEY (PROGRM_FILE_NM) REFERENCES COMTNPROGRMLIST(PROGRM_FILE_NM) ON DELETE CASCADE,
CONSTRAINT  COMTNMENUINFO_FK1 FOREIGN KEY (UPPER_MENU_NO) REFERENCES COMTNMENUINFO(MENU_NO) ON DELETE CASCADE
);






CREATE INDEX COMTNMENUINFO_i02 ON COMTNMENUINFO
(UPPER_MENU_NO  ASC);



CREATE TABLE COMTNSITEMAP
(
	MAPNG_CREAT_ID        VARCHAR2(30)  NOT NULL ,
	CREATR_ID             VARCHAR2(20)  NOT NULL ,
	MAPNG_FILE_NM         VARCHAR2(60)  NOT NULL ,
	MAPNG_FILE_PATH       VARCHAR2(100)  NOT NULL ,
CONSTRAINT  COMTNSITEMAP_PK PRIMARY KEY (MAPNG_CREAT_ID)
);



CREATE TABLE COMTNMENUCREATDTLS
(
	MENU_NO               NUMBER(20)  NOT NULL ,
	AUTHOR_CODE           VARCHAR2(30)  NOT NULL ,
	MAPNG_CREAT_ID        VARCHAR2(30)  NULL ,
CONSTRAINT  COMTNMENUCREATDTLS_PK PRIMARY KEY (MENU_NO,AUTHOR_CODE),
CONSTRAINT  COMTNMENUCREATDTLS_FK2 FOREIGN KEY (MENU_NO) REFERENCES COMTNMENUINFO(MENU_NO) ON DELETE CASCADE,
CONSTRAINT  COMTNMENUCREATDTLS_FK3 FOREIGN KEY (MAPNG_CREAT_ID) REFERENCES COMTNSITEMAP(MAPNG_CREAT_ID) ON DELETE CASCADE,
CONSTRAINT  COMTNMENUCREATDTLS_FK1 FOREIGN KEY (AUTHOR_CODE) REFERENCES COMTNAUTHORINFO(AUTHOR_CODE)
);



CREATE INDEX COMTNMENUCREATDTLS_i02 ON COMTNMENUCREATDTLS
(MENU_NO  ASC);



CREATE INDEX COMTNMENUCREATDTLS_i03 ON COMTNMENUCREATDTLS
(MAPNG_CREAT_ID  ASC);



CREATE INDEX COMTNMENUCREATDTLS_i04 ON COMTNMENUCREATDTLS
(AUTHOR_CODE  ASC);



CREATE TABLE COMTHEMPLYRINFOCHANGEDTLS
(
	EMPLYR_ID             VARCHAR2(20)  NOT NULL ,
	CHANGE_DE             CHAR(20)  NULL ,
	ORGNZT_ID             CHAR(20)  NULL ,
	GROUP_ID              CHAR(20)  NULL ,
	EMPL_NO               VARCHAR2(20)  NULL ,
	SEXDSTN_CODE          CHAR(1)  NULL ,
	BRTHDY                CHAR(20)  NULL ,
	FXNUM                 VARCHAR2(20)  NULL ,
	HOUSE_ADRES           VARCHAR2(100)  NULL ,
	HOUSE_END_TELNO       VARCHAR2(4)  NULL ,
	AREA_NO               VARCHAR2(4)  NULL ,
	DETAIL_ADRES          VARCHAR2(100)  NULL ,
	ZIP                   VARCHAR2(6)  NULL ,
	OFFM_TELNO            VARCHAR2(20)  NULL ,
	MBTLNUM               VARCHAR2(20)  NULL ,
	EMAIL_ADRES           VARCHAR2(50)  NULL ,
	HOUSE_MIDDLE_TELNO    VARCHAR2(4)  NULL ,
	PSTINST_CODE          CHAR(8)  NULL ,
	EMPLYR_STTUS_CODE     CHAR(1)  NULL ,
	ESNTL_ID              CHAR(20)  NULL ,
CONSTRAINT  COMTHEMPLYRINFOCHANGEDTLS_PK PRIMARY KEY (EMPLYR_ID,CHANGE_DE),
CONSTRAINT  COMTHEMPLYRINFOCHANGEDTLS_FK1 FOREIGN KEY (EMPLYR_ID) REFERENCES COMTNEMPLYRINFO(EMPLYR_ID)
);



CREATE INDEX COMTHEMPLYRINFOCHANGEDTLS_i01 ON COMTHEMPLYRINFOCHANGEDTLS
(EMPLYR_ID  ASC);



CREATE TABLE COMTNNTFCINFO
(
	NTCN_NO               NUMBER(20)  NOT NULL ,
	NTCN_SJ               VARCHAR2(60)  NOT NULL ,
	NTCN_CN               VARCHAR2(100)  NOT NULL ,
	NTCN_TM               VARCHAR2(14)  NOT NULL ,
	BH_NTCN_INTRVL        VARCHAR2(20)  NOT NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNNTFCINFO_PK PRIMARY KEY (NTCN_NO)
);



CREATE TABLE COMTNCNTCSYSTEM
(
	INSTT_ID              VARCHAR2(20)  NOT NULL ,
	SYS_ID                VARCHAR2(20)  NOT NULL ,
	SYS_NM                VARCHAR2(255)  NULL ,
	SYS_IP                VARCHAR2(23)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	USE_AT                CHAR(1)  NULL ,
CONSTRAINT  COMTNCNTCSYSTEM_PK PRIMARY KEY (INSTT_ID,SYS_ID)
);



CREATE TABLE COMTNBBSMASTEROPTN
(
	BBS_ID                CHAR(30)  NOT NULL ,
	ANSWER_AT             CHAR(1)  NOT NULL ,
	STSFDG_AT             CHAR(1)  NOT NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNBBSMASTEROPTN_PK PRIMARY KEY (BBS_ID)
);



CREATE TABLE COMTNANSWER
(
	NTT_ID                NUMBER(20)  NOT NULL ,
	BBS_ID                CHAR(30)  NOT NULL ,
	WRTER_ID              VARCHAR2(20)  NULL ,
	ANSWER                VARCHAR2(200)  NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	WRTER_NM              VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NOT NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	ANSWER_NO             NUMBER(20)  NOT NULL ,
CONSTRAINT  COMTNANSWER_PK PRIMARY KEY (NTT_ID,BBS_ID,ANSWER_NO),
CONSTRAINT  COMTNANSWER_FK1 FOREIGN KEY (BBS_ID) REFERENCES COMTNBBSMASTEROPTN(BBS_ID)
);



CREATE TABLE COMTNTRSMRCVLOG
(
	REQUST_ID             VARCHAR2(20)  NOT NULL ,
	OCCRRNC_DE            CHAR(20)  NULL ,
	TRSMRCV_SE_CODE       CHAR(3)  NULL ,
	CNTC_ID               CHAR(8)  NULL ,
	PROVD_INSTT_ID        CHAR(8)  NULL ,
	PROVD_SYS_ID          CHAR(8)  NULL ,
	PROVD_SVC_ID          CHAR(8)  NULL ,
	REQUST_INSTT_ID       CHAR(8)  NULL ,
	REQUST_SYS_ID         CHAR(8)  NULL ,
	REQUST_TRNSMIT_TM     VARCHAR2(14)  NULL ,
	REQUST_RECPTN_TM      VARCHAR2(14)  NULL ,
	RSPNS_TRNSMIT_TM      VARCHAR2(14)  NULL ,
	RSPNS_RECPTN_TM       VARCHAR2(14)  NULL ,
	RESULT_CODE           VARCHAR2(4)  NULL ,
	RESULT_MSSAGE         VARCHAR2(4000)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	RQESTER_ID            VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNTRSMRCVLOG_PK PRIMARY KEY (REQUST_ID)
);



CREATE TABLE COMTNDAMCALRES
(
	ORGNZT_ID             VARCHAR2(20)  NULL ,
	EXPERT_ID             CHAR(20)  NULL ,
	KNWLDG_TY_CODE        VARCHAR2(3)  NULL ,
	EMPLYR_ID             VARCHAR2(20)  NULL ,
	KNWLDG_NM             VARCHAR2(60)  NULL ,
	KNWLDG_CN             VARCHAR2(2500)  NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
	PARNTS_KNWLDG_ID      CHAR(20)  NULL ,
	ANSWER_DP             NUMBER(20)  NULL ,
	ANSWER_ORDR           NUMBER(20)  NULL ,
	ANSWER_GROUP_NO       NUMBER(20)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	KNWLDG_ID             CHAR(20)  NOT NULL ,
CONSTRAINT  COMTNDAMCALRES_PK PRIMARY KEY (KNWLDG_ID)
);



CREATE TABLE COMTNBACKUPRESULT
(
	BACKUP_RESULT_ID      VARCHAR2(20)  NOT NULL ,
	BACKUP_OPERT_ID       VARCHAR2(20)  NOT NULL ,
	BACKUP_FILE           VARCHAR2(255)  NULL ,
	STTUS                 VARCHAR2(2)  NULL ,
	ERROR_INFO            VARCHAR2(2000)  NULL ,
	EXECUT_BEGIN_TM       VARCHAR2(14)  NULL ,
	EXECUT_END_TM         VARCHAR2(14)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NOT NULL ,
CONSTRAINT  COMTNBACKUPRESULT_PK PRIMARY KEY (BACKUP_RESULT_ID)
);



CREATE TABLE COMTHTRSMRCVMNTRNGLOGINFO
(
	LOG_ID                CHAR(20)  NOT NULL ,
	CNTC_ID               CHAR(8)  NOT NULL ,
	TEST_CLASS_NM         VARCHAR2(255)  NULL ,
	MNGR_NM               VARCHAR2(60)  NULL ,
	MNGR_EMAIL_ADRES      VARCHAR2(50)  NULL ,
	MNTRNG_STTUS          CHAR(2)  NULL ,
	LOG_INFO              VARCHAR2(2000)  NULL ,
	CREAT_DT              DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NOT NULL ,
CONSTRAINT  COMTHTRSMRCVMNTRNGLOGINFO_PK PRIMARY KEY (LOG_ID)
);



CREATE TABLE COMTNSCRAP
(
	SCRAP_ID              CHAR(20)  NOT NULL ,
	NTT_ID                NUMBER(20)  NOT NULL ,
	BBS_ID                CHAR(30)  NOT NULL ,
	SCRAP_NM              VARCHAR2(100)  NOT NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNSCRAP_PK PRIMARY KEY (SCRAP_ID)
);



CREATE TABLE COMTNCNTCINSTT
(
	INSTT_ID              VARCHAR2(20)  NOT NULL ,
	INSTT_NM              VARCHAR2(100)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	USE_AT                CHAR(1)  NULL ,
CONSTRAINT  COMTNCNTCINSTT_PK PRIMARY KEY (INSTT_ID)
);



CREATE TABLE COMTHSYSHIST
(
	HIST_ID               CHAR(20)  NOT NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NOT NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	HIST_SE_CODE          CHAR(6)  NOT NULL ,
	HIST_CN               VARCHAR2(2500)  NOT NULL ,
	SYS_NM                VARCHAR2(255)  NOT NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
CONSTRAINT  COMTHSYSHIST_PK PRIMARY KEY (HIST_ID)
);



CREATE TABLE COMTNHTTPMON
(
	SYS_ID                VARCHAR2(20)  NOT NULL ,
	SITE_URL              VARCHAR2(100)  NULL ,
	WEBSVC_KND            VARCHAR2(10)  NULL ,
	HTTP_STTUS_CODE       VARCHAR2(3)  NULL ,
	CREAT_DT              DATE  NULL ,
	MNGR_NM               VARCHAR2(60)  NULL ,
	MNGR_EMAIL_ADRES      VARCHAR2(50)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	DELETE_AT			  CHAR(1)		NULL ,
CONSTRAINT  COMTNHTTPMON_PK PRIMARY KEY (SYS_ID)
);



CREATE TABLE COMTHHTTPMONLOGINFO
(
	SYS_ID                VARCHAR2(20)  NOT NULL ,
	SITE_URL              VARCHAR2(100)  NULL ,
	WEBSVC_KND            VARCHAR2(10)  NULL ,
	HTTP_STTUS_CODE       VARCHAR2(3)  NULL ,
	CREAT_DT              DATE  NULL ,
	LOG_INFO              VARCHAR2(2000)  NULL ,
	MNGR_NM               VARCHAR2(60)  NULL ,
	MNGR_EMAIL_ADRES      VARCHAR2(50)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LOG_ID                CHAR(20)  NOT NULL ,
CONSTRAINT  COMTHHTTPMONLOGINFO_PK PRIMARY KEY (SYS_ID,LOG_ID),
CONSTRAINT  COMTHHTTPMONLOGINFO_FK2 FOREIGN KEY (SYS_ID) REFERENCES COMTNHTTPMON(SYS_ID)
);



CREATE TABLE COMTHDBMNTRNGLOGINFO
(
	DATA_SOURC_NM         VARCHAR2(60)  NOT NULL ,
	SERVER_NM             VARCHAR2(60)  NULL ,
	DBMS_KND              VARCHAR2(2)  NULL ,
	CECK_SQL              VARCHAR2(250)  NULL ,
	MNGR_NM               VARCHAR2(60)  NULL ,
	MNGR_EMAIL_ADRES      VARCHAR2(50)  NULL ,
	MNTRNG_STTUS          CHAR(2)  NULL ,
	LOG_INFO              VARCHAR2(2000)  NULL ,
	CREAT_DT              DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	LAST_UPDT_PNTTM       DATE  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LOG_ID                CHAR(20)  NOT NULL ,
CONSTRAINT  COMTHDBMNTRNGLOGINFO_PK PRIMARY KEY (LOG_ID)
);



CREATE TABLE COMTHCONFMHISTORY
(
	CONFM_NO              NUMBER(8)  NOT NULL ,
	CONFM_RQESTER_ID      VARCHAR2(20)  NOT NULL ,
	CONFMER_ID            VARCHAR2(20)  NULL ,
	CONFM_DE              CHAR(20)  NULL ,
	CONFM_TY_CODE         CHAR(4)  NOT NULL ,
	CONFM_STTUS_CODE      CHAR(4)  NOT NULL ,
	OPERT_TY_CODE         CHAR(4)  NULL ,
	OPERT_ID              VARCHAR2(20)  NULL ,
	TRGET_JOB_TY_CODE     CHAR(3)  NULL ,
	TRGET_JOB_ID          CHAR(20)  NULL ,
CONSTRAINT  COMTHCONFMHISTORY_PK PRIMARY KEY (CONFM_NO)
);



CREATE TABLE COMTNDAMMAPTEAM
(
	ORGNZT_ID             VARCHAR2(20)  NOT NULL ,
	ORGNZT_NM             VARCHAR2(20)  NULL ,
	CL_DE                 CHAR(20)  NULL ,
	KNWLDG_URL            VARCHAR2(255)  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNDAMMAPTEAM_PK PRIMARY KEY (ORGNZT_ID)
);



CREATE TABLE COMTNTMPLATINFO
(
	TMPLAT_ID             CHAR(20)  NOT NULL ,
	TMPLAT_NM             VARCHAR2(255)  NULL ,
	TMPLAT_COURS          VARCHAR2(2000)  NULL ,
	USE_AT                CHAR(1)  NULL ,
	TMPLAT_SE_CODE        CHAR(6)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNTMPLATINFO_PK PRIMARY KEY (TMPLAT_ID)
);



CREATE TABLE COMTNINDVDLPGECNTNTS
(
	CNTNTS_ID             VARCHAR2(20)  NOT NULL ,
	CNTNTS_NM             VARCHAR2(100)  NOT NULL ,
	CNTC_URL              VARCHAR2(255)  NOT NULL ,
	CNTNTS_USE_AT         CHAR(1)  NOT NULL ,
	CNTNTS_LINK_URL       VARCHAR2(1000)  NULL ,
	CNTNTS_DC             VARCHAR2(250)  NULL ,
CONSTRAINT  COMTNINDVDLPGECNTNTS_PK PRIMARY KEY (CNTNTS_ID)
);



CREATE TABLE COMTNINDVDLPGEESTBS
(
	EMPLYR_ID             VARCHAR2(20)  NOT NULL ,
	UPEND_IMAGE           VARCHAR2(1024)  NULL ,
	TITLEBAR_COLOR        CHAR(7)  NULL ,
	ALGN_MTHD             CHAR(1)  NULL ,
	ALGN_CO               NUMBER(10)  NULL ,
CONSTRAINT  COMTNINDVDLPGEESTBS_PK PRIMARY KEY (EMPLYR_ID)
);



CREATE TABLE COMTNCNTNTSLIST
(
	CNTNTS_ID             VARCHAR2(20)  NOT NULL ,
	EMPLYR_ID             VARCHAR2(20)  NOT NULL ,
CONSTRAINT  COMTNCNTNTSLIST_PK PRIMARY KEY (CNTNTS_ID,EMPLYR_ID),
CONSTRAINT  COMTNCNTNTSLIST_FK1 FOREIGN KEY (CNTNTS_ID) REFERENCES COMTNINDVDLPGECNTNTS(CNTNTS_ID),
CONSTRAINT  COMTNCNTNTSLIST_FK2 FOREIGN KEY (EMPLYR_ID) REFERENCES COMTNINDVDLPGEESTBS(EMPLYR_ID)
);



CREATE INDEX COMTNCNTNTSLIST_i01 ON COMTNCNTNTSLIST
(CNTNTS_ID  ASC);



CREATE INDEX COMTNCNTNTSLIST_i02 ON COMTNCNTNTSLIST
(EMPLYR_ID  ASC);



CREATE TABLE COMTNCNTCMESSAGE
(
	CNTC_MSSAGE_ID        VARCHAR2(20)  NOT NULL ,
	CNTC_MSSAGE_NM        VARCHAR2(100)  NULL ,
	UPPER_CNTC_MSSAGE_ID  VARCHAR2(20)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	USE_AT                CHAR(1)  NULL ,
CONSTRAINT  COMTNCNTCMESSAGE_PK PRIMARY KEY (CNTC_MSSAGE_ID)
);



CREATE TABLE COMTNCNTCMESSAGEITEM
(
	CNTC_MSSAGE_ID        VARCHAR2(20)  NOT NULL ,
	IEM_ID                VARCHAR2(20)  NOT NULL ,
	IEM_NM                VARCHAR2(100)  NULL ,
	IEM_TY                VARCHAR2(50)  NULL ,
	IEM_LT                NUMBER(8)  NULL ,
	USE_AT                CHAR(1)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNCNTCMESSAGEITEM_PK PRIMARY KEY (CNTC_MSSAGE_ID,IEM_ID),
CONSTRAINT  COMTNCNTCMESSAGEITEM_FK1 FOREIGN KEY (CNTC_MSSAGE_ID) REFERENCES COMTNCNTCMESSAGE(CNTC_MSSAGE_ID)
);



CREATE INDEX COMTNCNTCMESSAGEITEM_i01 ON COMTNCNTCMESSAGEITEM
(CNTC_MSSAGE_ID  ASC);



CREATE TABLE COMTNBKMKMENUMANAGERESULT
(
	MENU_ID               NUMBER(20)  NOT NULL ,
	EMPLYR_ID             VARCHAR2(20)  NOT NULL ,
	MENU_NM               VARCHAR2(60)  NOT NULL ,
	PROGRM_STRE_PATH      VARCHAR2(100)  NOT NULL ,
CONSTRAINT  COMTNBKMKMENUMANAGERESULT_PK PRIMARY KEY (MENU_ID,EMPLYR_ID)
);



CREATE TABLE COMTNSYSTEMCNTC
(
	CNTC_ID               CHAR(8)  NOT NULL ,
	CNTC_NM               VARCHAR2(100)  NULL ,
	PROVD_INSTT_ID        CHAR(8)  NULL ,
	PROVD_SYS_ID          CHAR(8)  NULL ,
	PROVD_SVC_ID          CHAR(8)  NULL ,
	REQUST_INSTT_ID       CHAR(8)  NULL ,
	REQUST_SYS_ID         CHAR(8)  NULL ,
	CONFM_AT              CHAR(1)  NULL ,
	USE_AT                CHAR(1)  NULL ,
	VALID_BGNDE           CHAR(20)  NULL ,
	VALID_ENDDE           CHAR(20)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	CNTC_TY               VARCHAR2(60)  NULL ,
CONSTRAINT  COMTNSYSTEMCNTC_PK PRIMARY KEY (CNTC_ID)
);



CREATE TABLE COMTNINDVDLINFOPOLICY
(
	INDVDL_INFO_POLICY_ID  CHAR(20)  NOT NULL ,
	INDVDL_INFO_POLICY_CN  VARCHAR2(2500)  NULL ,
	INDVDL_INFO_POLICY_AGRE_AT  CHAR(1)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	INDVDL_INFO_POLICY_NM  VARCHAR2(255)  NULL ,
CONSTRAINT  COMTNINDVDLINFOPOLICY_PK PRIMARY KEY (INDVDL_INFO_POLICY_ID)
);



CREATE TABLE COMTNBNDTMANAGE
(
	BNDT_ID               VARCHAR2(20)  NOT NULL ,
	BNDT_DE               CHAR(8)  NOT NULL ,
	RM                    VARCHAR2(2500)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNBNDTMANAGE_PK PRIMARY KEY (BNDT_ID,BNDT_DE)
);



CREATE TABLE COMTNBNDTCECKMANAGE
(
	BNDT_CECK_SE          CHAR(2)  NOT NULL ,
	BNDT_CECK_CODE        VARCHAR2(10)  NOT NULL ,
	BNDT_CECK_CODE_NM     VARCHAR2(255)  NOT NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNBNDTCECKMANAGE_PK PRIMARY KEY (BNDT_CECK_CODE,BNDT_CECK_SE)
);



CREATE TABLE COMTNBNDTDIARY
(
	BNDT_ID               VARCHAR2(20)  NOT NULL ,
	BNDT_DE               CHAR(8)  NOT NULL ,
	BNDT_CECK_SE          CHAR(2)  NOT NULL ,
	BNDT_CECK_CODE        VARCHAR2(10)  NOT NULL ,
	CHCK_STTUS            VARCHAR2(1000)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNBNDTDIARY_PK PRIMARY KEY (BNDT_ID,BNDT_DE,BNDT_CECK_SE,BNDT_CECK_CODE),
CONSTRAINT  COMTNBNDTDIARY_FK2 FOREIGN KEY (BNDT_ID,BNDT_DE) REFERENCES COMTNBNDTMANAGE(BNDT_ID,BNDT_DE),
CONSTRAINT  COMTNBNDTDIARY_FK1 FOREIGN KEY (BNDT_CECK_CODE,BNDT_CECK_SE) REFERENCES COMTNBNDTCECKMANAGE(BNDT_CECK_CODE,BNDT_CECK_SE)
);



CREATE TABLE COMTNBATCHRESULT
(
	BATCH_RESULT_ID       VARCHAR2(20)  NOT NULL ,
	BATCH_SCHDUL_ID       VARCHAR2(20)  NOT NULL ,
	BATCH_OPERT_ID        VARCHAR2(20)  NOT NULL ,
	PARAMTR               VARCHAR2(250)  NULL ,
	STTUS                 VARCHAR2(2)  NULL ,
	ERROR_INFO            VARCHAR2(2000)  NULL ,
	EXECUT_BEGIN_TM       VARCHAR2(14)  NULL ,
	EXECUT_END_TM         VARCHAR2(14)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNBATCHRESULT_PK PRIMARY KEY (BATCH_RESULT_ID)
);



CREATE TABLE COMTNSTSFDG
(
	STSFDG_NO             NUMBER(20)  NOT NULL ,
	NTT_ID                NUMBER(20)  NOT NULL ,
	BBS_ID                CHAR(30)  NOT NULL ,
	WRTER_ID              VARCHAR2(20)  NULL ,
	WRTER_NM              VARCHAR2(20)  NULL ,
	PASSWORD              VARCHAR2(200)  NULL ,
	STSFDG                NUMBER(1)  NOT NULL ,
	STSFDG_CN             VARCHAR2(200)  NULL ,
	USE_AT                CHAR(1)  NOT NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNSTSFDG_PK PRIMARY KEY (STSFDG_NO)
);



CREATE TABLE COMTNBATCHOPERT
(
	BATCH_OPERT_ID        VARCHAR2(20)  NOT NULL ,
	BATCH_OPERT_NM        VARCHAR2(60)  NULL ,
	BATCH_PROGRM          VARCHAR2(255)  NULL ,
	PARAMTR               VARCHAR2(250)  NULL ,
	USE_AT                CHAR(1)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NOT NULL ,
CONSTRAINT  COMTNBATCHOPERT_PK PRIMARY KEY (BATCH_OPERT_ID)
);



CREATE TABLE COMTNFILESYSMNTRNG
(
	FILE_SYS_ID           CHAR(20)  NOT NULL ,
	FILE_SYS_NM           VARCHAR2(60)  NOT NULL ,
	FILE_SYS_MANAGE_NM    VARCHAR2(255)  NOT NULL ,
	FILE_SYS_SIZE         NUMBER(8)  NOT NULL ,
	FILE_SYS_THRHLD       NUMBER(8)  NOT NULL ,
	FILE_SYS_USGQTY       NUMBER(8)  NULL ,
	MNGR_NM               VARCHAR2(60)  NULL ,
	MNGR_EMAIL_ADRES      VARCHAR2(50)  NULL ,
	MNTRNG_STTUS          CHAR(2)  NULL ,
	CREAT_DT              DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNFILESYSMNTRNG_PK PRIMARY KEY (FILE_SYS_ID)
);



CREATE TABLE COMTNFILESYSMNTRNGLOGINFO
(
	FILE_SYS_ID           CHAR(20)  NOT NULL ,
	FILE_SYS_NM           VARCHAR2(60)  NOT NULL ,
	FILE_SYS_MANAGE_NM    VARCHAR2(255)  NOT NULL ,
	FILE_SYS_SIZE         NUMBER(8)  NOT NULL ,
	FILE_SYS_THRHLD       NUMBER(8)  NOT NULL ,
	FILE_SYS_USGQTY       NUMBER(8)  NULL ,
	MNTRNG_STTUS          CHAR(2)  NULL ,
	LOG_INFO              VARCHAR2(2000)  NULL ,
	CREAT_DT              DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LOG_ID                CHAR(20)  NOT NULL ,
CONSTRAINT  COMTNFILESYSMNTRNGLOGINFO_PK PRIMARY KEY (FILE_SYS_ID,LOG_ID),
CONSTRAINT  COMTNFILESYSMNTRNGLOGINFO_FK2 FOREIGN KEY (FILE_SYS_ID) REFERENCES COMTNFILESYSMNTRNG(FILE_SYS_ID)
);



CREATE TABLE COMTNBATCHSCHDUL
(
	BATCH_SCHDUL_ID       VARCHAR2(20)  NOT NULL ,
	BATCH_OPERT_ID        VARCHAR2(20)  NOT NULL ,
	EXECUT_CYCLE          VARCHAR2(2)  NULL ,
	EXECUT_SCHDUL_DE      CHAR(20)  NULL ,
	EXECUT_SCHDUL_HOUR    CHAR(2)  NULL ,
	EXECUT_SCHDUL_MNT     CHAR(2)  NULL ,
	EXECUT_SCHDUL_SECND   CHAR(2)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NOT NULL ,
CONSTRAINT  COMTNBATCHSCHDUL_PK PRIMARY KEY (BATCH_SCHDUL_ID)
);



CREATE TABLE COMTNBATCHSCHDULDFK
(
	BATCH_SCHDUL_ID       VARCHAR2(20)  NOT NULL ,
	EXECUT_SCHDUL_DFK_SE  CHAR(1)  NOT NULL ,
CONSTRAINT  COMTNBATCHSCHDULDFK_PK PRIMARY KEY (BATCH_SCHDUL_ID,EXECUT_SCHDUL_DFK_SE),
CONSTRAINT  COMTNBATCHSCHDULDFK_FK1 FOREIGN KEY (BATCH_SCHDUL_ID) REFERENCES COMTNBATCHSCHDUL(BATCH_SCHDUL_ID)
);



CREATE TABLE COMTNCTSNNMANAGE
(
	CTSNN_ID              VARCHAR2(20)  NOT NULL ,
	USER_ID               VARCHAR2(20)  NOT NULL ,
	CTSNN_CODE            CHAR(2)  NOT NULL ,
	REQST_DE              CHAR(20)  NOT NULL ,
	CTSNN_NM              VARCHAR2(255)  NOT NULL ,
	TRGTER_NM             VARCHAR2(20)  NOT NULL ,
	BRTHDY                CHAR(20)  NOT NULL ,
	OCCRRNC_DE            CHAR(20)  NOT NULL ,
	RELATE                CHAR(2)  NOT NULL ,
	RM                    VARCHAR2(2500)  NULL ,
	SANCTNER_ID           VARCHAR2(20)  NOT NULL ,
	CONFM_AT              CHAR(1)  NULL ,
	SANCTN_DT             DATE  NULL ,
	RETURN_RESN           VARCHAR2(1000)  NULL ,
	INFRML_SANCTN_ID      CHAR(20)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNCTSNNMANAGE_PK PRIMARY KEY (CTSNN_ID)
);



CREATE TABLE COMTCADMINISTCODERECPTNLOG
(
	OCCRRNC_DE            CHAR(20)  NOT NULL ,
	ADMINIST_ZONE_SE      CHAR(1)  NOT NULL ,
	ADMINIST_ZONE_CODE    VARCHAR2(10)  NOT NULL ,
	OPERT_SN              NUMBER(10)  NOT NULL ,
	CHANGE_SE_CODE        VARCHAR2(2)  NULL ,
	PROCESS_SE            VARCHAR2(2)  NULL ,
	ADMINIST_ZONE_NM      VARCHAR2(60)  NULL ,
	LOWEST_ADMINIST_ZONE_NM  VARCHAR2(60)  NULL ,
	CTPRVN_CODE           VARCHAR2(2)  NULL ,
	SIGNGU_CODE           VARCHAR2(3)  NULL ,
	EMD_CODE              VARCHAR2(3)  NULL ,
	LI_CODE               VARCHAR2(2)  NULL ,
	CREAT_DE              CHAR(20)  NULL ,
	ABL_DE                CHAR(20)  NULL ,
	ABL_ENNC              CHAR(1)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTCADMINISTCODERECPTNLOG_PK PRIMARY KEY (OCCRRNC_DE,ADMINIST_ZONE_SE,ADMINIST_ZONE_CODE,OPERT_SN)
);



CREATE TABLE COMTNTROBLINFO
(
	TROBL_ID              CHAR(20)  NOT NULL ,
	TROBL_NM              VARCHAR2(60)  NULL ,
	TROBL_KND             CHAR(2)  NULL ,
	TROBL_DC              VARCHAR2(2000)  NULL ,
	TROBL_OCCRRNC_TIME    VARCHAR2(14)  NULL ,
	TROBL_RQESTER_NM      VARCHAR2(60)  NULL ,
	TROBL_REQUST_TIME     VARCHAR2(14)  NULL ,
	TROBL_PROCESS_RESULT  VARCHAR2(2000)  NULL ,
	TROBL_OPETR_NM        VARCHAR2(60)  NULL ,
	TROBL_PROCESS_TIME    VARCHAR2(14)  NULL ,
	PROCESS_STTUS         CHAR(1)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNTROBLINFO_PK PRIMARY KEY (TROBL_ID)
);



CREATE TABLE COMTNDAMKNOIFM
(
	KNWLDG_ID             CHAR(20)  NOT NULL ,
	KNWLDG_TY_CODE        VARCHAR2(3)  NULL ,
	ORGNZT_ID             VARCHAR2(20)  NULL ,
	EXPERT_ID             CHAR(20)  NULL ,
	EMPLYR_ID             VARCHAR2(20)  NULL ,
	KNWLDG_NM             VARCHAR2(60)  NULL ,
	KNWLDG_CN             VARCHAR2(2500)  NULL ,
	KWRD                  VARCHAR2(100)  NULL ,
	OTHBC_AT              CHAR(1)  NULL ,
	KNWLDG_EVL            CHAR(1)  NULL ,
	COLCT_DE              CHAR(20)  NULL ,
	EVL_DE                CHAR(20)  NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	DSUSE_DE              CHAR(20)  NULL ,
CONSTRAINT  COMTNDAMKNOIFM_PK PRIMARY KEY (KNWLDG_ID)
);



CREATE TABLE COMTNDAMMAPKNO
(
	KNWLDG_TY_CODE        VARCHAR2(3)  NOT NULL ,
	ORGNZT_ID             VARCHAR2(20)  NULL ,
	EXPERT_ID             CHAR(20)  NULL ,
	KNWLDG_TY_NM          VARCHAR2(60)  NULL ,
	CL_DE                 CHAR(20)  NULL ,
	KNWLDG_URL            VARCHAR2(255)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNDAMMAPKNO_PK PRIMARY KEY (KNWLDG_TY_CODE)
);



CREATE TABLE COMTNDAMPRO
(
	EXPERT_ID             CHAR(20)  NOT NULL ,
	KNWLDG_TY_CODE        VARCHAR2(3)  NOT NULL ,
	EXPERT_GRAD           CHAR(1)  NOT NULL ,
	EXPERT_CONFM_DE       CHAR(20)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	EXPERT_DC             VARCHAR2(2000)  NULL ,
CONSTRAINT  COMTNDAMPRO_PK PRIMARY KEY (EXPERT_ID,KNWLDG_TY_CODE,EXPERT_GRAD),
CONSTRAINT  COMTNDAMPRO_FK1 FOREIGN KEY (KNWLDG_TY_CODE) REFERENCES COMTNDAMMAPKNO(KNWLDG_TY_CODE)
);



CREATE TABLE COMTNINFRMLSANCTN
(
	INFRML_SANCTN_ID      CHAR(20)  NOT NULL ,
	JOB_SE_CODE           CHAR(3)  NOT NULL ,
	APPLCNT_ID            VARCHAR2(20)  NOT NULL ,
	REQST_DE              CHAR(20)  NOT NULL ,
	SANCTNER_ID           VARCHAR2(20)  NOT NULL ,
	CONFM_AT              CHAR(1)  NOT NULL ,
	SANCTN_DT             DATE  NULL ,
	RETURN_RESN           VARCHAR2(1000)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNINFRMLSANCTN_PK PRIMARY KEY (INFRML_SANCTN_ID)
);



CREATE TABLE COMTNDBMNTRNG
(
	DATA_SOURC_NM         VARCHAR2(60)  NOT NULL ,
	SERVER_NM             VARCHAR2(60)  NULL ,
	DBMS_KND              VARCHAR2(2)  NULL ,
	CECK_SQL              VARCHAR2(250)  NULL ,
	MNGR_NM               VARCHAR2(60)  NULL ,
	MNGR_EMAIL_ADRES      VARCHAR2(50)  NULL ,
	MNTRNG_STTUS          CHAR(2)  NULL ,
	CREAT_DT              DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NOT NULL ,
CONSTRAINT  COMTNDBMNTRNG_PK PRIMARY KEY (DATA_SOURC_NM)
);



CREATE TABLE COMTNTRSMRCVMNTRNG
(
	CNTC_ID               CHAR(8)  NOT NULL ,
	TEST_CLASS_NM         VARCHAR2(255)  NULL ,
	MNGR_NM               VARCHAR2(60)  NULL ,
	MNGR_EMAIL_ADRES      VARCHAR2(50)  NULL ,
	MNTRNG_STTUS          CHAR(2)  NULL ,
	CREAT_DT              DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NOT NULL ,
CONSTRAINT  COMTNTRSMRCVMNTRNG_PK PRIMARY KEY (CNTC_ID)
);



CREATE TABLE COMTNDEPTJOB
(
	DEPT_JOB_ID           CHAR(20)  NOT NULL ,
	DEPT_JOBBX_ID         CHAR(6)  NOT NULL ,
	DEPT_JOB_NM           VARCHAR2(255)  NOT NULL ,
	DEPT_JOB_CN           VARCHAR2(2500)  NOT NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
	CHARGER_ID            VARCHAR2(20)  NOT NULL ,
	PRIORT                CHAR(1)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NOT NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNDEPTJOB_PK PRIMARY KEY (DEPT_JOB_ID)
);



CREATE TABLE COMTNLEADERSCHDUL
(
	SCHDUL_ID             CHAR(20)  NOT NULL ,
	SCHDUL_SE             CHAR(1)  NULL ,
	SCHDUL_NM             VARCHAR2(255)  NOT NULL ,
	SCHDUL_CN             VARCHAR2(2500)  NOT NULL ,
	SCHDUL_PLACE          VARCHAR2(255)  NULL ,
	LEADER_ID             VARCHAR2(20)  NOT NULL ,
	REPTIT_SE_CODE        CHAR(1)  NULL ,
	SCHDUL_BGNDE          CHAR(20)  NULL ,
	SCHDUL_ENDDE          CHAR(20)  NULL ,
	SCHDUL_CHARGER_ID     VARCHAR2(20)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NOT NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNLEADERSCHDUL_PK PRIMARY KEY (SCHDUL_ID)
);



CREATE TABLE COMTNLEADERSCHDULDE
(
	SCHDUL_ID             CHAR(20)  NOT NULL ,
	SCHDUL_DE             CHAR(8)  NOT NULL ,
CONSTRAINT  COMTNLEADERSCHDULDE_PK PRIMARY KEY (SCHDUL_ID,SCHDUL_DE),
CONSTRAINT  COMTNLEADERSCHDULDE_FK1 FOREIGN KEY (SCHDUL_ID) REFERENCES COMTNLEADERSCHDUL(SCHDUL_ID)
);

CREATE TABLE COMTNLEADERSTTUS
(
	LEADER_ID             VARCHAR2(20)  NOT NULL ,
	LEADER_STTUS          CHAR(1)  NOT NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNLEADERSTTUS_PK PRIMARY KEY (LEADER_ID)
);

CREATE TABLE COMTNDEPTJOBBX
(
	DEPT_JOBBX_ID         CHAR(6)  NOT NULL ,
	DEPT_JOBBX_NM         VARCHAR2(255)  NOT NULL ,
	DEPT_ID               VARCHAR2(20)  NOT NULL ,
	INDICT_ORDR           NUMBER(6)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NOT NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNDEPTJOBBX_PK PRIMARY KEY (DEPT_JOBBX_ID)
);



CREATE TABLE COMTNDTAUSESTATS
(
	DTA_USE_STATS_ID      CHAR(20)  NOT NULL ,
	BBS_ID                CHAR(30)  NOT NULL ,
	NTT_ID                NUMBER(20)  NOT NULL ,
	ATCH_FILE_ID          CHAR(20)  NOT NULL ,
	FILE_SN               NUMBER(10)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNDTAUSESTATS_PK PRIMARY KEY (DTA_USE_STATS_ID)
);



CREATE TABLE COMTNINSTTCODE
(
	INSTT_CODE            CHAR(7)  NOT NULL ,
	ALL_INSTT_NM          VARCHAR2(255)  NULL ,
	LOWEST_INSTT_NM       VARCHAR2(100)  NULL ,
	INSTT_ABRV_NM         VARCHAR2(50)  NULL ,
	ODR                   CHAR(1)  NULL ,
	ORD                   CHAR(3)  NULL ,
	INSTT_ODR             CHAR(2)  NULL ,
	UPPER_INSTT_CODE      CHAR(7)  NULL ,
	BEST_INSTT_CODE       CHAR(7)  NULL ,
	REPRSNT_INSTT_CODE    CHAR(7)  NULL ,
	INSTT_TY_LCLAS        CHAR(2)  NULL ,
	INSTT_TY_MLSFC        CHAR(2)  NULL ,
	INSTT_TY_SCLAS        CHAR(2)  NULL ,
	TELNO                 VARCHAR2(20)  NULL ,
	FXNUM                 VARCHAR2(20)  NULL ,
	CREAT_DE              CHAR(20)  NULL ,
	ABL_DE                CHAR(20)  NULL ,
	ABL_ENNC              CHAR(1)  NULL ,
	CHANGE_DE             CHAR(20)  NULL ,
	CHANGE_TIME           VARCHAR2(6)  NULL ,
	BSIS_DE               CHAR(20)  NULL ,
	SORT_ORDR             NUMBER(8)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNINSTTCODE_PK PRIMARY KEY (INSTT_CODE)
);



CREATE TABLE COMTNINSTTCODERECPTNLOG
(
	OCCRRNC_DE            CHAR(20)  NOT NULL ,
	INSTT_CODE            CHAR(7)  NOT NULL ,
	OPERT_SN              NUMBER(10)  NOT NULL ,
	CHANGE_SE_CODE        VARCHAR2(2)  NULL ,
	PROCESS_SE            VARCHAR2(2)  NULL ,
	ETC_CODE              CHAR(2)  NULL ,
	ALL_INSTT_NM          VARCHAR2(255)  NULL ,
	LOWEST_INSTT_NM       VARCHAR2(100)  NULL ,
	INSTT_ABRV_NM         VARCHAR2(50)  NULL ,
	ODR                   CHAR(1)  NULL ,
	ORD                   CHAR(3)  NULL ,
	INSTT_ODR             CHAR(2)  NULL ,
	UPPER_INSTT_CODE      CHAR(7)  NULL ,
	BEST_INSTT_CODE       CHAR(7)  NULL ,
	REPRSNT_INSTT_CODE    CHAR(7)  NULL ,
	INSTT_TY_LCLAS        CHAR(2)  NULL ,
	INSTT_TY_MLSFC        CHAR(2)  NULL ,
	INSTT_TY_SCLAS        CHAR(2)  NULL ,
	TELNO                 VARCHAR2(20)  NULL ,
	FXNUM                 VARCHAR2(20)  NULL ,
	CREAT_DE              CHAR(20)  NULL ,
	ABL_DE                CHAR(20)  NULL ,
	ABL_ENNC              CHAR(1)  NULL ,
	CHANGE_DE             CHAR(20)  NULL ,
	CHANGE_TIME           VARCHAR2(6)  NULL ,
	BSIS_DE               CHAR(20)  NULL ,
	SORT_ORDR             NUMBER(8)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNINSTTCODERECPTNLOG_PK PRIMARY KEY (OCCRRNC_DE,INSTT_CODE,OPERT_SN)
);



CREATE TABLE COMTNINDVDLYRYCMANAGE
(
	OCCRRNC_YEAR          CHAR(4)  NOT NULL ,
	YRYC_OCCRRNC_CO       NUMBER(5,1)  NULL ,
	USE_YRYC_CO           NUMBER(5,1)  NULL ,
	REMNDR_YRYC_CO        NUMBER(5,1)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	USER_ID               VARCHAR2(20)  NOT NULL ,
CONSTRAINT  COMTNINDVDLYRYCMANAGE_PK PRIMARY KEY (OCCRRNC_YEAR,USER_ID)
);



CREATE TABLE COMTNNTWRKSVCMNTRNG
(
	SYS_IP                VARCHAR2(23)  NOT NULL ,
	SYS_PORT              NUMBER(5)  NOT NULL ,
	SYS_NM                VARCHAR2(255)  NOT NULL ,
	MNGR_NM               VARCHAR2(60)  NULL ,
	MNGR_EMAIL_ADRES      VARCHAR2(50)  NULL ,
	MNTRNG_STTUS          CHAR(2)  NULL ,
	CREAT_DT              DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NOT NULL ,
	LAST_UPDT_PNTTM       DATE  NOT NULL ,
CONSTRAINT  COMTNNTWRKSVCMNTRNG_PK PRIMARY KEY (SYS_IP,SYS_PORT)
);



CREATE TABLE COMTNNTWRKSVCMNTRNGLOGINFO
(
	SYS_IP                VARCHAR2(23)  NOT NULL ,
	SYS_PORT              NUMBER(5)  NOT NULL ,
	SYS_NM                VARCHAR2(255)  NOT NULL ,
	MNTRNG_STTUS          CHAR(2)  NULL ,
	LOG_INFO              VARCHAR2(2000)  NULL ,
	CREAT_DT              DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NOT NULL ,
	LAST_UPDT_PNTTM       DATE  NOT NULL ,
	LOG_ID                CHAR(20)  NOT NULL ,
CONSTRAINT  COMTNNTWRKSVCMNTRNGLOGINFO_PK PRIMARY KEY (SYS_IP,SYS_PORT,LOG_ID),
CONSTRAINT  COMTNNTWRKSVCMNTRNGLOGINFO_FK2 FOREIGN KEY (SYS_IP,SYS_PORT) REFERENCES COMTNNTWRKSVCMNTRNG(SYS_IP,SYS_PORT)
);



CREATE TABLE COMTNSERVEREQPMNINFO
(
	SERVER_EQPMN_ID       VARCHAR2(20)  NOT NULL ,
	SERVER_EQPMN_NM       VARCHAR2(60)  NULL ,
	SERVER_EQPMN_IP       VARCHAR2(23)  NULL ,
	SERVER_EQPMN_MNGR     VARCHAR2(60)  NULL ,
	MNGR_EMAIL_ADRES      VARCHAR2(50)  NULL ,
	OPERSYSM_INFO         VARCHAR2(2000)  NULL ,
	CPU_INFO              VARCHAR2(2000)  NULL ,
	MORY_INFO             VARCHAR2(2000)  NULL ,
	HDDISK                CHAR(18)  NULL ,
	ETC_INFO              VARCHAR2(250)  NULL ,
	RGSDE                 DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNSERVEREQPMNINFO_PK PRIMARY KEY (SERVER_EQPMN_ID)
);



CREATE TABLE COMTNSYNCHRNSERVERINFO
(
	SERVER_ID             CHAR(20)  NOT NULL ,
	SERVER_NM             VARCHAR2(60)  NULL ,
	SERVER_IP             VARCHAR2(23)  NULL ,
	SERVER_PORT           VARCHAR2(10)  NULL ,
	FTP_ID                VARCHAR2(20)  NULL ,
	FTP_PASSWORD          VARCHAR2(20)  NULL ,
	SYNCHRN_LC            VARCHAR2(255)  NULL ,
	REFLCT_AT             CHAR(1)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNSYNCHRNSERVERINFO_PK PRIMARY KEY (SERVER_ID)
);



CREATE TABLE COMTNSERVERINFO
(
	SERVER_ID             CHAR(20)  NOT NULL ,
	SERVER_NM             VARCHAR2(60)  NULL ,
	SERVER_KND            CHAR(2)  NULL ,
	RGSDE                 DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNSERVERINFO_PK PRIMARY KEY (SERVER_ID)
);



CREATE TABLE COMTNSERVEREQPMNRELATE
(
	SERVER_EQPMN_ID       VARCHAR2(20)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	SERVER_ID             CHAR(20)  NOT NULL ,
CONSTRAINT  COMTNSERVEREQPMNRELATE_PK PRIMARY KEY (SERVER_EQPMN_ID,SERVER_ID),
CONSTRAINT  COMTNSERVEREQPMNRELATE_FK2 FOREIGN KEY (SERVER_EQPMN_ID) REFERENCES COMTNSERVEREQPMNINFO(SERVER_EQPMN_ID),
CONSTRAINT  COMTNSERVEREQPMNRELATE_FK1 FOREIGN KEY (SERVER_ID) REFERENCES COMTNSERVERINFO(SERVER_ID)
);



CREATE TABLE COMTNSERVERRESRCELOGINFO
(
	SERVER_EQPMN_ID       VARCHAR2(20)  NOT NULL ,
	CPU_USE_RT            NUMBER(3)  NULL ,
	MORY_USE_RT           NUMBER(3)  NULL ,
	SVC_STTUS             CHAR(2)  NULL ,
	LOG_INFO              VARCHAR2(2000)  NULL ,
	CREAT_DT              DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	SERVER_ID             CHAR(20)  NOT NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LOG_ID                CHAR(20)  NOT NULL ,
CONSTRAINT  COMTNSERVERRESRCELOGINFO_PK PRIMARY KEY (SERVER_EQPMN_ID,SERVER_ID,LOG_ID),
CONSTRAINT  COMTNSERVERRESRCELOGINFO_FK1 FOREIGN KEY (SERVER_EQPMN_ID,SERVER_ID) REFERENCES COMTNSERVEREQPMNRELATE(SERVER_EQPMN_ID,SERVER_ID)
);



CREATE TABLE COMTNVCATNMANAGE
(
	APPLCNT_ID            VARCHAR2(20)  NOT NULL ,
	VCATN_SE              CHAR(2)  NOT NULL ,
	BGNDE                 CHAR(8)  NOT NULL ,
	ENDDE                 CHAR(8)  NOT NULL ,
	VCATN_RESN            VARCHAR2(200)  NOT NULL ,
	REQST_DE              CHAR(20)  NOT NULL ,
	OCCRRNC_YEAR          CHAR(4)  NULL ,
	SANCTNER_ID           VARCHAR2(20)  NULL ,
	CONFM_AT              CHAR(1)  NULL ,
	SANCTN_DT             DATE  NULL ,
	RETURN_RESN           VARCHAR2(1000)  NULL ,
	INFRML_SANCTN_ID      CHAR(20)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	NOON_SE               CHAR(1)  NULL ,
CONSTRAINT  COMTNVCATNMANAGE_PK PRIMARY KEY (APPLCNT_ID,VCATN_SE,BGNDE,ENDDE)
);



CREATE TABLE COMTNMEMOTODO
(
	TODO_ID               CHAR(20)  NOT NULL ,
	TODO_SJ               VARCHAR2(255)  NOT NULL ,
	TODO_BEGIN_TIME       VARCHAR2(14)  NOT NULL ,
	TODO_END_TIME         VARCHAR2(14)  NOT NULL ,
	WRTER_ID              VARCHAR2(20)  NOT NULL ,
	TODO_CN               VARCHAR2(2500)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NOT NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNMEMOTODO_PK PRIMARY KEY (TODO_ID)
);



CREATE TABLE COMTNNOTE
(
	NOTE_ID               CHAR(20)  NOT NULL ,
	NOTE_SJ               VARCHAR2(255)  NULL ,
	NOTE_CN               VARCHAR2(4000)  NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNNOTE_PK PRIMARY KEY (NOTE_ID)
);



CREATE TABLE COMTNNOTETRNSMIT
(
	NOTE_ID               CHAR(20)  NOT NULL ,
	NOTE_TRNSMIT_ID       CHAR(20)  NOT NULL ,
	TRNSMITER_ID          CHAR(20)  NULL ,
	DELETE_AT             CHAR(8)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNNOTETRNSMIT_PK PRIMARY KEY (NOTE_ID,NOTE_TRNSMIT_ID),
CONSTRAINT  COMTNNOTETRNSMIT_FK1 FOREIGN KEY (NOTE_ID) REFERENCES COMTNNOTE(NOTE_ID)
);



CREATE INDEX COMTNNOTETRNSMIT_i01 ON COMTNNOTETRNSMIT
(NOTE_ID  ASC);



CREATE TABLE COMTNNOTERECPTN
(
	NOTE_ID               CHAR(20)  NOT NULL ,
	NOTE_TRNSMIT_ID       CHAR(20)  NOT NULL ,
	NOTE_RECPTN_ID        CHAR(20)  NOT NULL ,
	RCVER_ID              CHAR(20)  NULL ,
	OPEN_YN               CHAR(1)  NULL ,
	RECPTN_SE             CHAR(1)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNNOTERECPTN_PK PRIMARY KEY (NOTE_ID,NOTE_TRNSMIT_ID,NOTE_RECPTN_ID),
CONSTRAINT  COMTNNOTERECPTN_FK1 FOREIGN KEY (NOTE_ID,NOTE_TRNSMIT_ID) REFERENCES COMTNNOTETRNSMIT(NOTE_ID,NOTE_TRNSMIT_ID)
);



CREATE INDEX COMTNNOTERECPTN_i01 ON COMTNNOTERECPTN
(NOTE_ID  ASC,NOTE_TRNSMIT_ID  ASC);



CREATE TABLE COMTNEVENTMANAGE
(
	EVENT_ID              CHAR(20)  NOT NULL ,
	EVENT_SE              VARCHAR2(2)  NOT NULL ,
	EVENT_NM              VARCHAR2(60)  NOT NULL ,
	EVENT_PURPS           VARCHAR2(200)  NOT NULL ,
	EVENT_BGNDE           CHAR(20)  NOT NULL ,
	EVENT_ENDDE           CHAR(20)  NOT NULL ,
	EVENT_AUSPC_INSTT_NM  VARCHAR2(60)  NULL ,
	EVENT_MNGT_INSTT_NM   VARCHAR2(60)  NULL ,
	EVENT_PLACE           VARCHAR2(200)  NOT NULL ,
	EVENT_CN              VARCHAR2(1000)  NULL ,
	CT_OCCRRNC_AT         CHAR(1)  NULL ,
	PARTCPT_CT            NUMBER(16)  NULL ,
	PSNCPA                NUMBER(10)  NOT NULL ,
	REFRN_URL             VARCHAR2(1024)  NULL ,
	RCEPT_BGNDE           CHAR(20)  NOT NULL ,
	RCEPT_ENDDE           CHAR(20)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNEVENTMANAGE_PK PRIMARY KEY (EVENT_ID)
);



CREATE TABLE COMTNEVENTATDRN
(
	APPLCNT_ID            VARCHAR2(20)  NOT NULL ,
	EVENT_ID              CHAR(20)  NOT NULL ,
	REQST_DE              CHAR(20)  NOT NULL ,
	SANCTNER_ID           VARCHAR2(20)  NOT NULL ,
	CONFM_AT              CHAR(1)  NULL ,
	SANCTN_DT             DATE  NULL ,
	RETURN_RESN           VARCHAR2(1000)  NULL ,
	INFRML_SANCTN_ID      CHAR(20)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNEVENTATDRN_PK PRIMARY KEY (APPLCNT_ID,EVENT_ID),
CONSTRAINT  COMTNEVENTATDRN_FK1 FOREIGN KEY (EVENT_ID) REFERENCES COMTNEVENTMANAGE(EVENT_ID)
);



CREATE INDEX COMTNEVENTATDRN_i01 ON COMTNEVENTATDRN
(EVENT_ID  ASC);



CREATE TABLE IMGTEMP
(
	ORGNZT_CODE           VARCHAR2(10)  NOT NULL ,
	ERNCSL_SE             VARCHAR2(2)  NOT NULL ,
	IMAGE_INFO            BLOB  NOT NULL ,
	IMAGE_TY              VARCHAR2(20)  NULL ,
CONSTRAINT  IMGTEMP_PK PRIMARY KEY (ORGNZT_CODE,ERNCSL_SE)
);



CREATE TABLE IDS
(
	IDGEN_TABLE_NM        VARCHAR2(20)  NOT NULL ,
	IDGEN_NEXT_ID         NUMBER(30)  NOT NULL ,
CONSTRAINT  IDS_PK PRIMARY KEY (IDGEN_TABLE_NM)
);



CREATE TABLE COMTNWIKMNTHNGREPRT
(
	REPRT_ID              CHAR(6)  NOT NULL ,
	REPRT_SE              CHAR(1)  NOT NULL ,
	REPRT_SJ              VARCHAR2(255)  NOT NULL ,
	REPORT_DE             CHAR(20)  NOT NULL ,
	WRTER_ID              VARCHAR2(20)  NOT NULL ,
	REPORTR_ID            VARCHAR2(20)  NOT NULL ,
	REPORT_BGNDE          CHAR(20)  NOT NULL ,
	REPORT_ENDDE          CHAR(20)  NOT NULL ,
	THSWIK_REPORT_CN      CLOB  NOT NULL ,
	NEXTWIK_REPORT_CN     CLOB  NOT NULL ,
	PARTCLR_MATTER        VARCHAR2(2500)  NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
	CONFM_DT              VARCHAR2(14)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NOT NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNWIKMNTHNGREPRT_PK PRIMARY KEY (REPRT_ID)
);



CREATE TABLE COMTNTWITTER
(
	USER_ID               VARCHAR2(20)  NOT NULL ,
	CNSMR_KEY             VARCHAR2(50)  NOT NULL ,
	CNSMR_SECRET          VARCHAR2(50)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNTWITTER_PK PRIMARY KEY (USER_ID)
);



CREATE TABLE COMTNWIKIBKMK
(
	WIKI_BKMK_ID          CHAR(20)  NOT NULL ,
	USER_ID               VARCHAR2(20)  NOT NULL ,
	WIKI_BKMK_NM          VARCHAR2(1000)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNWIKIBKMK_PK PRIMARY KEY (WIKI_BKMK_ID,USER_ID)
);



CREATE TABLE COMTNRWARDMANAGE
(
	RWARD_ID              CHAR(20)  NOT NULL ,
	RWARDWNR_ID           VARCHAR2(20)  NOT NULL ,
	RWARD_CODE            CHAR(2)  NOT NULL ,
	RWARD_DE              CHAR(20)  NOT NULL ,
	RWARD_NM              VARCHAR2(255)  NOT NULL ,
	PBLEN_CN              VARCHAR2(1000)  NULL ,
	SANCTNER_ID           VARCHAR2(20)  NOT NULL ,
	CONFM_AT              CHAR(1)  NULL ,
	SANCTN_DT             DATE  NULL ,
	RETURN_RESN           VARCHAR2(1000)  NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
	INFRML_SANCTN_ID      CHAR(20)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNRWARDMANAGE_PK PRIMARY KEY (RWARD_ID)
);



CREATE TABLE COMTNRSS
(
	RSS_ID                CHAR(20)  NOT NULL ,
	TRGET_SVC_NM          VARCHAR2(255)  NOT NULL ,
	TRGET_SVC_TABLE       VARCHAR2(255)  NOT NULL ,
	TRGET_SVC_LIST_CO     NUMBER(5)  NOT NULL ,
	HDER_TITLE            VARCHAR2(255)  NOT NULL ,
	HDER_LINK             VARCHAR2(255)  NOT NULL ,
	HDER_DC               VARCHAR2(4000)  NOT NULL ,
	HDER_TAG              VARCHAR2(255)  NULL ,
	HDER_ETC              VARCHAR2(250)  NULL ,
	BDT_TITLE             VARCHAR2(255)  NULL ,
	BDT_LINK              VARCHAR2(255)  NULL ,
	BDT_DC                VARCHAR2(4000)  NULL ,
	BDT_TAG               VARCHAR2(255)  NULL ,
	BDT_ETC_TAG           VARCHAR2(255)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNRSS_PK PRIMARY KEY (RSS_ID)
);



CREATE TABLE COMTNRESTDE
(
	RESTDE_NO             NUMBER(6)  NOT NULL ,
	RESTDE                CHAR(8)  NULL ,
	RESTDE_NM             VARCHAR2(60)  NULL ,
	RESTDE_DC             VARCHAR2(200)  NULL ,
	RESTDE_SE_CODE        VARCHAR2(2)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
CONSTRAINT  COMTNRESTDE_PK PRIMARY KEY (RESTDE_NO)
);



CREATE TABLE COMTNPROCESSMON
(
	PROCS_ID              CHAR(20)  NOT NULL ,
	PROCS_NM              VARCHAR2(60)  NULL ,
	PROCS_STTUS           VARCHAR2(3)  NULL ,
	CREAT_DT              DATE  NULL ,
	MNGR_NM               VARCHAR2(60)  NULL ,
	MNGR_EMAIL_ADRES      VARCHAR2(50)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNPROCESSMON_PK PRIMARY KEY (PROCS_ID)
);



CREATE TABLE COMTNPROCESSMONLOGINFO
(
	PROCS_ID              CHAR(20)  NOT NULL ,
	PROCS_NM              VARCHAR2(60)  NULL ,
	PROCS_STTUS           VARCHAR2(3)  NULL ,
	CREAT_DT              DATE  NULL ,
	LOG_INFO              VARCHAR2(2000)  NULL ,
	MNGR_NM               VARCHAR2(60)  NULL ,
	MNGR_EMAIL_ADRES      VARCHAR2(50)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	LOG_ID                CHAR(20)  NOT NULL ,
CONSTRAINT  COMTNPROCESSMONLOGINFO_PK PRIMARY KEY (PROCS_ID,LOG_ID),
CONSTRAINT  COMTNPROCESSMONLOGINFO_FK2 FOREIGN KEY (PROCS_ID) REFERENCES COMTNPROCESSMON(PROCS_ID)
);



CREATE TABLE COMTNNTWRKINFO
(
	NTWRK_ID              CHAR(20)  NOT NULL ,
	NTWRK_IP              VARCHAR2(23)  NULL ,
	GTWY                  VARCHAR2(23)  NULL ,
	SUBNET                VARCHAR2(23)  NULL ,
	DOMN_NM_SERVER        VARCHAR2(23)  NULL ,
	MANAGE_IEM            CHAR(2)  NULL ,
	USER_NM               VARCHAR2(60)  NULL ,
	USE_AT                CHAR(1)  NULL ,
	RGSDE                 DATE  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNNTWRKINFO_PK PRIMARY KEY (NTWRK_ID)
);



CREATE  VIEW COMVNUSERMASTER ( ESNTL_ID,USER_ID,PASSWORD,USER_NM,USER_ZIP,USER_ADRES,USER_EMAIL,GROUP_ID, USER_SE, ORGNZT_ID ) 
AS  
		SELECT ESNTL_ID, MBER_ID,PASSWORD,MBER_NM,ZIP,ADRES,MBER_EMAIL_ADRES,' ','GNR' AS USER_SE, ' ' ORGNZT_ID
		FROM COMTNGNRLMBER
		
	UNION ALL
		SELECT ESNTL_ID,EMPLYR_ID,PASSWORD,USER_NM,ZIP,HOUSE_ADRES,EMAIL_ADRES,GROUP_ID ,'USR' AS USER_SE, ORGNZT_ID
		FROM COMTNEMPLYRINFO
	UNION ALL
		SELECT ESNTL_ID,ENTRPRS_MBER_ID,ENTRPRS_MBER_PASSWORD,CMPNY_NM,ZIP,ADRES,APPLCNT_EMAIL_ADRES,' ' ,'ENT' AS USER_SE, ' ' ORGNZT_ID
		FROM COMTNENTRPRSMBER 
ORDER BY ESNTL_ID;



CREATE TABLE COMTNMEMOREPRT
(
	REPRT_SJ              VARCHAR2(255)  NOT NULL ,
	REPORT_DE             CHAR(20)  NOT NULL ,
	WRTER_ID              VARCHAR2(20)  NOT NULL ,
	REPORTR_ID            VARCHAR2(20)  NOT NULL ,
	REPORT_CN             VARCHAR2(2500)  NOT NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
	DRCT_MATTER           VARCHAR2(2500)  NULL ,
	DRCT_MATTER_REGIST_DT  VARCHAR2(14)  NULL ,
	REPORTR_INQIRE_DT     VARCHAR2(14)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NOT NULL ,
	FRST_REGIST_PNTTM     DATE  NOT NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	REPRT_ID              CHAR(6)  NOT NULL ,
CONSTRAINT  COMTNMEMOREPRT_PK PRIMARY KEY (REPRT_ID)
);



CREATE TABLE COMTNMTGPLACEMANAGE
(
	MTGRUM_ID             CHAR(20)  NOT NULL ,
	MTGRUM_NM             VARCHAR2(255)  NOT NULL ,
	OPN_BEGIN_TM          VARCHAR2(6)  NOT NULL ,
	OPN_END_TM            VARCHAR2(6)  NOT NULL ,
	ACEPTNC_POSBL_NMPR    NUMBER(10)  NOT NULL ,
	LC_SE                 CHAR(5)  NULL ,
	LC_DETAIL             VARCHAR2(200)  NULL ,
	ATCH_FILE_ID          CHAR(20)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNMTGPLACEMANAGE_PK PRIMARY KEY (MTGRUM_ID)
);



CREATE TABLE COMTNMTGPLACERESVE
(
	RESVE_ID              CHAR(20)  NOT NULL ,
	MTGRUM_ID             CHAR(20)  NOT NULL ,
	MTG_SJ                VARCHAR2(100)  NOT NULL ,
	RSVCTM_ID             VARCHAR2(20)  NOT NULL ,
	RESVE_DE              CHAR(8)  NOT NULL ,
	RESVE_BEGIN_TM        VARCHAR2(14)  NOT NULL ,
	RESVE_END_TM          VARCHAR2(14)  NOT NULL ,
	ATNDNC_NMPR           NUMBER(10)  NULL ,
	MTG_CN                VARCHAR2(2500)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNMTGPLACERESVE_PK PRIMARY KEY (RESVE_ID)
);



CREATE TABLE COMTNFXTRSMANAGE
(
	FXTRS_CODE            CHAR(14)  NOT NULL ,
	FXTRS_NM              VARCHAR2(100)  NOT NULL ,
	MAKR_NM               VARCHAR2(100)  NULL ,
	PRICE                 NUMBER(16)  NULL ,
CONSTRAINT  COMTNFXTRSMANAGE_PK PRIMARY KEY (FXTRS_CODE)
);



CREATE TABLE COMTNMTGPLACEFXTRS
(
	MTGRUM_ID             CHAR(20)  NOT NULL ,
	FXTRS_CODE            CHAR(14)  NOT NULL ,
	QY                    NUMBER(20)  NOT NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
CONSTRAINT  COMTNMTGPLACEFXTRS_PK PRIMARY KEY (MTGRUM_ID,FXTRS_CODE),
CONSTRAINT  COMTNMTGPLACEFXTRS_FK2 FOREIGN KEY (MTGRUM_ID) REFERENCES COMTNMTGPLACEMANAGE(MTGRUM_ID),
CONSTRAINT  COMTNMTGPLACEFXTRS_FK1 FOREIGN KEY (FXTRS_CODE) REFERENCES COMTNFXTRSMANAGE(FXTRS_CODE)
);



CREATE INDEX COMTNMTGPLACEFXTRS_i01 ON COMTNMTGPLACEFXTRS
(MTGRUM_ID  ASC);



CREATE TABLE COMTECOPSEQ
(
	TABLE_NAME            VARCHAR2(20)  NOT NULL ,
	NEXT_ID               NUMBER(30)  NULL ,
CONSTRAINT  COMTECOPSEQ_PK PRIMARY KEY (TABLE_NAME)
);



CREATE TABLE COMTNANNVRSRYMANAGE
(
	ANNVRSRY_ID           VARCHAR2(20)  NOT NULL ,
	USER_ID               VARCHAR2(20)  NOT NULL ,
	ANNVRSRY_SE           VARCHAR2(2)  NOT NULL ,
	ANNVRSRY_NM           VARCHAR2(255)  NOT NULL ,
	ANNVRSRY              CHAR(20)  NOT NULL ,
	CLDR_SE               CHAR(1)  NOT NULL ,
	ANNVRSRY_NTCN_SETUP   CHAR(1)  NULL ,
	ANNVRSRY_NTCN_BGNDE   CHAR(20)  NULL ,
	MEMO                  VARCHAR2(1000)  NULL ,
	FRST_REGISTER_ID      VARCHAR2(20)  NULL ,
	FRST_REGIST_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID        VARCHAR2(20)  NULL ,
	LAST_UPDT_PNTTM       DATE  NULL ,
	REPTIT_AT             CHAR(1)  NULL ,
CONSTRAINT  COMTNANNVRSRYMANAGE_PK PRIMARY KEY (ANNVRSRY_ID)
);

CREATE TABLE J_ATTACHFILE 
(
	FILE_ID VARCHAR2(13) NOT NULL,
	FILE_SEQ INTEGER NOT NULL,
	FILE_NAME VARCHAR2(100) NOT NULL,
	FILE_SIZE INTEGER,
	FILE_MASK VARCHAR2(100),
	DOWNLOAD_COUNT INTEGER,
	DOWNLOAD_EXPIRE_DATE VARCHAR2(8),
	DOWNLOAD_LIMIT_COUNT INTEGER,
	REG_DATE DATE,
	DELETE_YN VARCHAR2(1),
CONSTRAINT  J_ATTACHFILE_PK PRIMARY KEY (FILE_ID, FILE_SEQ)
);

CREATE TABLE COMTNPRIVACYLOG
(
    REQUST_ID            VARCHAR2(20) NOT NULL,
    INQIRE_DT            DATE NOT NULL,
    SRVC_NM              VARCHAR2(500) NULL,
    INQIRE_INFO          VARCHAR2(100) NULL,
    RQESTER_ID           VARCHAR2(20) NULL,
    RQESTER_IP           VARCHAR2(23) NULL,
CONSTRAINT  REQUST_ID_PK PRIMARY KEY (REQUST_ID)
)
;

CREATE TABLE COMTNCOMMUTE (
     WRKTM_ID           CHAR(20) NOT NULL,
     EMPLYR_ID          VARCHAR2(20) NOT NULL,
     ORGNZT_ID          VARCHAR2(20) NULL,
     WRKT_DT            VARCHAR2(10) NOT NULL, 
     WRK_START_TIME     VARCHAR2(14) NULL, 
     WRK_END_TIME       VARCHAR2(14) NULL, 
     WRK_HOURS          CHAR(2) NULL, 
     OVTMWRK_HOURS      CHAR(2) NULL,
     WRK_START_STATUS   VARCHAR2(10) NULL, 
     WRK_END_STATUS     VARCHAR2(10) NULL, 
     RM                 VARCHAR2(100) NULL,
     FRST_REGISTER_ID   VARCHAR2(20) NULL,
     FRST_REGIST_PNTTM  DATE NULL,
     LAST_UPDUSR_ID     VARCHAR2(20) NULL,
     LAST_UPDT_PNTTM    DATE NULL,
     CONSTRAINT  COMTNCOMMUTE_PK PRIMARY KEY (EMPLYR_ID, WRKT_DT)
);

CREATE TABLE COMTNBLOG
(
	BLOG_ID             CHAR(20)  NOT NULL ,
	BLOG_NM             VARCHAR2(255)  NOT NULL ,
	BLOG_INTRCN         VARCHAR2(2400)  NULL ,
	USE_AT              CHAR(1)  NOT NULL ,
	REGIST_SE_CODE      CHAR(6)  NULL ,
	TMPLAT_ID           CHAR(20)  NULL ,
	FRST_REGIST_PNTTM   DATE  NOT NULL ,
	FRST_REGISTER_ID    VARCHAR2(20)  NOT NULL ,
	LAST_UPDT_PNTTM     DATE  NULL ,
	LAST_UPDUSR_ID      VARCHAR2(20)  NULL ,
	BBS_ID 			CHAR(30) DEFAULT NULL,
  	BLOG_AT 			CHAR(2) DEFAULT NULL,
	CONSTRAINT COMTNBLOG_PK PRIMARY KEY (BLOG_ID)
);

CREATE TABLE COMTNBLOGUSER
(
	BLOG_ID               CHAR(20) NOT NULL,
	EMPLYR_ID             VARCHAR(20) NOT NULL,
	MNGR_AT               CHAR(1) NOT NULL,
	MBER_STTUS		  VARCHAR(15) NULL,
	SBSCRB_DE             DATE NULL,
	SECSN_DE              CHAR(20) NULL,
	USE_AT                CHAR(1) NULL,
	FRST_REGIST_PNTTM     DATE NOT NULL,
	FRST_REGISTER_ID      VARCHAR(20) NOT NULL,
	LAST_UPDT_PNTTM       DATE NULL,
	LAST_UPDUSR_ID        VARCHAR(20) NULL,
	CONSTRAINT COMTNBLOGUSER_PK PRIMARY KEY (BLOG_ID,EMPLYR_ID),
	CONSTRAINT COMTNBLOGUSER_FK1 FOREIGN KEY (BLOG_ID) REFERENCES COMTNBLOG(BLOG_ID)
);

CREATE TABLE COMTCMOBILEIDSERVICE
(
	SVCCODE			VARCHAR(50)		NOT NULL,
	PRESENTTYPE		INTEGER			NOT NULL,
	ENCRYPTTYPE		INTEGER			NOT NULL,
	KEYTYPE			INTEGER			NOT NULL,
	AUTHTYPE		VARCHAR(50)		DEFAULT NULL,
	SPNAME			VARCHAR(100)	NOT NULL,
	SERVICENAME		VARCHAR(100)	NOT NULL,
	ATTRLIST		VARCHAR(100)	DEFAULT NULL,
	PREDLIST		VARCHAR(100)	DEFAULT NULL,
	CALLBACKURL		VARCHAR(100)	DEFAULT NULL,
	REGDT			DATE		NOT NULL,
	UDTDT			DATE		NULL,
	PRIMARY KEY (SVCCODE)
);

CREATE TABLE COMTSMOBILEIDTRXINFO
(
	TRXCODE			VARCHAR(50)		NOT NULL,
	SVCCODE			VARCHAR(50)		NOT NULL,
	OPMODE			VARCHAR(50)		NOT NULL,
	DEVICEID		VARCHAR(100)	DEFAULT NULL,
	BRANCHNAME		VARCHAR(100)	DEFAULT NULL,
	NONCE			VARCHAR(100)	DEFAULT NULL,
	ZKPNONCE		VARCHAR(100)	DEFAULT NULL,
	VPVERIFYRESULT	VARCHAR(1)		NOT NULL,
	TRXSTSCODE		VARCHAR(4)		NOT NULL,
	PROFILESENDDT	DATE			NULL,
	IMGSENDDT		DATE			NULL,
	VPRECEPTDT		DATE			NULL,
	ERRORCN			VARCHAR(4000)	DEFAULT NULL,
	REGDT			DATE			NOT NULL,
	UDTDT			DATE			NULL,
	VPNAME			VARCHAR(50),
	PRIMARY KEY (TRXCODE)
);