/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.SourceType;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleContext {
    private Report report = new Report();
    private File sourceCodeFile;
    private String sourceCodeFilename;
    private SourceType sourceType;
    private final Map<String, Object> attributes;

    public RuleContext() {
        this.attributes = Collections.synchronizedMap(new HashMap());
    }

    public RuleContext(RuleContext ruleContext) {
        this.attributes = ruleContext.attributes;
    }

    public Report getReport() {
        return this.report;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public File getSourceCodeFile() {
        return this.sourceCodeFile;
    }

    public void setSourceCodeFile(File sourceCodeFile) {
        this.sourceCodeFile = sourceCodeFile;
    }

    public String getSourceCodeFilename() {
        return this.sourceCodeFilename;
    }

    public void setSourceCodeFilename(String filename) {
        this.sourceCodeFilename = filename;
    }

    public void excludeLines(Map<Integer, String> lines) {
        this.report.exclude(lines);
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(SourceType t) {
        this.sourceType = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 'name' cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter 'value' cannot be null.");
        }
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            if (!this.attributes.containsKey(name)) {
                this.attributes.put(name, value);
                return true;
            }
            return false;
        }
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Object removeAttribute(String name) {
        return this.attributes.remove(name);
    }
}

