/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.dcd;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import net.sourceforge.pmd.dcd.ClassLoaderUtil;
import net.sourceforge.pmd.dcd.graph.ClassNode;
import net.sourceforge.pmd.dcd.graph.ConstructorNode;
import net.sourceforge.pmd.dcd.graph.FieldNode;
import net.sourceforge.pmd.dcd.graph.MemberNode;
import net.sourceforge.pmd.dcd.graph.MethodNode;
import net.sourceforge.pmd.dcd.graph.NodeVisitorAdapter;
import net.sourceforge.pmd.dcd.graph.UsageGraph;
import net.sourceforge.retroweaver.runtime.java.lang.Class_;

public class UsageNodeVisitor
extends NodeVisitorAdapter {
    private final Options options = new Options();
    private static final /* synthetic */ Class class$java$lang$Object;
    private static final /* synthetic */ Class class$java$lang$String;

    public Object visit(UsageGraph usageGraph, Object data) {
        System.out.println("----------------------------------------");
        super.visit(usageGraph, data);
        System.out.println("----------------------------------------");
        return data;
    }

    public Object visit(ClassNode classNode, Object data) {
        boolean log = true;
        if (this.options.isIgnoreClassAnonymous() && Class_.isAnonymousClass(classNode.getType())) {
            this.ignore("class anonymous", classNode);
            log = false;
        }
        if (log) {
            System.out.println("--- " + classNode.getName() + " ---");
            return super.visit(classNode, data);
        }
        return data;
    }

    public Object visit(FieldNode fieldNode, Object data) {
        if (fieldNode.getUsers().isEmpty()) {
            boolean log = true;
            if (this.options.isIgnoreFieldInlinable() && (Modifier.isFinal(fieldNode.getMember().getModifiers()) && fieldNode.getMember().getType().isPrimitive() || fieldNode.getMember().getType().getName().equals("java.lang.String"))) {
                this.ignore("field inlinable", fieldNode);
                log = false;
            }
            if (log) {
                System.out.println("\t" + fieldNode.toStringLong());
            }
        }
        return super.visit(fieldNode, data);
    }

    public Object visit(ConstructorNode constructorNode, Object data) {
        if (constructorNode.getUsers().isEmpty()) {
            boolean log = true;
            if (constructorNode.isStaticInitializer()) {
                if (this.options.isIgnoreConstructorStaticInitializer()) {
                    this.ignore("constructor static initializer", constructorNode);
                    log = false;
                }
            } else if (constructorNode.isInstanceInitializer() && Modifier.isPrivate(((Constructor)constructorNode.getMember()).getModifiers())) {
                if (this.options.isIgnoreConstructorAllPrivate()) {
                    this.ignore("constructor all private", constructorNode);
                    log = false;
                } else if (this.options.isIgnoreConstructorSinglePrivateNoArg() && ((Constructor)constructorNode.getMember()).getParameterTypes().length == 0 && constructorNode.getClassNode().getConstructorNodes().size() == 1) {
                    this.ignore("constructor single private no-arg", constructorNode);
                    log = false;
                }
            }
            if (log) {
                System.out.println("\t" + constructorNode.toStringLong());
            }
        }
        return super.visit(constructorNode, data);
    }

    public Object visit(MethodNode methodNode, Object data) {
        if (methodNode.getUsers().isEmpty()) {
            boolean log = true;
            if (this.options.isIgnoreMethodAllOverride()) {
                if (ClassLoaderUtil.isOverridenMethod(methodNode.getClassNode().getClass(), methodNode.getMember(), false)) {
                    this.ignore("method all override", methodNode);
                    log = false;
                }
            } else if (this.options.isIgnoreMethodJavaLangObjectOverride()) {
                Class<?> clazz = class$java$lang$Object;
                if (clazz == null) {
                    clazz = class$java$lang$Object = new Object[0].getClass().getComponentType();
                }
                if (ClassLoaderUtil.isOverridenMethod(clazz, methodNode.getMember(), true)) {
                    this.ignore("method java.lang.Object override", methodNode);
                    log = false;
                }
            }
            if (this.options.isIgnoreMethodMain() && methodNode.getMember().getName().equals("main") && Modifier.isPublic(methodNode.getMember().getModifiers()) && Modifier.isStatic(methodNode.getMember().getModifiers()) && methodNode.getMember().getReturnType() == Void.TYPE && methodNode.getMember().getParameterTypes().length == 1 && methodNode.getMember().getParameterTypes()[0].isArray()) {
                Class<?> clazz = methodNode.getMember().getParameterTypes()[0].getComponentType();
                Class<?> clazz2 = class$java$lang$String;
                if (clazz2 == null) {
                    clazz2 = class$java$lang$String = new String[0].getClass().getComponentType();
                }
                if (clazz.equals(clazz2)) {
                    this.ignore("method public static void main(String[])", methodNode);
                    log = false;
                }
            }
            if (log) {
                System.out.println("\t" + methodNode.toStringLong());
            }
        }
        return super.visit(methodNode, data);
    }

    private void ignore(String description, ClassNode classNode) {
        System.out.println("Ignoring " + description + ": " + classNode.getName());
    }

    private void ignore(String description, MemberNode memberNode) {
        System.out.println("Ignoring " + description + ": " + memberNode.toStringLong());
    }

    private void printMember(MemberNode memberNode) {
        if (memberNode.getUsers().size() == 0) {
            System.out.println("\t" + memberNode.toStringLong());
        }
    }

    public static final class Options {
        private boolean ignoreClassAnonymous = true;
        private boolean ignoreConstructorStaticInitializer = true;
        private boolean ignoreConstructorSinglePrivateNoArg = true;
        private boolean ignoreConstructorAllPrivate = false;
        private boolean ignoreMethodJavaLangObjectOverride = true;
        private boolean ignoreMethodAllOverride = false;
        private boolean ignoreMethodMain = true;
        private boolean ignoreFieldInlinable = true;

        public boolean isIgnoreClassAnonymous() {
            return this.ignoreClassAnonymous;
        }

        public void setIgnoreClassAnonymous(boolean ignoreClassAnonymous) {
            this.ignoreClassAnonymous = ignoreClassAnonymous;
        }

        public boolean isIgnoreConstructorStaticInitializer() {
            return this.ignoreConstructorStaticInitializer;
        }

        public void setIgnoreConstructorStaticInitializer(boolean ignoreConstructorStaticInitializer) {
            this.ignoreConstructorStaticInitializer = ignoreConstructorStaticInitializer;
        }

        public boolean isIgnoreConstructorSinglePrivateNoArg() {
            return this.ignoreConstructorSinglePrivateNoArg;
        }

        public void setIgnoreConstructorSinglePrivateNoArg(boolean ignoreConstructorSinglePrivateNoArg) {
            this.ignoreConstructorSinglePrivateNoArg = ignoreConstructorSinglePrivateNoArg;
        }

        public boolean isIgnoreConstructorAllPrivate() {
            return this.ignoreConstructorAllPrivate;
        }

        public void setIgnoreConstructorAllPrivate(boolean ignoreConstructorAllPrivate) {
            this.ignoreConstructorAllPrivate = ignoreConstructorAllPrivate;
        }

        public boolean isIgnoreMethodJavaLangObjectOverride() {
            return this.ignoreMethodJavaLangObjectOverride;
        }

        public void setIgnoreMethodJavaLangObjectOverride(boolean ignoreMethodJavaLangObjectOverride) {
            this.ignoreMethodJavaLangObjectOverride = ignoreMethodJavaLangObjectOverride;
        }

        public boolean isIgnoreMethodAllOverride() {
            return this.ignoreMethodAllOverride;
        }

        public void setIgnoreMethodAllOverride(boolean ignoreMethodAllOverride) {
            this.ignoreMethodAllOverride = ignoreMethodAllOverride;
        }

        public boolean isIgnoreMethodMain() {
            return this.ignoreMethodMain;
        }

        public void setIgnoreMethodMain(boolean ignoreMethodMain) {
            this.ignoreMethodMain = ignoreMethodMain;
        }

        public boolean isIgnoreFieldInlinable() {
            return this.ignoreFieldInlinable;
        }

        public void setIgnoreFieldInlinable(boolean ignoreFieldInlinable) {
            this.ignoreFieldInlinable = ignoreFieldInlinable;
        }
    }
}

