/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.imports;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTImportDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.Comment;
import net.sourceforge.pmd.ast.FormalComment;
import net.sourceforge.pmd.ast.SimpleJavaNode;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.rules.ImportWrapper;

public class UnusedImportsRule
extends AbstractRule {
    protected Set<ImportWrapper> imports = new HashSet<ImportWrapper>();
    private static final Pattern SEE_PATTERN = Pattern.compile("@see\\s+(\\p{Alpha}\\p{Alnum}*)[\\s#]");
    private static final Pattern LINK_PATTERNS = Pattern.compile("\\{@link(?:plain)?\\s+(\\p{Alpha}\\p{Alnum}*)[\\s#\\}]");
    private static final Pattern VALUE_PATTERN = Pattern.compile("\\{@value\\s+(\\p{Alpha}\\p{Alnum}*)[\\s#\\}]");
    private static final Pattern[] PATTERNS = new Pattern[]{SEE_PATTERN, LINK_PATTERNS, VALUE_PATTERN};

    public Object visit(ASTCompilationUnit node, Object data) {
        this.imports.clear();
        super.visit(node, data);
        this.visitComments(node);
        Iterator<ImportWrapper> i$ = this.imports.iterator();
        while (i$.hasNext()) {
            ImportWrapper wrapper = i$.next();
            this.addViolation(data, wrapper.getNode(), wrapper.getFullName());
        }
        return data;
    }

    private void visitComments(ASTCompilationUnit node) {
        if (this.imports.isEmpty()) {
            return;
        }
        Iterator<Comment> i$ = node.getComments().iterator();
        while (i$.hasNext()) {
            Comment comment = i$.next();
            if (!(comment instanceof FormalComment)) continue;
            Pattern[] arr$ = PATTERNS;
            int len$ = arr$.length;
            for (int i$2 = 0; i$2 < len$; ++i$2) {
                Pattern p = arr$[i$2];
                Matcher m = p.matcher(comment.getImage());
                while (m.find()) {
                    String s = m.group(1);
                    ImportWrapper candidate = new ImportWrapper(s, s, new SimpleJavaNode(-1));
                    if (!this.imports.contains(candidate)) continue;
                    this.imports.remove(candidate);
                    if (!this.imports.isEmpty()) continue;
                    return;
                }
            }
        }
    }

    public Object visit(ASTImportDeclaration node, Object data) {
        if (!node.isImportOnDemand()) {
            String className;
            ASTName importedType = (ASTName)node.jjtGetChild(0);
            if (UnusedImportsRule.isQualifiedName(importedType)) {
                int lastDot = importedType.getImage().lastIndexOf(46) + 1;
                className = importedType.getImage().substring(lastDot);
            } else {
                className = importedType.getImage();
            }
            this.imports.add(new ImportWrapper(importedType.getImage(), className, node));
        }
        return data;
    }

    public Object visit(ASTClassOrInterfaceType node, Object data) {
        this.check(node);
        return super.visit(node, data);
    }

    public Object visit(ASTName node, Object data) {
        this.check(node);
        return data;
    }

    protected void check(SimpleNode node) {
        if (this.imports.isEmpty()) {
            return;
        }
        ImportWrapper candidate = this.getImportWrapper(node);
        if (this.imports.contains(candidate)) {
            this.imports.remove(candidate);
        }
    }

    protected ImportWrapper getImportWrapper(SimpleNode node) {
        String name = !UnusedImportsRule.isQualifiedName(node) ? node.getImage() : node.getImage().substring(0, node.getImage().indexOf(46));
        ImportWrapper candidate = new ImportWrapper(node.getImage(), name, new SimpleJavaNode(-1));
        return candidate;
    }
}

