/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.dfa.IDataFlowNode;
import net.sourceforge.pmd.dfa.variableaccess.VariableAccess;
import net.sourceforge.pmd.util.LineGetter;
import net.sourceforge.pmd.util.StringUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DFAPanel
extends JComponent
implements ListSelectionListener {
    private DFACanvas dfaCanvas;
    private JList nodeList;
    private DefaultListModel nodes = new DefaultListModel();

    public DFAPanel() {
        this.setLayout(new BorderLayout());
        JPanel leftPanel = new JPanel();
        this.nodeList = new JList(this.nodes);
        this.nodeList.setSelectionMode(0);
        this.nodeList.setFixedCellWidth(150);
        this.nodeList.setBorder(BorderFactory.createLineBorder(Color.black));
        this.nodeList.addListSelectionListener(this);
        leftPanel.add(this.nodeList);
        this.add((Component)leftPanel, "West");
        this.dfaCanvas = new DFACanvas();
        this.dfaCanvas.setBackground(Color.WHITE);
        this.dfaCanvas.setPreferredSize(new Dimension(900, 1400));
        JScrollPane scrollPane = new JScrollPane(this.dfaCanvas);
        this.add((Component)scrollPane, "Center");
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        ElementWrapper wrapper = null;
        if (this.nodes.size() == 1) {
            wrapper = (ElementWrapper)this.nodes.get(0);
        } else {
            if (this.nodes.isEmpty()) {
                return;
            }
            wrapper = this.nodeList.getSelectedValue() == null ? (ElementWrapper)this.nodes.get(0) : (ElementWrapper)this.nodeList.getSelectedValue();
        }
        this.dfaCanvas.setMethod(wrapper.getNode());
        this.dfaCanvas.repaint();
    }

    public void resetTo(List<ASTMethodDeclaration> newNodes, LineGetter lines) {
        this.dfaCanvas.setCode(lines);
        this.nodes.clear();
        for (ASTMethodDeclaration md : newNodes) {
            this.nodes.addElement(new ElementWrapper(md));
        }
        this.nodeList.setSelectedIndex(0);
        this.dfaCanvas.setMethod(newNodes.get(0));
        this.repaint();
    }

    private static class ElementWrapper {
        private ASTMethodDeclaration node;

        public ElementWrapper(ASTMethodDeclaration node) {
            this.node = node;
        }

        public ASTMethodDeclaration getNode() {
            return this.node;
        }

        public String toString() {
            return this.node.getMethodName();
        }
    }

    public static class DFACanvas
    extends JPanel {
        private static final int NODE_RADIUS = 12;
        private static final int NODE_DIAMETER = 24;
        private SimpleNode node;
        private int x = 150;
        private int y = 50;
        private LineGetter lines;

        private void addAccessLabel(StringBuffer sb, VariableAccess va) {
            if (va.isDefinition()) {
                sb.append("d(");
            } else if (va.isReference()) {
                sb.append("r(");
            } else if (va.isUndefinition()) {
                sb.append("u(");
            } else {
                sb.append("?(");
            }
            sb.append(va.getVariableName()).append(')');
        }

        private String childIndicesOf(IDataFlowNode node, String separator) {
            List<? extends IDataFlowNode> kids = node.getChildren();
            if (kids.isEmpty()) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            sb.append(kids.get(0).getIndex());
            for (int j = 1; j < node.getChildren().size(); ++j) {
                sb.append(separator);
                sb.append(kids.get(j).getIndex());
            }
            return sb.toString();
        }

        private String[] deriveAccessLabels(List flow) {
            if (flow == null || flow.isEmpty()) {
                return StringUtil.EMPTY_STRINGS;
            }
            String[] labels = new String[flow.size()];
            for (int i = 0; i < labels.length; ++i) {
                List<VariableAccess> access = ((IDataFlowNode)flow.get(i)).getVariableAccess();
                if (access == null || access.isEmpty()) continue;
                StringBuffer exp = new StringBuffer();
                this.addAccessLabel(exp, access.get(0));
                for (int k = 1; k < access.size(); ++k) {
                    exp.append(", ");
                    this.addAccessLabel(exp, access.get(k));
                }
                labels[i] = exp.toString();
            }
            return labels;
        }

        private int maxWidthOf(String[] strings, FontMetrics fm) {
            int max = 0;
            for (int i = 0; i < strings.length; ++i) {
                String str = strings[i];
                if (str == null) continue;
                max = Math.max(max, SwingUtilities.computeStringWidth(fm, str));
            }
            return max;
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.node == null) {
                return;
            }
            List<? extends IDataFlowNode> flow = this.node.getDataFlowNode().getFlow();
            FontMetrics fm = g.getFontMetrics();
            int halfFontHeight = fm.getAscent() / 2;
            String[] accessLabels = this.deriveAccessLabels(flow);
            int maxAccessLabelWidth = this.maxWidthOf(accessLabels, fm);
            for (int i = 0; i < flow.size(); ++i) {
                IDataFlowNode inode = flow.get(i);
                this.y = this.computeDrawPos(inode.getIndex());
                g.drawArc(this.x, this.y, 24, 24, 0, 360);
                g.drawString(this.lines.getLine(inode.getLine()), this.x + 100 + maxAccessLabelWidth, this.y + 15);
                String idx = String.valueOf(inode.getIndex());
                int halfWidth = SwingUtilities.computeStringWidth(fm, idx) / 2;
                g.drawString(idx, this.x + 12 - halfWidth, this.y + 12 + halfFontHeight);
                String accessLabel = accessLabels[i];
                if (accessLabel != null) {
                    g.drawString(accessLabel, this.x + 70, this.y + 15);
                }
                for (int j = 0; j < inode.getChildren().size(); ++j) {
                    IDataFlowNode n = inode.getChildren().get(j);
                    this.drawMyLine(inode.getIndex(), n.getIndex(), g);
                }
                String childIndices = this.childIndicesOf(inode, ", ");
                g.drawString(childIndices, this.x - 72, this.y + 12 - 2);
            }
        }

        public void setCode(LineGetter h) {
            this.lines = h;
        }

        public void setMethod(SimpleNode node) {
            this.node = node;
        }

        private int computeDrawPos(int index) {
            int z = 48;
            return z + index * z;
        }

        private void drawArrow(Graphics g, int x, int y, int direction) {
            int height = 8;
            int width = 8;
            switch (direction) {
                case 1: {
                    g.drawLine(x, y, x - 4, y + 8);
                    g.drawLine(x, y, x + 4, y + 8);
                    break;
                }
                case 5: {
                    g.drawLine(x, y, x - 4, y - 8);
                    g.drawLine(x, y, x + 4, y - 8);
                    break;
                }
                case 3: {
                    g.drawLine(x, y, x - 8, y - 4);
                    g.drawLine(x, y, x - 8, y + 4);
                    break;
                }
                case 7: {
                    g.drawLine(x, y, x + 8, y - 4);
                    g.drawLine(x, y, x + 8, y + 4);
                }
            }
        }

        private void drawMyLine(int index1, int index2, Graphics g) {
            int y1 = this.computeDrawPos(index1);
            int y2 = this.computeDrawPos(index2);
            if (index1 < index2) {
                if (index2 - index1 == 1) {
                    this.x += 12;
                    g.drawLine(this.x, y1 + 24, this.x, y2);
                    this.drawArrow(g, this.x, y2, 5);
                    this.x -= 12;
                } else if (index2 - index1 > 1) {
                    int n = (index2 - index1 - 2) * 10 + 10;
                    g.drawLine(this.x, y1 += 12, this.x - n, y1);
                    g.drawLine(this.x - n, y1, this.x - n, y2 += 12);
                    g.drawLine(this.x - n, y2, this.x, y2);
                    this.drawArrow(g, this.x, y2, 3);
                }
            } else if (index1 - index2 > 1) {
                this.x += 24;
                int n = (index1 - index2 - 2) * 10 + 10;
                g.drawLine(this.x, y1 += 12, this.x + n, y1);
                g.drawLine(this.x + n, y1, this.x + n, y2 += 12);
                g.drawLine(this.x + n, y2, this.x, y2);
                this.drawArrow(g, this.x, y2, 7);
                this.x -= 24;
            } else if (index1 - index2 == 1) {
                g.drawLine(this.x + 12, y2 += 24, this.x + 12, y1);
                this.drawArrow(g, this.x + 12, y2, 1);
            }
        }
    }
}

