/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.sourceforge.pmd.AbstractJavaRule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.jaxen.DocumentNavigator;
import net.sourceforge.pmd.jaxen.MatchesFunction;
import net.sourceforge.pmd.jaxen.TypeOfFunction;
import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;
import org.jaxen.Navigator;
import org.jaxen.SimpleVariableContext;
import org.jaxen.VariableContext;
import org.jaxen.XPath;
import org.jaxen.expr.AllNodeStep;
import org.jaxen.expr.DefaultXPathFactory;
import org.jaxen.expr.Expr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.Step;
import org.jaxen.expr.UnionExpr;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathRule
extends AbstractJavaRule {
    private Map<String, List<XPath>> nodeNameToXPaths;
    private boolean regexpFunctionRegistered;
    private boolean typeofFunctionRegistered;
    private static final String AST_ROOT = "_AST_ROOT_";

    public void evaluate(Node compilationUnit, RuleContext data) {
        try {
            this.initializeXPathExpression();
            List<XPath> xpaths = this.nodeNameToXPaths.get(compilationUnit.toString());
            if (xpaths == null) {
                xpaths = this.nodeNameToXPaths.get(AST_ROOT);
            }
            for (XPath xpath : xpaths) {
                List results = xpath.selectNodes((Object)compilationUnit);
                for (SimpleNode n : results) {
                    if (n instanceof ASTVariableDeclaratorId && this.getBooleanProperty("pluginname")) {
                        this.addViolation((Object)data, n, n.getImage());
                        continue;
                    }
                    this.addViolation((Object)data, n, this.getMessage());
                }
            }
        }
        catch (JaxenException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public List<String> getRuleChainVisits() {
        try {
            this.initializeXPathExpression();
            return super.getRuleChainVisits();
        }
        catch (JaxenException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void initializeXPathExpression() throws JaxenException {
        if (this.nodeNameToXPaths != null) {
            return;
        }
        if (!this.regexpFunctionRegistered) {
            MatchesFunction.registerSelfInSimpleContext();
            this.regexpFunctionRegistered = true;
        }
        if (!this.typeofFunctionRegistered) {
            TypeOfFunction.registerSelfInSimpleContext();
            this.typeofFunctionRegistered = true;
        }
        this.nodeNameToXPaths = new HashMap<String, List<XPath>>();
        BaseXPath originalXPath = this.createXPath(this.getStringProperty("xpath"));
        this.indexXPath((XPath)originalXPath, AST_ROOT);
        boolean useRuleChain = true;
        Stack<Expr> pending = new Stack<Expr>();
        pending.push(originalXPath.getRootExpr());
        while (!pending.isEmpty()) {
            Expr node = (Expr)pending.pop();
            boolean valid = false;
            if (node instanceof LocationPath) {
                List steps;
                LocationPath locationPath = (LocationPath)node;
                if (locationPath.isAbsolute() && (steps = locationPath.getSteps()).size() >= 2) {
                    Step step1 = (Step)steps.get(0);
                    Step step2 = (Step)steps.get(1);
                    if (step1 instanceof AllNodeStep && ((AllNodeStep)step1).getAxis() == 12 && step2 instanceof NameStep && ((NameStep)step2).getAxis() == 1) {
                        DefaultXPathFactory xpathFactory = new DefaultXPathFactory();
                        LocationPath relativeLocationPath = xpathFactory.createRelativeLocationPath();
                        Step allNodeStep = xpathFactory.createAllNodeStep(11);
                        Iterator i = step2.getPredicates().iterator();
                        while (i.hasNext()) {
                            allNodeStep.addPredicate((Predicate)i.next());
                        }
                        relativeLocationPath.addStep(allNodeStep);
                        for (int i2 = 2; i2 < steps.size(); ++i2) {
                            relativeLocationPath.addStep((Step)steps.get(i2));
                        }
                        BaseXPath xpath = this.createXPath(relativeLocationPath.getText());
                        this.indexXPath((XPath)xpath, ((NameStep)step2).getLocalName());
                        valid = true;
                    }
                }
            } else if (node instanceof UnionExpr) {
                UnionExpr unionExpr = (UnionExpr)node;
                pending.push(unionExpr.getLHS());
                pending.push(unionExpr.getRHS());
                valid = true;
            }
            if (valid) continue;
            useRuleChain = false;
            break;
        }
        if (useRuleChain) {
            for (String s : this.nodeNameToXPaths.keySet()) {
                this.addRuleChainVisit(s);
            }
        } else {
            this.nodeNameToXPaths.clear();
            this.indexXPath((XPath)originalXPath, AST_ROOT);
        }
    }

    private void indexXPath(XPath xpath, String nodeName) {
        List<XPath> xpaths = this.nodeNameToXPaths.get(nodeName);
        if (xpaths == null) {
            xpaths = new ArrayList<XPath>();
            this.nodeNameToXPaths.put(nodeName, xpaths);
        }
        xpaths.add(xpath);
    }

    private BaseXPath createXPath(String xpathQueryString) throws JaxenException {
        xpathQueryString = xpathQueryString.replaceAll("\"\"\"", "'\"'");
        BaseXPath xpath = new BaseXPath(xpathQueryString, (Navigator)new DocumentNavigator());
        if (this.getProperties().size() > 1) {
            SimpleVariableContext vc = new SimpleVariableContext();
            for (Map.Entry<Object, Object> e : this.getProperties().entrySet()) {
                if ("xpath".equals(e.getKey())) continue;
                vc.setVariableValue((String)e.getKey(), e.getValue());
            }
            xpath.setVariableContext((VariableContext)vc);
        }
        return xpath;
    }

    @Override
    public void apply(List astCompilationUnits, RuleContext ctx) {
        Iterator i = astCompilationUnits.iterator();
        while (i.hasNext()) {
            this.evaluate((Node)i.next(), ctx);
        }
    }
}

