/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.ABConnection;
import Altibase.jdbc.driver.ABParameterMetaData;
import Altibase.jdbc.driver.ABResultSet;
import Altibase.jdbc.driver.ABResultSetMetaData;
import Altibase.jdbc.driver.ABStatement;
import Altibase.jdbc.driver.ABTypes;
import Altibase.jdbc.driver.BindMeta;
import Altibase.jdbc.driver.Blob;
import Altibase.jdbc.driver.Clob;
import Altibase.jdbc.driver.Geometry;
import Altibase.jdbc.driver.SQLStates;
import Altibase.jdbc.driver.cmp;
import Altibase.jdbc.driver.ex;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.Calendar;

public class ABPreparedStatement
extends ABStatement
implements PreparedStatement,
ABTypes {
    static final long serialVersionUID = 3L;
    private static final int[] EMPTY_RESULT = new int[0];
    protected int pc;
    protected ABParameterMetaData pmeta;

    ABPreparedStatement(ABConnection c, String s) throws SQLException {
        super(c);
        this.mQueryString = s;
        this.mConnection.prepare(this);
        this.mState = 1;
    }

    ABPreparedStatement(ABConnection c, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        super(c, resultSetType, resultSetConcurrency);
        this.mQueryString = sql;
        this.mConnection.prepare(this);
        this.mState = 1;
    }

    public void addBatch() throws SQLException {
        ex.test(this.pc == 0, (short)72, SQLStates.mFixmsg[16]);
        this.pmeta.addBatch();
    }

    boolean bind(cmp chn) throws SQLException {
        return this.pmeta.sendBindInfo(chn);
    }

    public void clearBatch() throws SQLException {
        ex.test(this.pc == 0, (short)72, SQLStates.mFixmsg[16]);
        this.pmeta.clearArray();
    }

    public void clearParameters() throws SQLException {
        this.pmeta = null;
        this.setParamsCount((short)this.pc);
    }

    public boolean execute() throws SQLException {
        this.mConnection.exec(this);
        this.pmeta.executeLobUpdate();
        return super.size() > 0;
    }

    public int[] executeBatch() throws SQLException {
        int[] ret = EMPTY_RESULT;
        this.cancel();
        ex.test(this.isSelect(), (short)103, SQLStates.mFixmsg[17]);
        if (this.pmeta.getCurrentSize() > 0) {
            this.pmeta.allocBatchResult();
            try {
                int size = this.mConnection.execArray(this);
                ret = this.pmeta.getResultArray(size);
            }
            catch (SQLException e) {
                short sSize = this.pmeta.getCurrentSize();
                BatchUpdateException sExceptBatch = new BatchUpdateException(SQLStates.mFixmsg[45], SQLStates.status[65], this.pmeta.getResultArray(sSize));
                sExceptBatch.setNextException(e);
                throw sExceptBatch;
            }
        }
        this.pmeta.executeLobUpdate();
        return ret;
    }

    public synchronized ResultSet executeQuery() throws SQLException {
        ex.test(!this.isSelect(), (short)72, SQLStates.mFixmsg[18]);
        this.cancel();
        this.mUpdateCount = this.mConnection.writePrepareExecuteFetchReq(this);
        this.pmeta.reset();
        return this.getDefaultResultSet();
    }

    public int executeUpdate() throws SQLException {
        ex.test(this.isSelect(), (short)72, SQLStates.mFixmsg[19]);
        this.cancel();
        this.mUpdateCount = this.mConnection.exec(this);
        this.pmeta.executeLobUpdate();
        return (int)this.mUpdateCount;
    }

    final short getArraySize() {
        return this.pmeta.reset();
    }

    final short getBatchCount() {
        return this.pmeta == null ? (short)0 : this.pmeta.reset();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        ABResultSetMetaData rsm = null;
        ABResultSet rs = (ABResultSet)this.get(0);
        if (rs != null) {
            rsm = rs.getTableMetaData();
        }
        return rsm;
    }

    public String getParameterClassName(int p) throws SQLException {
        return this.pmeta.getParameterClassName(p);
    }

    public int getParameterCount() throws SQLException {
        return this.pmeta.size();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.pmeta;
    }

    public int getParameterMode(int p) throws SQLException {
        return this.pmeta.getParameterMode(p);
    }

    public int getParameterType(int p) throws SQLException {
        return this.pmeta.getParameterType(p);
    }

    public String getParameterTypeName(int p) throws SQLException {
        return this.pmeta.getParameterTypeName(p);
    }

    public short getParamsCount() {
        return (short)this.pc;
    }

    public int getPrecision(int p) throws SQLException {
        return this.pmeta.getPrecision(p);
    }

    public int getScale(int p) throws SQLException {
        return this.pmeta.getScale(p);
    }

    public int isNullable(int p) throws SQLException {
        return this.pmeta.isNullable(p);
    }

    public boolean isSigned(int p) throws SQLException {
        return this.pmeta.isSigned(p);
    }

    final BindMeta param(short p) throws SQLException {
        return this.pmeta.getMetaColumn(p);
    }

    public void setArray(int idx, Array x) throws SQLException {
        ex.exception((short)103);
    }

    public void setAsciiStream(int p, InputStream in, int len) throws SQLException {
        this.setBinaryStream(p, in, len);
    }

    public void setBigDecimal(int p, BigDecimal d) throws SQLException {
        this.pmeta.set(p, d);
    }

    public void setBinaryStream(int p, InputStream in, int len) throws SQLException {
        if (in == null) {
            this.pmeta.setNull(p, 2004);
        } else {
            Blob b = new Blob(in, (long)len & 0xFFFFFFFFL);
            this.pmeta.set(p, b);
        }
    }

    public void setBlob(int p, java.sql.Blob x) throws SQLException {
        Blob b = null;
        if (x == null) {
            this.pmeta.setNull(p, 2004);
        } else {
            b = new Blob(x.getBinaryStream(), Long.MAX_VALUE);
            this.pmeta.set(p, b);
        }
    }

    public void setBoolean(int p, boolean b) throws SQLException {
        this.pmeta.set(p, b);
    }

    public void setByte(int p, byte b) throws SQLException {
        this.pmeta.set(p, b);
    }

    public void setBytes(int idx, byte[] b) throws SQLException {
        if (b == null) {
            this.pmeta.setNull(idx, -2);
        } else {
            ByteBuffer bb = ByteBuffer.wrap(b);
            this.pmeta.set(idx, bb);
        }
    }

    public void setCharacterStream(int p, Reader in, int len) throws SQLException {
        if (in == null) {
            this.pmeta.setNull(p, 2005);
        } else {
            Clob b = new Clob(in, len);
            this.pmeta.set(p, b);
        }
    }

    public void setClob(int p, java.sql.Clob x) throws SQLException {
        if (x == null) {
            this.pmeta.setNull(p, 2005);
        } else {
            this.pmeta.set(p, new Clob(x.getCharacterStream(), Integer.MAX_VALUE));
        }
    }

    public void setDate(int p, Date d) throws SQLException {
        if (d == null) {
            this.pmeta.setNull(p, 91);
        } else {
            this.pmeta.set(p, d);
        }
    }

    public void setDate(int p, Date d, Calendar cal) throws SQLException {
        if (d == null) {
            this.pmeta.setNull(p, 91);
        } else {
            this.pmeta.set(p, d);
        }
    }

    public void setDouble(int idx, double d) throws SQLException {
        this.pmeta.set(idx, d);
    }

    public void setFloat(int idx, float f) throws SQLException {
        this.pmeta.set(idx, f);
    }

    public void setInt(int idx, int x) throws SQLException {
        this.pmeta.set(idx, x);
    }

    public void setLong(int idx, long l) throws SQLException {
        this.pmeta.set(idx, l);
    }

    public void setNull(int idx, int type) throws SQLException {
        this.pmeta.setNull(idx, type);
    }

    public void setNull(int idx, int type, String tname) throws SQLException {
        this.setNull(idx, type);
    }

    public void setObject(int aParamIdx, Object aObj) throws SQLException {
        aParamIdx = this.validateIndex(aParamIdx);
        if (aObj == null) {
            ex.exception((short)30);
        } else if (aObj instanceof StringBuffer) {
            this.setString(aParamIdx, aObj.toString());
        } else if (aObj instanceof Short) {
            this.setObject(aParamIdx, (Object)((Short)aObj), 5);
        } else if (aObj instanceof Integer) {
            this.setObject(aParamIdx, (Object)((Integer)aObj), 4);
        } else if (aObj instanceof Long) {
            this.setObject(aParamIdx, (Object)((Long)aObj), -5);
        } else if (aObj instanceof Float) {
            this.setObject(aParamIdx, (Object)((Float)aObj), 7);
        } else if (aObj instanceof Double) {
            this.setObject(aParamIdx, (Object)((Double)aObj), 8);
        } else if (aObj instanceof byte[]) {
            this.setBytes(aParamIdx, (byte[])aObj);
        } else if (aObj instanceof Blob) {
            this.setBlob(aParamIdx, (Blob)aObj);
        } else if (aObj instanceof Clob) {
            this.setClob(aParamIdx, (Clob)aObj);
        } else if (aObj instanceof InputStream) {
            this.setBinaryStream(aParamIdx, (InputStream)aObj, -1);
        } else if (aObj instanceof Reader) {
            this.setCharacterStream(aParamIdx, (Reader)aObj, Integer.MAX_VALUE);
        } else if (aObj instanceof BigDecimal) {
            this.setBigDecimal(aParamIdx, (BigDecimal)aObj);
        } else if (aObj instanceof Geometry) {
            ex.exception((short)30);
            this.setObject(aParamIdx, aObj, 10003);
        } else if (aObj instanceof Date) {
            this.setDate(aParamIdx, (Date)aObj);
        } else if (aObj instanceof Time) {
            this.setTime(aParamIdx, (Time)aObj);
        } else if (aObj instanceof Timestamp) {
            this.setTimestamp(aParamIdx, (Timestamp)aObj);
        } else if (aObj instanceof String) {
            this.setString(aParamIdx, aObj.toString());
        } else {
            this.setObject(aParamIdx, aObj, -2);
        }
    }

    public void setObject(int aParamIdx, Object aObj, int aSqlType) throws SQLException {
        this.setObject(aParamIdx, aObj, aSqlType, 0);
    }

    public void setObject(int aParamIdx, Object aObj, int aSqlType, int aScale) throws SQLException {
        if (aObj == null) {
            this.pmeta.setNull(aParamIdx, aSqlType);
        } else {
            switch (aSqlType) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    if (aObj instanceof Number) {
                        this.pmeta.set(aParamIdx, ((Number)aObj).longValue());
                        break;
                    }
                    if (aObj instanceof String) {
                        this.pmeta.set(aParamIdx, Long.parseLong((String)aObj));
                        break;
                    }
                    ex.exception((short)19);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    if (aObj instanceof Number) {
                        this.setDouble(aParamIdx, ((Number)aObj).doubleValue());
                        break;
                    }
                    if (aObj instanceof String) {
                        this.setDouble(aParamIdx, Double.parseDouble((String)aObj));
                        break;
                    }
                    ex.exception((short)19);
                    break;
                }
                case 2: 
                case 3: {
                    if (aObj instanceof BigDecimal) {
                        this.setBigDecimal(aParamIdx, (BigDecimal)aObj);
                    }
                    if (aObj instanceof BigInteger) {
                        this.setBigDecimal(aParamIdx, new BigDecimal((BigInteger)aObj, aScale));
                        break;
                    }
                    if (aObj instanceof String) {
                        this.setDouble(aParamIdx, Double.parseDouble((String)aObj));
                        break;
                    }
                    this.setBigDecimal(aParamIdx, new BigDecimal(aObj.toString()));
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    if (!(aObj instanceof String)) {
                        this.setString(aParamIdx, aObj.toString());
                        break;
                    }
                    this.setString(aParamIdx, (String)aObj);
                    break;
                }
                case 2005: {
                    if (aObj instanceof java.sql.Clob) {
                        this.setClob(aParamIdx, (java.sql.Clob)aObj);
                        break;
                    }
                    if (aObj instanceof Reader) {
                        this.setCharacterStream(aParamIdx, (Reader)aObj, Integer.MAX_VALUE);
                        break;
                    }
                    ex.exception((short)19);
                    break;
                }
                case 2004: {
                    if (aObj instanceof java.sql.Blob) {
                        this.setBlob(aParamIdx, (java.sql.Blob)aObj);
                        break;
                    }
                    if (aObj instanceof InputStream) {
                        this.setBinaryStream(aParamIdx, (InputStream)aObj, -1);
                        break;
                    }
                    ex.exception((short)19);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    ex.test(!(aObj instanceof byte[]), (short)19);
                    this.setBytes(aParamIdx, (byte[])aObj);
                    break;
                }
                case 20001: {
                    ex.test(!(aObj instanceof byte[]), (short)19);
                    this.pmeta.setAltibaseBytes(aParamIdx, ByteBuffer.wrap((byte[])aObj));
                    break;
                }
                case 20002: {
                    ex.test(!(aObj instanceof byte[]), (short)19);
                    this.pmeta.setNibble(aParamIdx, ByteBuffer.wrap((byte[])aObj));
                    break;
                }
                case 91: {
                    if (aObj instanceof Date) {
                        this.setDate(aParamIdx, (Date)aObj);
                        break;
                    }
                    if (aObj instanceof Timestamp) {
                        this.setTimestamp(aParamIdx, (Timestamp)aObj);
                        break;
                    }
                    if (!(aObj instanceof String)) break;
                    this.setDate(aParamIdx, this.getEncoder().parseDate((String)aObj));
                    break;
                }
                case 92: {
                    if (aObj instanceof Time) {
                        this.setTime(aParamIdx, (Time)aObj);
                        break;
                    }
                    if (aObj instanceof Timestamp) {
                        this.setTimestamp(aParamIdx, (Timestamp)aObj);
                        break;
                    }
                    if (!(aObj instanceof String)) break;
                    this.setTime(aParamIdx, this.getEncoder().parseTime((String)aObj));
                    break;
                }
                case 93: {
                    if (aObj instanceof Timestamp) {
                        this.setTimestamp(aParamIdx, (Timestamp)aObj);
                        break;
                    }
                    if (aObj instanceof Date) {
                        this.setDate(aParamIdx, (Date)aObj);
                        break;
                    }
                    if (aObj instanceof Time) {
                        this.setTime(aParamIdx, (Time)aObj);
                        break;
                    }
                    if (aObj instanceof String) {
                        this.setTimestamp(aParamIdx, this.getEncoder().parseTimestamp((String)aObj));
                        break;
                    }
                    ex.exception((short)19);
                    break;
                }
                case -7: {
                    if (aObj instanceof byte[]) {
                        this.pmeta.setBitSet(aParamIdx, (byte[])aObj);
                        break;
                    }
                    if (aObj instanceof String) {
                        this.pmeta.setBitSet(aParamIdx, (String)aObj);
                        break;
                    }
                    if (aObj instanceof BitSet) {
                        this.pmeta.set(aParamIdx, (BitSet)aObj, aScale);
                        break;
                    }
                    ex.exception((short)19);
                    break;
                }
                default: {
                    ex.exception((short)19);
                }
            }
        }
    }

    void setParamsCount(short params) throws SQLException {
        this.pc = params;
        this.pmeta = new ABParameterMetaData(this, params);
    }

    public void setRef(int idx, Ref x) throws SQLException {
        ex.exception((short)30);
    }

    public void setShort(int p, short v) throws SQLException {
        this.pmeta.set(p, v);
    }

    public void setString(int idx, String str) throws SQLException {
        if (str == null) {
            this.pmeta.setNull(idx, 1);
        } else {
            this.pmeta.set(idx, str);
        }
    }

    public void setTime(int p, Time t) throws SQLException {
        if (t == null) {
            this.pmeta.setNull(p, 92);
        } else {
            this.pmeta.set(p, t);
        }
    }

    public void setTime(int idx, Time t, Calendar cal) throws SQLException {
        ex.exception((short)30);
    }

    public void setTimestamp(int p, Timestamp t) throws SQLException {
        if (t == null) {
            this.pmeta.setNull(p, 93);
        } else {
            this.pmeta.set(p, t);
        }
    }

    public void setTimestamp(int idx, Timestamp t, Calendar cal) throws SQLException {
        ex.exception((short)30);
    }

    public void setUnicodeStream(int idx, InputStream in, int c) throws SQLException {
        ex.exception((short)30, SQLStates.mFixmsg[20]);
    }

    void setUpdateCount(long count, int pos) throws SQLException {
        super.setUpdateCount(count, pos);
        if (this.pmeta != null) {
            this.pmeta.setUpdateCount(count, pos);
        }
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        ex.exception((short)30);
    }

    private int validateIndex(int ind) throws SQLException {
        return ind;
    }

    boolean write(cmp chn) throws SQLException {
        return this.pmeta.write(chn);
    }
}

