/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.javadoc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JavadocUtil {
    protected static List pruneDirs(MavenProject project, List dirs) {
        ArrayList<String> pruned = new ArrayList<String>(dirs.size());
        Iterator i = dirs.iterator();
        while (i.hasNext()) {
            String dir = (String)i.next();
            if (dir == null) continue;
            File directory = new File(dir);
            if (!directory.isAbsolute()) {
                directory = new File(project.getBasedir(), directory.getPath());
            }
            if (!directory.isDirectory() || pruned.contains(dir)) continue;
            pruned.add(directory.getAbsolutePath());
        }
        return pruned;
    }

    protected static List pruneFiles(List files) {
        ArrayList<String> pruned = new ArrayList<String>(files.size());
        Iterator i = files.iterator();
        while (i.hasNext()) {
            File file;
            String f = (String)i.next();
            if (f == null || !(file = new File(f)).isFile() || pruned.contains(f)) continue;
            pruned.add(f);
        }
        return pruned;
    }

    protected static List getExcludedNames(List sourcePaths, String[] subpackagesList, String[] excludedPackages) {
        ArrayList excludedNames = new ArrayList();
        Iterator i = sourcePaths.iterator();
        while (i.hasNext()) {
            String path = (String)i.next();
            for (int j = 0; j < subpackagesList.length; ++j) {
                List excludes = JavadocUtil.getExcludedPackages(path, excludedPackages);
                excludedNames.addAll(excludes);
            }
        }
        return excludedNames;
    }

    protected static List getCompileArtifacts(Set artifacts) {
        return JavadocUtil.getCompileArtifacts(artifacts, false);
    }

    protected static List getCompileArtifacts(Set artifacts, boolean withTestScope) {
        ArrayList<Artifact> list = new ArrayList<Artifact>(artifacts.size());
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact a = (Artifact)i.next();
            if (!a.getArtifactHandler().isAddedToClasspath()) continue;
            if (withTestScope) {
                if (!"compile".equals(a.getScope()) && !"provided".equals(a.getScope()) && !"system".equals(a.getScope()) && !"test".equals(a.getScope())) continue;
                list.add(a);
                continue;
            }
            if (!"compile".equals(a.getScope()) && !"provided".equals(a.getScope()) && !"system".equals(a.getScope())) continue;
            list.add(a);
        }
        return list;
    }

    protected static String quotedArgument(String value) {
        String arg = value;
        if (StringUtils.isNotEmpty((String)arg)) {
            if (arg.indexOf("'") != -1) {
                arg = StringUtils.replace((String)arg, (String)"'", (String)"\\'");
            }
            arg = "'" + arg + "'";
            arg = StringUtils.replace((String)arg, (String)"\n", (String)" ");
        }
        return arg;
    }

    protected static String quotedPathArgument(String value) {
        String path = value;
        if (StringUtils.isNotEmpty((String)path)) {
            if ((path = path.replace('\\', '/')).indexOf("'") != -1) {
                String[] split = path.split("'");
                path = "";
                for (int i = 0; i < split.length; ++i) {
                    path = i != split.length - 1 ? path + split[i] + "\\'" : path + split[i];
                }
            }
            path = "'" + path + "'";
        }
        return path;
    }

    protected static void copyJavadocResources(File outputDirectory, File javadocDir) throws IOException {
        JavadocUtil.copyJavadocResources(outputDirectory, javadocDir, null);
    }

    protected static void copyJavadocResources(File outputDirectory, File javadocDir, String excludedocfilessubdir) throws IOException {
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.addAll(Arrays.asList(FileUtils.getDefaultExcludes()));
        if (StringUtils.isNotEmpty((String)excludedocfilessubdir)) {
            StringTokenizer st = new StringTokenizer(excludedocfilessubdir, ":");
            while (st.hasMoreTokens()) {
                String current = st.nextToken();
                excludes.add("**/" + current + "/*");
            }
        }
        if (javadocDir.exists() && javadocDir.isDirectory()) {
            List docFiles = FileUtils.getDirectoryNames((File)javadocDir, (String)"**/doc-files", (String)StringUtils.join(excludes.iterator(), (String)","), (boolean)false, (boolean)true);
            Iterator it = docFiles.iterator();
            while (it.hasNext()) {
                String docFile = (String)it.next();
                File docFileOutput = new File(outputDirectory, docFile);
                FileUtils.mkdir((String)docFileOutput.getAbsolutePath());
                FileUtils.copyDirectory((File)new File(javadocDir, docFile), (File)docFileOutput);
            }
        }
    }

    protected static List getIncludedFiles(File sourceDirectory, String[] fileList, String[] excludePackages) {
        ArrayList<String> files = new ArrayList<String>();
        for (int j = 0; j < fileList.length; ++j) {
            boolean include = true;
            for (int k = 0; k < excludePackages.length && include; ++k) {
                String[] excludeName = excludePackages[k].split("[*]");
                if (excludeName.length > 1) {
                    for (int u = 0; include && u < excludeName.length; ++u) {
                        if ("".equals(excludeName[u].trim()) || fileList[j].indexOf(excludeName[u]) == -1) continue;
                        include = false;
                    }
                    continue;
                }
                if (!fileList[j].startsWith(sourceDirectory.toString() + File.separatorChar + excludeName[0])) continue;
                if (excludeName[0].endsWith(String.valueOf(File.separatorChar))) {
                    File excludedPackage;
                    int i = fileList[j].lastIndexOf(File.separatorChar);
                    String packageName = fileList[j].substring(0, i + 1);
                    File currentPackage = new File(packageName);
                    if (currentPackage.equals(excludedPackage = new File(sourceDirectory, excludeName[0])) && fileList[j].substring(i).indexOf(".java") != -1) {
                        include = true;
                        continue;
                    }
                    include = false;
                    continue;
                }
                include = false;
            }
            if (!include) continue;
            files.add(JavadocUtil.quotedPathArgument(fileList[j]));
        }
        return files;
    }

    protected static List getExcludedPackages(String sourceDirectory, String[] excludePackagenames) {
        ArrayList<String> files = new ArrayList<String>();
        for (int i = 0; i < excludePackagenames.length; ++i) {
            String[] fileList = FileUtils.getFilesFromExtension((String)sourceDirectory, (String[])new String[]{"java"});
            for (int j = 0; j < fileList.length; ++j) {
                String[] excludeName = excludePackagenames[i].split("[*]");
                for (int u = 0; u < excludeName.length; ++u) {
                    if ("".equals(excludeName[u].trim()) || fileList[j].indexOf(excludeName[u]) == -1 || sourceDirectory.indexOf(excludeName[u]) != -1) continue;
                    files.add(fileList[j]);
                }
            }
        }
        ArrayList<String> excluded = new ArrayList<String>();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            String file = (String)it.next();
            int idx = file.lastIndexOf(File.separatorChar);
            String tmpStr = file.substring(0, idx);
            String[] srcSplit = (tmpStr = tmpStr.replace('\\', '/')).split(sourceDirectory.replace('\\', '/') + '/');
            String excludedPackage = srcSplit[1].replace('/', '.');
            if (excluded.contains(excludedPackage)) continue;
            excluded.add(excludedPackage);
        }
        return excluded;
    }

    protected static void addFilesFromSource(List files, File sourceDirectory, String[] excludePackages) {
        String[] fileList = FileUtils.getFilesFromExtension((String)sourceDirectory.getPath(), (String[])new String[]{"java"});
        if (fileList != null && fileList.length != 0) {
            List tmpFiles = JavadocUtil.getIncludedFiles(sourceDirectory, fileList, excludePackages);
            files.addAll(tmpFiles);
        }
    }

    protected static float getJavadocVersion(File javadocExe) throws IOException, CommandLineException, IllegalArgumentException, PatternSyntaxException {
        if (javadocExe == null || !javadocExe.exists() || !javadocExe.isFile()) {
            throw new IOException("The javadoc executable '" + javadocExe + "' doesn't exist or is not a file. ");
        }
        Commandline cmd = new Commandline();
        cmd.setExecutable(javadocExe.getAbsolutePath());
        cmd.setWorkingDirectory(javadocExe.getParentFile());
        cmd.createArg().setValue("-J-version");
        CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        int exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)out, (StreamConsumer)err);
        if (exitCode != 0) {
            StringBuffer msg = new StringBuffer("Exit code: " + exitCode + " - " + err.getOutput());
            msg.append('\n');
            msg.append("Command line was:" + CommandLineUtils.toString((String[])cmd.getCommandline()));
            throw new CommandLineException(msg.toString());
        }
        if (StringUtils.isNotEmpty((String)err.getOutput())) {
            return JavadocUtil.parseJavadocVersion(err.getOutput());
        }
        if (StringUtils.isNotEmpty((String)out.getOutput())) {
            return JavadocUtil.parseJavadocVersion(out.getOutput());
        }
        throw new IllegalArgumentException("No output found from the command line 'javadoc -J-version'");
    }

    protected static float parseJavadocVersion(String output) throws IllegalArgumentException, PatternSyntaxException {
        if (StringUtils.isEmpty((String)output)) {
            throw new IllegalArgumentException("The output could not be null.");
        }
        Pattern pattern = Pattern.compile("(?s).*?([0-9]+\\.[0-9]+)(\\.([0-9]+))?.*");
        Matcher matcher = pattern.matcher(output);
        if (!matcher.matches()) {
            throw new PatternSyntaxException("Unrecognized version of Javadoc: '" + output + "'", pattern.pattern(), pattern.toString().length() - 1);
        }
        String version = matcher.group(3);
        version = version == null ? matcher.group(1) : matcher.group(1) + version;
        return Float.parseFloat(version);
    }

    protected static String parseJavadocMemory(String memory) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)memory)) {
            throw new IllegalArgumentException("The memory could not be null.");
        }
        Pattern p = Pattern.compile("^\\s*(\\d+)\\s*?\\s*$");
        Matcher m = p.matcher(memory);
        if (m.matches()) {
            return m.group(1) + "m";
        }
        p = Pattern.compile("^\\s*(\\d+)\\s*k(b)?\\s*$", 2);
        m = p.matcher(memory);
        if (m.matches()) {
            return m.group(1) + "k";
        }
        p = Pattern.compile("^\\s*(\\d+)\\s*m(b)?\\s*$", 2);
        m = p.matcher(memory);
        if (m.matches()) {
            return m.group(1) + "m";
        }
        p = Pattern.compile("^\\s*(\\d+)\\s*g(b)?\\s*$", 2);
        m = p.matcher(memory);
        if (m.matches()) {
            return Integer.parseInt(m.group(1)) * 1024 + "m";
        }
        p = Pattern.compile("^\\s*(\\d+)\\s*t(b)?\\s*$", 2);
        m = p.matcher(memory);
        if (m.matches()) {
            return Integer.parseInt(m.group(1)) * 1024 * 1024 + "m";
        }
        throw new IllegalArgumentException("Could convert not to a memory size: " + memory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void fetchURL(Settings settings, URL url) throws IOException {
        Proxy activeProxy;
        String scheme;
        if (url == null) {
            throw new IOException("The url is null");
        }
        Properties oldSystemProperties = new Properties();
        oldSystemProperties.putAll((Map<?, ?>)System.getProperties());
        if (settings != null && !"file".equals(scheme = url.getProtocol()) && (activeProxy = settings.getActiveProxy()) != null) {
            scheme = "http".equals(scheme) || "https".equals(scheme) || "ftp".equals(scheme) ? scheme + "." : "";
            if (StringUtils.isNotEmpty((String)activeProxy.getHost())) {
                String userName;
                Properties systemProperties = System.getProperties();
                systemProperties.setProperty(scheme + "proxySet", "true");
                systemProperties.setProperty(scheme + "proxyHost", activeProxy.getHost());
                if (activeProxy.getPort() > 0) {
                    systemProperties.setProperty(scheme + "proxyPort", String.valueOf(activeProxy.getPort()));
                }
                if (StringUtils.isNotEmpty((String)activeProxy.getNonProxyHosts())) {
                    systemProperties.setProperty(scheme + "nonProxyHosts", activeProxy.getNonProxyHosts());
                }
                if (StringUtils.isNotEmpty((String)(userName = activeProxy.getUsername()))) {
                    final String pwd = StringUtils.isEmpty((String)activeProxy.getPassword()) ? "" : activeProxy.getPassword();
                    Authenticator.setDefault(new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(userName, pwd.toCharArray());
                        }
                    });
                }
            }
        }
        InputStream in = null;
        try {
            in = url.openStream();
        }
        finally {
            IOUtil.close((InputStream)in);
            if (settings != null && !"file".equals(url.getProtocol()) && settings.getActiveProxy() != null && StringUtils.isNotEmpty((String)settings.getActiveProxy().getHost())) {
                System.setProperties(oldSystemProperties);
                Authenticator.setDefault(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean validateEncoding(String charsetName) {
        if (StringUtils.isEmpty((String)charsetName)) {
            return false;
        }
        ByteArrayOutputStream ost = new ByteArrayOutputStream();
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)ost, charsetName);
        }
        catch (UnsupportedEncodingException exc) {
            boolean bl;
            try {
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtil.close(osw);
                throw throwable;
            }
            IOUtil.close((Writer)osw);
            return bl;
        }
        IOUtil.close((Writer)osw);
        return true;
    }

    protected static String hideProxyPassword(String cmdLine, Settings settings) {
        if (cmdLine == null) {
            throw new IllegalArgumentException("cmdLine could not be null");
        }
        if (settings == null) {
            return cmdLine;
        }
        Proxy activeProxy = settings.getActiveProxy();
        if (activeProxy != null && StringUtils.isNotEmpty((String)activeProxy.getHost()) && StringUtils.isNotEmpty((String)activeProxy.getUsername()) && StringUtils.isNotEmpty((String)activeProxy.getPassword())) {
            String pass = "-J-Dhttp.proxyPassword=\"" + activeProxy.getPassword() + "\"";
            String hidepass = "-J-Dhttp.proxyPassword=\"" + StringUtils.repeat((String)"*", (int)activeProxy.getPassword().length()) + "\"";
            return StringUtils.replace((String)cmdLine, (String)pass, (String)hidepass);
        }
        return cmdLine;
    }

    protected static List getTagletClassNames(File jarFile) throws IOException, ClassNotFoundException, NoClassDefFoundError {
        List classes = JavadocUtil.getClassNamesFromJar(jarFile);
        File tools = new File(System.getProperty("java.home"), "../lib/tools.jar");
        URLClassLoader cl = tools.exists() && tools.isFile() ? new URLClassLoader(new URL[]{jarFile.toURI().toURL(), tools.toURI().toURL()}, null) : new URLClassLoader(new URL[]{jarFile.toURI().toURL()}, null);
        ArrayList<String> tagletClasses = new ArrayList<String>();
        Class<?> tagletClass = cl.loadClass("com.sun.tools.doclets.Taglet");
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            Class<?> c = cl.loadClass(s);
            if (!tagletClass.isAssignableFrom(c) || Modifier.isAbstract(c.getModifiers())) continue;
            tagletClasses.add(c.getName());
        }
        return tagletClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getClassNamesFromJar(File jarFile) throws IOException {
        if (jarFile == null || !jarFile.exists() || !jarFile.isFile()) {
            throw new IOException("The jar '" + jarFile + "' doesn't exist or is not a file.");
        }
        ArrayList<String> classes = new ArrayList<String>();
        JarInputStream jarStream = null;
        try {
            jarStream = new JarInputStream(new FileInputStream(jarFile));
            JarEntry jarEntry = jarStream.getNextJarEntry();
            while (jarEntry != null && jarEntry != null) {
                if (jarEntry.getName().toLowerCase(Locale.ENGLISH).endsWith(".class")) {
                    String name = jarEntry.getName().substring(0, jarEntry.getName().indexOf("."));
                    classes.add(name.replaceAll("/", "\\."));
                }
                jarStream.closeEntry();
                jarEntry = jarStream.getNextJarEntry();
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(jarStream);
            throw throwable;
        }
        IOUtil.close((InputStream)jarStream);
        return classes;
    }
}

