/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.varia;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.ULogger;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.rule.ExpressionRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.ComponentBase;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class LogFilePatternReceiver
extends Receiver {
    private final Set keywords = new HashSet();
    private static final String PROP_START = "PROP(";
    private static final String PROP_END = ")";
    private static final String LOGGER = "LOGGER";
    private static final String MESSAGE = "MESSAGE";
    private static final String TIMESTAMP = "TIMESTAMP";
    private static final String NDC = "NDC";
    private static final String LEVEL = "LEVEL";
    private static final String THREAD = "THREAD";
    private static final String CLASS = "CLASS";
    private static final String FILE = "FILE";
    private static final String LINE = "LINE";
    private static final String METHOD = "METHOD";
    private static final String DEFAULT_HOST = "file";
    private static final String EXCEPTION_PATTERN = "\tat.*";
    private static final String REGEXP_DEFAULT_WILDCARD = ".+?";
    private static final String REGEXP_GREEDY_WILDCARD = ".+";
    private static final String PATTERN_WILDCARD = "*";
    private static final String DEFAULT_GROUP = "(.+?)";
    private static final String GREEDY_GROUP = "(.+)";
    private final String newLine = System.getProperty("line.separator");
    private final String[] emptyException = new String[]{""};
    private SimpleDateFormat dateFormat;
    private String timestampFormat = "yyyy-MM-d HH:mm:ss,SSS";
    private String logFormat;
    private String fileURL;
    private String host;
    private String path;
    private boolean tailing;
    private String filterExpression;
    private Perl5Util util = null;
    private Perl5Compiler exceptionCompiler = null;
    private Perl5Matcher exceptionMatcher = null;
    private static final String VALID_DATEFORMAT_CHAR_PATTERN = "[GyMwWDdFEaHkKhmsSzZ]";
    private Rule expressionRule;
    private Map currentMap;
    private List additionalLines;
    private List matchingKeywords;
    private String regexp;
    private Reader reader;
    private String timestampPatternText;

    public LogFilePatternReceiver() {
        this.keywords.add(TIMESTAMP);
        this.keywords.add(LOGGER);
        this.keywords.add(LEVEL);
        this.keywords.add(THREAD);
        this.keywords.add(CLASS);
        this.keywords.add(FILE);
        this.keywords.add(LINE);
        this.keywords.add(METHOD);
        this.keywords.add(MESSAGE);
        this.keywords.add(NDC);
    }

    public String getFileURL() {
        return this.fileURL;
    }

    public void setFileURL(String fileURL) {
        this.fileURL = fileURL;
    }

    public String getFilterExpression() {
        return this.filterExpression;
    }

    public void setFilterExpression(String filterExpression) {
        this.filterExpression = filterExpression;
    }

    public boolean isTailing() {
        return this.tailing;
    }

    public void setTailing(boolean tailing) {
        this.tailing = tailing;
    }

    public String getLogFormat() {
        return this.logFormat;
    }

    public void setLogFormat(String logFormat) {
        this.logFormat = logFormat;
    }

    public void setTimestampFormat(String timestampFormat) {
        this.timestampFormat = timestampFormat;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    private int getExceptionLine() {
        try {
            Pattern exceptionPattern = this.exceptionCompiler.compile(EXCEPTION_PATTERN);
            int i = 0;
            while (i < this.additionalLines.size()) {
                if (this.exceptionMatcher.matches((String)this.additionalLines.get(i), exceptionPattern)) {
                    return i - 1;
                }
                ++i;
            }
        }
        catch (MalformedPatternException mpe) {
            this.getLogger().warn("Bad pattern: \tat.*");
        }
        return -1;
    }

    private String buildMessage(String firstMessageLine, int exceptionLine) {
        if (this.additionalLines.size() == 0 || exceptionLine == 0) {
            return firstMessageLine;
        }
        StringBuffer message = new StringBuffer();
        if (firstMessageLine != null) {
            message.append(firstMessageLine);
        }
        int linesToProcess = exceptionLine == -1 ? this.additionalLines.size() : exceptionLine;
        int i = 0;
        while (i < linesToProcess) {
            message.append(this.newLine);
            message.append(this.additionalLines.get(i));
            ++i;
        }
        return message.toString();
    }

    private String[] buildException(int exceptionLine) {
        if (exceptionLine == -1) {
            return this.emptyException;
        }
        String[] exception = new String[this.additionalLines.size() - exceptionLine];
        int i = 0;
        while (i < this.additionalLines.size() - exceptionLine) {
            exception[i] = (String)this.additionalLines.get(i + exceptionLine);
            ++i;
        }
        return exception;
    }

    private LoggingEvent buildEvent() {
        if (this.currentMap.size() == 0) {
            if (this.additionalLines.size() > 0) {
                Iterator iter = this.additionalLines.iterator();
                while (iter.hasNext()) {
                    this.getLogger().info("found non-matching line: " + iter.next());
                }
            }
            this.additionalLines.clear();
            return null;
        }
        int exceptionLine = this.getExceptionLine();
        String[] exception = this.buildException(exceptionLine);
        if (this.additionalLines.size() > 0 && exceptionLine != 0) {
            this.currentMap.put(MESSAGE, this.buildMessage((String)this.currentMap.get(MESSAGE), exceptionLine));
        }
        LoggingEvent event = this.convertToEvent(this.currentMap, exception);
        this.currentMap.clear();
        this.additionalLines.clear();
        return event;
    }

    protected void process(Reader unbufferedReader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(unbufferedReader);
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern regexpPattern = null;
        try {
            regexpPattern = compiler.compile(this.regexp);
        }
        catch (MalformedPatternException mpe) {
            throw new RuntimeException("Bad pattern: " + this.regexp);
        }
        Perl5Matcher eventMatcher = new Perl5Matcher();
        String line = null;
        this.getLogger().debug("tailing file: " + this.tailing);
        while (true) {
            LoggingEvent event;
            if ((line = bufferedReader.readLine()) != null) {
                if (eventMatcher.matches(line, regexpPattern)) {
                    event = this.buildEvent();
                    if (event != null && this.passesExpression(event)) {
                        this.doPost(event);
                    }
                    this.currentMap.putAll(this.processEvent(eventMatcher.getMatch()));
                    continue;
                }
                this.additionalLines.add(line);
                continue;
            }
            event = this.buildEvent();
            if (event != null) {
                if (this.passesExpression(event)) {
                    this.doPost(event);
                }
                this.getLogger().debug("no further lines to process in " + this.fileURL);
            }
            try {
                LogFilePatternReceiver logFilePatternReceiver = this;
                synchronized (logFilePatternReceiver) {
                    this.wait(2000L);
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (!this.tailing) break;
        }
        this.getLogger().debug("processing " + this.fileURL + " complete");
        this.shutdown();
    }

    private boolean passesExpression(LoggingEvent event) {
        if (event != null && this.expressionRule != null) {
            return this.expressionRule.evaluate(event);
        }
        return true;
    }

    private Map processEvent(MatchResult result) {
        HashMap map = new HashMap();
        int i = 1;
        while (i < result.groups()) {
            map.put(this.matchingKeywords.get(i - 1), result.group(i));
            ++i;
        }
        return map;
    }

    private String convertTimestamp() {
        return this.util.substitute("s/([GyMwWDdFEaHkKhmsSzZ])+/\\\\w+/g", this.timestampFormat);
    }

    protected void setHost(String host) {
        this.host = host;
    }

    protected void setPath(String path) {
        this.path = path;
    }

    protected void initialize() {
        if (this.host == null && this.path == null) {
            try {
                URL url = new URL(this.fileURL);
                this.host = url.getHost();
                this.path = url.getPath();
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
        }
        if (this.host == null || this.host.trim().equals("")) {
            this.host = DEFAULT_HOST;
        }
        if (this.path == null || this.path.trim().equals("")) {
            this.path = this.fileURL;
        }
        this.util = new Perl5Util();
        this.exceptionCompiler = new Perl5Compiler();
        this.exceptionMatcher = new Perl5Matcher();
        this.currentMap = new HashMap();
        this.additionalLines = new ArrayList();
        this.matchingKeywords = new ArrayList();
        if (this.timestampFormat != null) {
            this.dateFormat = new SimpleDateFormat(this.timestampFormat);
            this.timestampPatternText = this.convertTimestamp();
        }
        try {
            if (this.filterExpression != null) {
                this.expressionRule = ExpressionRule.getRule(this.filterExpression);
            }
        }
        catch (Exception e) {
            this.getLogger().warn((Object)("Invalid filter expression: " + this.filterExpression), e);
        }
        TreeMap<Integer, String> keywordMap = new TreeMap<Integer, String>();
        String newPattern = this.logFormat;
        int index = 0;
        int currentPosition = 0;
        String current = newPattern;
        while (index > -1) {
            index = current.indexOf(PROP_START);
            currentPosition += index;
            if (index <= -1) continue;
            String currentProp = current.substring(current.indexOf(PROP_START));
            String prop = currentProp.substring(0, currentProp.indexOf(PROP_END) + 1);
            current = current.substring(current.indexOf(currentProp) + 1);
            String shortProp = prop.substring(PROP_START.length(), prop.length() - 1);
            keywordMap.put(new Integer(currentPosition), shortProp);
            newPattern = this.replace(prop, shortProp, newPattern);
        }
        newPattern = this.replaceMetaChars(newPattern);
        newPattern = this.replace(PATTERN_WILDCARD, REGEXP_DEFAULT_WILDCARD, newPattern);
        Iterator iter = this.keywords.iterator();
        while (iter.hasNext()) {
            String keyword = (String)iter.next();
            int index2 = newPattern.indexOf(keyword);
            if (index2 <= -1) continue;
            keywordMap.put(new Integer(index2), keyword);
        }
        this.matchingKeywords.addAll(keywordMap.values());
        String currentPattern = newPattern;
        int i = 0;
        while (i < this.matchingKeywords.size()) {
            String keyword = (String)this.matchingKeywords.get(i);
            currentPattern = i == this.matchingKeywords.size() - 1 ? this.replace(keyword, GREEDY_GROUP, currentPattern) : (TIMESTAMP.equals(keyword) ? this.replace(keyword, "(" + this.timestampPatternText + PROP_END, currentPattern) : this.replace(keyword, DEFAULT_GROUP, currentPattern));
            ++i;
        }
        this.regexp = currentPattern;
        this.getLogger().debug("regexp is " + this.regexp);
    }

    private String replace(String pattern, String replacement, String input) {
        return this.util.substitute("s/" + Perl5Compiler.quotemeta((String)pattern) + "/" + Perl5Compiler.quotemeta((String)replacement) + "/g", input);
    }

    private String replaceMetaChars(String input) {
        input = this.replace("(", "\\(", input);
        input = this.replace(PROP_END, "\\)", input);
        input = this.replace("[", "\\[", input);
        input = this.replace("]", "\\]", input);
        input = this.replace("{", "\\{", input);
        input = this.replace("}", "\\}", input);
        input = this.replace("#", "\\#", input);
        input = this.replace("/", "\\/", input);
        return input;
    }

    private LoggingEvent convertToEvent(Map fieldMap, String[] exception) {
        if (fieldMap == null) {
            return null;
        }
        if (!fieldMap.containsKey(LOGGER)) {
            fieldMap.put(LOGGER, "Unknown");
        }
        if (exception == null) {
            exception = this.emptyException;
        }
        Logger logger = null;
        long timeStamp = 0L;
        String level = null;
        String threadName = null;
        String message = null;
        String ndc = null;
        String className = null;
        String methodName = null;
        String eventFileName = null;
        String lineNumber = null;
        Hashtable<String, String> properties = new Hashtable<String, String>();
        logger = Logger.getLogger((String)fieldMap.remove(LOGGER));
        if (this.dateFormat != null && fieldMap.containsKey(TIMESTAMP)) {
            try {
                timeStamp = this.dateFormat.parse((String)fieldMap.remove(TIMESTAMP)).getTime();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (timeStamp == 0L) {
            timeStamp = System.currentTimeMillis();
        }
        level = (String)fieldMap.remove(LEVEL);
        Level levelImpl = Level.toLevel(level);
        threadName = (String)fieldMap.remove(THREAD);
        message = (String)fieldMap.remove(MESSAGE);
        if (message == null) {
            message = "";
        }
        ndc = (String)fieldMap.remove(NDC);
        className = (String)fieldMap.remove(CLASS);
        methodName = (String)fieldMap.remove(METHOD);
        eventFileName = (String)fieldMap.remove(FILE);
        lineNumber = (String)fieldMap.remove(LINE);
        properties.put("hostname", this.host);
        properties.put("application", this.path);
        properties.putAll(fieldMap);
        LocationInfo info = null;
        info = eventFileName != null || className != null || methodName != null || lineNumber != null ? new LocationInfo(eventFileName, className, methodName, lineNumber) : LocationInfo.NA_LOCATION_INFO;
        LoggingEvent event = new LoggingEvent();
        event.setLogger(logger);
        event.setTimeStamp(timeStamp);
        event.setLevel(levelImpl);
        event.setThreadName(threadName);
        event.setMessage(message);
        event.setThrowableInformation(new ThrowableInformation(exception));
        event.setLocationInformation(info);
        event.setNDC(ndc);
        event.setProperties(properties);
        return event;
    }

    public static void main(String[] args) {
    }

    public void shutdown() {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void activateOptions() {
        new Thread(new Runnable(){

            public void run() {
                LogFilePatternReceiver.this.initialize();
                while (LogFilePatternReceiver.this.reader == null) {
                    ComponentBase.access$101((LogFilePatternReceiver)LogFilePatternReceiver.this).info("attempting to load file: " + LogFilePatternReceiver.this.getFileURL());
                    try {
                        LogFilePatternReceiver.this.reader = new InputStreamReader(new URL(LogFilePatternReceiver.this.getFileURL()).openStream());
                    }
                    catch (FileNotFoundException fnfe) {
                        ComponentBase.access$201((LogFilePatternReceiver)LogFilePatternReceiver.this).info("file not available - will try again in 10 seconds");
                        1 var2_3 = this;
                        synchronized (var2_3) {
                            try {
                                this.wait(10000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    catch (IOException ioe) {
                        ComponentBase.access$301((LogFilePatternReceiver)LogFilePatternReceiver.this).warn((Object)"unable to load file", ioe);
                        return;
                    }
                }
                try {
                    LogFilePatternReceiver.this.process(LogFilePatternReceiver.this.reader);
                }
                catch (IOException ioe) {
                    ComponentBase.access$401((LogFilePatternReceiver)LogFilePatternReceiver.this).info("stream closed");
                }
            }
        }).start();
    }

    static /* synthetic */ ULogger access$101(LogFilePatternReceiver x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ULogger access$201(LogFilePatternReceiver x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ULogger access$301(LogFilePatternReceiver x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ULogger access$401(LogFilePatternReceiver x0) {
        return x0.getLogger();
    }
}

