/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbPreparedStatement;
import com.tmax.tibero.jdbc.TbRSFwOnly;
import com.tmax.tibero.jdbc.TbRSScrollable;
import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.TbSQLWarning;
import com.tmax.tibero.jdbc.TbStatement;
import com.tmax.tibero.jdbc.data.Row;
import com.tmax.tibero.jdbc.util.TbError;
import com.tmax.tibero.jdbc.util.TbSqlParser;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class TbRSSensitive
extends TbRSScrollable {
    protected TbPreparedStatement refetchStmt = null;
    private int[] rowIndices = null;
    private List refetchRowids = null;
    private int lastRowIdParamCnt = 0;
    private int startRowIndex = -1;
    private int stopRowIndex = -1;

    public void reset() {
        super.reset();
        this.refetchStmt = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        try {
            super.close();
        }
        finally {
            if (this.refetchStmt != null) {
                try {
                    this.refetchStmt.close();
                }
                catch (Exception exception) {
                }
                finally {
                    this.refetchStmt = null;
                }
            }
        }
    }

    public String ToString() {
        StringBuffer buf = new StringBuffer(128);
        buf.append(this.toString());
        return buf.toString();
    }

    protected TbRSSensitive(TbStatement stmt, int cursorId, int colCnt, int hiddenColCnt) throws SQLException {
        super(stmt, cursorId, colCnt, hiddenColCnt);
        this.rowIndices = new int[stmt.getFetchSize()];
        this.refetchRowids = new ArrayList(stmt.getFetchSize());
    }

    protected int fetchRowsChunk() throws SQLException {
        int fetchCnt = super.fetchRowsChunk();
        if (fetchCnt > 0) {
            this.stopRowIndex = this.rowsFetchedCnt - 1;
            this.startRowIndex = this.rowsFetchedCnt - fetchCnt;
        }
        return fetchCnt;
    }

    protected boolean isCurrentWindow(int rowIndex) {
        return rowIndex >= this.startRowIndex && rowIndex <= this.stopRowIndex;
    }

    public synchronized void refreshRow() throws SQLException {
        if (this.isCurrentWindow(this.currentRowIndex)) {
            return;
        }
        int realRefetchSize = this.refreshRowForced(this.fetchSize);
        if (this.fetchDirection == 1000) {
            this.startRowIndex = this.currentRowIndex;
            this.stopRowIndex = this.currentRowIndex + realRefetchSize - 1;
        } else {
            this.startRowIndex = this.currentRowIndex - realRefetchSize + 1;
            this.stopRowIndex = this.currentRowIndex;
        }
    }

    protected int refreshRowForced(int refetchSize) throws SQLException {
        if (!this.rsetType.useRowId()) {
            throw new TbSQLException(-90201, "unsupported ResultSet type:Forward-Only+Read-Only or Scroll-Insensitive+Read-Only");
        }
        try {
            int realRefetchSize = this.fillRowIndexForRefetch(refetchSize);
            this.buildRefetchStatement(realRefetchSize);
            this.refreshCachedRows(realRefetchSize);
            return realRefetchSize;
        }
        catch (SQLException sqe) {
            throw new TbSQLException(-90626, TbError.trimVendorHeader(sqe.getMessage()));
        }
    }

    private int fillRowIndexForRefetch(int refetchSize) throws SQLException {
        int index = 0;
        if (this.fetchDirection == 1001) {
            int stopIndex = Math.max(this.currentRowIndex - refetchSize, 0);
            int rowIndex = this.currentRowIndex;
            while (rowIndex > stopIndex) {
                this.rowIndices[index] = rowIndex;
                this.refetchRowids.add(index, this.getRowAt(rowIndex).getRawBytes(1));
                --rowIndex;
                ++index;
            }
        } else {
            int stopIndex = Math.min(this.currentRowIndex + refetchSize, this.rowsFetchedCnt);
            int rowIndex = this.currentRowIndex;
            while (rowIndex < stopIndex) {
                this.rowIndices[index] = rowIndex;
                this.refetchRowids.add(index, this.getRowAt(rowIndex).getRawBytes(1));
                ++rowIndex;
                ++index;
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildRefetchStatement(int realRefetchSize) throws SQLException {
        if (this.lastRowIdParamCnt != realRefetchSize) {
            if (this.refetchStmt != null) {
                try {
                    this.refetchStmt.close();
                }
                catch (SQLException sqe) {
                    this.addWarning(new TbSQLWarning(-590708, TbError.trimVendorHeader(sqe.getMessage())));
                }
                finally {
                    this.refetchStmt = null;
                }
            }
            String sql = TbSqlParser.getRowIdAddedRefetchSql(this.stmt.getSqlWithRowId(), realRefetchSize);
            this.refetchStmt = new TbPreparedStatement(this.stmt.conn, sql);
            this.lastRowIdParamCnt = realRefetchSize;
            if (this.stmt instanceof TbPreparedStatement) {
                this.refetchStmt.copyBindData(((TbPreparedStatement)this.stmt).getBindData());
            }
        }
        int totalParamCnt = this.refetchStmt.getBindData().getParameterCnt();
        int rowIdParamStartIndex = totalParamCnt - this.lastRowIdParamCnt;
        for (int i = 0; i < this.lastRowIdParamCnt; ++i) {
            this.refetchStmt.setBytes(rowIdParamStartIndex + i + 1, 15, (byte[])this.refetchRowids.get(i));
        }
    }

    private boolean isByteArrayEqual(byte[] src, byte[] dst) {
        if (src.length != dst.length) {
            return false;
        }
        for (int i = 0; i < src.length; ++i) {
            if (src[i] == dst[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshCachedRows(int realRefetchSize) throws SQLException {
        this.refetchStmt.setFetchSize(realRefetchSize);
        TbRSFwOnly rs = (TbRSFwOnly)this.refetchStmt.executeQuery();
        block5: while (rs.next()) {
            byte[] rowid = rs.getBytes(1);
            for (int i = 0; i < realRefetchSize; ++i) {
                if (!this.isByteArrayEqual(rowid, (byte[])this.refetchRowids.get(i))) continue;
                Row row = rs.getCurrentRow();
                this.setRowAt(this.rowIndices[i], row);
                continue block5;
            }
        }
        try {
            rs.setResetRows(false);
            rs.close();
        }
        catch (SQLException sqe) {
            this.addWarning(new TbSQLWarning(-590708, TbError.trimVendorHeader(sqe.getMessage())));
        }
        finally {
            rs = null;
        }
    }

    public synchronized boolean first() throws SQLException {
        if (super.first()) {
            this.refreshRow();
            return true;
        }
        return false;
    }

    public synchronized boolean last() throws SQLException {
        if (super.last()) {
            this.refreshRow();
            return true;
        }
        return false;
    }

    public synchronized boolean absolute(int rowIndex) throws SQLException {
        if (super.absolute(rowIndex)) {
            this.refreshRow();
            return true;
        }
        return false;
    }

    public synchronized boolean relative(int row) throws SQLException {
        if (super.relative(row)) {
            this.refreshRow();
            return true;
        }
        return false;
    }

    public synchronized boolean previous() throws SQLException {
        if (super.previous()) {
            this.refreshRow();
            return true;
        }
        return false;
    }

    public synchronized boolean next() throws SQLException {
        if (super.next()) {
            this.refreshRow();
            return true;
        }
        return false;
    }

    protected void removeCurrentRow() throws SQLException {
        this.checkRowIndex(this.currentRowIndex);
        this.rows.remove(this.currentRowIndex);
        if (this.currentRowIndex < this.startRowIndex) {
            --this.startRowIndex;
        }
        if (this.currentRowIndex < this.stopRowIndex) {
            --this.stopRowIndex;
        }
        --this.currentRowIndex;
        --this.rowsFetchedCnt;
    }
}

