/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbConnection;
import com.tmax.tibero.jdbc.TbResultSet;
import com.tmax.tibero.jdbc.TbResultSetMetaData;
import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.TbStatement;
import com.tmax.tibero.jdbc.data.Column;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.RawData;
import com.tmax.tibero.jdbc.data.Row;
import com.tmax.tibero.jdbc.data.RsetBuilder;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;

public abstract class TbResultSetBase
extends TbResultSet {
    protected TbStatement stmt = null;
    protected int cursorId = -1;
    protected DataTypeConverter typeConverter = null;
    protected int colCnt = -1;
    private Column[] cols;
    protected HashMap columnNameMap = null;
    protected int beginColumnIndex = 0;
    protected int currentRowIndex = -1;
    protected int rowsFetchedCnt = 0;
    protected int fetchDirection = 1000;
    protected int fetchSize = 50;
    protected boolean lastColumnWasNull = false;
    protected boolean fetchComplete = false;
    protected boolean isRsetClosed = false;
    protected boolean isSvrCsrClosed = false;
    private boolean closeStatementOnClose = false;

    protected TbResultSetBase(TbStatement stmt, int cursorId, int colCnt, int hiddenColCnt) throws SQLException {
        super(RsetBuilder.RSET, stmt.getRealRsetType(), -1L);
        if (stmt == null) {
            throw new TbSQLException(-90608);
        }
        this.stmt = stmt;
        this.cursorId = cursorId;
        this.typeConverter = stmt.conn.getTypeConverter();
        this.colCnt = colCnt + hiddenColCnt;
        this.fetchDirection = stmt.getFetchDirection();
        this.fetchSize = stmt.getFetchSize();
        this.closeStatementOnClose = false;
        this.beginColumnIndex = hiddenColCnt + (stmt.getRealRsetType().useRowId() ? 1 : 0);
        this.makeColumnMetaArray(this.colCnt);
    }

    private void buildColumnNameMap() {
        this.columnNameMap = new HashMap();
        for (int i = this.getColumnCount() - 1; i >= 0; --i) {
            this.columnNameMap.put(this.cols[i + this.beginColumnIndex].getName().toUpperCase(), new Integer(i + 1));
        }
    }

    public Row[] buildRowData(int rowCnt) {
        Row[] rows = null;
        try {
            rows = this.getRows(rowCnt);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.stmt.getRowChunkMgr().makeRowData(rows, rowCnt, this.getCols());
        return rows;
    }

    public void checkColumnPos(int index) throws SQLException {
        if (this.getColumnCount() < 0) {
            throw new TbSQLException(-90607);
        }
        if (index <= 0 || index > this.getColumnCount()) {
            throw new TbSQLException(-90609);
        }
    }

    private void checkRsetAndConnClosed() throws SQLException {
        if (this.isRsetClosed) {
            throw new TbSQLException(-90646);
        }
        if (this.isSvrCsrClosed) {
            throw new TbSQLException(-90647);
        }
        if (this.stmt.conn == null || this.stmt.conn.isClosed()) {
            throw new TbSQLException(-90603);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        if (this.isRsetClosed) {
            return;
        }
        try {
            this.closeCursor();
        }
        catch (SQLException sqe) {
        }
        finally {
            this.reset();
            this.isRsetClosed = true;
            if (this.closeStatementOnClose) {
                try {
                    this.stmt.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    public synchronized void closeCursor() throws SQLException {
        if (this.isSvrCsrClosed) {
            return;
        }
        if (this.stmt != null && (((TbConnection)this.stmt.getConnection()).isPooledConnection || !((TbConnection)this.stmt.getConnection()).isSessionClosed()) && this.rsetBuilder.equals(RsetBuilder.RSET)) {
            ((TbConnection)this.stmt.getConnection()).closeCursor(this, this.cursorId);
        }
        this.isSvrCsrClosed = true;
    }

    public void closeStatementOnClose() {
        this.closeStatementOnClose = true;
    }

    private void columnClear() {
        for (int i = 0; i < this.cols.length; ++i) {
            this.cols[i].reset();
            this.cols[i] = null;
        }
        this.cols = null;
    }

    protected int fetchRowsChunk() throws SQLException {
        Row[] rows = this.stmt.fetch(this);
        if (rows == null) {
            throw new TbSQLException(-90500, " returned no result ");
        }
        int fetchCnt = this.addRows(rows);
        return fetchCnt;
    }

    public synchronized int findColumn(String columnName) throws SQLException {
        return this.getColumnIndex(columnName);
    }

    public synchronized InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkRsetAndConnClosed();
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return null;
        }
        return this.typeConverter.toAsciiStream(this.getColumnDataType(columnIndex), this.getRowData(columnIndex));
    }

    public int getBeginColumnIndex() {
        return this.beginColumnIndex;
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getBigDecimal(columnIndex, 0);
    }

    public synchronized BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.checkRsetAndConnClosed();
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return null;
        }
        return this.typeConverter.toBigDecimal(this.getColumnDataType(columnIndex), this.getRowData(columnIndex));
    }

    public synchronized InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkRsetAndConnClosed();
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return null;
        }
        return this.typeConverter.toBinaryStream(this.getColumnDataType(columnIndex), this.getRowData(columnIndex));
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkRsetAndConnClosed();
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return null;
        }
        return this.typeConverter.toBlob(this.getColumnDataType(columnIndex), this.getRowData(columnIndex));
    }

    public synchronized boolean getBoolean(int columnIndex) throws SQLException {
        this.checkRsetAndConnClosed();
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return false;
        }
        return this.typeConverter.toBoolean(this.getColumnDataType(columnIndex), this.getRowData(columnIndex));
    }

    public synchronized byte getByte(int columnIndex) throws SQLException {
        this.checkRsetAndConnClosed();
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return 0;
        }
        return this.typeConverter.toByte(this.getColumnDataType(columnIndex), this.getRowData(columnIndex));
    }

    public synchronized byte[] getBytes(int columnIndex) throws SQLException {
        this.checkRsetAndConnClosed();
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return null;
        }
        return this.typeConverter.toBytes(this.getColumnDataType(columnIndex), this.getRowData(columnIndex));
    }

    public synchronized Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkRsetAndConnClosed();
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return null;
        }
        return this.typeConverter.toCharacterStream(this.getColumnDataType(columnIndex), this.getRowData(columnIndex));
    }

    public Clob getClob(int columnIndex) throws SQLException {
        this.checkRsetAndConnClosed();
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return null;
        }
        return this.typeConverter.toClob(this.getColumnDataType(columnIndex), this.getRowData(columnIndex));
    }

    public Column[] getCols() {
        return this.cols;
    }

    public synchronized int getColumnCount() {
        return this.colCnt - this.beginColumnIndex;
    }

    protected int getColumnDataType(int columnIndex) throws SQLException {
        this.checkColumnPos(columnIndex);
        return this.cols[columnIndex + this.beginColumnIndex - 1].getDataType();
    }

    protected int getColumnIndex(String columnName) throws SQLException {
        return this.getColumnPosByName(columnName);
    }

    protected int getColumnMaxLength(int columnIndex) throws SQLException {
        this.checkColumnPos(columnIndex);
        return this.cols[columnIndex + this.beginColumnIndex - 1].getMaxLength();
    }

    protected String getColumnName(int columnIndex) throws SQLException {
        this.checkColumnPos(columnIndex);
        return this.cols[columnIndex + this.beginColumnIndex - 1].getName();
    }

    protected boolean getColumnNullable(int columnIndex) throws SQLException {
        this.checkColumnPos(columnIndex);
        return this.cols[columnIndex + this.beginColumnIndex - 1].isNullable();
    }

    private int getColumnPosByName(String columnName) throws SQLException {
        Integer colNum;
        if (this.cols == null || this.getColumnCount() == 0) {
            throw new TbSQLException(-90607);
        }
        if (this.columnNameMap == null) {
            this.buildColumnNameMap();
        }
        if ((colNum = (Integer)this.columnNameMap.get(columnName != null ? columnName.toUpperCase() : "")) == null) {
            throw new TbSQLException(-90611, columnName);
        }
        return colNum;
    }

    protected int getColumnPrecision(int columnIndex) throws SQLException {
        this.checkColumnPos(columnIndex);
        return this.cols[columnIndex + this.beginColumnIndex - 1].getPrecision();
    }

    protected byte[] getColumnRawData(int columnIndex) throws SQLException {
        return this.getCurrentRow().getRawBytes(columnIndex + this.beginColumnIndex);
    }

    protected int getColumnScale(int columnIndex) throws SQLException {
        this.checkColumnPos(columnIndex);
        return this.cols[columnIndex + this.beginColumnIndex - 1].getScale();
    }

    protected int getColumnSqlType(int columnIndex) throws SQLException {
        this.checkColumnPos(columnIndex);
        return this.cols[columnIndex + this.beginColumnIndex - 1].getSqlType();
    }

    protected abstract Row getCurrentRow() throws SQLException;

    public int getCursorId() {
        return this.cursorId;
    }

    public synchronized Date getDate(int columnIndex) throws SQLException {
        this.checkRsetAndConnClosed();
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return null;
        }
        return this.typeConverter.toDate(this.getColumnDataType(columnIndex), this.getRowData(columnIndex));
    }

    public synchronized double getDouble(int columnIndex) throws SQLException {
        this.checkRsetAndConnClosed();
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return 0.0;
        }
        return this.typeConverter.toDouble(this.getColumnDataType(columnIndex), this.getRowData(columnIndex));
    }

    public synchronized int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public synchronized int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public synchronized float getFloat(int columnIndex) throws SQLException {
        this.checkRsetAndConnClosed();
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return 0.0f;
        }
        return this.typeConverter.toFloat(this.getColumnDataType(columnIndex), this.getRowData(columnIndex));
    }

    public synchronized int getInt(int columnIndex) throws SQLException {
        this.checkRsetAndConnClosed();
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return 0;
        }
        return this.typeConverter.toInt(this.getColumnDataType(columnIndex), this.getRowData(columnIndex));
    }

    public synchronized long getLong(int columnIndex) throws SQLException {
        this.checkRsetAndConnClosed();
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return 0L;
        }
        return this.typeConverter.toLong(this.getColumnDataType(columnIndex), this.getRowData(columnIndex));
    }

    public synchronized InputStream getLongByteStream(int columnIndex) throws SQLException {
        this.checkRsetAndConnClosed();
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return null;
        }
        return this.typeConverter.toLongByteStream(this.getColumnDataType(columnIndex), this.getRowData(columnIndex));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new TbResultSetMetaData(this);
    }

    public synchronized Object getObject(int columnIndex) throws SQLException {
        this.checkRsetAndConnClosed();
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return null;
        }
        int dataType = this.getColumnDataType(columnIndex);
        int sqlType = DataType.getSqlType(dataType);
        return this.typeConverter.toObject(dataType, sqlType, this.getRowData(columnIndex));
    }

    public synchronized int getRow() throws SQLException {
        if (this.rowsFetchedCnt == 0 || this.currentRowIndex < 0) {
            return 0;
        }
        if (this.currentRowIndex >= this.rowsFetchedCnt) {
            throw new TbSQLException(-90624);
        }
        return this.currentRowIndex + 1;
    }

    protected abstract Row getRowAt(int var1) throws SQLException;

    protected RawData getRowData(int columnIndex) throws SQLException {
        return this.getCurrentRow().getRawData(columnIndex + this.beginColumnIndex);
    }

    public abstract Row[] getRows(int var1) throws SQLException;

    public synchronized short getShort(int columnIndex) throws SQLException {
        this.checkRsetAndConnClosed();
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return 0;
        }
        return this.typeConverter.toShort(this.getColumnDataType(columnIndex), this.getRowData(columnIndex));
    }

    public Statement getStatement() throws SQLException {
        return this.stmt;
    }

    public synchronized String getString(int columnIndex) throws SQLException {
        this.checkRsetAndConnClosed();
        if (this.setLastColumnIsNull(columnIndex)) {
            return null;
        }
        return this.typeConverter.toString(this.getColumnDataType(columnIndex), this.getRowData(columnIndex));
    }

    public synchronized Time getTime(int columnIndex) throws SQLException {
        this.checkRsetAndConnClosed();
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return null;
        }
        return this.typeConverter.toTime(this.getColumnDataType(columnIndex), this.getRowData(columnIndex));
    }

    public synchronized Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkRsetAndConnClosed();
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return null;
        }
        return this.typeConverter.toTimestamp(this.getColumnDataType(columnIndex), this.getRowData(columnIndex));
    }

    public synchronized InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkRsetAndConnClosed();
        this.setLastColumnWasNull(columnIndex);
        if (this.lastColumnWasNull) {
            return null;
        }
        return this.typeConverter.toUnicodeStream(this.getColumnDataType(columnIndex), this.getRowData(columnIndex));
    }

    protected boolean hasNoResultReturned() throws SQLException {
        if (this.rowsFetchedCnt > 0) {
            return false;
        }
        return this.fetchComplete;
    }

    public synchronized boolean isAfterLast() throws SQLException {
        return !this.hasNoResultReturned() && this.fetchComplete && this.currentRowIndex + 1 > this.rowsFetchedCnt;
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        return !this.hasNoResultReturned() && this.currentRowIndex < 0;
    }

    public boolean isFetchComplete() {
        return this.fetchComplete;
    }

    public boolean isRsetClosed() {
        return this.isRsetClosed;
    }

    private void makeColumnMetaArray(int colCnt) {
        this.cols = new Column[colCnt];
        for (int i = 0; i < colCnt; ++i) {
            this.cols[i] = new Column();
        }
    }

    public synchronized boolean next() throws SQLException {
        if (this.isRsetClosed) {
            throw new TbSQLException(-90646);
        }
        if (this.stmt.conn == null || this.stmt.conn.isClosed()) {
            throw new TbSQLException(-90603);
        }
        if (this.isSvrCsrClosed) {
            return false;
        }
        this.currentRowIndex = this.currentRowIndex < 0 ? 0 : ++this.currentRowIndex;
        while (this.currentRowIndex >= this.rowsFetchedCnt) {
            if (!this.fetchComplete) {
                this.fetchRowsChunk();
                continue;
            }
            return false;
        }
        return true;
    }

    protected abstract void removeCurrentRow() throws SQLException;

    protected void reset() {
        super.reset();
        if (this.cols != null) {
            this.columnClear();
            this.cols = null;
        }
        if (this.columnNameMap != null) {
            this.columnNameMap.clear();
            this.columnNameMap = null;
        }
        this.stmt = null;
        this.cursorId = -1;
        this.lastColumnWasNull = false;
        this.typeConverter = null;
        this.fetchComplete = false;
        this.currentRowIndex = -1;
        this.rowsFetchedCnt = 0;
        this.fetchDirection = 1000;
        this.fetchSize = 50;
        this.isRsetClosed = false;
        this.closeStatementOnClose = false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public synchronized void setFetchCompleted(int fetchResultBitmap) {
        this.fetchComplete = TbCommon.getBitmapAt(0, fetchResultBitmap);
    }

    public synchronized void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: 
            case 1002: {
                this.fetchDirection = 1000;
                return;
            }
            case 1001: {
                this.fetchDirection = 1001;
                break;
            }
            default: {
                throw new TbSQLException(-90608);
            }
        }
    }

    public synchronized void setFetchSize(int rows) throws SQLException {
        if (rows == 0) {
            this.fetchSize = 50;
        } else if (rows > 0) {
            this.fetchSize = rows;
        } else {
            throw new TbSQLException(-90608, " rows < 0 ");
        }
    }

    protected boolean setLastColumnIsNull(int columnIndex) throws SQLException {
        this.lastColumnWasNull = this.getCurrentRow().isNull(columnIndex + this.beginColumnIndex);
        return this.lastColumnWasNull;
    }

    protected void setLastColumnWasNull(int columnIndex) throws SQLException {
        this.lastColumnWasNull = this.getCurrentRow().isNull(columnIndex + this.beginColumnIndex);
    }

    protected abstract void setRowAt(int var1, Row var2) throws SQLException;

    public String ToString() {
        StringBuffer buf = new StringBuffer(128);
        buf.append(this.toString());
        buf.append(" cursorId[").append(this.cursorId).append("]");
        buf.append(" lastColumnWasNull[").append(this.lastColumnWasNull).append("]");
        buf.append(" typeConverterverter[").append(this.typeConverter).append("]");
        buf.append(" fetchComplete[").append(this.fetchComplete).append("]");
        buf.append(" columnNameMap[").append(this.columnNameMap).append("]");
        buf.append(" currentRowIndex[").append(this.currentRowIndex).append("]");
        buf.append(" rowsFetchedCnt[").append(this.rowsFetchedCnt).append("]");
        buf.append(" fetchDirection[").append(this.fetchDirection).append("]");
        buf.append(" fetchSize[").append(this.fetchSize).append("]");
        buf.append(" useRowId[").append(this.rsetType.useRowId()).append("]");
        buf.append(" columnSize[").append(this.cols != null ? this.cols.length : 0).append("]");
        buf.append(super.ToString());
        return buf.toString();
    }

    public synchronized boolean wasNull() throws SQLException {
        return this.lastColumnWasNull;
    }
}

