/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbResultSet;
import com.tmax.tibero.jdbc.data.DataType;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class TbResultSetMetaData
implements ResultSetMetaData {
    private TbResultSet rset = null;

    public void reset() {
        this.rset = null;
    }

    public TbResultSetMetaData(TbResultSet rset) {
        this.rset = rset;
    }

    public int getColumnCount() throws SQLException {
        return this.rset.getColumnCount();
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        this.rset.checkColumnPos(column);
        return false;
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        int dataType = this.rset.getColumnDataType(column);
        return DataType.isCharacterCategory(dataType) || dataType == 13 || dataType == 10;
    }

    public boolean isSearchable(int column) throws SQLException {
        int dataType = this.rset.getColumnDataType(column);
        return dataType != 11 && dataType != 10 && dataType != 12 && dataType != 13;
    }

    public boolean isCurrency(int column) throws SQLException {
        int dataType = this.rset.getColumnDataType(column);
        return dataType == 1;
    }

    public int isNullable(int column) throws SQLException {
        return this.rset.getColumnNullable(column) ? 1 : 0;
    }

    public boolean isSigned(int column) throws SQLException {
        return DataType.isNumberCategory(this.rset.getColumnDataType(column));
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        int dataType = this.rset.getColumnDataType(column);
        int maxLen = this.rset.getColumnMaxLength(column);
        if (maxLen > 0) {
            return maxLen;
        }
        switch (dataType) {
            case 2: 
            case 3: {
                if (this.rset.getColumnName(column).length() == 0) {
                    return 1;
                }
                return this.rset.getColumnName(column).length();
            }
            case 1: {
                return 45;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return 24;
            }
            case 15: {
                return 14;
            }
            case 12: 
            case 13: {
                return 400000000;
            }
        }
        return 65535;
    }

    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    public String getColumnName(int column) throws SQLException {
        return this.rset.getColumnName(column);
    }

    public String getSchemaName(int column) throws SQLException {
        this.rset.checkColumnPos(column);
        return "";
    }

    public int getPrecision(int column) throws SQLException {
        int prec = this.rset.getColumnPrecision(column);
        if (prec < 0) {
            return 0;
        }
        return prec;
    }

    public int getScale(int column) throws SQLException {
        int scale = this.rset.getColumnScale(column);
        if (scale < 0) {
            return 0;
        }
        return scale;
    }

    public String getTableName(int column) throws SQLException {
        this.rset.checkColumnPos(column);
        return "";
    }

    public String getCatalogName(int column) throws SQLException {
        this.rset.checkColumnPos(column);
        return "";
    }

    public int getColumnType(int column) throws SQLException {
        return this.rset.getColumnSqlType(column);
    }

    public String getColumnTypeName(int column) throws SQLException {
        return DataType.getDataTypeName(this.rset.getColumnDataType(column));
    }

    public boolean isReadOnly(int column) throws SQLException {
        this.rset.checkColumnPos(column);
        return false;
    }

    public boolean isWritable(int column) throws SQLException {
        this.rset.checkColumnPos(column);
        return true;
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.rset.checkColumnPos(column);
        return false;
    }

    public String getColumnClassName(int column) throws SQLException {
        return DataType.getDataTypeClassName(this.rset.getColumnDataType(column));
    }
}

