/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.comm;

import com.tmax.tibero.DBConst;
import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbCallableStatement;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbConnection;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.TbPreparedStatement;
import com.tmax.tibero.jdbc.TbResultSet;
import com.tmax.tibero.jdbc.TbResultSetBase;
import com.tmax.tibero.jdbc.TbResultSetFactory;
import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.TbSQLInfo;
import com.tmax.tibero.jdbc.TbSQLWarning;
import com.tmax.tibero.jdbc.TbSavepoint;
import com.tmax.tibero.jdbc.TbStatement;
import com.tmax.tibero.jdbc.comm.TbBatchStreamDataWriter;
import com.tmax.tibero.jdbc.comm.TbBlobAccessor;
import com.tmax.tibero.jdbc.comm.TbClobAccessor;
import com.tmax.tibero.jdbc.comm.TbComm;
import com.tmax.tibero.jdbc.comm.TbLogOn;
import com.tmax.tibero.jdbc.comm.TbPacketHeader;
import com.tmax.tibero.jdbc.comm.TbStream;
import com.tmax.tibero.jdbc.data.BatchInfo;
import com.tmax.tibero.jdbc.data.BindData;
import com.tmax.tibero.jdbc.data.BindItem;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.RawData;
import com.tmax.tibero.jdbc.data.Row;
import com.tmax.tibero.jdbc.data.RowChunkMgr;
import com.tmax.tibero.jdbc.data.StreamBuffer;
import com.tmax.tibero.jdbc.dpl.TbDirColumnMeta;
import com.tmax.tibero.jdbc.dpl.TbDirPathException;
import com.tmax.tibero.jdbc.dpl.TbDirPathMetaData;
import com.tmax.tibero.jdbc.dpl.TbDirPathStream;
import com.tmax.tibero.jdbc.dpl.TbDirPathStreamDataWriter;
import com.tmax.tibero.jdbc.msg.TbBindparam;
import com.tmax.tibero.jdbc.msg.TbColNameList;
import com.tmax.tibero.jdbc.msg.TbColumnDesc;
import com.tmax.tibero.jdbc.msg.TbMsgBatchUpdateReply;
import com.tmax.tibero.jdbc.msg.TbMsgCancel;
import com.tmax.tibero.jdbc.msg.TbMsgCloseCsr;
import com.tmax.tibero.jdbc.msg.TbMsgCloseSess;
import com.tmax.tibero.jdbc.msg.TbMsgCommit;
import com.tmax.tibero.jdbc.msg.TbMsgDplAbort;
import com.tmax.tibero.jdbc.msg.TbMsgDplDatasave;
import com.tmax.tibero.jdbc.msg.TbMsgDplFinish;
import com.tmax.tibero.jdbc.msg.TbMsgDplFlushRow;
import com.tmax.tibero.jdbc.msg.TbMsgDplLoadStreamReply;
import com.tmax.tibero.jdbc.msg.TbMsgDplPrepare;
import com.tmax.tibero.jdbc.msg.TbMsgDplPrepareReply;
import com.tmax.tibero.jdbc.msg.TbMsgEreply;
import com.tmax.tibero.jdbc.msg.TbMsgExecdir;
import com.tmax.tibero.jdbc.msg.TbMsgExecute;
import com.tmax.tibero.jdbc.msg.TbMsgExecuteCallReply;
import com.tmax.tibero.jdbc.msg.TbMsgExecuteCountReply;
import com.tmax.tibero.jdbc.msg.TbMsgExecuteNeedDataReply;
import com.tmax.tibero.jdbc.msg.TbMsgExecutePivotReply;
import com.tmax.tibero.jdbc.msg.TbMsgExecutePrefetchNoDescReply;
import com.tmax.tibero.jdbc.msg.TbMsgExecutePrefetchReply;
import com.tmax.tibero.jdbc.msg.TbMsgExecutePsmReply;
import com.tmax.tibero.jdbc.msg.TbMsgExecuteRsetNoDescReply;
import com.tmax.tibero.jdbc.msg.TbMsgExecuteRsetReply;
import com.tmax.tibero.jdbc.msg.TbMsgFetch;
import com.tmax.tibero.jdbc.msg.TbMsgFetchPivot;
import com.tmax.tibero.jdbc.msg.TbMsgFetchPivotReply;
import com.tmax.tibero.jdbc.msg.TbMsgFetchReply;
import com.tmax.tibero.jdbc.msg.TbMsgGetLastExecutedSqlinfo;
import com.tmax.tibero.jdbc.msg.TbMsgGetLastExecutedSqlinfoReply;
import com.tmax.tibero.jdbc.msg.TbMsgLobClose;
import com.tmax.tibero.jdbc.msg.TbMsgLobCloseReply;
import com.tmax.tibero.jdbc.msg.TbMsgLobCreateTemp;
import com.tmax.tibero.jdbc.msg.TbMsgLobCreateTempReply;
import com.tmax.tibero.jdbc.msg.TbMsgLobDeleteTemp;
import com.tmax.tibero.jdbc.msg.TbMsgLobInlob;
import com.tmax.tibero.jdbc.msg.TbMsgLobInlobReply;
import com.tmax.tibero.jdbc.msg.TbMsgLobInstr;
import com.tmax.tibero.jdbc.msg.TbMsgLobLength;
import com.tmax.tibero.jdbc.msg.TbMsgLobLengthReply;
import com.tmax.tibero.jdbc.msg.TbMsgLobOpen;
import com.tmax.tibero.jdbc.msg.TbMsgLobOpenReply;
import com.tmax.tibero.jdbc.msg.TbMsgLobRead;
import com.tmax.tibero.jdbc.msg.TbMsgLobReadReply;
import com.tmax.tibero.jdbc.msg.TbMsgLobTrunc;
import com.tmax.tibero.jdbc.msg.TbMsgLobTruncReply;
import com.tmax.tibero.jdbc.msg.TbMsgLobWrite;
import com.tmax.tibero.jdbc.msg.TbMsgLobWriteReply;
import com.tmax.tibero.jdbc.msg.TbMsgLongRead;
import com.tmax.tibero.jdbc.msg.TbMsgLongReadReply;
import com.tmax.tibero.jdbc.msg.TbMsgOpenSess;
import com.tmax.tibero.jdbc.msg.TbMsgPrepare;
import com.tmax.tibero.jdbc.msg.TbMsgPrepareExecute;
import com.tmax.tibero.jdbc.msg.TbMsgPrepareReply;
import com.tmax.tibero.jdbc.msg.TbMsgPutData;
import com.tmax.tibero.jdbc.msg.TbMsgResetSess;
import com.tmax.tibero.jdbc.msg.TbMsgRollback;
import com.tmax.tibero.jdbc.msg.TbMsgSavept;
import com.tmax.tibero.jdbc.msg.TbMsgSetIslLvl;
import com.tmax.tibero.jdbc.msg.TbMsgStmtcancel;
import com.tmax.tibero.jdbc.msg.TbOutParam;
import com.tmax.tibero.jdbc.msg.TbPivotInfo;
import com.tmax.tibero.jdbc.msg.TbPvValType;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.Vector;

public class TbCommType4
implements TbComm,
TbClobAccessor,
TbBlobAccessor {
    public TbConnection conn = null;
    public TbStream stream = null;

    public TbCommType4(TbConnection tbConnection) {
        this.conn = tbConnection;
    }

    public String ToString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append(this.toString());
        buf.append(" conn[").append(this.conn).append("]");
        buf.append(" stream[").append(this.stream).append("]");
        return buf.toString();
    }

    public TbStream getStream() {
        return this.stream;
    }

    public void reset() {
        try {
            if (this.stream != null) {
                this.stream.close();
                this.stream = null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.conn != null) {
            this.conn.reset();
            this.conn = null;
        }
    }

    protected TbConnection getTbConnection() {
        return this.conn;
    }

    public TbStream getTbStream() {
        return this.stream;
    }

    public synchronized void close() {
        this.reset();
    }

    public synchronized void commit() throws SQLException {
        this.stream.sendMsg(new TbMsgCommit(0));
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        switch (replyMsg.getMsgType()) {
            case 75: {
                this.doCommitReplyOK();
                return;
            }
            case 76: {
                this.doErrorReply(-90510, replyMsg);
                return;
            }
        }
        throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
    }

    public synchronized void rollback() throws SQLException {
        TbMsgRollback rollbackMsg = new TbMsgRollback(0);
        this.stream.sendMsg(rollbackMsg);
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        switch (replyMsg.getMsgType()) {
            case 75: {
                this.doRollbackReplyOK();
                break;
            }
            case 76: {
                this.doErrorReply(-90511, replyMsg);
                break;
            }
            default: {
                throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
            }
        }
    }

    public synchronized void setIsolationLevel(int level) throws SQLException {
        int dbIsolation = 0;
        if (level == 2) {
            dbIsolation = 0;
        } else if (level == 8) {
            dbIsolation = 1;
        } else {
            throw new TbSQLException(-90201, "supports 'READ COMMITTED' and 'SERIALIZABLE'");
        }
        TbMsgSetIslLvl islLvlMsg = new TbMsgSetIslLvl(0);
        islLvlMsg.set(dbIsolation);
        this.stream.sendMsg(islLvlMsg);
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        switch (replyMsg.getMsgType()) {
            case 75: {
                this.doSetIsolationLevelOK();
                return;
            }
            case 76: {
                this.doErrorReply(-90513, replyMsg);
                return;
            }
        }
        throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
    }

    public synchronized void openSession() throws SQLException {
        this.stream.sendMsg(new TbMsgOpenSess(0));
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        switch (replyMsg.getMsgType()) {
            case 75: {
                this.doOpenSessionReplyOK(replyMsg);
                return;
            }
            case 76: {
                this.doErrorReply(-90504, replyMsg);
                return;
            }
        }
        throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
    }

    public synchronized void closeSession() throws SQLException {
        TbMsgCloseSess msg = new TbMsgCloseSess(this.conn.getAutoCommit() ? 1 : 0);
        msg.set(this.conn.getAutoCommit() ? 1 : 0);
        this.stream.sendMsg(msg);
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        switch (replyMsg.getMsgType()) {
            case 75: {
                this.doCloseSessionReplyOK();
                return;
            }
            case 76: {
                this.doErrorReply(-90503, replyMsg);
                return;
            }
        }
        throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
    }

    public synchronized void resetSession() throws SQLException {
        this.stream.sendMsg(new TbMsgResetSess(0));
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        switch (replyMsg.getMsgType()) {
            case 75: {
                this.doResetSessReplyOK();
                return;
            }
            case 76: {
                this.doErrorReply(-90543, replyMsg);
                return;
            }
        }
        throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
    }

    public synchronized void cancel() throws SQLException {
        this.stream.sendMsg(new TbMsgCancel(0));
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        switch (replyMsg.getMsgType()) {
            case 75: {
                this.doCancelReplyOK();
                return;
            }
            case 76: {
                this.doErrorReply(-90526, replyMsg);
                return;
            }
        }
        throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
    }

    public synchronized void logon() throws SQLException {
        try {
            this.stream = new TbStream(this.conn, this.conn.info.getServerName(), this.conn.info.getPortNumber(), this.conn.info.getTdu(), this.conn.getTypeConverter());
        }
        catch (SQLException e) {
            if (this.conn.info.getFailOver()) {
                this.stream = new TbStream(this.conn, this.conn.info.getBackupServerName(), this.conn.info.getBackupPortNumber(), this.conn.info.getTdu(), this.conn.getTypeConverter());
            }
            throw e;
        }
        TbLogOn logOn = new TbLogOn(this.conn, this.stream);
        logOn.logon();
    }

    public synchronized void closeCursor(TbResultSet rs, int cursorId) throws SQLException {
        TbMsgCloseCsr closeCsrMsg = new TbMsgCloseCsr(0);
        closeCsrMsg.set(cursorId);
        this.stream.sendMsg(closeCsrMsg);
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        switch (replyMsg.getMsgType()) {
            case 75: {
                return;
            }
            case 76: {
                this.doErrorReply(-90507, replyMsg);
                return;
            }
        }
        throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
    }

    public void cancelStatement() throws SQLException {
        TbMsgStmtcancel stmtCancelMsg = new TbMsgStmtcancel(0);
        stmtCancelMsg.set(this.conn.getSessionId(), this.conn.getSerialNo(), 0);
        this.stream.sendMsg(stmtCancelMsg);
    }

    public synchronized TbResultSet executeDirect(TbStatement stmt, String sql) throws SQLException {
        int autoCommit = stmt.getConnection().getAutoCommit() ? 1 : 0;
        TbMsgExecdir execdirMsg = new TbMsgExecdir(autoCommit);
        execdirMsg.set(autoCommit, stmt.getPreFetchSize(), sql);
        this.stream.sendMsg(execdirMsg);
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        block9: while (true) {
            switch (replyMsg.getMsgType()) {
                case 2: 
                case 75: {
                    return this.doExecuteOkReply(stmt);
                }
                case 13: {
                    return this.doExecuteCountReply((TbMsgExecuteCountReply)replyMsg, stmt);
                }
                case 8: {
                    return this.doExecuteRsetReply((TbMsgExecuteRsetReply)replyMsg, stmt);
                }
                case 14: {
                    return this.doExecuteDirectCallReply(stmt);
                }
                case 11: {
                    return this.doExecutePrefetchReply((TbMsgExecutePrefetchReply)replyMsg, stmt);
                }
                case 9: {
                    replyMsg = this.doExecutePivotReply((TbMsgExecutePivotReply)replyMsg, stmt);
                    continue block9;
                }
                case 76: {
                    this.doErrorReply(-90508, replyMsg);
                }
            }
            break;
        }
        throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
    }

    public synchronized Row[] fetch(TbStatement stmt, TbResultSetBase rs) throws SQLException {
        TbMsgFetch fetchMsg = new TbMsgFetch(0);
        fetchMsg.csrid = rs.getCursorId();
        fetchMsg.fetchSize = rs.getFetchSize();
        this.stream.sendMsg(fetchMsg);
        return this.doFetchReply(stmt, rs);
    }

    public synchronized TbResultSet execute(TbPreparedStatement stmt, String sql) throws SQLException {
        BindData bindData = stmt.getBindData();
        TbBindparam[] paramInfo = this.bindParameterData(bindData);
        int autoCommit = stmt.getConnection().getAutoCommit() ? 1 : 0;
        TbMsgExecute executeMsg = new TbMsgExecute(autoCommit);
        executeMsg.set(stmt.getPPID(), autoCommit, stmt.getPreFetchSize(), paramInfo.length, paramInfo);
        this.stream.sendMsg(executeMsg);
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        block11: while (true) {
            switch (replyMsg.getMsgType()) {
                case 2: 
                case 75: {
                    return this.doExecuteOkReply(stmt);
                }
                case 12: {
                    return this.doExecutePrefetchNoDescReply((TbMsgExecutePrefetchNoDescReply)replyMsg, stmt);
                }
                case 13: {
                    return this.doExecuteCountReply((TbMsgExecuteCountReply)replyMsg, stmt);
                }
                case 8: {
                    return this.doExecuteRsetReply((TbMsgExecuteRsetReply)replyMsg, stmt);
                }
                case 10: {
                    return this.doExecuteRsetNoDescReply((TbMsgExecuteRsetNoDescReply)replyMsg, stmt);
                }
                case 16: {
                    return this.doExecutePutData(replyMsg, stmt);
                }
                case 15: {
                    if (stmt instanceof TbCallableStatement) {
                        return this.doExecuteCallReply((TbCallableStatement)stmt, ((TbMsgExecutePsmReply)replyMsg).paramData);
                    }
                    return this.doExecutePsmReply(stmt, (TbMsgExecutePsmReply)replyMsg);
                }
                case 9: {
                    replyMsg = this.doExecutePivotReply((TbMsgExecutePivotReply)replyMsg, stmt);
                    continue block11;
                }
                case 76: {
                    return this.doExecuteErrorReply(stmt, sql, replyMsg);
                }
            }
            break;
        }
        throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
    }

    public synchronized void prepare(TbPreparedStatement pstmt, String originalSql, Vector paramTypes) throws SQLException {
        TbMsgPrepare msg = new TbMsgPrepare(0);
        msg.set(originalSql);
        this.stream.sendMsg(msg);
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        switch (replyMsg.getMsgType()) {
            case 4: {
                this.doPrepareReplyOK((TbMsgPrepareReply)replyMsg, pstmt, paramTypes);
                return;
            }
            case 76: {
                this.doErrorReply(-90506, replyMsg);
                return;
            }
        }
        throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
    }

    public synchronized TbResultSet prepareExecute(TbPreparedStatement stmt, String sql) throws SQLException {
        if (stmt.getPPID() != null) {
            return this.execute(stmt, sql);
        }
        BindData bindData = stmt.getBindData();
        TbBindparam[] paramInfo = this.bindParameterData(bindData);
        int autoCommit = stmt.getConnection().getAutoCommit() ? 1 : 0;
        TbMsgPrepareExecute prepareExecuteMsg = new TbMsgPrepareExecute(autoCommit);
        prepareExecuteMsg.set(sql, autoCommit, stmt.getPreFetchSize(), paramInfo.length, paramInfo);
        this.stream.sendMsg(prepareExecuteMsg);
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        block11: while (true) {
            switch (replyMsg.getMsgType()) {
                case 2: 
                case 75: {
                    return this.doExecuteOkReply(stmt);
                }
                case 13: {
                    stmt.setPPID(((TbMsgExecuteCountReply)replyMsg).ppid);
                    return this.doExecuteCountReply((TbMsgExecuteCountReply)replyMsg, stmt);
                }
                case 11: {
                    stmt.setPPID(((TbMsgExecutePrefetchReply)replyMsg).ppid);
                    stmt.buildColMetaArray(((TbMsgExecutePrefetchReply)replyMsg).colCnt, ((TbMsgExecutePrefetchReply)replyMsg).hiddenColCnt, ((TbMsgExecutePrefetchReply)replyMsg).colMeta);
                    return this.doExecutePrefetchReply((TbMsgExecutePrefetchReply)replyMsg, stmt);
                }
                case 8: {
                    stmt.setPPID(((TbMsgExecuteRsetReply)replyMsg).ppid);
                    stmt.buildColMetaArray(((TbMsgExecuteRsetReply)replyMsg).colCnt, ((TbMsgExecuteRsetReply)replyMsg).hiddenColCnt, ((TbMsgExecuteRsetReply)replyMsg).colMeta);
                    return this.doExecuteRsetReply((TbMsgExecuteRsetReply)replyMsg, stmt);
                }
                case 16: {
                    return this.doExecutePutData(replyMsg, stmt);
                }
                case 15: {
                    if (stmt instanceof TbCallableStatement) {
                        return this.doExecuteCallReply((TbCallableStatement)stmt, ((TbMsgExecutePsmReply)replyMsg).paramData);
                    }
                    return this.doExecutePsmReply(stmt, (TbMsgExecutePsmReply)replyMsg);
                }
                case 14: {
                    return this.doExecuteCallReply((TbCallableStatement)stmt, ((TbMsgExecuteCallReply)replyMsg).paramData);
                }
                case 9: {
                    replyMsg = this.doExecutePivotReply((TbMsgExecutePivotReply)replyMsg, stmt);
                    continue block11;
                }
                case 76: {
                    this.doErrorReply(-90508, replyMsg);
                }
            }
            break;
        }
        throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
    }

    private void doPrepareReplyOK(TbMsgPrepareReply msg, TbPreparedStatement pstmt, Vector paramTypes) {
        if (msg.isPreparedDdl == 1) {
            pstmt.setPPID(null);
            pstmt.setParameterCnt(0);
            pstmt.setPreparedDDLFlag(true);
        } else {
            int paramCnt = msg.bindParamCnt;
            pstmt.setPPID(msg.ppid);
            pstmt.setParameterCnt(paramCnt);
            pstmt.setPreparedDDLFlag(false);
            for (int j = 0; j < paramCnt; ++j) {
                paramTypes.add(j, new Integer(msg.bindParamMeta[j].type));
            }
            pstmt.buildColMetaArray(msg.outColCnt, msg.hiddenColCnt, msg.colDesc);
        }
    }

    public synchronized void batchUpdate(TbPreparedStatement stmt, int totBatchRowCnt, int batchRowCnt, int bindParamSum, int flag, int autoCommit, int offset, int paramInfoSize) throws SQLException {
        TbBatchStreamDataWriter batchWriter = stmt.getBatchStreamDataWriter();
        batchWriter.set(totBatchRowCnt, batchRowCnt, stmt.getParameterCnt(), flag, autoCommit, bindParamSum, paramInfoSize);
        this.stream.flushBatch(batchWriter, offset, paramInfoSize);
    }

    public synchronized int[] batchUpdateReply(int batchRowCnt) throws SQLException {
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        switch (replyMsg.getMsgType()) {
            case 32: {
                return this.doBatchUpdateReplyOK((TbMsgBatchUpdateReply)replyMsg, batchRowCnt);
            }
            case 76: {
                this.doErrorReply(-90515, replyMsg);
                return null;
            }
        }
        throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
    }

    public synchronized int[] batchUpdateLoop(TbPreparedStatement stmt, int flag, int autoCommit, int offset, BatchInfo[] batchInfos, int totBatchRowCnt) throws SQLException {
        int cntOfs = 0;
        int[] curUpdateCnt = new int[]{};
        try {
            for (int i = 0; i < batchInfos.length; ++i) {
                BatchInfo batchInfo = batchInfos[i];
                if (i > 0) {
                    flag |= 0x1000;
                }
                if (i == 0) {
                    this.batchUpdate(stmt, totBatchRowCnt, batchInfo.getBatchRowCnt(), batchInfo.getBindParamSum(), flag, autoCommit, offset, batchInfo.getParamInfoSize());
                } else {
                    this.batchUpdate(stmt, totBatchRowCnt, batchInfo.getBatchRowCnt(), batchInfo.getBindParamSum(), flag, 0, offset, batchInfo.getParamInfoSize());
                }
                offset += batchInfo.getParamInfoSize();
                cntOfs += curUpdateCnt.length;
            }
        }
        catch (BatchUpdateException e) {
            throw new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), e.getUpdateCounts());
        }
        return this.batchUpdateReply(totBatchRowCnt);
    }

    public synchronized byte[] readLongBytes(byte[] locator) throws SQLException {
        TbMsgLongReadReply reply;
        ByteArrayOutputStream byteBuf = new ByteArrayOutputStream();
        TbMsgLongRead msg = new TbMsgLongRead(0);
        do {
            msg.set(DBConst.MIN_DEFERRED_BYTE_SIZE, locator, locator.length);
            this.stream.sendMsg(msg);
            TbMsg replyMsg = this.stream.readMsgHdr();
            this.stream.readMsgBody(replyMsg);
            switch (replyMsg.getMsgType()) {
                case 53: {
                    reply = (TbMsgLongReadReply)replyMsg;
                    locator = new byte[reply.longLoc.length];
                    System.arraycopy(reply.longLoc, 0, locator, 0, locator.length);
                    byteBuf.write(reply.data, 0, reply.data.length);
                    break;
                }
                case 76: {
                    throw this.getErrorMessage(-90534, replyMsg);
                }
                default: {
                    throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
                }
            }
        } while (reply.isLastData == 0);
        return byteBuf.toByteArray();
    }

    public synchronized String readLong(byte[] locator) throws SQLException {
        TbMsgLongReadReply reply;
        StringBuffer readLongBuf = new StringBuffer();
        TbMsgLongRead msg = new TbMsgLongRead(0);
        DataTypeConverter conv = this.conn.getTypeConverter();
        byte[] charPiece = new byte[3];
        int charPieceLen = 0;
        block4: do {
            msg.set(DBConst.MIN_DEFERRED_BYTE_SIZE, locator, locator.length);
            this.stream.sendMsg(msg);
            TbMsg replyMsg = this.stream.readMsgHdr();
            this.stream.readMsgBody(replyMsg, 36, charPiece, charPieceLen);
            switch (replyMsg.getMsgType()) {
                case 53: {
                    reply = (TbMsgLongReadReply)replyMsg;
                    locator = new byte[reply.longLoc.length];
                    System.arraycopy(reply.longLoc, 0, locator, 0, locator.length);
                    if (reply.data == null || reply.data.length == 0) continue block4;
                    int clbOffset = conv.getEndingBytePos(reply.data, reply.data.length - 1);
                    char[] destData = new char[clbOffset + 1];
                    int destCharCnt = conv.bytesToChars(reply.data, 0, clbOffset + 1, destData, 0, clbOffset + 1);
                    charPieceLen = reply.data.length - (clbOffset + 1);
                    System.arraycopy(reply.data, clbOffset + 1, charPiece, 0, charPieceLen);
                    readLongBuf.append(destData, 0, destCharCnt);
                    break;
                }
                case 76: {
                    throw this.getErrorMessage(-90534, replyMsg);
                }
                default: {
                    throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
                }
            }
        } while (reply.isLastData == 0);
        return readLongBuf.toString();
    }

    private TbResultSet doExecuteDirectCallReply(TbStatement stmt) throws SQLException {
        throw new TbSQLException(-90615);
    }

    private TbResultSet doExecuteCountReply(TbMsgExecuteCountReply replyMsg, TbStatement stmt) throws SQLException {
        long updateCount = (0xFFFFFFFF00000000L & (long)replyMsg.cntHigh << 32) + (0xFFFFFFFFL & (long)replyMsg.cntLow);
        return TbResultSetFactory.buildUpdateResult(stmt, updateCount);
    }

    private TbResultSet doExecuteRsetNoDescReply(TbMsgExecuteRsetNoDescReply msg, TbPreparedStatement stmt) throws SQLException {
        return this.conn.getTypeConverter().toResultSet(stmt.getOutColCnt(), stmt.getHiddenColCnt(), msg.csrId, stmt.getColMetaArray(), stmt);
    }

    private TbResultSet doExecuteRsetReply(TbMsgExecuteRsetReply replyMsg, TbStatement stmt) throws SQLException {
        return this.conn.getTypeConverter().toResultSet(replyMsg.colCnt, replyMsg.hiddenColCnt, replyMsg.csrId, replyMsg.colMeta, stmt);
    }

    private TbResultSet doExecutePrefetchNoDescReply(TbMsgExecutePrefetchNoDescReply msg, TbPreparedStatement stmt) throws SQLException {
        TbResultSet rs = this.conn.getTypeConverter().toResultSet(stmt.getOutColCnt(), stmt.getHiddenColCnt(), msg.csrId, stmt.getColMetaArray(), stmt);
        RowChunkMgr rowChunkMgr = stmt.getRowChunkMgr();
        rowChunkMgr.prepare(msg.rowChunkSize);
        StreamBuffer buf = rowChunkMgr.getChunkBuffer();
        this.stream.readChunkData(buf, msg.rowChunkSize);
        rs.setFetchCompleted(msg.isFetchCompleted);
        Row[] rows = rs.buildRowData(msg.rowCnt);
        rs.addRows(rows);
        return rs;
    }

    private TbResultSet doExecutePrefetchReply(TbMsgExecutePrefetchReply replyMsg, TbStatement stmt) throws SQLException {
        TbResultSet rs = this.conn.getTypeConverter().toResultSet(replyMsg.colCnt, replyMsg.hiddenColCnt, replyMsg.csrId, replyMsg.colMeta, stmt);
        RowChunkMgr rowChunkMgr = stmt.getRowChunkMgr();
        rowChunkMgr.prepare(replyMsg.rowChunkSize);
        StreamBuffer buf = rowChunkMgr.getChunkBuffer();
        this.stream.readChunkData(buf, replyMsg.rowChunkSize);
        rs.setFetchCompleted(replyMsg.isFetchCompleted);
        Row[] rows = rs.buildRowData(replyMsg.rowCnt);
        rs.addRows(rows);
        return rs;
    }

    private TbMsg doExecutePivotReply(TbMsgExecutePivotReply pivotMsg, TbStatement stmt) throws SQLException {
        TbMsg replyMsg;
        TbPivotInfo[] pivotInfo = new TbPivotInfo[pivotMsg.pivotInfo.length];
        for (int i = 0; i < pivotMsg.pivotInfo.length; ++i) {
            pivotInfo[i] = new TbPivotInfo();
            pivotInfo[i].colIdx = pivotMsg.pivotInfo[i].colIdx;
            pivotInfo[i].chunkCnt = pivotMsg.pivotInfo[i].chunkCnt;
            if (pivotMsg.pivotInfo[i].valType == null) continue;
            pivotInfo[i].valType = new TbPvValType[pivotMsg.pivotInfo[i].valType.length];
            for (int j = 0; j < pivotMsg.pivotInfo[i].valType.length; ++j) {
                pivotInfo[i].valType[j] = new TbPvValType();
                pivotInfo[i].valType[j].type = pivotMsg.pivotInfo[i].valType[j].type;
            }
        }
        stmt.setPivotInfo(pivotInfo);
        stmt.addPivotData(pivotMsg.chunk);
        TbMsgFetchPivot msg = new TbMsgFetchPivot(0);
        block5: while (true) {
            this.stream.sendMsg(msg);
            replyMsg = this.stream.readMsgHdr();
            this.stream.readMsgBody(replyMsg);
            switch (replyMsg.getMsgType()) {
                case 21: {
                    stmt.addPivotData(((TbMsgFetchPivotReply)replyMsg).chunk);
                    continue block5;
                }
            }
            break;
        }
        return replyMsg;
    }

    private TbResultSet doExecuteOkReply(TbStatement stmt) throws SQLException {
        return TbResultSetFactory.buildOKResult(stmt);
    }

    private Row[] doFetchReply(TbStatement stmt, TbResultSetBase rs) throws SQLException {
        TbMsg msg = this.stream.readMsgHdr();
        this.stream.readMsgBody(msg);
        int msgType = msg.getMsgType();
        if (msgType == 76) {
            this.doErrorReply(-90509, msg);
        } else if (msgType != 19) {
            throw new TbSQLException(-90402, "Unsupported Protocol[" + msg.getMsgType() + "]");
        }
        TbMsgFetchReply replyMsg = (TbMsgFetchReply)msg;
        RowChunkMgr rowChunkMgr = stmt.getRowChunkMgr();
        rowChunkMgr.prepare(replyMsg.rowChunkSize);
        StreamBuffer buf = rowChunkMgr.getChunkBuffer();
        this.stream.readChunkData(buf, replyMsg.rowChunkSize);
        rs.setFetchCompleted(replyMsg.isFetchCompleted);
        return rs.buildRowData(replyMsg.rowCnt);
    }

    private TbResultSet doExecuteCallReply(TbCallableStatement stmt, TbOutParam[] paramData) throws SQLException {
        int colCnt = 0;
        if (paramData != null) {
            colCnt = paramData.length;
        }
        BindData binds = stmt.getBindData();
        int bindsIndex = -1;
        int bindCnt = binds.getParameterCnt();
        if (binds.getOutParameterCnt() != colCnt) {
            throw new TbSQLException(-90618);
        }
        if (paramData == null) {
            return TbResultSetFactory.buildCallResult(stmt);
        }
        for (int i = 0; i < colCnt; ++i) {
            ++bindsIndex;
            while (bindsIndex < bindCnt && !binds.isOutParameterOn(bindsIndex)) {
                ++bindsIndex;
            }
            if (bindsIndex >= bindCnt) {
                throw new TbSQLException(-90618);
            }
            BindItem item = binds.getBindItem(bindsIndex);
            item.setData(2, paramData[i].value.length, paramData[i].value, paramData[i].dataType);
            item.setColMeta(paramData[i].colMeta);
        }
        return TbResultSetFactory.buildCallResult(stmt);
    }

    private TbResultSet doExecutePsmReply(TbPreparedStatement stmt, TbMsgExecutePsmReply replyMsg) throws SQLException {
        BindData binds = stmt.getBindData();
        int colCnt = 0;
        if (replyMsg.paramData != null) {
            colCnt = replyMsg.paramData.length;
        }
        if (binds.getOutParameterCnt() != colCnt) {
            throw new TbSQLException(-90618);
        }
        return TbResultSetFactory.buildOKResult(stmt);
    }

    private TbResultSet doExecutePutData(TbMsg msg, TbPreparedStatement stmt) throws SQLException {
        BindData binddata = stmt.getBindData();
        TbMsg replyMsg = this.putBindData(msg, binddata, stmt);
        switch (replyMsg.getMsgType()) {
            case 14: {
                return this.doExecuteDirectCallReply(stmt);
            }
            case 13: {
                return this.doExecuteCountReply((TbMsgExecuteCountReply)replyMsg, stmt);
            }
            case 75: {
                return this.doExecuteOkReply(stmt);
            }
            case 8: {
                return this.doExecuteRsetReply((TbMsgExecuteRsetReply)replyMsg, stmt);
            }
        }
        throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
    }

    private TbMsg putBindData(TbMsg msg, BindData bindData, TbStatement stmt) throws SQLException {
        int paramIndex;
        BindItem item;
        for (int deferredParamCnt = bindData.getDeferredParamCnt(); deferredParamCnt > 0 && (msg = this.putEachBindItem(item = bindData.getBindItem(paramIndex = ((TbMsgExecuteNeedDataReply)msg).paramIndex), paramIndex, stmt.getCurCsrId())).getMsgType() == 16; --deferredParamCnt) {
            stmt.setCurCsrId(((TbMsgExecuteNeedDataReply)msg).csrId);
        }
        return msg;
    }

    private TbMsg putEachBindItem(BindItem item, int paramIndex, int csrId) throws SQLException {
        TbMsg replyMsg = null;
        if (item.getKind() != 8) {
            throw new TbSQLException(-590717, "invalid deferred parameter" + item);
        }
        try {
            int offset = 0;
            DataTypeConverter converter = this.conn.getTypeConverter();
            TbMsgPutData msg = new TbMsgPutData(0);
            RawData rawData = item.getRawData();
            Object data = rawData.getData();
            if (data instanceof Reader) {
                int readCharLen;
                char[] charBuf = new char[DBConst.MIN_DEFERRED_CHAR_CNT];
                byte[] byteBuf = new byte[DBConst.MIN_DEFERRED_BYTE_SIZE];
                Reader reader = (Reader)data;
                for (int totalCharCnt = rawData.getLength(); totalCharCnt > 0 && (readCharLen = reader.read(charBuf)) != -1; totalCharCnt -= readCharLen) {
                    int convertedByteCnt = converter.charsToBytes(charBuf, offset, readCharLen, byteBuf, 0, byteBuf.length);
                    msg.set(paramIndex, csrId, byteBuf, convertedByteCnt);
                    this.stream.sendMsg(msg);
                }
            } else if (data instanceof char[]) {
                int totalCharCnt = rawData.getLength();
                byte[] byteBuf = new byte[DBConst.MIN_DEFERRED_BYTE_SIZE];
                while (totalCharCnt > 0) {
                    int writeCharCnt = DBConst.MIN_DEFERRED_CHAR_CNT > totalCharCnt ? totalCharCnt : DBConst.MIN_DEFERRED_CHAR_CNT;
                    int convertedByteCnt = converter.charsToBytes((char[])data, offset, writeCharCnt, byteBuf, 0, byteBuf.length);
                    msg.set(paramIndex, csrId, byteBuf, convertedByteCnt);
                    this.stream.sendMsg(msg);
                    totalCharCnt -= writeCharCnt;
                    offset += writeCharCnt;
                }
            } else if (data instanceof InputStream) {
                int readByteCnt = 0;
                int writeByteCnt = 0;
                byte[] byteBuf = new byte[DBConst.MIN_DEFERRED_BYTE_SIZE];
                for (int totalByteCnt = rawData.getLength(); totalByteCnt > 0; totalByteCnt -= writeByteCnt) {
                    if (totalByteCnt < DBConst.MIN_DEFERRED_BYTE_SIZE) {
                        writeByteCnt = totalByteCnt;
                        byteBuf = new byte[writeByteCnt];
                    } else {
                        writeByteCnt = DBConst.MIN_DEFERRED_BYTE_SIZE;
                    }
                    InputStream binaryStream = (InputStream)data;
                    readByteCnt = binaryStream.read(byteBuf, 0, writeByteCnt);
                    if (readByteCnt != -1) {
                        msg.set(paramIndex, csrId, byteBuf, readByteCnt);
                        this.stream.sendMsg(msg);
                        continue;
                    }
                    break;
                }
            } else {
                int totalByteCnt = rawData.getLength();
                byte[] byteBuf = new byte[DBConst.MIN_DEFERRED_BYTE_SIZE];
                while (totalByteCnt > 0) {
                    int writeByteCnt = totalByteCnt < DBConst.MIN_DEFERRED_BYTE_SIZE ? totalByteCnt : DBConst.MIN_DEFERRED_BYTE_SIZE;
                    System.arraycopy(data, offset, byteBuf, 0, writeByteCnt);
                    msg.set(paramIndex, csrId, byteBuf, writeByteCnt);
                    this.stream.sendMsg(msg);
                    totalByteCnt -= writeByteCnt;
                    offset += writeByteCnt;
                }
            }
            msg.set(paramIndex, csrId, new byte[0], 0);
            this.stream.sendMsg(msg);
            replyMsg = this.handlePutDataEndReply();
        }
        catch (IOException e) {
            throw new TbSQLException(-90202, "Failed to read bind parameter");
        }
        return replyMsg;
    }

    private TbMsg handlePutDataEndReply() throws SQLException {
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        if (replyMsg.getMsgType() == 76) {
            this.doErrorReply(-90508, replyMsg);
        }
        return replyMsg;
    }

    private int[] doBatchUpdateReplyOK(TbMsgBatchUpdateReply replyMsg, int batchCnt) throws SQLException {
        int i;
        int[] updateCnt = new int[replyMsg.executedCnt];
        if (replyMsg.affectedCnt == null) {
            for (i = 0; i < replyMsg.executedCnt; ++i) {
                updateCnt[i] = 1;
            }
        } else {
            for (i = 0; i < replyMsg.executedCnt; ++i) {
                updateCnt[i] = replyMsg.affectedCnt[i].cnt;
            }
        }
        if (batchCnt != replyMsg.executedCnt) {
            TbSQLException e = replyMsg.getException(-90515);
            throw new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), updateCnt);
        }
        return updateCnt;
    }

    private void doSetIsolationLevelOK() {
    }

    private void doOpenSessionReplyOK(TbMsg msg) {
    }

    private void doCloseSessionReplyOK() {
    }

    private void doCommitReplyOK() {
    }

    private void doRollbackReplyOK() {
    }

    private void doSavepointReplyOK() {
    }

    private void doCancelReplyOK() {
    }

    private void doResetSessReplyOK() {
    }

    private void doErrorReply(int errorCode, TbMsg msg) throws SQLException {
        TbSQLException ex = this.getErrorMessage(errorCode, msg);
        throw ex;
    }

    private TbResultSet doExecuteErrorReply(TbPreparedStatement stmt, String sql, TbMsg msg) throws SQLException {
        TbSQLException ex = this.getErrorMessage(-90508, msg);
        if (ex.getErrorCode() == -12018) {
            stmt.setPPID(null);
            return this.prepareExecute(stmt, sql);
        }
        throw ex;
    }

    protected TbBindparam[] bindParameterData(BindData bindData) throws SQLException {
        bindData.resetDeferredParamCnt();
        int paramCnt = bindData.getParameterCnt();
        TbBindparam[] bindParam = new TbBindparam[paramCnt];
        for (int i = 0; i < paramCnt; ++i) {
            BindItem item = bindData.getBindItem(i);
            if (!item.isBinded()) {
                throw new TbSQLException(-90627);
            }
            int flag = 0;
            bindParam[i] = new TbBindparam();
            flag = item.getKind() & 0xFF;
            flag |= item.getExDataType() << 8 & 0xFFFFFF00;
            if (item.getKind() == 8) {
                bindData.incDeferredParamCnt();
                bindParam[i].set(flag, null, 0);
                continue;
            }
            if (item.isNull()) {
                bindParam[i].set(flag, null, 0);
                continue;
            }
            bindParam[i].set(flag, (byte[])item.getRawData().getData(), item.getRawData().getLength());
        }
        return bindParam;
    }

    public TbSQLException getErrorMessage(int code, TbMsg msg) throws SQLException {
        TbMsgEreply errMsg = (TbMsgEreply)msg;
        if (errMsg.flag == Integer.MIN_VALUE) {
            this.reset();
        }
        return errMsg.getException(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TbSQLWarning getWarningMessage() throws SQLException {
        TbPacketHeader header = this.stream.getPacketHeader();
        try {
            TbSQLWarning tbSQLWarning = null;
            return tbSQLWarning;
        }
        finally {
            if (this.stream != null) {
                this.stream.skipUnreadPacketData();
            }
        }
    }

    public synchronized long read(TbClob clob, long offset, char[] buffer, long bufOffset, long numChars) throws SQLException {
        int splitCharCnt = 0;
        int readCharCnt = 0;
        long totalCharCnt = 0L;
        int bytePerChar = 2;
        long byteOffset = offset * (long)bytePerChar;
        int maxChar = TbLob.MAX_CHUNK_SIZE / bytePerChar;
        do {
            splitCharCnt = numChars - totalCharCnt >= (long)maxChar ? maxChar : (int)(numChars - totalCharCnt);
            readCharCnt = this._read(clob, byteOffset, buffer, null, totalCharCnt, splitCharCnt * bytePerChar);
            byteOffset += (long)(readCharCnt * bytePerChar);
        } while (numChars > (totalCharCnt += (long)readCharCnt) && !clob.isEndOfStream());
        return totalCharCnt;
    }

    public synchronized long write(TbClob clob, long offset, char[] inBuffer, long bufOffset, long numChars) throws SQLException {
        boolean firstMsg = true;
        boolean lastMsg = false;
        int splitCharCnt = 0;
        long totalCharCnt = 0L;
        int flag = 0;
        int bytePerChar = 2;
        int maxChar = TbLob.MAX_CHUNK_SIZE / bytePerChar;
        long byteOffset = offset * (long)bytePerChar;
        if (numChars <= (long)maxChar) {
            this._write(clob, byteOffset, inBuffer, null, bufOffset, numChars, 0x3000000);
            return numChars;
        }
        do {
            if (numChars - totalCharCnt > (long)maxChar) {
                splitCharCnt = maxChar;
            } else {
                splitCharCnt = (int)(numChars - totalCharCnt);
                lastMsg = true;
            }
            flag = 0;
            if (firstMsg) {
                flag = 0x1000000;
            }
            if (lastMsg) {
                flag = 0x2000000;
            }
            try {
                this._write(clob, byteOffset, inBuffer, null, bufOffset + totalCharCnt, splitCharCnt, flag);
            }
            catch (SQLException e) {
                if (!firstMsg) {
                    this.cancel();
                }
                throw e;
            }
            byteOffset += (long)(splitCharCnt * bytePerChar);
            firstMsg = false;
        } while (numChars > (totalCharCnt += (long)splitCharCnt));
        return totalCharCnt;
    }

    public synchronized void truncate(TbClob clob, long newLength) throws SQLException {
        this._truncate(clob, newLength *= (long)this.conn.getTypeConverter().getUCS2MaxBytesPerChar());
    }

    public synchronized long position(TbClob clob, TbClob searchLob, long start) throws SQLException {
        long pos = this._position((TbLob)clob, searchLob, start);
        return pos * (long)this.conn.getTypeConverter().getUCS2MaxBytesPerChar();
    }

    public synchronized long position(TbClob clob, char[] searchStr, long start) throws SQLException {
        long pos = this._position((TbLob)clob, searchStr, start);
        return pos * (long)this.conn.getTypeConverter().getUCS2MaxBytesPerChar();
    }

    public synchronized boolean open(TbClob clob, int mode) throws SQLException {
        return this._open(clob, mode);
    }

    public synchronized boolean close(TbClob clob) throws SQLException {
        return this._close(clob);
    }

    public synchronized long length(TbClob clob) throws SQLException {
        long length = this._length(clob);
        return length / (long)this.conn.getTypeConverter().getUCS2MaxBytesPerChar();
    }

    public synchronized byte[] createTemporaryClob() throws SQLException {
        return this._createTemporary(13);
    }

    public synchronized byte[] createTemporaryNClob() throws SQLException {
        return this._createTemporary(20);
    }

    public synchronized void freeTemporaryClob(TbClob clob) throws SQLException {
        this._freeTemporary(clob);
    }

    public synchronized long read(TbBlob blob, long offset, byte[] outBuffer, long inBufferOffset, long numBytes) throws SQLException {
        int splitLen = 0;
        int readLen = 0;
        long totalLen = 0L;
        do {
            splitLen = numBytes - totalLen >= (long)TbLob.MAX_CHUNK_SIZE ? TbLob.MAX_CHUNK_SIZE : (int)(numBytes - totalLen);
        } while (numBytes > (totalLen += (long)(readLen = this._read(blob, offset + totalLen, null, outBuffer, totalLen, splitLen))) && splitLen == readLen);
        return totalLen;
    }

    public synchronized long write(TbBlob blob, long pos, byte[] bytes, long offset, long length) throws SQLException {
        boolean firstMsg = true;
        boolean lastMsg = false;
        int splitLen = 0;
        long totalLen = 0L;
        int flag = 0;
        if (length <= (long)TbLob.MAX_CHUNK_SIZE) {
            this._write(blob, pos, null, bytes, offset, length, 0x3000000);
            return length;
        }
        do {
            if (length - totalLen > (long)TbLob.MAX_CHUNK_SIZE) {
                splitLen = TbLob.MAX_CHUNK_SIZE;
            } else {
                splitLen = (int)(length - totalLen);
                lastMsg = true;
            }
            flag = 0;
            if (firstMsg) {
                flag = 0x1000000;
            } else if (lastMsg) {
                flag = 0x2000000;
            }
            try {
                this._write(blob, pos + totalLen, null, bytes, offset + totalLen, splitLen, flag);
            }
            catch (SQLException e) {
                if (!firstMsg) {
                    this.cancel();
                }
                throw e;
            }
            firstMsg = false;
        } while (length > (totalLen += (long)splitLen));
        return totalLen;
    }

    public synchronized void truncate(TbBlob blob, long newLength) throws SQLException {
        this._truncate(blob, newLength);
    }

    public synchronized long position(TbBlob blob, TbBlob searchLob, long start) throws SQLException {
        return this._position((TbLob)blob, searchLob, start);
    }

    public synchronized long position(TbBlob blob, byte[] pattern, long start) throws SQLException {
        return this._position((TbLob)blob, pattern, start);
    }

    public synchronized boolean open(TbBlob blob, int mode) throws SQLException {
        return this._open(blob, mode);
    }

    public synchronized boolean close(TbBlob blob) throws SQLException {
        return this._close(blob);
    }

    public synchronized long length(TbBlob blob) throws SQLException {
        return this._length(blob);
    }

    public synchronized byte[] createTemporaryBlob() throws SQLException {
        return this._createTemporary(12);
    }

    public synchronized void freeTemporaryBlob(TbBlob blob) throws SQLException {
        this._freeTemporary(blob);
    }

    private int _read(TbLob lob, long offset, char[] charBuffer, byte[] byteBuffer, long bufOffset, int length) throws SQLException {
        TbMsgLobRead msg = new TbMsgLobRead(0);
        msg.set((int)(offset >> 32), (int)(offset & 0xFFFFFFFFL), length, lob.getLocator(), lob.getLocatorLength());
        this.stream.sendMsg(msg);
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        switch (replyMsg.getMsgType()) {
            case 36: {
                TbMsgLobReadReply reply = (TbMsgLobReadReply)replyMsg;
                int byteLen = 0;
                if (reply.data != null) {
                    byteLen = reply.data.length;
                }
                if (byteLen == length) {
                    lob.setEndOfStream(false);
                } else {
                    lob.setEndOfStream(true);
                }
                if (byteLen <= 0) {
                    return 0;
                }
                if (lob instanceof TbClob) {
                    return this.doClobReadOK((TbClob)lob, reply, byteLen, charBuffer, bufOffset);
                }
                return this.doBlobReadOK((TbBlob)lob, reply, byteLen, byteBuffer, bufOffset);
            }
            case 76: {
                throw this.getErrorMessage(-90516, replyMsg);
            }
        }
        throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
    }

    private void _write(TbLob lob, long offset, char[] charBuffer, byte[] byteBuffer, long bufOffset, long length, int packetPos) throws SQLException {
        TbMsgLobWrite msg = new TbMsgLobWrite(0);
        msg.set((int)(offset >> 32), (int)(offset & 0xFFFFFFFFL), packetPos, lob.getLocator(), lob.getLocatorLength(), null, 0);
        if (lob instanceof TbClob) {
            int maxLen = this.conn.getTypeConverter().getUCS2MaxBytesPerChar() * (int)length;
            msg.data = new byte[maxLen];
            msg.dataLen = msg.data.length;
            this.conn.getTypeConverter().charsToFixedBytes(charBuffer, (int)bufOffset, (int)length, msg.data, 0, msg.data.length);
        } else {
            int paddingLen = TbCommon.getPadLength((int)length);
            msg.data = new byte[(int)length + paddingLen];
            msg.dataLen = (int)length;
            System.arraycopy(byteBuffer, (int)bufOffset, msg.data, 0, (int)length);
            TbCommon.writePadding(msg.data, (int)length, paddingLen);
        }
        this.stream.sendMsg(msg);
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        switch (replyMsg.getMsgType()) {
            case 75: {
                break;
            }
            case 42: {
                this.doLobWriteReplyOK(lob, replyMsg, packetPos);
                break;
            }
            case 76: {
                throw this.getErrorMessage(-90517, replyMsg);
            }
            default: {
                throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
            }
        }
    }

    private void _truncate(TbLob lob, long newLength) throws SQLException {
        TbMsgLobTrunc msg = new TbMsgLobTrunc(0);
        msg.set((int)(newLength >> 32), (int)(newLength & 0xFFFFFFFFL), lob.getLocator(), lob.getLocatorLength());
        this.stream.sendMsg(msg);
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        switch (replyMsg.getMsgType()) {
            case 38: {
                lob.setLocator(((TbMsgLobTruncReply)replyMsg).slobLoc);
                break;
            }
            case 76: {
                throw this.getErrorMessage(-90520, replyMsg);
            }
            default: {
                throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
            }
        }
    }

    private long _length(TbLob lob) throws SQLException {
        TbMsgLobLength msg = new TbMsgLobLength(0);
        msg.set(lob.getLocator(), lob.getLocatorLength());
        this.stream.sendMsg(msg);
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        switch (replyMsg.getMsgType()) {
            case 34: {
                TbMsgLobLengthReply reply = (TbMsgLobLengthReply)replyMsg;
                return (0xFFFFFFFF00000000L & (long)reply.lenHigh << 32) + (0xFFFFFFFFL & (long)reply.lenLow);
            }
            case 76: {
                throw this.getErrorMessage(-90523, replyMsg);
            }
        }
        throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
    }

    private long _position(TbLob lob, TbLob searchLob, long start) throws SQLException {
        TbMsgLobInlob msg = new TbMsgLobInlob(0);
        msg.set((int)(start >> 32), (int)(start & 0xFFFFFFFFL), lob.getLocator(), lob.getLocatorLength(), searchLob.getLocator(), searchLob.getLocatorLength());
        this.stream.sendMsg(msg);
        try {
            TbMsg replyMsg = this.stream.readMsgHdr();
            this.stream.readMsgBody(replyMsg);
            switch (replyMsg.getMsgType()) {
                case 47: {
                    long position;
                    long l = position = 0xFFFFFFFF00000000L & (long)(((TbMsgLobInlobReply)replyMsg).offsetHigh << 32) + (0xFFFFFFFFL & (long)((TbMsgLobInlobReply)replyMsg).offsetLow);
                    return l;
                }
                case 76: {
                    throw this.getErrorMessage(-90519, replyMsg);
                }
            }
            throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
        }
        finally {
            this.stream.skipUnreadPacketData();
        }
    }

    private long _position(TbLob lob, char[] searchStr, long start) throws SQLException {
        TbMsgLobInstr msg = new TbMsgLobInstr(0);
        msg.set((int)(start >> 32), (int)(start & 0xFFFFFFFFL), lob.getLocator(), lob.getLocatorLength(), searchStr.toString());
        this.stream.sendMsg(msg);
        try {
            TbMsg replyMsg = this.stream.readMsgHdr();
            this.stream.readMsgBody(replyMsg);
            switch (replyMsg.getMsgType()) {
                case 40: {
                    long position;
                    long l = position = 0xFFFFFFFF00000000L & (long)(((TbMsgLobInlobReply)replyMsg).offsetHigh << 32) + (0xFFFFFFFFL & (long)((TbMsgLobInlobReply)replyMsg).offsetLow);
                    return l;
                }
                case 76: {
                    throw this.getErrorMessage(-90518, replyMsg);
                }
            }
            throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
        }
        finally {
            this.stream.skipUnreadPacketData();
        }
    }

    private long _position(TbLob lob, byte[] pattern, long start) throws SQLException {
        TbMsgLobInstr msg = new TbMsgLobInstr(0);
        msg.set((int)(start >> 32), (int)(start & 0xFFFFFFFFL), lob.getLocator(), lob.getLocatorLength(), pattern.toString());
        this.stream.sendMsg(msg);
        try {
            TbMsg replyMsg = this.stream.readMsgHdr();
            this.stream.readMsgBody(replyMsg);
            switch (replyMsg.getMsgType()) {
                case 40: {
                    long position;
                    long l = position = 0xFFFFFFFF00000000L & (long)(((TbMsgLobInlobReply)replyMsg).offsetHigh << 32) + (0xFFFFFFFFL & (long)((TbMsgLobInlobReply)replyMsg).offsetLow);
                    return l;
                }
                case 76: {
                    throw this.getErrorMessage(-90518, replyMsg);
                }
            }
            throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
        }
        finally {
            this.stream.skipUnreadPacketData();
        }
    }

    private boolean _open(TbLob lob, int mode) throws SQLException {
        TbMsgLobOpen msg = new TbMsgLobOpen(0);
        msg.set(mode, lob.getLocator(), lob.getLocatorLength());
        this.stream.sendMsg(msg);
        try {
            TbMsg replyMsg = this.stream.readMsgHdr();
            this.stream.readMsgBody(replyMsg);
            switch (replyMsg.getMsgType()) {
                case 49: {
                    this.doLobOpenOK(lob, (TbMsgLobOpenReply)replyMsg);
                    boolean bl = true;
                    return bl;
                }
                case 76: {
                    throw this.getErrorMessage(-90521, replyMsg);
                }
            }
            throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
        }
        finally {
            this.stream.skipUnreadPacketData();
        }
    }

    private boolean _close(TbLob lob) throws SQLException {
        TbMsgLobClose msg = new TbMsgLobClose(0);
        msg.set(lob.getLocator(), lob.getLocatorLength());
        try {
            TbMsg replyMsg = this.stream.readMsgHdr();
            this.stream.readMsgBody(replyMsg);
            switch (replyMsg.getMsgType()) {
                case 51: {
                    this.doLobCloseOK(lob, (TbMsgLobCloseReply)replyMsg);
                    boolean bl = true;
                    return bl;
                }
                case 76: {
                    throw this.getErrorMessage(-90522, replyMsg);
                }
            }
            throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
        }
        finally {
            this.stream.skipUnreadPacketData();
        }
    }

    private byte[] _createTemporary(int type) throws SQLException {
        TbMsgLobCreateTemp msg = new TbMsgLobCreateTemp(0);
        msg.set(type);
        this.stream.sendMsg(msg);
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        switch (replyMsg.getMsgType()) {
            case 44: {
                return ((TbMsgLobCreateTempReply)replyMsg).slobLoc;
            }
            case 76: {
                throw this.getErrorMessage(-90524, replyMsg);
            }
        }
        throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
    }

    private void _freeTemporary(TbLob lob) throws SQLException {
        TbMsgLobDeleteTemp msg = new TbMsgLobDeleteTemp(0);
        msg.set(lob.getLocator(), lob.getLocatorLength());
        this.stream.sendMsg(msg);
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        switch (replyMsg.getMsgType()) {
            case 75: {
                return;
            }
            case 76: {
                throw this.getErrorMessage(-90525, replyMsg);
            }
        }
        throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
    }

    private int doClobReadOK(TbClob lob, TbMsgLobReadReply msg, int byteLen, char[] buffer, long bufOffset) throws SQLException {
        return this.conn.getTypeConverter().fixedBytesToChars(msg.data, 0, byteLen, buffer, (int)bufOffset, (int)((long)buffer.length - bufOffset));
    }

    private int doBlobReadOK(TbBlob lob, TbMsgLobReadReply msg, int byteLen, byte[] buffer, long bufOffset) {
        System.arraycopy(msg.data, 0, buffer, (int)bufOffset, byteLen);
        return byteLen;
    }

    private void doLobWriteReplyOK(TbLob lob, TbMsg reply, int packetPos) {
        TbMsgLobWriteReply msg = (TbMsgLobWriteReply)reply;
        if ((packetPos & 0x2000000) == 0) {
            return;
        }
        lob.setLocator(msg.slobLoc);
    }

    private void doLobOpenOK(TbLob lob, TbMsgLobOpenReply replyMsg) throws SQLException {
        byte[] updatedLocator = replyMsg.slobLoc;
        lob.setLocator(updatedLocator);
    }

    private void doLobCloseOK(TbLob lob, TbMsgLobCloseReply replyMsg) throws SQLException {
        byte[] updatedLocator = replyMsg.slobLoc;
        lob.setLocator(updatedLocator);
    }

    public synchronized TbSQLInfo getLastExecutedSqlinfo() throws SQLException {
        TbMsgGetLastExecutedSqlinfo getLastExecutedSqlInfoMsg = new TbMsgGetLastExecutedSqlinfo(0);
        getLastExecutedSqlInfoMsg.set(this.conn.getSessionId());
        this.stream.sendMsg(getLastExecutedSqlInfoMsg);
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        switch (replyMsg.getMsgType()) {
            case 74: {
                TbSQLInfo tbSQLInfo = new TbSQLInfo();
                tbSQLInfo.setSqlid(((TbMsgGetLastExecutedSqlinfoReply)replyMsg).sqlid);
                tbSQLInfo.setHashval(((TbMsgGetLastExecutedSqlinfoReply)replyMsg).hashval);
                return tbSQLInfo;
            }
            case 76: {
                this.doErrorReply(-90535, replyMsg);
            }
        }
        throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
    }

    public void dirPathPrepare(TbDirPathStream dirPathStream) throws SQLException {
        TbDirPathMetaData dplMetaData = dirPathStream.getDPLMetaData();
        int columnCnt = dplMetaData.getColumnCnt();
        TbColNameList[] colNameList = new TbColNameList[columnCnt];
        for (int i = 0; i < columnCnt; ++i) {
            colNameList[i] = new TbColNameList();
            colNameList[i].set(dplMetaData.getColumn(i + 1));
        }
        TbMsgDplPrepare dplPrepareMsg = new TbMsgDplPrepare(0);
        int logFlag = dplMetaData.isLogFlag() ? 1 : 0;
        dplPrepareMsg.set(logFlag, dplMetaData.getSchema(), dplMetaData.getTable(), columnCnt, colNameList);
        this.stream.sendMsg(dplPrepareMsg);
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        switch (replyMsg.getMsgType()) {
            case 56: {
                if (columnCnt != ((TbMsgDplPrepareReply)replyMsg).colMeta.length) {
                    throw new SQLException("column count dismatched", "error", 1);
                }
                TbDirColumnMeta[] dirColumnMeta = dirPathStream.getDPLMetaData().getDirColumnMeta();
                TbColumnDesc curColMeta = null;
                for (int i = 0; i < columnCnt; ++i) {
                    curColMeta = ((TbMsgDplPrepareReply)replyMsg).colMeta[i];
                    int precision = -1;
                    int scale = -1;
                    if (DataType.isNumberCategory(curColMeta.dataType) || DataType.isDateCategory(curColMeta.dataType)) {
                        scale = curColMeta.scale;
                        precision = curColMeta.precision;
                    }
                    dirColumnMeta[i].set(curColMeta.name, curColMeta.dataType, precision, scale, curColMeta.etcMeta, curColMeta.maxSize);
                }
                return;
            }
            case 76: {
                this.doErrorReply(-90536, replyMsg);
            }
        }
        throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dirPathLoadStream(TbDirPathStream dirPathStream, TbDirPathStreamDataWriter dplStreamDataWriter, int partialFlag) throws SQLException {
        try {
            dplStreamDataWriter.set(partialFlag);
            this.stream.flush(dplStreamDataWriter);
        }
        finally {
            dplStreamDataWriter.clearStreamBuf();
        }
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        switch (replyMsg.getMsgType()) {
            case 58: {
                int rowCnt = ((TbMsgDplLoadStreamReply)replyMsg).rowCnt;
                int returnCode = ((TbMsgDplLoadStreamReply)replyMsg).returnCode;
                dirPathStream.addRowCnt(rowCnt);
                dirPathStream.setReturnCode(returnCode);
                if (returnCode != 3) break;
                TbSQLException e = ((TbMsgDplLoadStreamReply)replyMsg).getException(-90537);
                throw new TbDirPathException(e.getMessage(), e.getSQLState(), e.getErrorCode(), rowCnt);
            }
            case 76: {
                this.doErrorReply(-90537, replyMsg);
            }
            default: {
                throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
            }
        }
    }

    public void dirPathDataSave(int action) throws SQLException {
        TbMsgDplDatasave dplDatasaveMsg = new TbMsgDplDatasave(0);
        dplDatasaveMsg.set(action);
        this.stream.sendMsg(dplDatasaveMsg);
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        switch (replyMsg.getMsgType()) {
            case 75: {
                this.doCommitReplyOK();
                return;
            }
            case 76: {
                this.doErrorReply(-90538, replyMsg);
                return;
            }
        }
        throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
    }

    public void dirPathFinish() throws SQLException {
        TbMsgDplFinish dplFinishMsg = new TbMsgDplFinish(0);
        this.stream.sendMsg(dplFinishMsg);
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        switch (replyMsg.getMsgType()) {
            case 75: {
                this.doCommitReplyOK();
                return;
            }
            case 76: {
                this.doErrorReply(-90539, replyMsg);
                return;
            }
        }
        throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
    }

    public void dirPathFlushRow() throws SQLException {
        this.stream.sendMsg(new TbMsgDplFlushRow(0));
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        switch (replyMsg.getMsgType()) {
            case 75: {
                this.doCommitReplyOK();
                return;
            }
            case 76: {
                this.doErrorReply(-90540, replyMsg);
                return;
            }
        }
        throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
    }

    public void dirPathAbort() throws SQLException {
        this.stream.sendMsg(new TbMsgDplAbort(0));
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        switch (replyMsg.getMsgType()) {
            case 75: {
                this.doCommitReplyOK();
                return;
            }
            case 76: {
                this.doErrorReply(-90541, replyMsg);
                return;
            }
        }
        throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
    }

    public synchronized void rollback(TbSavepoint savepoint) throws SQLException {
        TbMsgRollback rollbackMsg = new TbMsgRollback(0);
        if (savepoint != null) {
            String savepointName = null;
            try {
                savepointName = savepoint.getSavepointName();
            }
            catch (SQLException e) {
                savepointName = "SVPT" + savepoint.getSavepointId();
            }
            rollbackMsg.set(savepointName);
        }
        this.stream.sendMsg(rollbackMsg);
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        switch (replyMsg.getMsgType()) {
            case 75: {
                this.doRollbackReplyOK();
                break;
            }
            case 76: {
                this.doErrorReply(-90511, replyMsg);
                break;
            }
            default: {
                throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
            }
        }
    }

    public synchronized void setSavePoint(TbSavepoint savepoint) throws SQLException {
        TbMsgSavept saveptMsg = new TbMsgSavept(0);
        String savepointName = null;
        try {
            savepointName = savepoint.getSavepointName();
        }
        catch (SQLException e) {
            savepointName = "SVPT" + savepoint.getSavepointId();
        }
        saveptMsg.set(savepointName);
        this.stream.sendMsg(saveptMsg);
        TbMsg replyMsg = this.stream.readMsgHdr();
        this.stream.readMsgBody(replyMsg);
        switch (replyMsg.getMsgType()) {
            case 75: {
                this.doSavepointReplyOK();
                break;
            }
            case 76: {
                this.doErrorReply(-90514, replyMsg);
                break;
            }
            default: {
                throw new TbSQLException(-90402, "Unsupported Protocol[" + replyMsg.getMsgType() + "]");
            }
        }
    }
}

