/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.TbUserDefinedTypeException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;

public class DataType {
    public static final int NONE = 0;
    public static final int NUMBER = 1;
    public static final int CHAR = 2;
    public static final int VARCHAR = 3;
    public static final int RAW = 4;
    public static final int DATE = 5;
    public static final int TIME = 6;
    public static final int TIMESTAMP = 7;
    public static final int ITV_YTM = 8;
    public static final int ITV_DTS = 9;
    public static final int LONG = 10;
    public static final int LONGRAW = 11;
    public static final int BLOB = 12;
    public static final int CLOB = 13;
    public static final int BFILE = 14;
    public static final int ROWID = 15;
    public static final int CURSOR = 16;
    public static final int UNKNOWN = 17;
    public static final int NCHAR = 18;
    public static final int NVARCHAR = 19;
    public static final int NCLOB = 20;

    public static boolean isNumberCategory(int dataType) {
        return dataType == 1;
    }

    public static boolean isCharacterCategory(int dataType) {
        return dataType == 2 || dataType == 3;
    }

    public static boolean isNationalCategory(int dataType) {
        return dataType == 18 || dataType == 19;
    }

    public static boolean isDateCategory(int dataType) {
        return dataType == 5 || dataType == 6 || dataType == 7;
    }

    public static boolean isValidDataType(int dataType) {
        switch (dataType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    public static void checkValidDataType(int dataType) throws SQLException {
        if (!DataType.isValidDataType(dataType)) {
            throw new TbSQLException(-590703, "" + dataType);
        }
    }

    public static int getSqlType(int dataType) throws SQLException {
        switch (dataType) {
            case 0: {
                return 0;
            }
            case 2: 
            case 18: {
                return 1;
            }
            case 3: 
            case 19: {
                return 12;
            }
            case 1: {
                return 2;
            }
            case 5: {
                return 91;
            }
            case 6: {
                return 92;
            }
            case 7: {
                return 93;
            }
            case 8: {
                return 1111;
            }
            case 9: {
                return 1111;
            }
            case 15: {
                return 1;
            }
            case 4: {
                return -3;
            }
            case 12: {
                return 2004;
            }
            case 13: 
            case 20: {
                return 2005;
            }
            case 10: {
                return -1;
            }
            case 11: {
                return -4;
            }
        }
        throw new TbUserDefinedTypeException(-590703);
    }

    private static String getSqlTypeName(int sqlType) {
        switch (sqlType) {
            case 1111: {
                return "Types.OTHER";
            }
            case 2000: {
                return "Types.JAVA_OBJECT";
            }
            case 2001: {
                return "Types.DISTINCT";
            }
            case 2002: {
                return "Types.STRUCT";
            }
            case 2003: {
                return "Types.ARRAY";
            }
            case 2006: {
                return "Types.REF";
            }
            case -7: {
                return "Types.BIT";
            }
            case 1: {
                return "Types.CHAR";
            }
            case -2: {
                return "Types.BINARY";
            }
            case -3: {
                return "Types.VARBINARY";
            }
            case -4: {
                return "Types.LONGVARBINARY";
            }
            case -1: {
                return "Types.LONGVARCHAR";
            }
            case 12: {
                return "Types.VARCHAR";
            }
            case 3: {
                return "Types.DECIMAL";
            }
            case -5: {
                return "Types.BIGINT";
            }
            case 2: {
                return "Types.NUMERIC";
            }
            case 6: {
                return "Types.FLOAT";
            }
            case 7: {
                return "Types.REAL";
            }
            case 8: {
                return "Types.DOUBLE";
            }
            case -6: {
                return "Types.TINYINT";
            }
            case 5: {
                return "Types.SMALLINT";
            }
            case 4: {
                return "Types.INTEGER";
            }
            case 91: {
                return "Types.DATE";
            }
            case 92: {
                return "Types.TIME";
            }
            case 93: {
                return "Types.TIMESTAMP";
            }
            case 2004: {
                return "Types.BLOB";
            }
            case 2005: {
                return "Types.CLOB";
            }
            case -16: {
                return "Types.CURSOR";
            }
            case 0: {
                return "Types.NULL";
            }
        }
        return "Unknown Type " + sqlType;
    }

    public static String getDataTypeName(int dataType) throws SQLException {
        switch (dataType) {
            case 2: {
                return "CHAR";
            }
            case 3: {
                return "VARCHAR";
            }
            case 1: {
                return "NUMBER";
            }
            case 5: {
                return "DATE";
            }
            case 6: {
                return "TIME";
            }
            case 7: {
                return "TIMESTAMP";
            }
            case 8: {
                return "INTERVAL YEAR TO MONTH";
            }
            case 9: {
                return "INTERVAL DAY TO SECOND";
            }
            case 4: {
                return "RAW";
            }
            case 12: {
                return "BLOB";
            }
            case 13: {
                return "CLOB";
            }
            case 10: {
                return "LONG";
            }
            case 11: {
                return "LONG RAW";
            }
            case 15: {
                return "ROWID";
            }
            case 18: {
                return "NCHAR";
            }
            case 19: {
                return "NVARCHAR";
            }
            case 20: {
                return "NCLOB";
            }
            case 16: {
                return "CURSOR";
            }
        }
        throw new TbUserDefinedTypeException(-590703);
    }

    public static int getDataType(int sqlType) throws SQLException {
        switch (sqlType) {
            case -7: 
            case 1: {
                return 2;
            }
            case -4: 
            case -3: 
            case -2: {
                return 4;
            }
            case -1: 
            case 12: {
                return 3;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return 1;
            }
            case 91: 
            case 92: {
                return 5;
            }
            case 93: {
                return 7;
            }
            case 2004: {
                return 12;
            }
            case 2005: {
                return 13;
            }
            case -16: {
                return 16;
            }
            case 0: {
                return 3;
            }
        }
        throw new TbSQLException(-590704, DataType.getSqlTypeName(sqlType));
    }

    public static int getDataType(Object x) throws SQLException {
        int dataType;
        if (x == null) {
            return 2;
        }
        if (x instanceof String) {
            dataType = 3;
        } else if (x instanceof BigDecimal || x instanceof Short || x instanceof Integer || x instanceof Long || x instanceof Float || x instanceof Double) {
            dataType = 1;
        } else if (x instanceof byte[]) {
            dataType = 4;
        } else if (x instanceof Date) {
            dataType = 5;
        } else if (x instanceof Time) {
            dataType = 6;
        } else if (x instanceof Timestamp) {
            dataType = 7;
        } else if (x instanceof Boolean) {
            dataType = 1;
        } else if (x instanceof Byte) {
            dataType = 2;
        } else if (x instanceof InputStream) {
            dataType = 3;
        } else if (x instanceof Reader) {
            dataType = 3;
        } else {
            throw new TbUserDefinedTypeException(-590703);
        }
        return dataType;
    }

    public static String getDataTypeClassName(int dataType) throws SQLException {
        switch (dataType) {
            case 1: {
                return "java.math.BigDecimal";
            }
            case 2: 
            case 3: 
            case 10: 
            case 18: 
            case 19: {
                return "java.lang.String";
            }
            case 5: {
                return "java.sql.Date";
            }
            case 6: {
                return "java.sql.Time";
            }
            case 7: {
                return "java.sql.Timestamp";
            }
            case 4: 
            case 11: {
                return "byte[]";
            }
            case 15: {
                return "com.tmax.tibero.jdbc.data.TbRowId";
            }
            case 12: {
                return "java.sql.Blob";
            }
            case 13: 
            case 20: {
                return "java.sql.Clob";
            }
            case 16: {
                return "java.sql.ResultSet";
            }
            case 9: {
                return "com.tmax.tibero.jdbc.TbIntervalDts";
            }
            case 8: {
                return "com.tmax.tibero.jdbc.TbIntervalYtm";
            }
        }
        throw new TbUserDefinedTypeException(-590703);
    }

    public static int getSqlType(Object x) throws SQLException {
        if (x == null) {
            return 1;
        }
        if (x instanceof String) {
            return 12;
        }
        if (x instanceof BigDecimal) {
            return 2;
        }
        if (x instanceof Integer) {
            return 4;
        }
        if (x instanceof Long) {
            return -5;
        }
        if (x instanceof Float) {
            return 7;
        }
        if (x instanceof Double) {
            return 8;
        }
        if (x instanceof byte[]) {
            return -3;
        }
        if (x instanceof Date) {
            return 91;
        }
        if (x instanceof Time) {
            return 92;
        }
        if (x instanceof Timestamp) {
            return 93;
        }
        if (x instanceof Boolean) {
            return -7;
        }
        if (x instanceof Clob) {
            return 2005;
        }
        if (x instanceof Blob) {
            return 2004;
        }
        if (x instanceof Array) {
            return 2003;
        }
        if (x instanceof Struct) {
            return 2002;
        }
        if (x instanceof Ref) {
            return 2006;
        }
        if (x instanceof URL) {
            return 70;
        }
        return 2000;
    }
}

