/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbConnection;
import com.tmax.tibero.jdbc.TbIntervalDts;
import com.tmax.tibero.jdbc.TbIntervalYtm;
import com.tmax.tibero.jdbc.TbResultSet;
import com.tmax.tibero.jdbc.TbResultSetFactory;
import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.TbStatement;
import com.tmax.tibero.jdbc.data.BindItem;
import com.tmax.tibero.jdbc.data.Column;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.data.RawData;
import com.tmax.tibero.jdbc.data.TbNrowId;
import com.tmax.tibero.jdbc.data.TbNumber;
import com.tmax.tibero.jdbc.data.TbRowId;
import com.tmax.tibero.jdbc.data.charset.Charset;
import com.tmax.tibero.jdbc.data.charset.CharsetMapper;
import com.tmax.tibero.jdbc.msg.TbColumnDesc;
import com.tmax.tibero.jdbc.util.TbCalendar;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class DataTypeConverter
implements Cloneable {
    private CharsetMapper charsetMapper = new CharsetMapper(Charset.getName(2));
    private CharsetMapper nCharsetMapper = null;
    private TbConnection conn = null;
    private static final TbCalendar cal = new TbCalendar();
    private static final int DEFAULT_CHARSET = 2;

    public DataTypeConverter() throws TbSQLException {
    }

    public DataTypeConverter(TbConnection conn) throws TbSQLException {
        this();
        this.conn = conn;
    }

    private Date _dateFromBytes(byte[] bytes, int offset) {
        int db_century = 0xFF & bytes[offset + 0];
        int db_year = 0xFF & bytes[offset + 1];
        int db_month = 0xFF & bytes[offset + 2];
        int day = 0xFF & bytes[offset + 3];
        int hour = 0xFF & bytes[offset + 4];
        int minute = 0xFF & bytes[offset + 5];
        int second = 0xFF & bytes[offset + 6];
        int year = (db_century - 100) * 100 + (db_year - 100);
        int month = db_month - 1;
        TbCalendar calendar = new TbCalendar();
        calendar.clear();
        calendar.set(year, month, day, hour, minute, second);
        Date date = new Date(calendar.getTimeInMillis());
        return date;
    }

    private Time _timeFromBytes(byte[] bytes, int offset) {
        int hour = 0xFF & bytes[offset];
        int minute = 0xFF & bytes[offset + 1];
        int second = 0xFF & bytes[offset + 2];
        int nanoSec = TbCommon.byte2int(bytes, offset + 4, 4);
        TbCalendar calendar = new TbCalendar();
        calendar.clear();
        calendar.set(10, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(nanoSec);
        Time time = new Time(timestamp.getTime());
        return time;
    }

    private Time _timeFromDateBytes(byte[] bytes, int offset) {
        int hour = 0xFF & bytes[offset + 4];
        int minute = 0xFF & bytes[offset + 5];
        int second = 0xFF & bytes[offset + 6];
        TbCalendar calendar = new TbCalendar();
        calendar.clear();
        calendar.set(10, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        Time time = new Time(calendar.getTimeInMillis());
        return time;
    }

    private Time _timeFromTimestampBytes(byte[] bytes, int offset) {
        int hour = 0xFF & bytes[offset + 4];
        int minute = 0xFF & bytes[offset + 5];
        int second = 0xFF & bytes[offset + 6];
        int nanoSec = TbCommon.byte2intR(bytes, offset + 8, 4);
        TbCalendar calendar = new TbCalendar();
        calendar.clear();
        calendar.set(10, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(nanoSec);
        Time time = new Time(timestamp.getTime());
        return time;
    }

    private Timestamp _timestampFromDateBytes(byte[] bytes, int offset, int length) throws SQLException {
        if (length != 8) {
            throw new TbSQLException(-590705, "corrupted date type");
        }
        int db_century = 0xFF & bytes[offset + 0];
        int db_year = 0xFF & bytes[offset + 1];
        int db_month = 0xFF & bytes[offset + 2];
        int day = 0xFF & bytes[offset + 3];
        int hour = 0xFF & bytes[offset + 4];
        int minute = 0xFF & bytes[offset + 5];
        int second = 0xFF & bytes[offset + 6];
        int year = (db_century - 100) * 100 + (db_year - 100);
        int month = db_month - 1;
        int nanoSec = 0;
        TbCalendar calendar = new TbCalendar();
        calendar.set(year, month, day, hour, minute, second);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(nanoSec);
        return timestamp;
    }

    private Timestamp _timestampFromTimeBytes(byte[] bytes, int offset, int length) throws SQLException {
        if (length != 8) {
            throw new TbSQLException(-590705, "corrupted time type");
        }
        int hour = 0xFF & bytes[offset];
        int minute = 0xFF & bytes[offset + 1];
        int second = 0xFF & bytes[offset + 2];
        int nanoSec = TbCommon.byte2intR(bytes, offset + 4, 4);
        TbCalendar calendar = new TbCalendar();
        calendar.clear();
        calendar.set(10, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(nanoSec);
        return timestamp;
    }

    private Timestamp _timestampFromTimestampBytes(byte[] bytes, int offset, int length) throws SQLException {
        if (length != 12) {
            throw new TbSQLException(-590705, "corrupted timestamp type");
        }
        int db_century = 0xFF & bytes[offset + 0];
        int db_year = 0xFF & bytes[offset + 1];
        int db_month = 0xFF & bytes[offset + 2];
        int day = 0xFF & bytes[offset + 3];
        int hour = 0xFF & bytes[offset + 4];
        int minute = 0xFF & bytes[offset + 5];
        int second = 0xFF & bytes[offset + 6];
        int year = (db_century - 100) * 100 + (db_year - 100);
        int month = db_month - 1;
        int nanoSec = TbCommon.byte2int(bytes, offset + 8, 4);
        TbCalendar calendar = new TbCalendar();
        calendar.set(year, month, day, hour, minute, second);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(nanoSec);
        return timestamp;
    }

    public byte[] bigDecimalToServerTypeCast(BigDecimal data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: 
            case 18: 
            case 19: {
                return this.fromString(data.toString());
            }
            case 1: {
                return this.fromBigDecimal(data);
            }
            case 4: {
                return data.toString().getBytes();
            }
        }
        throw new TbSQLException(-590703, "" + svrType);
    }

    public byte[] binaryToServerTypeCast(byte[] data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: 
            case 18: 
            case 19: {
                return this.fromString(data.toString());
            }
            case 4: {
                return data;
            }
        }
        throw new TbSQLException(-590703, "" + svrType);
    }

    public byte[] booleanToServerTypeCast(boolean data, int svrType) throws SQLException {
        switch (svrType) {
            case 1: {
                if (data) {
                    return this.fromInt(1);
                }
                return this.fromInt(0);
            }
            case 2: 
            case 3: 
            case 18: 
            case 19: {
                if (data) {
                    return this.fromString("1");
                }
                return this.fromString("0");
            }
        }
        throw new TbSQLException(-590703, "" + svrType);
    }

    public void buildColumnMetadata(TbColumnDesc[] colMeta, TbResultSet rs, int colCnt) throws SQLException {
        Column[] cols = rs.getCols();
        Object curColMeta = null;
        for (int i = 0; i < colCnt; ++i) {
            cols[i].set(i, colMeta[i]);
        }
    }

    public int bytesToChars(byte[] srcBytes, int srcStart, int srcLen, char[] destChars, int destStart, int destLen) throws SQLException {
        return this.charsetMapper.bytesToChars(srcBytes, srcStart, srcLen, destChars, destStart, destLen, false);
    }

    public byte[] byteToServerTypeCast(byte data, int svrType) throws SQLException {
        switch (svrType) {
            case 1: {
                return this.fromInt(data);
            }
        }
        throw new TbSQLException(-590703, "" + svrType);
    }

    public int charsToBytes(char[] srcChars, int srcStart, int srcLen, byte[] destBytes, int destStart, int destLen) throws SQLException {
        return this.charsetMapper.charsToBytes(srcChars, srcStart, srcLen, destBytes, destStart, destLen, false);
    }

    public int charsToFixedBytes(char[] srcChars, int srcStart, int srcLen, byte[] destBytes, int destStart, int destLen) throws SQLException {
        byte highByte = 0;
        byte lowByte = 0;
        int j = destStart;
        for (int i = srcStart; i < srcStart + srcLen; ++i) {
            highByte = (byte)(srcChars[i] >> 8 & 0xFF);
            lowByte = (byte)(srcChars[i] & 0xFF);
            if (j + 1 >= destStart + destLen) {
                throw new TbSQLException(-590714, "conversion buffer full");
            }
            destBytes[j] = highByte;
            destBytes[j + 1] = lowByte;
            j += 2;
        }
        return j - destStart;
    }

    public byte[] dateToServerTypeCast(Date data, int svrType) throws SQLException {
        TbCalendar calendar = new TbCalendar();
        calendar.setTime(data);
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: 
            case 18: 
            case 19: {
                return this.fromString(data.toString());
            }
            case 5: {
                return this.fromDate(calendar);
            }
            case 7: {
                return this.fromTimestamp(calendar, 0);
            }
            case 6: {
                return this.fromTime(calendar, 0);
            }
            case 4: {
                return data.toString().getBytes();
            }
        }
        throw new TbSQLException(-590703, "" + svrType);
    }

    public byte[] doubleToServerTypeCast(double data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: 
            case 18: 
            case 19: {
                return this.fromString(new Double(data).toString());
            }
            case 1: {
                return this.fromDouble(data);
            }
            case 4: {
                return new Double(data).toString().getBytes();
            }
        }
        throw new TbSQLException(-590703, "" + svrType);
    }

    public int fixedBytesToChars(byte[] srcBytes, int srcStart, int srcLen, char[] destChars, int destStart, int destLen) throws SQLException {
        int j = destStart;
        if (srcLen % 2 != 0) {
            throw new TbSQLException(-590714, "invalid UCS2 byte array");
        }
        for (int i = srcStart; i < srcStart + srcLen; i += 2) {
            if (j >= destStart + destLen) {
                throw new TbSQLException(-590714, "conversion buffer full");
            }
            destChars[j] = (char)((short)(srcBytes[i] << 8 & 0xFFFF) + (short)(srcBytes[i + 1] & 0xFF));
            ++j;
        }
        return j - destStart;
    }

    public byte[] floatToServerTypeCast(float data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: 
            case 18: 
            case 19: {
                return this.fromString(new Float(data).toString());
            }
            case 1: {
                return this.fromFloat(data);
            }
            case 4: {
                return new Float(data).toString().getBytes();
            }
        }
        throw new TbSQLException(-590703, "" + svrType);
    }

    public byte[] fromBigDecimal(BigDecimal x) throws SQLException {
        return TbNumber.toRawBytes(x);
    }

    public byte[] fromBinaryStreamToBytes(InputStream x, int length) throws SQLException {
        try {
            int maxLen = Math.min(65535, length);
            byte[] bytes = new byte[maxLen];
            int readLen = 0;
            int len = 0;
            while ((len = x.read(bytes, readLen, maxLen - readLen)) != -1 && maxLen > (readLen += len)) {
            }
            return bytes;
        }
        catch (IOException e) {
            throw new TbSQLException(-90616, e.getMessage());
        }
    }

    public byte[] fromBoolean(boolean x) throws SQLException {
        int val = 0;
        if (x) {
            val = 1;
        }
        return this.fromInt(val);
    }

    public byte[] fromByte(byte x) throws SQLException {
        return this.fromInt(x);
    }

    public byte[] fromCharacterStreamToBytes(Reader reader, int length) throws SQLException {
        try {
            int maxLen = Math.min(65535, length);
            char[] chars = new char[maxLen];
            int readLen = reader.read(chars, 0, maxLen);
            String str = new String(chars, 0, readLen);
            byte[] bytes = this.getDBEncodedBytes(str);
            return bytes;
        }
        catch (IOException e) {
            throw new TbSQLException(-90616, e.getMessage());
        }
    }

    public byte[] fromDate(TbCalendar x) throws SQLException {
        byte[] date = new byte[8];
        int year = x.get(1);
        date[0] = (byte)(year / 100 + 100);
        date[1] = (byte)(year % 100 + 100);
        date[2] = (byte)(x.get(2) + 1);
        date[3] = (byte)x.get(5);
        date[4] = x.get(9) == 0 ? (byte)x.get(10) : (byte)(x.get(10) + 12);
        date[5] = (byte)x.get(12);
        date[6] = (byte)x.get(13);
        return date;
    }

    public byte[] fromDouble(double x) throws SQLException {
        return TbNumber.toRawBytes(x);
    }

    public byte[] fromFloat(float x) throws SQLException {
        return TbNumber.toRawBytes(x);
    }

    public byte[] fromInt(int x) throws SQLException {
        return TbNumber.toRawBytes(x);
    }

    public byte[] fromLong(long x) throws SQLException {
        return TbNumber.toRawBytes(x);
    }

    public byte[] fromNString(String x) throws SQLException {
        return this.getDBEncodedNBytes(x);
    }

    public byte[] fromObject(Object x) throws SQLException {
        if (x == null) {
            return new byte[0];
        }
        byte[] bytes = null;
        if (x instanceof String) {
            bytes = this.fromString((String)x);
        } else if (x instanceof BigDecimal) {
            bytes = this.fromBigDecimal((BigDecimal)x);
        } else if (x instanceof Short) {
            bytes = this.fromShort((Short)x);
        } else if (x instanceof Integer) {
            bytes = this.fromInt((Integer)x);
        } else if (x instanceof Long) {
            bytes = this.fromLong((Long)x);
        } else if (x instanceof Float) {
            bytes = this.fromFloat(((Float)x).floatValue());
        } else if (x instanceof Double) {
            bytes = this.fromDouble((Double)x);
        } else if (x instanceof byte[]) {
            bytes = (byte[])x;
        } else if (x instanceof Date) {
            TbCalendar date = new TbCalendar();
            date.setTime((Date)x);
            bytes = this.fromDate(date);
        } else if (x instanceof Time) {
            TbCalendar time = new TbCalendar();
            time.setTimeInMillis(((Time)x).getTime());
            bytes = this.fromTime(time, 0);
        } else if (x instanceof Timestamp) {
            TbCalendar ts = new TbCalendar();
            ts.setTimeInMillis(((Timestamp)x).getTime());
            bytes = this.fromTimestamp(ts, ((Timestamp)x).getNanos());
        } else if (x instanceof Byte) {
            bytes = this.fromByte((Byte)x);
        } else if (x instanceof Boolean) {
            bytes = this.fromBoolean((Boolean)x);
        } else if (x instanceof InputStream) {
            bytes = this.fromBinaryStreamToBytes((InputStream)x, 65535);
        } else if (x instanceof Reader) {
            bytes = this.fromCharacterStreamToBytes((Reader)x, 65535);
        } else {
            throw new TbSQLException(-590703, x.getClass().getName());
        }
        return bytes;
    }

    public byte[] fromShort(short x) throws SQLException {
        return this.fromInt(x);
    }

    public byte[] fromString(String x) throws SQLException {
        return this.getDBEncodedBytes(x);
    }

    public byte[] fromTime(TbCalendar cldr, int nanoSec) throws SQLException {
        byte[] time = new byte[8];
        int amPm = cldr.get(9);
        int hour = cldr.get(10);
        if (amPm == 1) {
            hour += 12;
        }
        time[0] = (byte)hour;
        time[1] = (byte)cldr.get(12);
        time[2] = (byte)cldr.get(13);
        time[3] = 0;
        TbCommon.int2bytes(nanoSec, time, 4, 4);
        return time;
    }

    public byte[] fromTimestamp(TbCalendar x, int nanoSec) throws SQLException {
        byte[] ts = new byte[12];
        int year = x.get(1);
        int amPm = x.get(9);
        int hour = x.get(10);
        if (amPm == 1) {
            hour += 12;
        }
        ts[0] = (byte)(year / 100 + 100);
        ts[1] = (byte)(year % 100 + 100);
        ts[2] = (byte)(x.get(2) + 1);
        ts[3] = (byte)x.get(5);
        ts[4] = (byte)hour;
        ts[5] = (byte)x.get(12);
        ts[6] = (byte)x.get(13);
        TbCommon.int2bytes(nanoSec, ts, 8, 4);
        return ts;
    }

    private TbConnection getConn() {
        return this.conn;
    }

    public String getDBDecodedNString(byte[] bytes, int offset, int length) throws SQLException {
        return this.nCharsetMapper.bytesToString(bytes, offset, length, false);
    }

    public String getDBDecodedString(byte[] bytes) throws SQLException {
        return this.getDBDecodedString(bytes, 0, bytes.length);
    }

    public String getDBDecodedString(byte[] bytes, int offset, int length) throws SQLException {
        return this.charsetMapper.bytesToString(bytes, offset, length, false);
    }

    public byte[] getDBEncodedBytes(String msg) throws SQLException {
        return this.charsetMapper.stringToBytes(msg, false);
    }

    public byte[] getDBEncodedNBytes(String msg) throws SQLException {
        return this.nCharsetMapper.stringToBytes(msg, false);
    }

    public int getEndingBytePos(byte[] srcBytes, int offset) {
        return this.charsetMapper.getEndingBytePos(srcBytes, offset);
    }

    public int getLeadingBytePos(byte[] srcBytes, int offset) {
        return this.charsetMapper.getLeadingBytePos(srcBytes, offset);
    }

    public int getMaxBytesPerChar() {
        return this.charsetMapper.getMaxBytesPerChar();
    }

    public int getUCS2MaxBytesPerChar() {
        return 2;
    }

    public byte[] integerToServerTypeCast(int data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: 
            case 18: 
            case 19: {
                return this.fromString(new Integer(data).toString());
            }
            case 1: {
                return this.fromInt(data);
            }
            case 4: {
                return new Integer(data).toString().getBytes();
            }
        }
        throw new TbSQLException(-590703, "" + svrType);
    }

    public byte[] longToServerTypeCast(long data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: 
            case 18: 
            case 19: {
                return this.fromString(new Long(data).toString());
            }
            case 1: {
                return this.fromLong(data);
            }
            case 4: {
                return new Long(data).toString().getBytes();
            }
        }
        throw new TbSQLException(-590703, "" + svrType);
    }

    public byte[] objectToServerTypeCast(Object data, int svrType) throws SQLException {
        if (data instanceof String) {
            return this.varcharToServerTypeCast((String)data, svrType);
        }
        if (data instanceof Boolean) {
            return this.booleanToServerTypeCast((Boolean)data, svrType);
        }
        if (data instanceof Byte) {
            return this.byteToServerTypeCast((Byte)data, svrType);
        }
        if (data instanceof byte[]) {
            return this.binaryToServerTypeCast((byte[])data, svrType);
        }
        if (data instanceof BigDecimal) {
            return this.bigDecimalToServerTypeCast((BigDecimal)data, svrType);
        }
        if (data instanceof Integer) {
            return this.integerToServerTypeCast((Integer)data, svrType);
        }
        if (data instanceof Float) {
            return this.floatToServerTypeCast(((Float)data).floatValue(), svrType);
        }
        if (data instanceof Double) {
            return this.doubleToServerTypeCast((Double)data, svrType);
        }
        if (data instanceof Long) {
            return this.longToServerTypeCast((Long)data, svrType);
        }
        if (data instanceof Short) {
            return this.shortToServerTypeCast((Short)data, svrType);
        }
        if (data instanceof Date) {
            return this.dateToServerTypeCast((Date)data, svrType);
        }
        if (data instanceof Time) {
            return this.timeToServerTypeCast((Time)data, svrType);
        }
        if (data instanceof Timestamp) {
            return this.timestampToServerTypeCast((Timestamp)data, svrType);
        }
        throw new TbSQLException(-90610);
    }

    public void reset() {
        this.charsetMapper = null;
        this.nCharsetMapper = null;
        this.conn = null;
    }

    public void setCharset(int charset, int nCharset) throws TbSQLException {
        String charsetName = Charset.getName(charset);
        String nCharsetName = Charset.getName(nCharset);
        this.charsetMapper = new CharsetMapper(charsetName);
        this.nCharsetMapper = new CharsetMapper(nCharsetName);
    }

    public byte[] shortToServerTypeCast(short data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: 
            case 18: 
            case 19: {
                return this.fromString(new Short(data).toString());
            }
            case 1: {
                return this.fromShort(data);
            }
            case 4: {
                return new Short(data).toString().getBytes();
            }
        }
        throw new TbSQLException(-590703, "" + svrType);
    }

    public byte[] timestampToServerTypeCast(Timestamp data, int svrType) throws SQLException {
        TbCalendar ts = new TbCalendar();
        ts.setTimeInMillis(data.getTime());
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: 
            case 18: 
            case 19: {
                return this.fromString(data.toString());
            }
            case 5: {
                return this.fromDate(ts);
            }
            case 6: {
                return this.fromTime(ts, data.getNanos());
            }
            case 7: {
                return this.fromTimestamp(ts, data.getNanos());
            }
            case 4: {
                return data.toString().getBytes();
            }
        }
        throw new TbSQLException(-590703, "" + svrType);
    }

    public byte[] timeToServerTypeCast(Time data, int svrType) throws SQLException {
        TbCalendar time = new TbCalendar();
        time.setTimeInMillis(data.getTime());
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: 
            case 18: 
            case 19: {
                return this.fromString(data.toString());
            }
            case 6: {
                return this.fromTime(time, 0);
            }
            case 5: {
                return this.fromDate(time);
            }
            case 7: {
                return this.fromTimestamp(time, 0);
            }
            case 4: {
                return data.toString().getBytes();
            }
        }
        throw new TbSQLException(-590703, "" + svrType);
    }

    public InputStream toAsciiStream(int dataType, RawData rawData) throws SQLException {
        Object data = rawData.getData();
        if (data instanceof byte[]) {
            int offset = 0;
            int length = rawData.getLength();
            byte[] bytes = (byte[])data;
            if (DataType.isCharacterCategory(dataType)) {
                return new ByteArrayInputStream(bytes, offset, length);
            }
            if (dataType == 10) {
                byte[] longLocator = new byte[length];
                System.arraycopy(bytes, offset, longLocator, 0, length);
                String longData = this.getConn().getTbComm().readLong(longLocator);
                return new ByteArrayInputStream(longData.getBytes(), 0, longData.length());
            }
            throw new TbSQLException(-90612);
        }
        throw new TbSQLException(-90612);
    }

    public BigDecimal toBigDecimal(int dataType, RawData rawData) throws SQLException {
        Object data = rawData.getData();
        if (data instanceof byte[]) {
            int offset = 0;
            int length = rawData.getLength();
            byte[] bytes = (byte[])data;
            if (length == 0 || bytes == null) {
                return null;
            }
            if (DataType.isCharacterCategory(dataType)) {
                BigDecimal bd = null;
                try {
                    bd = new BigDecimal(this.getDBDecodedString(bytes, offset, length).trim());
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                return bd;
            }
            if (DataType.isNumberCategory(dataType)) {
                return TbNumber.getBigDecimalFromRawBytes(bytes, offset, length);
            }
            throw new TbSQLException(-90612);
        }
        throw new TbSQLException(-90612);
    }

    public InputStream toBinaryStream(int dataType, RawData rawData) throws SQLException {
        Object data = rawData.getData();
        if (data instanceof InputStream) {
            try {
                ((InputStream)data).reset();
                return (InputStream)data;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new TbSQLException(-90616, e.getMessage());
            }
        }
        if (data instanceof Blob) {
            return ((TbBlob)data).getBinaryStream();
        }
        if (data instanceof byte[]) {
            int offset = 0;
            int length = rawData.getLength();
            byte[] bytes = (byte[])data;
            if (DataType.isCharacterCategory(dataType)) {
                return new ByteArrayInputStream(bytes, offset, length);
            }
            if (dataType == 11) {
                byte[] longLocator = new byte[length];
                System.arraycopy(bytes, offset, longLocator, 0, length);
                byte[] longRawData = this.getConn().getTbComm().readLongBytes(longLocator);
                return new ByteArrayInputStream(longRawData, 0, longRawData.length);
            }
            if (12 == dataType) {
                byte[] locator = new byte[length];
                System.arraycopy(bytes, offset, locator, 0, length);
                TbBlob blob = new TbBlob(this.getConn(), locator);
                InputStream stream = blob.getBinaryStream();
                blob = null;
                return stream;
            }
            throw new TbSQLException(-90612);
        }
        throw new TbSQLException(-90612);
    }

    public Blob toBlob(int dataType, RawData rawData) throws SQLException {
        Object data = rawData.getData();
        if (data instanceof Blob) {
            return (Blob)data;
        }
        if (data instanceof byte[]) {
            int length = rawData.getLength();
            int dataPtr = 0;
            if (12 == dataType) {
                byte[] locator = new byte[length];
                System.arraycopy(data, dataPtr, locator, 0, length);
                return new TbBlob(this.getConn(), locator);
            }
            throw new TbSQLException(-90612);
        }
        throw new TbSQLException(-90612);
    }

    public byte[] toBlobBytes(RawData rawData) throws SQLException {
        Object data = rawData.getData();
        if (data instanceof byte[]) {
            TbBlob blob = (TbBlob)this.toBlob(12, rawData);
            blob.setConnection(this.conn);
            long length = blob.length();
            return blob.getBytes(1L, (int)length);
        }
        throw new TbSQLException(-90612);
    }

    public boolean toBoolean(int dataType, RawData rawData) throws SQLException {
        Object data = rawData.getData();
        if (data instanceof byte[]) {
            int offset = 0;
            int length = rawData.getLength();
            if (DataType.isCharacterCategory(dataType)) {
                String str = this.getDBDecodedString((byte[])data, offset, length).trim();
                return str != null && (str.equals("t") || str.equals("1") || str.equalsIgnoreCase("true"));
            }
            if (DataType.isNationalCategory(dataType)) {
                String str = this.getDBDecodedNString((byte[])data, offset, length).trim();
                return str != null && (str.equals("t") || str.equals("1") || str.equalsIgnoreCase("true"));
            }
            if (DataType.isNumberCategory(dataType)) {
                int i = TbNumber.getIntFromRawBytes((byte[])data, offset, length);
                return i != 0;
            }
            throw new TbSQLException(-90612, DataType.getDataTypeName(dataType));
        }
        throw new TbSQLException(-90612);
    }

    public byte toByte(int dataType, RawData rawData) throws SQLException {
        int i = this.toInt(dataType, rawData);
        if (i > 127 || i < -128) {
            throw new TbSQLException(-90610, "corrupted data format");
        }
        return (byte)i;
    }

    public byte[] toBytes(int dataType, RawData rawData) throws SQLException {
        Object data = rawData.getData();
        if (data instanceof byte[]) {
            if (dataType == 10 || dataType == 11) {
                return this.toLongBytes(rawData);
            }
            if (dataType == 13 || dataType == 20) {
                throw new TbSQLException(-90612);
            }
            if (dataType == 12) {
                return this.toBlobBytes(rawData);
            }
            int offset = 0;
            int length = rawData.getLength();
            byte[] bytes = (byte[])data;
            byte[] newBytes = new byte[length];
            if (length > 0) {
                System.arraycopy(bytes, offset, newBytes, 0, length);
            }
            return newBytes;
        }
        throw new TbSQLException(-90612);
    }

    public Reader toCharacterStream(int dataType, RawData rawData) throws SQLException {
        Object data = rawData.getData();
        if (data instanceof Reader) {
            try {
                ((Reader)data).reset();
                return (Reader)data;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new TbSQLException(-90616, e.getMessage());
            }
        }
        if (data instanceof Clob) {
            return ((TbClob)data).getCharacterStream();
        }
        if (data instanceof byte[]) {
            int offset = 0;
            int length = rawData.getLength();
            byte[] bytes = (byte[])data;
            if (DataType.isCharacterCategory(dataType)) {
                return new InputStreamReader(new ByteArrayInputStream(bytes, offset, length));
            }
            if (dataType == 10) {
                byte[] longLocator = new byte[length];
                System.arraycopy(bytes, offset, longLocator, 0, length);
                String longData = this.getConn().getTbComm().readLong(longLocator);
                return new InputStreamReader(new ByteArrayInputStream(longData.getBytes(), 0, longData.getBytes().length));
            }
            if (dataType == 13 || dataType == 20) {
                byte[] locator = new byte[length];
                System.arraycopy(bytes, offset, locator, 0, length);
                TbClob clob = new TbClob(this.getConn(), locator);
                Reader reader = clob.getCharacterStream();
                clob = null;
                return reader;
            }
            throw new TbSQLException(-90612);
        }
        throw new TbSQLException(-90612);
    }

    public Clob toClob(int dataType, RawData rawData) throws SQLException {
        Object data = rawData.getData();
        if (data instanceof Clob) {
            return (Clob)data;
        }
        if (data instanceof byte[]) {
            int length = rawData.getLength();
            int dataPtr = 0;
            if (dataType == 13 || dataType == 20) {
                byte[] locator = new byte[length];
                System.arraycopy(data, dataPtr, locator, 0, length);
                return new TbClob(this.getConn(), locator);
            }
            throw new TbSQLException(-90612);
        }
        throw new TbSQLException(-90612);
    }

    public Date toDate(int dataType, RawData rawData) throws SQLException {
        Object data = rawData.getData();
        if (data instanceof byte[]) {
            int offset = 0;
            int length = rawData.getLength();
            byte[] bytes = (byte[])data;
            if (length == 0 || bytes == null) {
                return null;
            }
            Date date = null;
            if (DataType.isCharacterCategory(dataType)) {
                try {
                    date = Date.valueOf(this.getDBDecodedString(bytes, offset, length).trim());
                }
                catch (NumberFormatException e) {}
            } else if (dataType == 5) {
                if (length != 8) {
                    throw new TbSQLException(-590705, "corrupted date type");
                }
                date = this._dateFromBytes(bytes, offset);
            } else if (dataType == 7) {
                if (length != 12) {
                    throw new TbSQLException(-590705, "corrupted timestamp type");
                }
                date = this._dateFromBytes(bytes, offset);
            } else {
                throw new TbSQLException(-90612, "" + dataType);
            }
            return date;
        }
        throw new TbSQLException(-90612);
    }

    public double toDouble(int dataType, RawData rawData) throws SQLException {
        Object data = rawData.getData();
        if (data instanceof byte[]) {
            int offset = 0;
            int length = rawData.getLength();
            byte[] bytes = (byte[])data;
            if (DataType.isCharacterCategory(dataType)) {
                double d = 0.0;
                try {
                    d = Double.parseDouble(this.getDBDecodedString(bytes, offset, length).trim());
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                return d;
            }
            if (DataType.isNationalCategory(dataType)) {
                double d = 0.0;
                try {
                    d = Double.parseDouble(this.getDBDecodedNString(bytes, offset, length).trim());
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                return d;
            }
            if (DataType.isNumberCategory(dataType)) {
                return TbNumber.getDoubleFromRawBytes(bytes, offset, length);
            }
            throw new TbSQLException(-90612);
        }
        throw new TbSQLException(-90612);
    }

    public float toFloat(int dataType, RawData rawData) throws SQLException {
        Object data = rawData.getData();
        if (data instanceof byte[]) {
            int offset = 0;
            int length = rawData.getLength();
            byte[] bytes = (byte[])data;
            if (DataType.isCharacterCategory(dataType)) {
                float f = 0.0f;
                try {
                    f = Float.parseFloat(this.getDBDecodedString(bytes, offset, length).trim());
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                return f;
            }
            if (DataType.isNationalCategory(dataType)) {
                float f = 0.0f;
                try {
                    f = Float.parseFloat(this.getDBDecodedNString(bytes, offset, length).trim());
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                return f;
            }
            if (DataType.isNumberCategory(dataType)) {
                return (float)TbNumber.getDoubleFromRawBytes(bytes, offset, length);
            }
            throw new TbSQLException(-90612);
        }
        throw new TbSQLException(-90612);
    }

    public int toInt(int dataType, RawData rawData) throws SQLException {
        Object data = rawData.getData();
        if (data instanceof byte[]) {
            int offset = 0;
            int length = rawData.getLength();
            byte[] bytes = (byte[])data;
            if (DataType.isCharacterCategory(dataType)) {
                if (bytes.length == 0) {
                    return 0;
                }
                try {
                    return Integer.parseInt(this.getDBDecodedString(bytes, offset, length).trim());
                }
                catch (NumberFormatException e) {
                    return TbCommon.byte2int(bytes, offset, length);
                }
            }
            if (DataType.isNationalCategory(dataType)) {
                if (bytes.length == 0) {
                    return 0;
                }
                try {
                    return Integer.parseInt(this.getDBDecodedNString(bytes, offset, length).trim());
                }
                catch (NumberFormatException e) {
                    return TbCommon.byte2int(bytes, offset, length);
                }
            }
            if (DataType.isNumberCategory(dataType)) {
                return TbNumber.getIntFromRawBytes(bytes, offset, length);
            }
            throw new TbSQLException(-90612);
        }
        throw new TbSQLException(-90612);
    }

    public TbIntervalDts toIntervalDts(int dataType, RawData rawData) throws SQLException {
        Object data = rawData.getData();
        if (data instanceof byte[]) {
            int offset = 0;
            int length = rawData.getLength();
            byte[] bytes = (byte[])data;
            if (length == 0 || bytes == null) {
                return null;
            }
            TbIntervalDts intervalDts = null;
            if (dataType != 9) {
                throw new TbSQLException(-90612, "" + dataType);
            }
            byte[] itvDtsBytes = new byte[length];
            System.arraycopy(bytes, offset, itvDtsBytes, 0, length);
            intervalDts = new TbIntervalDts(itvDtsBytes);
            return intervalDts;
        }
        throw new TbSQLException(-90612);
    }

    public TbIntervalYtm toIntervalYtm(int dataType, RawData rawData) throws SQLException {
        Object data = rawData.getData();
        if (data instanceof byte[]) {
            int offset = 0;
            int length = rawData.getLength();
            byte[] bytes = (byte[])data;
            if (length == 0 || bytes == null) {
                return null;
            }
            TbIntervalYtm intervalYtm = null;
            if (dataType != 8) {
                throw new TbSQLException(-90612, "" + dataType);
            }
            byte[] itvYtmBytes = new byte[length];
            System.arraycopy(bytes, offset, itvYtmBytes, 0, length);
            intervalYtm = new TbIntervalYtm(itvYtmBytes);
            return intervalYtm;
        }
        throw new TbSQLException(-90612);
    }

    public long toLong(int dataType, RawData rawData) throws SQLException {
        Object data = rawData.getData();
        if (data instanceof byte[]) {
            int offset = 0;
            int length = rawData.getLength();
            byte[] bytes = (byte[])data;
            if (DataType.isCharacterCategory(dataType)) {
                if (bytes.length == 0) {
                    return 0L;
                }
                try {
                    return Long.parseLong(this.getDBDecodedString(bytes, offset, length).trim());
                }
                catch (NumberFormatException e) {
                    return TbCommon.byte2long(bytes, offset, length);
                }
            }
            if (DataType.isNationalCategory(dataType)) {
                if (bytes.length == 0) {
                    return 0L;
                }
                try {
                    return Long.parseLong(this.getDBDecodedNString(bytes, offset, length).trim());
                }
                catch (NumberFormatException e) {
                    return TbCommon.byte2long(bytes, offset, length);
                }
            }
            if (DataType.isNumberCategory(dataType)) {
                return TbNumber.getLongFromRawBytes(bytes, offset, length);
            }
            throw new TbSQLException(-90612);
        }
        throw new TbSQLException(-90612);
    }

    public byte[] toLongBytes(RawData rawData) throws SQLException {
        Object data = rawData.getData();
        if (data instanceof byte[]) {
            int offset = 0;
            int length = rawData.getLength();
            byte[] longLocator = new byte[length];
            System.arraycopy(data, offset, longLocator, 0, length);
            return this.getConn().getTbComm().readLongBytes(longLocator);
        }
        throw new TbSQLException(-90612);
    }

    public InputStream toLongByteStream(int dataType, RawData rawData) throws SQLException {
        Object data = rawData.getData();
        if (data instanceof byte[]) {
            int offset = 0;
            int length = rawData.getLength();
            byte[] bytes = (byte[])data;
            if (dataType == 10 || dataType == 11) {
                byte[] longLocator = new byte[length];
                System.arraycopy(bytes, offset, longLocator, 0, length);
                byte[] longData = this.getConn().getTbComm().readLongBytes(longLocator);
                return new ByteArrayInputStream(longData, 0, longData.length);
            }
            throw new TbSQLException(-590703);
        }
        throw new TbSQLException(-90612);
    }

    public String toLongString(RawData rawData) throws SQLException {
        Object data = rawData.getData();
        if (data instanceof byte[]) {
            int offset = 0;
            int length = rawData.getLength();
            byte[] longLocator = new byte[length];
            System.arraycopy(data, offset, longLocator, 0, length);
            return this.getConn().getTbComm().readLong(longLocator);
        }
        throw new TbSQLException(-90612);
    }

    public TbNrowId toNrowId(RawData rawData) throws SQLException {
        Object data = rawData.getData();
        if (data instanceof byte[]) {
            int offset = 0;
            byte[] bytes = (byte[])data;
            TbNrowId NrowId = new TbNrowId();
            System.arraycopy(bytes, offset, NrowId.nrowid, 0, 8);
            return NrowId;
        }
        throw new TbSQLException(-90612);
    }

    public Object toObject(int dataType, int sqlType, RawData rawData) throws SQLException {
        switch (dataType) {
            case 2: 
            case 3: 
            case 18: 
            case 19: {
                return this.toString(dataType, rawData);
            }
            case 10: {
                return this.toLongString(rawData);
            }
            case 11: {
                return this.toLongBytes(rawData);
            }
            case 1: {
                BigDecimal bd = this.toBigDecimal(dataType, rawData);
                switch (sqlType) {
                    case -6: 
                    case 4: 
                    case 5: {
                        return new Integer(bd.intValue());
                    }
                    case -5: {
                        return new Long(bd.longValue());
                    }
                    case 7: {
                        return new Float(bd.floatValue());
                    }
                    case 6: 
                    case 8: {
                        return new Double(bd.doubleValue());
                    }
                }
                return bd;
            }
            case 5: {
                if (sqlType == 91) {
                    return this.toDate(dataType, rawData);
                }
                if (sqlType == 92) {
                    return this.toTime(dataType, rawData);
                }
            }
            case 6: {
                return this.toTime(dataType, rawData);
            }
            case 7: {
                return this.toTimestamp(dataType, rawData);
            }
            case 4: {
                return this.toBytes(dataType, rawData);
            }
            case 15: {
                if (this.conn.getServerInfo().getServerIsNanobase() == 1) {
                    return this.toNrowId(rawData);
                }
                return this.toRowId(rawData);
            }
            case 12: {
                return this.toBlob(dataType, rawData);
            }
            case 13: 
            case 20: {
                return this.toClob(dataType, rawData);
            }
            case 9: {
                return this.toIntervalDts(dataType, rawData);
            }
            case 8: {
                return this.toIntervalYtm(dataType, rawData);
            }
        }
        throw new TbSQLException(-590703, "" + dataType);
    }

    public TbResultSet toResultSet(BindItem bindItem, TbStatement stmt, boolean forCursor) throws SQLException {
        RawData rawData = bindItem.getRawData();
        Object data = rawData.getData();
        if (data instanceof byte[]) {
            int length = rawData.getLength();
            int dataPtr = 0;
            int csrId = TbCommon.byte2int((byte[])data, dataPtr, length);
            TbColumnDesc[] colMeta = bindItem.getColMeta();
            if (colMeta == null) {
                throw new TbSQLException(-90644);
            }
            TbResultSet rs = TbResultSetFactory.buildRsetResult(stmt, csrId, colMeta.length, 0, forCursor);
            this.buildColumnMetadata(colMeta, rs, colMeta.length);
            rs.setFetchCompleted(0);
            return rs;
        }
        throw new TbSQLException(-90612);
    }

    public TbResultSet toResultSet(int colCnt, int hiddenColCnt, int csrId, TbColumnDesc[] colMeta, TbStatement stmt) throws SQLException {
        int realColCnt = colCnt - hiddenColCnt;
        TbResultSet rs = TbResultSetFactory.buildRsetResult(stmt, csrId, realColCnt, hiddenColCnt, false);
        this.buildColumnMetadata(colMeta, rs, colCnt);
        rs.setFetchCompleted(0);
        return rs;
    }

    public TbRowId toRowId(RawData rawData) throws SQLException {
        Object data = rawData.getData();
        if (data instanceof byte[]) {
            int offset = 0;
            byte[] bytes = (byte[])data;
            TbRowId rowid = new TbRowId();
            rowid.byteToRowId(this.conn.getServerInfo().getServerEndian(), bytes, offset);
            return rowid;
        }
        throw new TbSQLException(-90612);
    }

    public short toShort(int dataType, RawData rawData) throws SQLException {
        int i = this.toInt(dataType, rawData);
        if (i > Short.MAX_VALUE || i < Short.MIN_VALUE) {
            throw new TbSQLException(-90610, "corrupted data format");
        }
        return (short)i;
    }

    public String toString(int dataType, RawData rawData) throws SQLException {
        Object data = rawData.getData();
        if (data instanceof byte[]) {
            if (DataType.isCharacterCategory(dataType)) {
                int offset = 0;
                int length = rawData.getLength();
                byte[] bytes = (byte[])data;
                if (length == 0 || bytes == null) {
                    return null;
                }
                return this.getDBDecodedString(bytes, offset, length);
            }
            if (dataType == 13 || dataType == 20) {
                TbClob clob = (TbClob)this.toClob(dataType, rawData);
                clob.setConnection(this.conn);
                long clobLength = clob.length();
                return clob.getSubString(1L, (int)clobLength);
            }
            if (dataType == 10) {
                return this.toLongString(rawData);
            }
            if (dataType == 18 || dataType == 19) {
                int offset = 0;
                int length = rawData.getLength();
                byte[] bytes = (byte[])data;
                if (length == 0 || bytes == null) {
                    return null;
                }
                return this.getDBDecodedNString(bytes, offset, length);
            }
            Object obj = null;
            if (dataType == 1) {
                BigDecimal bd = this.toBigDecimal(dataType, rawData);
                if (bd == null) {
                    return null;
                }
                return bd.toString();
            }
            if (dataType == 5) {
                obj = this.toTimestamp(dataType, rawData);
                return obj != null ? obj.toString() : (String)obj;
            }
            obj = this.toObject(dataType, DataType.getSqlType(dataType), rawData);
            return obj != null ? obj.toString() : (String)obj;
        }
        throw new TbSQLException(-90612);
    }

    public Time toTime(int dataType, RawData rawData) throws SQLException {
        Object data = rawData.getData();
        if (data instanceof byte[]) {
            int offset = 0;
            int length = rawData.getLength();
            byte[] bytes = (byte[])data;
            if (length == 0 || bytes == null) {
                return null;
            }
            Time time = null;
            if (DataType.isCharacterCategory(dataType)) {
                try {
                    time = Time.valueOf(this.getDBDecodedString(bytes, offset, length).trim());
                }
                catch (NumberFormatException e) {}
            } else if (dataType == 5) {
                if (length != 8) {
                    throw new TbSQLException(-590705, "corrupted time type");
                }
                time = this._timeFromDateBytes(bytes, offset);
            } else if (dataType == 6) {
                if (length != 8) {
                    throw new TbSQLException(-590705, "corrupted time type");
                }
                time = this._timeFromBytes(bytes, offset);
            } else if (dataType == 7) {
                if (length != 12) {
                    throw new TbSQLException(-590705, "corrupted timestamp type");
                }
                time = this._timeFromTimestampBytes(bytes, offset + 4);
            } else {
                throw new TbSQLException(-90612, "" + dataType);
            }
            return time;
        }
        throw new TbSQLException(-90612);
    }

    public Timestamp toTimestamp(int dataType, RawData rawData) throws SQLException {
        Object data = rawData.getData();
        if (data instanceof byte[]) {
            int offset = 0;
            int length = rawData.getLength();
            byte[] bytes = (byte[])data;
            if (length == 0 || bytes == null) {
                return null;
            }
            Timestamp timestamp = null;
            if (DataType.isCharacterCategory(dataType)) {
                try {
                    timestamp = Timestamp.valueOf(this.getDBDecodedString(bytes, offset, length).trim());
                }
                catch (NumberFormatException e) {}
            } else if (dataType == 5) {
                timestamp = this._timestampFromDateBytes(bytes, offset, length);
            } else if (dataType == 6) {
                timestamp = this._timestampFromTimeBytes(bytes, offset, length);
            } else if (dataType == 7) {
                timestamp = this._timestampFromTimestampBytes(bytes, offset, length);
            } else {
                throw new TbSQLException(-90612, "" + dataType);
            }
            return timestamp;
        }
        throw new TbSQLException(-90612);
    }

    public InputStream toUnicodeStream(int dataType, RawData rawData) throws SQLException {
        if (DataType.isCharacterCategory(dataType)) {
            return new ByteArrayInputStream(this.toString(dataType, rawData).getBytes());
        }
        Object data = rawData.getData();
        if (data instanceof byte[]) {
            int offset = 0;
            int length = rawData.getLength();
            byte[] bytes = (byte[])data;
            if (dataType == 10) {
                byte[] longLocator = new byte[length];
                System.arraycopy(bytes, offset, longLocator, 0, length);
                String longData = this.getConn().getTbComm().readLong(longLocator);
                return new ByteArrayInputStream(longData.getBytes());
            }
            throw new TbSQLException(-90612);
        }
        throw new TbSQLException(-90612);
    }

    public byte[] varcharToRowidCast(String data, int svrType) throws SQLException {
        switch (svrType) {
            case 15: {
                if (this.conn.getServerInfo().getServerIsNanobase() == 1) {
                    TbNrowId nrowid = new TbNrowId();
                    return nrowid.getServerBytes(this.conn.getServerInfo().getServerEndian(), data);
                }
                TbRowId rowid = new TbRowId();
                return rowid.getServerBytes(this.conn.getServerInfo().getServerEndian(), data);
            }
        }
        throw new TbSQLException(-590703, "" + svrType);
    }

    public byte[] varcharToServerTypeCast(String data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: 
            case 18: 
            case 19: {
                return this.fromString(data);
            }
            case 1: {
                BigDecimal bd = new BigDecimal(data);
                return this.fromBigDecimal(bd);
            }
            case 4: {
                return data.toString().getBytes();
            }
            case 5: {
                Date date = Date.valueOf(data);
                cal.setTime(date);
                return this.fromDate(cal);
            }
            case 6: {
                Time time = Time.valueOf(data);
                cal.setTimeInMillis(time.getTime());
                return this.fromTime(cal, 0);
            }
            case 7: {
                Timestamp ts = Timestamp.valueOf(data);
                cal.setTimeInMillis(ts.getTime());
                return this.fromTimestamp(cal, ts.getNanos());
            }
            case 13: 
            case 20: {
                char[] charBuf = data.toCharArray();
                byte[] byteBuf = new byte[charBuf.length * 2];
                this.charsToFixedBytes(charBuf, 0, charBuf.length, byteBuf, 0, byteBuf.length);
                return byteBuf;
            }
        }
        throw new TbSQLException(-590703, "" + svrType);
    }
}

