/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.SQLException;

public class TbNumber {
    private static final int MAX_PRECISION = 38;
    private static final int EXP_BIAS_POS = 65;
    private static final int EXP_BIAS_NEG = 62;
    private static final int MAX_EXP = 62;
    private static final int MIN_EXP = -65;
    private static final int NUMBER_TOP = -16;
    private static final int NUMBER_BOT = 16;
    private static byte[] MAX_INTEGER;
    private static byte[] MIN_INTEGER;
    private static byte[] MAX_LONG;
    private static byte[] MIN_LONG;
    private static byte[] MAX_DOUBLE;
    private static byte[] MIN_DOUBLE;
    private static boolean INT_IS_OUTOFBOUND;
    private static boolean LONG_IS_OUTOFBOUND;
    private static boolean DOUBLE_IS_OUTOFBOUND;
    private static final int[] pow100int;
    private static final long[] pow100long;

    public static int getIntFromRawBytes(byte[] bytes, int offset, int length) throws SQLException {
        int sigLen;
        int exponent;
        boolean isPositive;
        if (length == 1) {
            return 0;
        }
        if (!TbNumber.rangeCheckInt(bytes, offset)) {
            throw new SQLException();
        }
        --length;
        boolean bl = isPositive = (bytes[++offset] & 0x80) != 0;
        if (isPositive) {
            exponent = (bytes[offset] & 0x7F) - 65;
            sigLen = Math.min(exponent + 1, length - 1);
        } else {
            exponent = 62 - (bytes[offset] & 0x7F);
            sigLen = Math.min(exponent + 1, length - 2);
        }
        int result = 0;
        for (int i = 1; i <= sigLen; ++i) {
            result += pow100int[exponent + 1 - i] * TbNumber.digitDecode(isPositive, bytes[offset + i]);
        }
        return isPositive ? result : -result;
    }

    public static long getLongFromRawBytes(byte[] bytes, int offset, int length) throws SQLException {
        int sigLen;
        int exponent;
        boolean isPositive;
        if (length == 1) {
            return 0L;
        }
        if (!TbNumber.rangeCheckLong(bytes, offset)) {
            throw new SQLException();
        }
        --length;
        boolean bl = isPositive = (bytes[++offset] & 0x80) != 0;
        if (isPositive) {
            exponent = (bytes[offset] & 0x7F) - 65;
            sigLen = Math.min(exponent + 1, length - 1);
        } else {
            exponent = 62 - (bytes[offset] & 0x7F);
            sigLen = Math.min(exponent + 1, length - 2);
        }
        long result = 0L;
        for (int i = 1; i <= sigLen; ++i) {
            result += pow100long[exponent + 1 - i] * (long)TbNumber.digitDecode(isPositive, bytes[offset + i]);
        }
        return isPositive ? result : -result;
    }

    public static double getDoubleFromRawBytes(byte[] bytes, int offset, int length) throws SQLException {
        if (!TbNumber.rangeCheckDouble(bytes, offset)) {
            throw new SQLException();
        }
        return Double.valueOf(TbNumber.getRoughSciForm(bytes, offset + 1, length - 1));
    }

    public static BigDecimal getBigDecimalFromRawBytes(byte[] bytes, int offset, int length) throws SQLException {
        if (!TbNumber.isOrdinary(bytes, offset)) {
            throw new SQLException();
        }
        return new BigDecimal(TbNumber.getNormalForm(bytes, offset + 1, length - 1));
    }

    public static byte[] toRawBytes(int num) throws SQLException {
        return TbNumber.fromValidString(Integer.toString(num));
    }

    public static byte[] toRawBytes(long num) throws SQLException {
        return TbNumber.fromValidString(Long.toString(num));
    }

    public static byte[] toRawBytes(float num) throws SQLException {
        return TbNumber.fromValidString(Float.toString(num));
    }

    public static byte[] toRawBytes(double num) throws SQLException {
        return TbNumber.fromValidString(Double.toString(num));
    }

    public static byte[] toRawBytes(BigDecimal num) throws SQLException {
        return TbNumber.fromValidString(num.toString());
    }

    private static byte digitEncode(boolean isPositive, int x) {
        return isPositive ? (byte)(128 + x) : (byte)(128 - x);
    }

    private static int digitDecode(boolean isPositive, byte x) {
        return isPositive ? (byte)(128 + x) : (byte)(128 - x);
    }

    private static byte[] fromValidString(String str) throws SQLException {
        int[] temp_coef = new int[39];
        StringReader sr = new StringReader(str);
        try {
            int orderOfCoef;
            int coefIdx = 0;
            int posLastNonzero = -1;
            int numZeroesFollowingPoint = 0;
            char scan = (char)sr.read();
            boolean isPositive = true;
            if (scan == '-') {
                isPositive = false;
                scan = (char)sr.read();
            } else if (scan == '+') {
                scan = (char)sr.read();
            }
            while (scan == '0') {
                scan = (char)sr.read();
            }
            while (Character.isDigit(scan)) {
                if (coefIdx < 38) {
                    temp_coef[coefIdx] = Character.getNumericValue(scan);
                    if (scan != '0') {
                        posLastNonzero = coefIdx;
                    }
                }
                ++coefIdx;
                scan = (char)sr.read();
            }
            int pos1stNonzeroBeforePoint = coefIdx;
            if (scan == '.') {
                scan = (char)sr.read();
                if (posLastNonzero < 0) {
                    while (scan == '0') {
                        ++numZeroesFollowingPoint;
                        scan = (char)sr.read();
                    }
                }
                while (Character.isDigit(scan)) {
                    if (coefIdx < 38) {
                        temp_coef[coefIdx] = Character.getNumericValue(scan);
                        if (scan != '0') {
                            posLastNonzero = coefIdx;
                        }
                    }
                    ++coefIdx;
                    scan = (char)sr.read();
                }
            }
            int exp10 = 0;
            boolean expIsNegative = false;
            if (scan == 'e' | scan == 'E') {
                scan = (char)sr.read();
                if (scan == '-') {
                    expIsNegative = true;
                    scan = (char)sr.read();
                } else if (scan == '+') {
                    scan = (char)sr.read();
                }
                exp10 = 0;
                while (Character.isDigit(scan)) {
                    exp10 = exp10 * 10 + Character.getNumericValue(scan);
                    scan = (char)sr.read();
                }
            }
            if (posLastNonzero < 0) {
                return TbNumber.toRawBytesZero();
            }
            int n = orderOfCoef = pos1stNonzeroBeforePoint > 0 ? pos1stNonzeroBeforePoint - 1 : -(numZeroesFollowingPoint + 1);
            if (expIsNegative) {
                exp10 = -exp10;
            }
            boolean initialZeroInCoef = ((exp10 += orderOfCoef) & 1) == 0;
            int exp = exp10 >> 1;
            if (exp > 62 || exp < -65) {
                throw new SQLException();
            }
            int totalLen = 1 + (isPositive ? 0 : 1) + (posLastNonzero + 1 + 1 + (initialZeroInCoef ? 1 : 0)) / 2;
            byte[] bytes = new byte[totalLen + 1];
            bytes[0] = (byte)totalLen;
            bytes[1] = isPositive ? (byte)(0x80 | 65 + exp) : (byte)(62 - exp);
            boolean isLower = initialZeroInCoef;
            int sum = 0;
            int t = 2;
            for (int i = 0; i <= posLastNonzero; ++i) {
                if (isLower) {
                    bytes[t++] = TbNumber.digitEncode(isPositive, sum + temp_coef[i]);
                } else {
                    sum = temp_coef[i] * 10;
                }
                isLower = !isLower;
            }
            if (isLower) {
                bytes[t++] = TbNumber.digitEncode(isPositive, sum);
            }
            if (!isPositive) {
                bytes[t++] = -16;
            }
            return bytes;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String getRoughSciForm(byte[] bytes, int offset, int length) {
        int sigLen;
        int exponent;
        boolean isPositive;
        if (length == 1) {
            return "0";
        }
        boolean bl = isPositive = (bytes[offset] & 0x80) != 0;
        if (isPositive) {
            exponent = (bytes[offset] & 0x7F) - 65;
            sigLen = length - 1;
        } else {
            exponent = 62 - (bytes[offset] & 0x7F);
            sigLen = length - 2;
        }
        exponent *= 2;
        StringBuffer buf = new StringBuffer(50);
        if (!isPositive) {
            buf.append('-');
        }
        for (int i = 1; i <= sigLen; ++i) {
            if (i == 2) {
                buf.append('.');
            }
            int dig = TbNumber.digitDecode(isPositive, bytes[offset + i]);
            if (i > 1 && dig < 10) {
                buf.append('0');
            }
            if (i == sigLen && dig % 10 == 0) {
                buf.append(dig / 10);
                if (sigLen != 1) continue;
                ++exponent;
                continue;
            }
            buf.append(dig);
        }
        buf.append('e');
        buf.append(exponent);
        return buf.toString();
    }

    private static String getNormalForm(byte[] bytes, int offset, int length) {
        int i;
        int sigLen;
        int exponent;
        boolean isPositive;
        if (length == 1) {
            return "0";
        }
        boolean bl = isPositive = (bytes[offset] & 0x80) != 0;
        if (isPositive) {
            exponent = (bytes[offset] & 0x7F) - 65;
            sigLen = length - 1;
        } else {
            exponent = 62 - (bytes[offset] & 0x7F);
            sigLen = length - 2;
        }
        exponent *= 2;
        StringBuffer buf = new StringBuffer(50);
        if (!isPositive) {
            buf.append('-');
        }
        if (exponent < 0) {
            buf.append('.');
            for (i = 0; i < -exponent - 2; ++i) {
                buf.append('0');
            }
        }
        for (i = 1; i <= sigLen; ++i) {
            int dig;
            if (exponent >= 0 && i * 2 - 4 == exponent) {
                buf.append('.');
            }
            if ((dig = TbNumber.digitDecode(isPositive, bytes[offset + i])) < 10) {
                if (i > 1 || exponent < 0) {
                    buf.append('0');
                }
                buf.append(dig);
                continue;
            }
            if (i == sigLen && dig % 10 == 0) {
                if (i * 2 - 4 >= exponent) {
                    buf.append(dig / 10);
                    continue;
                }
                buf.append(dig);
                continue;
            }
            buf.append(dig);
        }
        for (i = 0; i < exponent - (sigLen - 1) * 2; ++i) {
            buf.append('0');
        }
        return buf.toString();
    }

    private static byte[] toRawBytesZero() {
        return new byte[]{1, -128};
    }

    private static boolean lessThanOrEqualTo(byte[] x, int xoffset, byte[] y, int yoffset) {
        int minsize = Math.min(x[xoffset], y[yoffset]);
        for (int i = 1; i <= minsize; ++i) {
            if ((byte)(128 + x[xoffset + i]) < (byte)(128 + y[yoffset + i])) {
                return true;
            }
            if ((byte)(128 + x[xoffset + i]) <= (byte)(128 + y[yoffset + i])) continue;
            return false;
        }
        return x[xoffset] <= y[yoffset];
    }

    private static boolean isOrdinary(byte[] x, int offset) {
        return x[offset] == 1 && x[offset + 1] == -128 || x[offset + 2] != -16 && x[offset + 2] != 16;
    }

    private static boolean rangeCheckInt(byte[] x, int offset) {
        return TbNumber.isOrdinary(x, offset) && (INT_IS_OUTOFBOUND || TbNumber.lessThanOrEqualTo(MIN_INTEGER, 0, x, offset) && TbNumber.lessThanOrEqualTo(x, offset, MAX_INTEGER, 0));
    }

    private static boolean rangeCheckLong(byte[] x, int offset) {
        return TbNumber.isOrdinary(x, offset) && (LONG_IS_OUTOFBOUND || TbNumber.lessThanOrEqualTo(MIN_LONG, 0, x, offset) && TbNumber.lessThanOrEqualTo(x, offset, MAX_LONG, 0));
    }

    private static boolean rangeCheckDouble(byte[] x, int offset) {
        return TbNumber.isOrdinary(x, offset) && (DOUBLE_IS_OUTOFBOUND || TbNumber.lessThanOrEqualTo(MIN_DOUBLE, 0, x, offset) && TbNumber.lessThanOrEqualTo(x, offset, MAX_DOUBLE, 0));
    }

    static {
        pow100int = new int[]{1, 100, 10000, 1000000, 100000000};
        pow100long = new long[]{1L, 100L, 10000L, 1000000L, 100000000L, 10000000000L, 1000000000000L, 100000000000000L, 10000000000000000L, 1000000000000000000L};
        try {
            MAX_INTEGER = TbNumber.toRawBytes(Integer.MAX_VALUE);
            MIN_INTEGER = TbNumber.toRawBytes(Integer.MIN_VALUE);
            INT_IS_OUTOFBOUND = false;
        }
        catch (SQLException e) {
            INT_IS_OUTOFBOUND = true;
        }
        try {
            MAX_LONG = TbNumber.toRawBytes(Long.MAX_VALUE);
            MIN_LONG = TbNumber.toRawBytes(Long.MIN_VALUE);
            LONG_IS_OUTOFBOUND = false;
        }
        catch (SQLException e) {
            LONG_IS_OUTOFBOUND = true;
        }
        try {
            MAX_DOUBLE = TbNumber.toRawBytes(Double.MAX_VALUE);
            MIN_DOUBLE = TbNumber.toRawBytes(Double.MIN_VALUE);
            DOUBLE_IS_OUTOFBOUND = false;
        }
        catch (SQLException e) {
            DOUBLE_IS_OUTOFBOUND = true;
        }
    }
}

