/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.dpl;

import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.dpl.TbDirBindItem;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

public class TbDirBindData {
    protected TbDirBindItem[] bindItems = null;

    public String ToString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append(this.toString());
        int len = this.bindItems == null ? 0 : this.bindItems.length;
        for (int i = 0; i < len; ++i) {
            buf.append("[").append(i).append("]").append(this.bindItems[i].ToString());
        }
        return buf.toString();
    }

    public void reuse() {
        if (this.bindItems == null) {
            return;
        }
        int len = this.bindItems.length;
        for (int i = 0; i < len; ++i) {
            this.bindItems[i].reuse();
        }
    }

    public void copyBindData(TbDirBindData src) {
        if (this.bindItems == null) {
            return;
        }
        int len = this.bindItems.length;
        for (int i = 0; i < len; ++i) {
            this.bindItems[i].copyBindItem(src.bindItems[i]);
        }
    }

    public void close() {
        for (int i = 0; i < this.bindItems.length; ++i) {
            this.bindItems[i].close();
            this.bindItems[i] = null;
        }
        this.bindItems = null;
    }

    public TbDirBindData(int fixedLength) throws SQLException {
        if (fixedLength < 0) {
            throw new TbSQLException(-90608, " length < 0 ");
        }
        this.bindItems = new TbDirBindItem[fixedLength];
        for (int i = 0; i < fixedLength; ++i) {
            this.bindItems[i] = new TbDirBindItem();
        }
    }

    private void checkValid(int pos) throws SQLException {
        if (pos < 0 || this.bindItems == null || pos >= this.bindItems.length) {
            throw new TbSQLException(-90609);
        }
    }

    public void setBindItem(int pos, int length, byte[] bytes) throws SQLException {
        this.checkValid(pos);
        this.bindItems[pos].set(length, bytes);
    }

    public void setBindItem(int pos, int length, InputStream binaryStream) throws SQLException {
        this.checkValid(pos);
        this.bindItems[pos].setLength(length);
        this.bindItems[pos].setRawDataStream(binaryStream);
    }

    public void setBindItem(int pos, int length, Reader rawDataReader) throws SQLException {
        this.checkValid(pos);
        this.bindItems[pos].setLength(length);
        this.bindItems[pos].setRawDataReader(rawDataReader);
    }

    public TbDirBindItem[] getBindItem() {
        return this.bindItems;
    }

    public TbDirBindItem getBindItem(int pos) throws SQLException {
        this.checkValid(pos);
        return this.bindItems[pos];
    }

    public int getParameterCnt() {
        return this.bindItems.length;
    }
}

