/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.ext;

import com.tmax.tibero.jdbc.TbConnection;
import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.ext.TbConnectionEventHandler;
import com.tmax.tibero.jdbc.ext.TbXAException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import javax.transaction.xa.Xid;

public class TbLogicalConnection
implements Connection {
    private TbConnectionEventHandler eventHandler = null;
    private TbConnection physicalConn = null;
    private boolean closed = true;
    private boolean useXA = false;

    public void reset() {
        this.eventHandler = null;
        this.physicalConn = null;
    }

    public TbLogicalConnection(TbConnectionEventHandler eventHandler, TbConnection physicalConn, boolean useXA) throws SQLException {
        this.eventHandler = eventHandler;
        this.physicalConn = physicalConn;
        this.useXA = useXA;
        if (physicalConn.isClosed()) {
            this.closed = true;
            TbSQLException sqe = new TbSQLException(-90643);
            throw sqe;
        }
        this.closed = false;
    }

    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        try {
            this.physicalConn.resetSession();
            this.physicalConn.reuse();
            this.closed = true;
            this.eventHandler.notifyClosedEvent();
        }
        catch (SQLException sqe) {
            this.eventHandler.notifyExceptionEvent(sqe);
            throw sqe;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isPhysConnClosed() {
        return this.physicalConn.isClosed();
    }

    public boolean isUseXA() {
        return this.useXA;
    }

    public Statement createStatement() throws SQLException {
        if (this.isClosed()) {
            throw new TbSQLException(-90603);
        }
        try {
            return this.physicalConn.createStatement();
        }
        catch (SQLException sqe) {
            this.eventHandler.notifyExceptionEvent(sqe);
            throw sqe;
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.isClosed()) {
            throw new TbSQLException(-90603);
        }
        try {
            return this.physicalConn.prepareStatement(sql);
        }
        catch (SQLException sqe) {
            this.eventHandler.notifyExceptionEvent(sqe);
            throw sqe;
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        if (this.isClosed()) {
            throw new TbSQLException(-90603);
        }
        try {
            return this.physicalConn.prepareCall(sql);
        }
        catch (SQLException sqe) {
            this.eventHandler.notifyExceptionEvent(sqe);
            throw sqe;
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        if (this.isClosed()) {
            throw new TbSQLException(-90603);
        }
        try {
            return this.physicalConn.nativeSQL(sql);
        }
        catch (SQLException sqe) {
            this.eventHandler.notifyExceptionEvent(sqe);
            throw sqe;
        }
    }

    public void setAutoCommit(boolean flag) throws SQLException {
        if (this.isClosed()) {
            throw new TbSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            if (flag) {
                throw new TbSQLException(-90602);
            }
        } else {
            try {
                this.physicalConn.setAutoCommit(flag);
            }
            catch (SQLException sqe) {
                this.eventHandler.notifyExceptionEvent(sqe);
                throw sqe;
            }
        }
    }

    public boolean getAutoCommit() throws SQLException {
        if (this.isClosed()) {
            throw new TbSQLException(-90603);
        }
        try {
            return this.physicalConn.getAutoCommit();
        }
        catch (SQLException sqe) {
            this.eventHandler.notifyExceptionEvent(sqe);
            throw sqe;
        }
    }

    public void commit() throws SQLException {
        if (this.isClosed()) {
            throw new TbSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            throw new TbSQLException(-90602);
        }
        try {
            this.physicalConn.commit();
        }
        catch (SQLException sqe) {
            this.eventHandler.notifyExceptionEvent(sqe);
            throw sqe;
        }
    }

    public void rollback() throws SQLException {
        if (this.isClosed()) {
            throw new TbSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            throw new TbSQLException(-90602);
        }
        try {
            this.physicalConn.rollback();
        }
        catch (SQLException sqe) {
            this.eventHandler.notifyExceptionEvent(sqe);
            throw sqe;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw new TbSQLException(-90603);
        }
        try {
            return this.physicalConn.getMetaData();
        }
        catch (SQLException sqe) {
            this.eventHandler.notifyExceptionEvent(sqe);
            throw sqe;
        }
    }

    public void setReadOnly(boolean flag) throws SQLException {
        if (this.isClosed()) {
            throw new TbSQLException(-90603);
        }
        try {
            this.physicalConn.setReadOnly(flag);
        }
        catch (SQLException sqe) {
            this.eventHandler.notifyExceptionEvent(sqe);
            throw sqe;
        }
    }

    public boolean isReadOnly() throws SQLException {
        if (this.isClosed()) {
            throw new TbSQLException(-90603);
        }
        try {
            return this.physicalConn.isReadOnly();
        }
        catch (SQLException sqe) {
            this.eventHandler.notifyExceptionEvent(sqe);
            throw sqe;
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        if (this.isClosed()) {
            throw new TbSQLException(-90603);
        }
        try {
            this.physicalConn.setCatalog(catalog);
        }
        catch (SQLException sqe) {
            this.eventHandler.notifyExceptionEvent(sqe);
            throw sqe;
        }
    }

    public String getCatalog() throws SQLException {
        if (this.isClosed()) {
            throw new TbSQLException(-90603);
        }
        try {
            return this.physicalConn.getCatalog();
        }
        catch (SQLException sqe) {
            this.eventHandler.notifyExceptionEvent(sqe);
            throw sqe;
        }
    }

    public void setTransactionIsolation(int isolation) throws SQLException {
        if (this.isClosed()) {
            throw new TbSQLException(-90603);
        }
        try {
            this.physicalConn.setTransactionIsolation(isolation);
        }
        catch (SQLException sqe) {
            this.eventHandler.notifyExceptionEvent(sqe);
            throw sqe;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        if (this.isClosed()) {
            throw new TbSQLException(-90603);
        }
        try {
            return this.physicalConn.getTransactionIsolation();
        }
        catch (SQLException sqe) {
            this.eventHandler.notifyExceptionEvent(sqe);
            throw sqe;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.isClosed()) {
            throw new TbSQLException(-90603);
        }
        try {
            return this.physicalConn.getWarnings();
        }
        catch (SQLException sqe) {
            this.eventHandler.notifyExceptionEvent(sqe);
            throw sqe;
        }
    }

    public void clearWarnings() throws SQLException {
        if (this.isClosed()) {
            throw new TbSQLException(-90603);
        }
        try {
            this.physicalConn.clearWarnings();
        }
        catch (SQLException sqe) {
            this.eventHandler.notifyExceptionEvent(sqe);
            throw sqe;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.isClosed()) {
            throw new TbSQLException(-90603);
        }
        try {
            return this.physicalConn.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException sqe) {
            this.eventHandler.notifyExceptionEvent(sqe);
            throw sqe;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.isClosed()) {
            throw new TbSQLException(-90603);
        }
        try {
            return this.physicalConn.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException sqe) {
            this.eventHandler.notifyExceptionEvent(sqe);
            throw sqe;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.isClosed()) {
            throw new TbSQLException(-90603);
        }
        try {
            return this.physicalConn.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException sqe) {
            this.eventHandler.notifyExceptionEvent(sqe);
            throw sqe;
        }
    }

    public Map getTypeMap() throws SQLException {
        if (this.isClosed()) {
            throw new TbSQLException(-90603);
        }
        try {
            return this.physicalConn.getTypeMap();
        }
        catch (SQLException sqe) {
            this.eventHandler.notifyExceptionEvent(sqe);
            throw sqe;
        }
    }

    public void setTypeMap(Map typeMap) throws SQLException {
        if (this.isClosed()) {
            throw new TbSQLException(-90603);
        }
        try {
            this.physicalConn.setTypeMap(typeMap);
        }
        catch (SQLException sqe) {
            this.eventHandler.notifyExceptionEvent(sqe);
            throw sqe;
        }
    }

    public void start(Xid xid, int flag) throws TbXAException {
        if (!this.isPhysConnClosed() && this.isUseXA()) {
            this.physicalConn.getTbXAComm().xaStart(xid, flag);
        }
    }

    public void end(Xid xid, int flag) throws TbXAException {
        if (!this.isPhysConnClosed() && this.isUseXA()) {
            this.physicalConn.getTbXAComm().xaEnd(xid, flag);
        }
    }

    public void commit(Xid xid, boolean flag) throws TbXAException {
        if (!this.isPhysConnClosed() && this.isUseXA()) {
            this.physicalConn.getTbXAComm().xaCommit(xid, flag);
        }
    }

    public void rollback(Xid xid) throws TbXAException {
        if (!this.isPhysConnClosed() && this.isUseXA()) {
            this.physicalConn.getTbXAComm().xaRollback(xid);
        }
    }

    public Xid[] recover(int flag) throws TbXAException {
        if (!this.isPhysConnClosed() && this.isUseXA()) {
            return this.physicalConn.getTbXAComm().xaRecover(flag);
        }
        throw new TbXAException("recover failed");
    }

    public int prepare(Xid xid) throws TbXAException {
        if (!this.isPhysConnClosed() && this.isUseXA()) {
            return this.physicalConn.getTbXAComm().xaPrepare(xid);
        }
        throw new TbXAException("prepare failed");
    }

    public void forget(Xid xid) throws TbXAException {
    }

    public void setTxnMode(int txnMode) throws TbSQLException {
        if (this.isClosed()) {
            throw new TbSQLException(-90603);
        }
        this.physicalConn.setTxnMode(txnMode);
    }

    public int getTxnMode() throws TbSQLException {
        if (this.isClosed()) {
            throw new TbSQLException(-90603);
        }
        return this.physicalConn.getTxnMode();
    }

    public void setHoldability(int holdability) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public int getHoldability() throws SQLException {
        throw new TbSQLException(-90201);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        if (this.isClosed()) {
            throw new TbSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            throw new TbSQLException(-90602);
        }
        return this.physicalConn.setSavepoint(name);
    }

    public Savepoint setSavepoint() throws SQLException {
        if (this.isClosed()) {
            throw new TbSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            throw new TbSQLException(-90602);
        }
        return this.physicalConn.setSavepoint();
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new TbSQLException(-90201);
    }
}

