/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.ext;

import com.tmax.tibero.jdbc.TbPreparedStatement;
import com.tmax.tibero.jdbc.ext.TbStatementCacheEntry;
import java.sql.SQLException;

public class TbStatementCache {
    private TbStatementCacheEntry cacheEntryHead = null;
    private TbStatementCacheEntry cacheEntryTail;
    private int cacheSize;
    private int numEntry;

    public TbStatementCache(int size) {
        this.cacheSize = size;
        this.numEntry = 0;
    }

    public void add(String sql, int rsetType, int rsetCon, TbPreparedStatement pstmt) throws SQLException {
        if (pstmt.isCachedStmt()) {
            return;
        }
        if (this.numEntry == this.cacheSize) {
            this.purgeLastEntry();
        }
        pstmt.resetCacheEntry();
        TbStatementCacheEntry newEntry = new TbStatementCacheEntry();
        newEntry.sql = sql;
        newEntry.rsetType = rsetType;
        newEntry.rsetCon = rsetCon;
        newEntry.pstmt = pstmt;
        newEntry.next = this.cacheEntryHead;
        if (this.cacheEntryHead != null) {
            this.cacheEntryHead.prev = newEntry;
        }
        this.cacheEntryHead = newEntry;
        if (this.cacheEntryTail == null) {
            this.cacheEntryTail = newEntry;
        }
        ++this.numEntry;
    }

    public void clear() {
        TbStatementCacheEntry item = this.cacheEntryHead;
        while (item != null) {
            try {
                item.clear();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            item = item.next;
        }
        this.cacheEntryHead = null;
        this.numEntry = 0;
    }

    private void purgeLastEntry() throws SQLException {
        TbStatementCacheEntry purgedItem = this.cacheEntryTail;
        purgedItem.prev.next = purgedItem.next;
        purgedItem.clear();
        this.cacheEntryTail = purgedItem.prev;
        --this.numEntry;
    }

    public TbPreparedStatement search(String sql, int rsetType, int rsetCon) throws SQLException {
        TbStatementCacheEntry item = this.cacheEntryHead;
        while (item != null) {
            if (item.sql.equals(sql) && item.rsetType == rsetType && item.rsetCon == rsetCon) {
                if (item.prev != null) {
                    item.prev.next = item.next;
                }
                if (item.next != null) {
                    item.next.prev = item.prev;
                }
                if (item == this.cacheEntryHead) {
                    this.cacheEntryHead = item.next;
                }
                if (item == this.cacheEntryTail) {
                    this.cacheEntryTail = item.prev;
                }
                item.pstmt.initParameter();
                item.pstmt.setCachedStmt(false);
                --this.numEntry;
                return item.pstmt;
            }
            item = item.next;
        }
        return null;
    }
}

