/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgAuthReq
extends TbMsg {
    public int flags;
    public String username;
    public String dbname;
    public String passwd;
    public String progName;
    public int progPid;
    public String nlsDate;
    public String nlsTime;
    public String nlsTimestamp;

    public TbMsgAuthReq(int autoCommit) {
        this.msgType = 1;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(int flags, String username, String dbname, String passwd, String progName, int progPid, String nlsDate, String nlsTime, String nlsTimestamp) {
        this.flags = flags;
        this.username = username;
        this.dbname = dbname;
        this.passwd = passwd;
        this.progName = progName;
        this.progPid = progPid;
        this.nlsDate = nlsDate;
        this.nlsTime = nlsTime;
        this.nlsTimestamp = nlsTimestamp;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeInt(this.flags, 4);
        if (this.username != null) {
            writer.writeLenAndDBEncodedPadString(this.username);
        } else {
            writer.writeInt(0, 4);
        }
        if (this.dbname != null) {
            writer.writeLenAndDBEncodedPadString(this.dbname);
        } else {
            writer.writeInt(0, 4);
        }
        if (this.passwd != null) {
            writer.writeLenAndDBEncodedPadString(this.passwd);
        } else {
            writer.writeInt(0, 4);
        }
        if (this.progName != null) {
            writer.writeLenAndDBEncodedPadString(this.progName);
        } else {
            writer.writeInt(0, 4);
        }
        writer.writeInt(this.progPid, 4);
        if (this.nlsDate != null) {
            writer.writeLenAndDBEncodedPadString(this.nlsDate);
        } else {
            writer.writeInt(0, 4);
        }
        if (this.nlsTime != null) {
            writer.writeLenAndDBEncodedPadString(this.nlsTime);
        } else {
            writer.writeInt(0, 4);
        }
        if (this.nlsTimestamp != null) {
            writer.writeLenAndDBEncodedPadString(this.nlsTimestamp);
        } else {
            writer.writeInt(0, 4);
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        this.flags = reader.readInt32();
        int usernameLen = reader.readInt32();
        this.username = reader.readDBDecodedPadString(usernameLen);
        int dbnameLen = reader.readInt32();
        this.dbname = reader.readDBDecodedPadString(dbnameLen);
        int passwdLen = reader.readInt32();
        this.passwd = reader.readDBDecodedPadString(passwdLen);
        int progNameLen = reader.readInt32();
        this.progName = reader.readDBDecodedPadString(progNameLen);
        this.progPid = reader.readInt32();
        int nlsDateLen = reader.readInt32();
        this.nlsDate = reader.readDBDecodedPadString(nlsDateLen);
        int nlsTimeLen = reader.readInt32();
        this.nlsTime = reader.readDBDecodedPadString(nlsTimeLen);
        int nlsTimestampLen = reader.readInt32();
        this.nlsTimestamp = reader.readDBDecodedPadString(nlsTimestampLen);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgAuthReq msg = (TbMsgAuthReq)obj;
        if (this.flags != msg.flags) {
            return false;
        }
        if (this.username == null && msg.username != null || this.username != null && msg.username == null) {
            return false;
        }
        if (this.username != null && msg.username != null && !this.username.equals(msg.username)) {
            return false;
        }
        if (this.dbname == null && msg.dbname != null || this.dbname != null && msg.dbname == null) {
            return false;
        }
        if (this.dbname != null && msg.dbname != null && !this.dbname.equals(msg.dbname)) {
            return false;
        }
        if (this.passwd == null && msg.passwd != null || this.passwd != null && msg.passwd == null) {
            return false;
        }
        if (this.passwd != null && msg.passwd != null && !this.passwd.equals(msg.passwd)) {
            return false;
        }
        if (this.progName == null && msg.progName != null || this.progName != null && msg.progName == null) {
            return false;
        }
        if (this.progName != null && msg.progName != null && !this.progName.equals(msg.progName)) {
            return false;
        }
        if (this.progPid != msg.progPid) {
            return false;
        }
        if (this.nlsDate == null && msg.nlsDate != null || this.nlsDate != null && msg.nlsDate == null) {
            return false;
        }
        if (this.nlsDate != null && msg.nlsDate != null && !this.nlsDate.equals(msg.nlsDate)) {
            return false;
        }
        if (this.nlsTime == null && msg.nlsTime != null || this.nlsTime != null && msg.nlsTime == null) {
            return false;
        }
        if (this.nlsTime != null && msg.nlsTime != null && !this.nlsTime.equals(msg.nlsTime)) {
            return false;
        }
        if (this.nlsTimestamp == null && msg.nlsTimestamp != null || this.nlsTimestamp != null && msg.nlsTimestamp == null) {
            return false;
        }
        return this.nlsTimestamp == null || msg.nlsTimestamp == null || this.nlsTimestamp.equals(msg.nlsTimestamp);
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgAuthReq]/");
        str.append("flags=");
        str.append(this.flags);
        str.append("/");
        str.append("username=");
        str.append(this.username);
        str.append("/");
        str.append("dbname=");
        str.append(this.dbname);
        str.append("/");
        str.append("passwd=");
        str.append(this.passwd);
        str.append("/");
        str.append("progName=");
        str.append(this.progName);
        str.append("/");
        str.append("progPid=");
        str.append(this.progPid);
        str.append("/");
        str.append("nlsDate=");
        str.append(this.nlsDate);
        str.append("/");
        str.append("nlsTime=");
        str.append(this.nlsTime);
        str.append("/");
        str.append("nlsTimestamp=");
        str.append(this.nlsTimestamp);
        str.append("/");
        return str.append("\n").toString();
    }
}

