/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgLobReadReply
extends TbMsg {
    public byte[] data;
    public int dataLen;

    public TbMsgLobReadReply(int autoCommit) {
        this.msgType = 36;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(byte[] data, int dataLen) {
        this.data = data;
        this.dataLen = dataLen;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        if (this.dataLen != 0) {
            writer.writeInt(this.dataLen, 4);
            writer.writePadBytes(this.data, 0, this.dataLen);
        } else {
            writer.writeInt(0, 4);
            writer.writeInt(0, 4);
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        int dataLen = reader.readInt32();
        if (dataLen != 0) {
            this.data = new byte[dataLen];
            reader.readPadBytes(this.data, 0, dataLen);
        } else {
            reader.moveReadOffset(4);
            this.data = new byte[0];
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgLobReadReply msg = (TbMsgLobReadReply)obj;
        if (this.data == null && msg.data != null || this.data != null && msg.data == null) {
            return false;
        }
        if (this.data != null && msg.data != null) {
            if (this.data.length != msg.data.length) {
                return false;
            }
            for (int i = 0; i < msg.data.length; ++i) {
                if (this.data[i] == msg.data[i]) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgLobReadReply]/");
        str.append("data=");
        if (this.data != null) {
            for (int i = 0; i < this.data.length; ++i) {
                str.append(this.data[i] + "/");
            }
        } else {
            str.append("null/");
        }
        return str.append("\n").toString();
    }
}

