/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgLobTruncReply
extends TbMsg {
    public int lobType;
    public byte[] slobLoc;
    public int slobLocLen;

    public TbMsgLobTruncReply(int autoCommit) {
        this.msgType = 38;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(int lobType, byte[] slobLoc, int slobLocLen) {
        this.lobType = lobType;
        this.slobLoc = slobLoc;
        this.slobLocLen = slobLocLen;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeInt(this.lobType, 4);
        if (this.slobLocLen != 0) {
            writer.writeInt(this.slobLocLen, 4);
            writer.writePadBytes(this.slobLoc, 0, this.slobLocLen);
        } else {
            writer.writeInt(0, 4);
            writer.writeInt(0, 4);
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        this.lobType = reader.readInt32();
        int slobLocLen = reader.readInt32();
        if (slobLocLen != 0) {
            this.slobLoc = new byte[slobLocLen];
            reader.readPadBytes(this.slobLoc, 0, slobLocLen);
        } else {
            reader.moveReadOffset(4);
            this.slobLoc = new byte[0];
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgLobTruncReply msg = (TbMsgLobTruncReply)obj;
        if (this.lobType != msg.lobType) {
            return false;
        }
        if (this.slobLoc == null && msg.slobLoc != null || this.slobLoc != null && msg.slobLoc == null) {
            return false;
        }
        if (this.slobLoc != null && msg.slobLoc != null) {
            if (this.slobLoc.length != msg.slobLoc.length) {
                return false;
            }
            for (int i = 0; i < msg.slobLoc.length; ++i) {
                if (this.slobLoc[i] == msg.slobLoc[i]) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgLobTruncReply]/");
        str.append("lobType=");
        str.append(this.lobType);
        str.append("/");
        str.append("slobLoc=");
        if (this.slobLoc != null) {
            for (int i = 0; i < this.slobLoc.length; ++i) {
                str.append(this.slobLoc[i] + "/");
            }
        } else {
            str.append("null/");
        }
        return str.append("\n").toString();
    }
}

