/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgXaRecoverReply
extends TbMsg {
    public int xidCount;
    public byte[] xids;
    public int xidsLen;

    public TbMsgXaRecoverReply(int autoCommit) {
        this.msgType = 70;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(int xidCount, byte[] xids, int xidsLen) {
        this.xidCount = xidCount;
        this.xids = xids;
        this.xidsLen = xidsLen;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeInt(this.xidCount, 4);
        if (this.xidsLen != 0) {
            writer.writeInt(this.xidsLen, 4);
            writer.writePadBytes(this.xids, 0, this.xidsLen);
        } else {
            writer.writeInt(0, 4);
            writer.writeInt(0, 4);
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        this.xidCount = reader.readInt32();
        int xidsLen = reader.readInt32();
        if (xidsLen != 0) {
            this.xids = new byte[xidsLen];
            reader.readPadBytes(this.xids, 0, xidsLen);
        } else {
            reader.moveReadOffset(4);
            this.xids = new byte[0];
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgXaRecoverReply msg = (TbMsgXaRecoverReply)obj;
        if (this.xidCount != msg.xidCount) {
            return false;
        }
        if (this.xids == null && msg.xids != null || this.xids != null && msg.xids == null) {
            return false;
        }
        if (this.xids != null && msg.xids != null) {
            if (this.xids.length != msg.xids.length) {
                return false;
            }
            for (int i = 0; i < msg.xids.length; ++i) {
                if (this.xids[i] == msg.xids[i]) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgXaRecoverReply]/");
        str.append("xidCount=");
        str.append(this.xidCount);
        str.append("/");
        str.append("xids=");
        if (this.xids != null) {
            for (int i = 0; i < this.xids.length; ++i) {
                str.append(this.xids[i] + "/");
            }
        } else {
            str.append("null/");
        }
        return str.append("\n").toString();
    }
}

