/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbConnection;
import com.tmax.tibero.jdbc.TbPreparedStatement;
import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.data.BindItem;
import com.tmax.tibero.jdbc.data.DataType;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class TbCallableStatement
extends TbPreparedStatement
implements CallableStatement {
    protected boolean lastColumnWasNull = false;
    private static final int DFLT_NAMED_PARAM_CNT = 10;
    private String[] namedParamArr = new String[10];
    private int namedParamCnt = 0;

    public TbCallableStatement(TbConnection conn, String sql) throws SQLException {
        this(conn, sql, 1003, 1007, 50);
    }

    public TbCallableStatement(TbConnection conn, String sql, int rsetType, int rsetConcurrency, int preFetchSize) throws SQLException {
        super(conn, sql, rsetType, rsetConcurrency, preFetchSize, false);
    }

    private int addNamedParam(String paramName) {
        for (int i = 0; i < this.namedParamCnt; ++i) {
            if (!this.namedParamArr[i].equals(paramName)) continue;
            return i + 1;
        }
        if (this.namedParamCnt >= this.namedParamArr.length) {
            String[] newArr = new String[this.namedParamArr.length * 2];
            System.arraycopy(this.namedParamArr, 0, newArr, 0, this.namedParamArr.length);
            this.namedParamArr = newArr;
        }
        this.namedParamArr[this.namedParamCnt++] = paramName;
        return this.namedParamCnt;
    }

    protected void banFunctionUse() throws SQLException {
    }

    void checkBindData() throws SQLException {
        if (this.bindData == null) {
            throw new TbSQLException(-90619);
        }
    }

    private void checkConnClosed() throws SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            throw new TbSQLException(-90603);
        }
    }

    public synchronized void close() throws SQLException {
        super.close();
        this.namedParamArr = null;
        this.namedParamCnt = 0;
    }

    public synchronized boolean execute() throws SQLException {
        if (this.namedParamCnt > 0) {
            this.rewriteQuestionToNamedParam();
        }
        return super.execute();
    }

    public synchronized int executeUpdate() throws SQLException {
        if (this.namedParamCnt > 0) {
            this.rewriteQuestionToNamedParam();
        }
        return super.executeUpdate();
    }

    public Array getArray(int i) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public Array getArray(String parameterName) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        return this.getArray(paramIndex);
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return this.getBigDecimal(parameterIndex, 0);
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.checkConnClosed();
        BindItem item = this.getBindItem(parameterIndex);
        this.setLastColumnWasNull(item);
        if (this.lastColumnWasNull) {
            return null;
        }
        return this.conn.typeConverter.toBigDecimal(item.getExDataType(), item.getRawData());
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        return this.getBigDecimal(paramIndex);
    }

    BindItem getBindItem(int parameterIndex) throws SQLException {
        this.checkBindData();
        return this.bindData.getBindItem(parameterIndex - 1);
    }

    public Blob getBlob(int parameterIndex) throws SQLException {
        this.checkConnClosed();
        BindItem item = this.getBindItem(parameterIndex);
        this.setLastColumnWasNull(item);
        if (this.lastColumnWasNull) {
            return null;
        }
        return this.conn.typeConverter.toBlob(item.getExDataType(), item.getRawData());
    }

    public Blob getBlob(String parameterName) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        return this.getBlob(paramIndex);
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.checkConnClosed();
        BindItem item = this.getBindItem(parameterIndex);
        this.setLastColumnWasNull(item);
        if (this.lastColumnWasNull) {
            return false;
        }
        return this.conn.typeConverter.toBoolean(item.getExDataType(), item.getRawData());
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        return this.getBoolean(paramIndex);
    }

    public byte getByte(int parameterIndex) throws SQLException {
        this.checkConnClosed();
        BindItem item = this.getBindItem(parameterIndex);
        this.setLastColumnWasNull(item);
        if (this.lastColumnWasNull) {
            return 0;
        }
        return this.conn.typeConverter.toByte(item.getExDataType(), item.getRawData());
    }

    public byte getByte(String parameterName) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        return this.getByte(paramIndex);
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.checkConnClosed();
        BindItem item = this.getBindItem(parameterIndex);
        this.setLastColumnWasNull(item);
        if (this.lastColumnWasNull) {
            return null;
        }
        return this.conn.typeConverter.toBytes(item.getExDataType(), item.getRawData());
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        return this.getBytes(paramIndex);
    }

    public Clob getClob(int parameterIndex) throws SQLException {
        this.checkConnClosed();
        BindItem item = this.getBindItem(parameterIndex);
        this.setLastColumnWasNull(item);
        if (this.lastColumnWasNull) {
            return null;
        }
        return this.conn.typeConverter.toClob(item.getExDataType(), item.getRawData());
    }

    public Clob getClob(String parameterName) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        return this.getClob(paramIndex);
    }

    public Date getDate(int parameterIndex) throws SQLException {
        this.checkConnClosed();
        BindItem item = this.getBindItem(parameterIndex);
        this.setLastColumnWasNull(item);
        if (this.lastColumnWasNull) {
            return null;
        }
        return this.conn.typeConverter.toDate(item.getExDataType(), item.getRawData());
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        return this.getDate(parameterIndex);
    }

    public Date getDate(String parameterName) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        return this.getDate(paramIndex);
    }

    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        return this.getDate(paramIndex, cal);
    }

    public double getDouble(int parameterIndex) throws SQLException {
        this.checkConnClosed();
        BindItem item = this.getBindItem(parameterIndex);
        this.setLastColumnWasNull(item);
        if (this.lastColumnWasNull) {
            return 0.0;
        }
        return this.conn.typeConverter.toDouble(item.getExDataType(), item.getRawData());
    }

    public double getDouble(String parameterName) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        return this.getDouble(paramIndex);
    }

    public float getFloat(int parameterIndex) throws SQLException {
        this.checkConnClosed();
        BindItem item = this.getBindItem(parameterIndex);
        this.setLastColumnWasNull(item);
        if (this.lastColumnWasNull) {
            return 0.0f;
        }
        return this.conn.typeConverter.toFloat(item.getExDataType(), item.getRawData());
    }

    public float getFloat(String parameterName) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        return this.getFloat(paramIndex);
    }

    public int getInt(int parameterIndex) throws SQLException {
        this.checkConnClosed();
        BindItem item = this.getBindItem(parameterIndex);
        this.setLastColumnWasNull(item);
        if (this.lastColumnWasNull) {
            return 0;
        }
        return this.conn.typeConverter.toInt(item.getExDataType(), item.getRawData());
    }

    public int getInt(String parameterName) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        return this.getInt(paramIndex);
    }

    public long getLong(int parameterIndex) throws SQLException {
        this.checkConnClosed();
        BindItem item = this.getBindItem(parameterIndex);
        this.setLastColumnWasNull(item);
        if (this.lastColumnWasNull) {
            return 0L;
        }
        return this.conn.typeConverter.toLong(item.getExDataType(), item.getRawData());
    }

    public long getLong(String parameterName) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        return this.getLong(paramIndex);
    }

    public Object getObject(int parameterIndex) throws SQLException {
        this.checkConnClosed();
        BindItem bindItem = this.getBindItem(parameterIndex);
        if (bindItem.getKind() == 1) {
            throw new TbSQLException(-90617, "IN parameter is not allowed");
        }
        if (bindItem.getExDataType() == 16) {
            return this.conn.typeConverter.toResultSet(bindItem, this, true);
        }
        this.setLastColumnWasNull(bindItem);
        if (this.lastColumnWasNull) {
            return null;
        }
        return this.conn.typeConverter.toObject(bindItem.getExDataType(), bindItem.getSqlType(), bindItem.getRawData());
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public Object getObject(String parameterName) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        return this.getObject(paramIndex);
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        return this.getObject(paramIndex, map);
    }

    public Ref getRef(int i) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public Ref getRef(String parameterName) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        return this.getRef(paramIndex);
    }

    public short getShort(int parameterIndex) throws SQLException {
        this.checkConnClosed();
        BindItem item = this.getBindItem(parameterIndex);
        this.setLastColumnWasNull(item);
        if (this.lastColumnWasNull) {
            return 0;
        }
        return this.conn.typeConverter.toShort(item.getExDataType(), item.getRawData());
    }

    public short getShort(String parameterName) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        return this.getShort(paramIndex);
    }

    public String getString(int parameterIndex) throws SQLException {
        this.checkConnClosed();
        BindItem item = this.getBindItem(parameterIndex);
        this.setLastColumnWasNull(item);
        if (this.lastColumnWasNull) {
            return null;
        }
        return this.conn.typeConverter.toString(item.getExDataType(), item.getRawData());
    }

    public String getString(String parameterName) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        return this.getString(paramIndex);
    }

    public Time getTime(int parameterIndex) throws SQLException {
        this.checkConnClosed();
        BindItem item = this.getBindItem(parameterIndex);
        this.setLastColumnWasNull(item);
        if (this.lastColumnWasNull) {
            return null;
        }
        return this.conn.typeConverter.toTime(item.getExDataType(), item.getRawData());
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return this.getTime(parameterIndex);
    }

    public Time getTime(String parameterName) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        return this.getTime(paramIndex);
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        return this.getTime(paramIndex, cal);
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.checkConnClosed();
        BindItem item = this.getBindItem(parameterIndex);
        this.setLastColumnWasNull(item);
        if (this.lastColumnWasNull) {
            return null;
        }
        return this.conn.typeConverter.toTimestamp(item.getExDataType(), item.getRawData());
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(parameterIndex);
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        return this.getTimestamp(paramIndex);
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        return this.getTimestamp(paramIndex, cal);
    }

    public URL getURL(int parameterIndex) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public URL getURL(String parameterName) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        return this.getURL(paramIndex);
    }

    public synchronized void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType, 0);
    }

    public synchronized void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        this.bindData.setBindItem(parameterIndex - 1, 2, sqlType);
        this.bindData.getBindItem(parameterIndex - 1).setExDataType(DataType.getDataType(sqlType));
    }

    public void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        this.registerOutParameter(paramIndex, sqlType);
    }

    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        this.registerOutParameter(paramIndex, sqlType, scale);
    }

    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        this.registerOutParameter(paramIndex, sqlType, typeName);
    }

    private void rewriteQuestionToNamedParam() throws SQLException {
        int j = 0;
        char[] sqlArr = this.originalSql.toCharArray();
        StringBuffer sqlBuf = new StringBuffer();
        if (super.getParameterCnt() != this.namedParamCnt) {
            throw new TbSQLException(-90627);
        }
        for (int i = 0; i < sqlArr.length; ++i) {
            if (sqlArr[i] == '?') {
                sqlBuf.append(this.namedParamArr[j++]);
                sqlBuf.append("=>?");
                continue;
            }
            sqlBuf.append(sqlArr[i]);
        }
        if (j != this.namedParamCnt) {
            throw new TbSQLException(-90627);
        }
        this.originalSql = new String(sqlBuf);
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        super.setAsciiStream(paramIndex, x, length);
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        super.setBigDecimal(paramIndex, x);
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        super.setBinaryStream(paramIndex, x, length);
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        super.setBoolean(paramIndex, x);
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        super.setByte(paramIndex, x);
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        super.setBytes(paramIndex, x);
    }

    public void setCharacterStream(String parameterName, Reader x, int length) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        super.setCharacterStream(paramIndex, x, length);
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        super.setDate(paramIndex, x);
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        super.setDate(paramIndex, x, cal);
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        super.setDouble(paramIndex, x);
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        super.setFloat(paramIndex, x);
    }

    public void setInt(String parameterName, int x) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        super.setInt(paramIndex, x);
    }

    synchronized void setLastColumnWasNull(BindItem item) {
        this.lastColumnWasNull = item.isNull();
    }

    public void setLong(String parameterName, long x) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        super.setLong(paramIndex, x);
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        super.setNull(paramIndex, sqlType);
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        super.setNull(paramIndex, sqlType, typeName);
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        super.setObject(paramIndex, x);
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        super.setObject(paramIndex, x, targetSqlType);
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        super.setObject(paramIndex, x, targetSqlType, scale);
    }

    public void setShort(String parameterName, short x) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        super.setShort(paramIndex, x);
    }

    public void setString(String parameterName, String x) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        super.setString(paramIndex, x);
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        super.setTime(paramIndex, x);
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        super.setTime(paramIndex, x, cal);
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        super.setTimestamp(paramIndex, x);
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        int paramIndex = this.addNamedParam(parameterName);
        super.setTimestamp(paramIndex, x, cal);
    }

    public void setURL(String parameterName, URL val) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public String ToString() {
        StringBuffer buf = new StringBuffer();
        buf.append("==== TbCallableStatement ====");
        buf.append(" lastColumnWasNull[").append(this.lastColumnWasNull).append("]");
        buf.append(super.ToString());
        return buf.toString();
    }

    public synchronized boolean wasNull() throws SQLException {
        return this.lastColumnWasNull;
    }
}

