/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.util.TbError;
import com.tmax.tibero.jdbc.util.TbResourceBundle;
import java.sql.SQLException;
import java.util.MissingResourceException;

public class TbSQLException
extends SQLException {
    private static final long serialVersionUID = -4246010380113127776L;
    private static final String ORA_ERR_CODE_FILE = "com.tmax.tibero.jdbc.OracleErrcode_gen";
    private int errCode = 0;
    private int dmlLine = 0;
    private int dmlCol = 0;
    private static TbResourceBundle _oraErrBundle = new TbResourceBundle(TbSQLException.getBundleFileName());

    public static String getBundleFileName() {
        return ORA_ERR_CODE_FILE;
    }

    public static final int getOraErrCode(int codeNo) {
        try {
            return new Integer(_oraErrBundle.getValue(codeNo));
        }
        catch (MissingResourceException e) {
            return -1;
        }
    }

    public static int getVendorErrCode(int errcode) {
        if (Debug.ORA_COMPATABLE) {
            return TbSQLException.getOraErrCode(errcode);
        }
        return errcode;
    }

    public TbSQLException(int codeNo) {
        super(TbError.getMsg(codeNo), null, TbSQLException.getVendorErrCode(codeNo));
        this.errCode = codeNo;
    }

    public TbSQLException(int codeNo, String moreInfo) {
        super(TbError.getMsg(codeNo) + " - " + moreInfo, null, TbSQLException.getVendorErrCode(codeNo));
        this.errCode = codeNo;
    }

    public TbSQLException(int codeNo, String sqlState, String description) {
        super(description, sqlState, TbSQLException.getVendorErrCode(codeNo));
        this.errCode = codeNo;
    }

    public int getDmlErrorCol() {
        return this.dmlCol;
    }

    public int getDmlErrorLine() {
        return this.dmlLine;
    }

    public int getErrorCode() {
        return this.errCode;
    }

    public void setDmlErrorCol(int col) {
        this.dmlCol = col;
    }

    public void setDmlErrorLine(int line) {
        this.dmlLine = line;
    }
}

