/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.data.charset.ASCIIDecoder;
import com.tmax.tibero.jdbc.data.charset.ASCIIEncoder;
import com.tmax.tibero.jdbc.data.charset.CharsetDecoder;
import com.tmax.tibero.jdbc.data.charset.CharsetEncoder;
import com.tmax.tibero.jdbc.data.charset.EUCKRDecoder;
import com.tmax.tibero.jdbc.data.charset.EUCKREncoder;
import com.tmax.tibero.jdbc.data.charset.MS949Decoder;
import com.tmax.tibero.jdbc.data.charset.MS949Encoder;
import com.tmax.tibero.jdbc.data.charset.SJISDecoder;
import com.tmax.tibero.jdbc.data.charset.SJISEncoder;
import com.tmax.tibero.jdbc.data.charset.UTF16Decoder;
import com.tmax.tibero.jdbc.data.charset.UTF16Encoder;
import com.tmax.tibero.jdbc.data.charset.UTF8Decoder;
import com.tmax.tibero.jdbc.data.charset.UTF8Encoder;
import java.sql.SQLException;

public class CharsetMapper {
    private CharsetEncoder encoder = null;
    private CharsetDecoder decoder = null;

    public CharsetMapper(String serverCharSet) {
        if (serverCharSet.equalsIgnoreCase("EUC-KR")) {
            this.encoder = new EUCKREncoder();
            this.decoder = new EUCKRDecoder();
        } else if (serverCharSet.equalsIgnoreCase("MSWIN949")) {
            this.encoder = new MS949Encoder();
            this.decoder = new MS949Decoder();
        } else if (serverCharSet.equalsIgnoreCase("UTF-8")) {
            this.encoder = new UTF8Encoder();
            this.decoder = new UTF8Decoder();
        } else if (serverCharSet.equalsIgnoreCase("ASCII")) {
            this.encoder = new ASCIIEncoder();
            this.decoder = new ASCIIDecoder();
        } else if (serverCharSet.equalsIgnoreCase("UTF-16")) {
            this.encoder = new UTF16Encoder();
            this.decoder = new UTF16Decoder();
        } else if (serverCharSet.equalsIgnoreCase("SHIFT-JIS")) {
            this.encoder = new SJISEncoder();
            this.decoder = new SJISDecoder();
        }
    }

    public int bytesToChars(byte[] srcBytes, int srcStart, int srcLen, char[] destChars, int destStart, int destLen, boolean forceFixedBytes) throws SQLException {
        if (forceFixedBytes) {
            return this.decoder.fixedBytesToChars(srcBytes, srcStart, srcLen, destChars, destStart, destLen);
        }
        return this.decoder.bytesToChars(srcBytes, srcStart, srcLen, destChars, destStart, destLen);
    }

    public String bytesToString(byte[] srcBytes, int srcStart, int srcLen, boolean forceFixedBytes) throws SQLException {
        if (forceFixedBytes) {
            return this.decoder.fixedBytesToString(srcBytes, srcStart, srcLen);
        }
        return this.decoder.bytesToString(srcBytes, srcStart, srcLen);
    }

    public int charsToBytes(char[] srcChars, int srcStart, int srcLen, byte[] destBytes, int destStart, int destLen, boolean forceFixedBytes) throws SQLException {
        if (forceFixedBytes) {
            return this.encoder.charsToFixedBytes(srcChars, srcStart, srcLen, destBytes, destStart, destLen);
        }
        return this.encoder.charsToBytes(srcChars, srcStart, srcLen, destBytes, destStart, destLen);
    }

    public int getEndingBytePos(byte[] srcBytes, int offset) {
        return this.encoder.getEndingBytePos(srcBytes, offset);
    }

    public int getLeadingBytePos(byte[] srcBytes, int offset) {
        return this.encoder.getLeadingBytePos(srcBytes, offset);
    }

    public int getMaxBytesPerChar() {
        return this.encoder.getMaxBytesPerChar();
    }

    public byte[] stringToBytes(String str, boolean forceFixedBytes) throws SQLException {
        if (forceFixedBytes) {
            return this.encoder.stringToFixedBytes(str);
        }
        return this.encoder.stringToBytes(str);
    }
}

