/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.TbSQLException;

public class UnicodeByteToCharConverter {
    protected boolean subMode = true;
    protected char[] subChars = new char[]{'\ufffd'};
    int originalByteOrder;
    boolean usesMark;

    public UnicodeByteToCharConverter() {
        this.originalByteOrder = 0;
        this.usesMark = true;
    }

    protected UnicodeByteToCharConverter(int i, boolean flag) {
        this.originalByteOrder = i;
        this.usesMark = flag;
    }

    public int convert(byte[] abyte0, int i, int j, char[] ac, int k, int l) throws TbSQLException {
        int i1;
        int byteOrder = 1;
        boolean usesMark = false;
        boolean started = false;
        int leftOverByte = 0;
        boolean leftOver = false;
        if (i >= j) {
            return 0;
        }
        int l1 = 0;
        int i2 = i;
        int j2 = k;
        if (leftOver) {
            i1 = leftOverByte & 0xFF;
            leftOver = false;
        } else {
            i1 = abyte0[i2++] & 0xFF;
        }
        l1 = 1;
        if (usesMark && !started && i2 < j) {
            int j1 = abyte0[i2++] & 0xFF;
            l1 = 2;
            char c = (char)(i1 << 8 | j1);
            int k2 = 0;
            if (c == '\ufeff') {
                k2 = 1;
            } else if (c == '\ufffe') {
                k2 = 2;
            }
            if (byteOrder == 0) {
                if (k2 == 0) {
                    throw new TbSQLException(-590714, "Missing byte-order mark");
                }
                byteOrder = k2;
                if (i2 < j) {
                    i1 = abyte0[i2++] & 0xFF;
                    l1 = 1;
                }
            } else if (k2 == 0) {
                --i2;
                l1 = 1;
            } else if (byteOrder == k2) {
                if (i2 < j) {
                    i1 = abyte0[i2++] & 0xFF;
                    l1 = 1;
                }
            } else {
                throw new TbSQLException(-590714, "Incorrect byte-order mark");
            }
            started = true;
        }
        while (i2 < j) {
            int k1 = abyte0[i2++] & 0xFF;
            l1 = 2;
            char c1 = byteOrder == 1 ? (char)(i1 << 8 | k1) : (char)(k1 << 8 | i1);
            if (c1 == '\ufffe') {
                throw new TbSQLException(-590714, "Reversed byte-order mark");
            }
            if (j2 >= l) {
                throw new TbSQLException(-590714, "Conversion buffer overflow");
            }
            ac[j2++] = c1;
            if (i2 >= j) continue;
            i1 = abyte0[i2++] & 0xFF;
            l1 = 1;
        }
        if (l1 == 1) {
            leftOverByte = i1;
            leftOver = true;
        }
        return j2 - k;
    }
}

