/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.TbColNameList;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgDplPrepare
extends TbMsg {
    public int loggingFlag;
    public String schemaName;
    public String tableName;
    public int colNameListArrayCnt;
    public TbColNameList[] colNameList;

    public TbMsgDplPrepare(int autoCommit) {
        this.msgType = 55;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(int loggingFlag, String schemaName, String tableName, int colNameListArrayCnt, TbColNameList[] colNameList) {
        this.loggingFlag = loggingFlag;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.colNameListArrayCnt = colNameListArrayCnt;
        this.colNameList = colNameList;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeInt(this.loggingFlag, 4);
        if (this.schemaName != null) {
            writer.writeLenAndDBEncodedPadString(this.schemaName);
        } else {
            writer.writeInt(0, 4);
        }
        if (this.tableName != null) {
            writer.writeLenAndDBEncodedPadString(this.tableName);
        } else {
            writer.writeInt(0, 4);
        }
        writer.writeInt(this.colNameListArrayCnt, 4);
        if (this.colNameList != null) {
            for (int i = 0; i < this.colNameListArrayCnt; ++i) {
                this.colNameList[i].serialize(writer);
            }
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        this.loggingFlag = reader.readInt32();
        int schemaNameLen = reader.readInt32();
        this.schemaName = reader.readDBDecodedPadString(schemaNameLen);
        int tableNameLen = reader.readInt32();
        this.tableName = reader.readDBDecodedPadString(tableNameLen);
        int colNameListLen = reader.readInt32();
        if (colNameListLen > 0) {
            this.colNameList = new TbColNameList[colNameListLen];
            for (int i = 0; i < colNameListLen; ++i) {
                this.colNameList[i] = new TbColNameList();
                this.colNameList[i].deserialize(reader);
            }
        } else {
            this.colNameList = null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgDplPrepare msg = (TbMsgDplPrepare)obj;
        if (this.loggingFlag != msg.loggingFlag) {
            return false;
        }
        if (this.schemaName == null && msg.schemaName != null || this.schemaName != null && msg.schemaName == null) {
            return false;
        }
        if (this.schemaName != null && msg.schemaName != null && !this.schemaName.equals(msg.schemaName)) {
            return false;
        }
        if (this.tableName == null && msg.tableName != null || this.tableName != null && msg.tableName == null) {
            return false;
        }
        if (this.tableName != null && msg.tableName != null && !this.tableName.equals(msg.tableName)) {
            return false;
        }
        if (this.colNameList == null && msg.colNameList != null || this.colNameList != null && msg.colNameList == null) {
            return false;
        }
        if (this.colNameList != null && msg.colNameList != null) {
            if (this.colNameList.length != msg.colNameList.length) {
                return false;
            }
            for (int i = 0; i < msg.colNameList.length; ++i) {
                if (this.colNameList[i].equals(msg.colNameList[i])) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgDplPrepare]/");
        str.append("loggingFlag=");
        str.append(this.loggingFlag);
        str.append("/");
        str.append("schemaName=");
        str.append(this.schemaName);
        str.append("/");
        str.append("tableName=");
        str.append(this.tableName);
        str.append("/");
        str.append("colNameList={\n");
        if (this.colNameList != null) {
            for (int i = 0; i < this.colNameList.length; ++i) {
                str.append("  colNameList[" + i + "]=" + this.colNameList[i]);
            }
        } else {
            str.append("=null");
        }
        str.append("}/");
        return str.append("\n").toString();
    }
}

