/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.TbBindParamDesc;
import com.tmax.tibero.jdbc.msg.TbColumnDesc;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgPrepareReply
extends TbMsg {
    public byte[] ppid = new byte[8];
    public int outColCnt;
    public int bindParamCnt;
    public int isPreparedDdl;
    public int hiddenColCnt;
    public String csrName;
    public int colDescArrayCnt;
    public TbColumnDesc[] colDesc;
    public int bindParamMetaArrayCnt;
    public TbBindParamDesc[] bindParamMeta;

    public TbMsgPrepareReply(int autoCommit) {
        this.msgType = 4;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(byte[] ppid, int outColCnt, int bindParamCnt, int isPreparedDdl, int hiddenColCnt, String csrName, int colDescArrayCnt, TbColumnDesc[] colDesc, int bindParamMetaArrayCnt, TbBindParamDesc[] bindParamMeta) {
        this.ppid = ppid;
        this.outColCnt = outColCnt;
        this.bindParamCnt = bindParamCnt;
        this.isPreparedDdl = isPreparedDdl;
        this.hiddenColCnt = hiddenColCnt;
        this.csrName = csrName;
        this.colDescArrayCnt = colDescArrayCnt;
        this.colDesc = colDesc;
        this.bindParamMetaArrayCnt = bindParamMetaArrayCnt;
        this.bindParamMeta = bindParamMeta;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        int i;
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeBytes(this.ppid);
        writer.writeInt(this.outColCnt, 4);
        writer.writeInt(this.bindParamCnt, 4);
        writer.writeInt(this.isPreparedDdl, 4);
        writer.writeInt(this.hiddenColCnt, 4);
        if (this.csrName != null) {
            writer.writeLenAndDBEncodedPadString(this.csrName);
        } else {
            writer.writeInt(0, 4);
        }
        writer.writeInt(this.colDescArrayCnt, 4);
        if (this.colDesc != null) {
            for (i = 0; i < this.colDescArrayCnt; ++i) {
                this.colDesc[i].serialize(writer);
            }
        }
        writer.writeInt(this.bindParamMetaArrayCnt, 4);
        if (this.bindParamMeta != null) {
            for (i = 0; i < this.bindParamMetaArrayCnt; ++i) {
                this.bindParamMeta[i].serialize(writer);
            }
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        int bindParamMetaLen;
        reader.readBytes(this.ppid, 0, 8);
        this.outColCnt = reader.readInt32();
        this.bindParamCnt = reader.readInt32();
        this.isPreparedDdl = reader.readInt32();
        this.hiddenColCnt = reader.readInt32();
        int csrNameLen = reader.readInt32();
        this.csrName = reader.readDBDecodedPadString(csrNameLen);
        int colDescLen = reader.readInt32();
        if (colDescLen > 0) {
            this.colDesc = new TbColumnDesc[colDescLen];
            for (int i = 0; i < colDescLen; ++i) {
                this.colDesc[i] = new TbColumnDesc();
                this.colDesc[i].deserialize(reader);
            }
        } else {
            this.colDesc = null;
        }
        if ((bindParamMetaLen = reader.readInt32()) > 0) {
            this.bindParamMeta = new TbBindParamDesc[bindParamMetaLen];
            for (int i = 0; i < bindParamMetaLen; ++i) {
                this.bindParamMeta[i] = new TbBindParamDesc();
                this.bindParamMeta[i].deserialize(reader);
            }
        } else {
            this.bindParamMeta = null;
        }
    }

    public boolean equals(Object obj) {
        int i;
        if (obj == null) {
            return false;
        }
        TbMsgPrepareReply msg = (TbMsgPrepareReply)obj;
        if (this.ppid == null && msg.ppid != null || this.ppid != null && msg.ppid == null) {
            return false;
        }
        if (this.ppid != null && msg.ppid != null) {
            if (this.ppid.length != msg.ppid.length) {
                return false;
            }
            for (i = 0; i < msg.ppid.length; ++i) {
                if (this.ppid[i] == msg.ppid[i]) continue;
                return false;
            }
        }
        if (this.outColCnt != msg.outColCnt) {
            return false;
        }
        if (this.bindParamCnt != msg.bindParamCnt) {
            return false;
        }
        if (this.isPreparedDdl != msg.isPreparedDdl) {
            return false;
        }
        if (this.hiddenColCnt != msg.hiddenColCnt) {
            return false;
        }
        if (this.csrName == null && msg.csrName != null || this.csrName != null && msg.csrName == null) {
            return false;
        }
        if (this.csrName != null && msg.csrName != null && !this.csrName.equals(msg.csrName)) {
            return false;
        }
        if (this.colDesc == null && msg.colDesc != null || this.colDesc != null && msg.colDesc == null) {
            return false;
        }
        if (this.colDesc != null && msg.colDesc != null) {
            if (this.colDesc.length != msg.colDesc.length) {
                return false;
            }
            for (i = 0; i < msg.colDesc.length; ++i) {
                if (this.colDesc[i].equals(msg.colDesc[i])) continue;
                return false;
            }
        }
        if (this.bindParamMeta == null && msg.bindParamMeta != null || this.bindParamMeta != null && msg.bindParamMeta == null) {
            return false;
        }
        if (this.bindParamMeta != null && msg.bindParamMeta != null) {
            if (this.bindParamMeta.length != msg.bindParamMeta.length) {
                return false;
            }
            for (i = 0; i < msg.bindParamMeta.length; ++i) {
                if (this.bindParamMeta[i].equals(msg.bindParamMeta[i])) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        int i;
        StringBuffer str = new StringBuffer("[TbMsgPrepareReply]/");
        str.append("ppid=");
        if (this.ppid != null) {
            for (i = 0; i < this.ppid.length; ++i) {
                str.append(this.ppid[i] + "/");
            }
        } else {
            str.append("null/");
        }
        str.append("outColCnt=");
        str.append(this.outColCnt);
        str.append("/");
        str.append("bindParamCnt=");
        str.append(this.bindParamCnt);
        str.append("/");
        str.append("isPreparedDdl=");
        str.append(this.isPreparedDdl);
        str.append("/");
        str.append("hiddenColCnt=");
        str.append(this.hiddenColCnt);
        str.append("/");
        str.append("csrName=");
        str.append(this.csrName);
        str.append("/");
        str.append("colDesc={\n");
        if (this.colDesc != null) {
            for (i = 0; i < this.colDesc.length; ++i) {
                str.append("  colDesc[" + i + "]=" + this.colDesc[i]);
            }
        } else {
            str.append("=null");
        }
        str.append("}/");
        str.append("bindParamMeta={\n");
        if (this.bindParamMeta != null) {
            for (i = 0; i < this.bindParamMeta.length; ++i) {
                str.append("  bindParamMeta[" + i + "]=" + this.bindParamMeta[i]);
            }
        } else {
            str.append("=null");
        }
        str.append("}/");
        return str.append("\n").toString();
    }
}

