/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgSvrAuthReqWithVer
extends TbMsg {
    public int protocolMajor;
    public int protocolMinor;
    public int service;
    public String username;
    public String dbname;
    public byte[] passwd;
    public int passwdLen;

    public TbMsgSvrAuthReqWithVer(int autoCommit) {
        this.msgType = 138;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(int protocolMajor, int protocolMinor, int service, String username, String dbname, byte[] passwd, int passwdLen) {
        this.protocolMajor = protocolMajor;
        this.protocolMinor = protocolMinor;
        this.service = service;
        this.username = username;
        this.dbname = dbname;
        this.passwd = passwd;
        this.passwdLen = passwdLen;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeInt(this.protocolMajor, 4);
        writer.writeInt(this.protocolMinor, 4);
        writer.writeInt(this.service, 4);
        if (this.username != null) {
            writer.writeLenAndDBEncodedPadString(this.username);
        } else {
            writer.writeInt(0, 4);
        }
        if (this.dbname != null) {
            writer.writeLenAndDBEncodedPadString(this.dbname);
        } else {
            writer.writeInt(0, 4);
        }
        if (this.passwdLen != 0) {
            writer.writeInt(this.passwdLen, 4);
            writer.writePadBytes(this.passwd, 0, this.passwdLen);
        } else {
            writer.writeInt(0, 4);
            writer.writeInt(0, 4);
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        this.protocolMajor = reader.readInt32();
        this.protocolMinor = reader.readInt32();
        this.service = reader.readInt32();
        int usernameLen = reader.readInt32();
        this.username = reader.readDBDecodedPadString(usernameLen);
        int dbnameLen = reader.readInt32();
        this.dbname = reader.readDBDecodedPadString(dbnameLen);
        int passwdLen = reader.readInt32();
        if (passwdLen != 0) {
            this.passwd = new byte[passwdLen];
            reader.readPadBytes(this.passwd, 0, passwdLen);
        } else {
            reader.moveReadOffset(4);
            this.passwd = new byte[0];
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgSvrAuthReqWithVer msg = (TbMsgSvrAuthReqWithVer)obj;
        if (this.protocolMajor != msg.protocolMajor) {
            return false;
        }
        if (this.protocolMinor != msg.protocolMinor) {
            return false;
        }
        if (this.service != msg.service) {
            return false;
        }
        if (this.username == null && msg.username != null || this.username != null && msg.username == null) {
            return false;
        }
        if (this.username != null && msg.username != null && !this.username.equals(msg.username)) {
            return false;
        }
        if (this.dbname == null && msg.dbname != null || this.dbname != null && msg.dbname == null) {
            return false;
        }
        if (this.dbname != null && msg.dbname != null && !this.dbname.equals(msg.dbname)) {
            return false;
        }
        if (this.passwd == null && msg.passwd != null || this.passwd != null && msg.passwd == null) {
            return false;
        }
        if (this.passwd != null && msg.passwd != null) {
            if (this.passwd.length != msg.passwd.length) {
                return false;
            }
            for (int i = 0; i < msg.passwd.length; ++i) {
                if (this.passwd[i] == msg.passwd[i]) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgSvrAuthReqWithVer]/");
        str.append("protocolMajor=");
        str.append(this.protocolMajor);
        str.append("/");
        str.append("protocolMinor=");
        str.append(this.protocolMinor);
        str.append("/");
        str.append("service=");
        str.append(this.service);
        str.append("/");
        str.append("username=");
        str.append(this.username);
        str.append("/");
        str.append("dbname=");
        str.append(this.dbname);
        str.append("/");
        str.append("passwd=");
        if (this.passwd != null) {
            for (int i = 0; i < this.passwd.length; ++i) {
                str.append(this.passwd[i] + "/");
            }
        } else {
            str.append("null/");
        }
        return str.append("\n").toString();
    }
}

