/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.util;

public class TbSqlTypeScanner {
    private static final char NULL = '\u0000';
    private static final int STATE_START = 0;
    private static final int STATE_1 = 1;
    private static final int STATE_2 = 2;
    private static final int STATE_3 = 3;
    private static final int STATE_4 = 4;
    private static final int STATE_5 = 5;
    private static final int STATE_6 = 6;
    private static final int STATE_DONE = 10;
    public static final int UNKNOWN_STMT = 0;
    public static final int SELECT_DML = 1;
    public static final int UPDATE_DML = 2;
    public static final int OTHER_DML = 3;
    public static final int DDL = 4;
    public static final int TRAN_STMT = 5;
    public static final int SESS_STMT = 6;
    public static final int SYSTEM_STMT = 7;
    private int state;
    private int index;
    private char[] sqlText;

    public int getCurrentIndex() {
        return this.index;
    }

    private char getNextChar() {
        if (this.index < this.sqlText.length) {
            return this.sqlText[this.index++];
        }
        return '\u0000';
    }

    public synchronized int getSqlType(String sql) {
        this.sqlText = sql.toCharArray();
        this.index = 0;
        String curToken = this.getToken();
        if (curToken.equals("(")) {
            curToken = this.getToken();
        }
        if (curToken.equals("SELECT")) {
            return 1;
        }
        if (curToken.equals("DELETE") || curToken.equals("INSERT") || curToken.equals("UPDATE")) {
            return 2;
        }
        if (curToken.equals("CALL") || curToken.equals("EXPLAIN") || curToken.equals("LOCK ") || curToken.equals("MERGE")) {
            return 3;
        }
        if (curToken.equals("CREATE") || curToken.equals("DROP") || curToken.equals("COMMENT") || curToken.equals("GRANT") || curToken.equals("RENAME") || curToken.equals("REVOKE") || curToken.equals("TRUNCATE")) {
            return 4;
        }
        if (curToken.equals("ALTER")) {
            curToken = this.getToken();
            if (curToken.equals("SESSION")) {
                return 6;
            }
            if (curToken.equals("SYSTEM")) {
                return 7;
            }
        } else {
            if (curToken.equals("COMMIT") || curToken.equals("ROLLBACK")) {
                return 5;
            }
            if (curToken.equals("SET") && (curToken = this.getToken()).equals("ROLE")) {
                return 6;
            }
        }
        return 0;
    }

    private String getToken() {
        this.state = 0;
        StringBuffer token = new StringBuffer(32);
        while (this.state != 10) {
            char chr = this.getNextChar();
            boolean save = true;
            block0 : switch (this.state) {
                case 0: {
                    switch (chr) {
                        case '/': {
                            this.state = 1;
                            break block0;
                        }
                        case '-': {
                            this.state = 4;
                            break block0;
                        }
                        case '\'': {
                            this.state = 6;
                            break block0;
                        }
                        case '(': 
                        case ')': {
                            if (token.length() > 0) {
                                this.state = 10;
                                save = false;
                                this.ungetNextChar();
                                break block0;
                            }
                            this.state = 10;
                            save = true;
                            break block0;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (token.length() > 0) {
                                this.state = 10;
                            }
                            save = false;
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            save = false;
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (chr) {
                        case '*': {
                            this.state = 2;
                            save = false;
                            token.delete(token.length() - 1, token.length());
                            break block0;
                        }
                        case '(': 
                        case ')': {
                            this.state = 10;
                            save = false;
                            this.ungetNextChar();
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            save = false;
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 2: {
                    switch (chr) {
                        case '*': {
                            this.state = 3;
                            save = false;
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            save = false;
                            break block0;
                        }
                    }
                    save = false;
                    break;
                }
                case 3: {
                    switch (chr) {
                        case '*': {
                            save = false;
                            break block0;
                        }
                        case '/': {
                            this.state = 0;
                            save = false;
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            save = false;
                            break block0;
                        }
                    }
                    this.state = 2;
                    save = false;
                    break;
                }
                case 4: {
                    switch (chr) {
                        case '-': {
                            this.state = 5;
                            save = false;
                            token.delete(token.length() - 1, token.length());
                            break block0;
                        }
                        case '(': 
                        case ')': {
                            this.state = 10;
                            save = false;
                            this.ungetNextChar();
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            save = false;
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 5: {
                    switch (chr) {
                        case '\n': 
                        case '\r': {
                            this.state = 0;
                            this.ungetNextChar();
                            save = false;
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            save = false;
                            break block0;
                        }
                    }
                    save = false;
                    break;
                }
                case 6: {
                    switch (chr) {
                        case '\'': {
                            this.state = 0;
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            save = false;
                            break block0;
                        }
                    }
                }
            }
            if (!save) continue;
            token.append(chr);
        }
        return token.substring(0, token.length()).toUpperCase();
    }

    private void ungetNextChar() {
        --this.index;
    }
}

