/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.ABConnection;
import Altibase.jdbc.driver.ex;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Properties;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class ABPooledConnection
implements XAConnection,
Serializable,
PooledConnection {
    static final long serialVersionUID = 1L;
    private boolean isUseConn = false;
    private LinkedList list = new LinkedList();
    protected ABConnection con;
    boolean autoCommit = false;

    ABPooledConnection(Connection con) throws SQLException {
        this.con = (ABConnection)con;
        this.con.setPooledConnection(this);
        this.autoCommit = con.getAutoCommit();
    }

    ABPooledConnection(Connection con, boolean autoCommit) throws SQLException {
        this.con = (ABConnection)con;
        this.con.setPooledConnection(this);
        this.autoCommit = autoCommit;
        con.setAutoCommit(autoCommit);
    }

    ABPooledConnection(Properties prop) throws SQLException {
        this.con = new ABConnection(prop);
        this.con.setPooledConnection(this);
        this.autoCommit = this.con.getAutoCommit();
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.list.add(connectionEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.con == null) {
            this.fireConnectionClosed();
            return;
        }
        if (this.list.size() > 0) {
            if (!this.con.getAutoCommit()) {
                try {
                    this.con.rollback();
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            try {
                this.con.setPooledConnection(null);
                this.con.close();
            }
            catch (SQLException sQLException) {
            }
            finally {
                this.fireConnectionClosed();
                this.con = null;
            }
        }
    }

    void fireConnectionClosed() {
        if (this.isUseConn) {
            this.isUseConn = false;
            ConnectionEvent evt = new ConnectionEvent(this);
            for (int i = 0; i < this.list.size(); ++i) {
                ((ConnectionEventListener)this.list.getLast()).connectionClosed(evt);
                this.list.removeLast();
            }
        }
    }

    void fireConnectionFatalError(SQLException e) {
        ConnectionEvent evt = new ConnectionEvent(this, e);
        ConnectionEventListener[] local = this.list.toArray(new ConnectionEventListener[this.list.size()]);
        for (int i = 0; i < local.length; ++i) {
            local[i].connectionErrorOccurred(evt);
        }
    }

    public Connection getConnection() throws SQLException {
        ex.test(this.con == null, (short)26);
        if (this.isUseConn) {
            this.isUseConn = false;
            this.con.close();
            this.isUseConn = true;
            this.con.resetCallClose();
            return this.con;
        }
        this.con.clearWarnings();
        this.isUseConn = true;
        this.con.connect();
        if (!this.con.getAutoCommit()) {
            try {
                this.con.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (!this.con.isXaOpened()) {
            this.con.setAutoCommit(this.autoCommit);
        }
        this.con.resetCallClose();
        return this.con;
    }

    public int getTimeStamp() throws SQLException {
        ex.test(this.con == null, (short)26);
        return this.con.getTimeStamp();
    }

    public XAResource getXAResource() throws SQLException {
        return this.con.xa_open();
    }

    public int hashCode() {
        return this.con.hashCode();
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.list.remove(connectionEventListener);
    }

    void setAutoCommit(boolean commitMode) throws SQLException {
        if (commitMode != this.autoCommit) {
            this.autoCommit = commitMode;
            this.con.setAutoCommit(this.autoCommit);
        }
    }
}

