/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.LobUpdater;
import Altibase.jdbc.driver.SQLStates;
import Altibase.jdbc.driver.cmp;
import Altibase.jdbc.driver.ex;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.SQLException;

class Blob
implements java.sql.Blob,
LobUpdater,
SQLStates {
    protected long locator;
    protected cmp chn;
    protected long capacity;
    protected long limit;
    protected long position;
    protected long mark;
    protected Object link;
    private static byte[] zerob = new byte[0];

    Blob() {
        this.capacity = -1L;
        this.init(0L, null);
    }

    public Blob(byte[] b) throws SQLException {
        this(b, 0, b.length);
    }

    public Blob(byte[] b, int offset, int size) throws SQLException {
        ex.exception((short)30);
    }

    Blob(java.io.InputStream is) throws SQLException {
        this.link = is;
        this.capacity = Long.MAX_VALUE;
    }

    Blob(java.io.InputStream is, long length) throws SQLException {
        this.link = is;
        this.capacity = length > 0L ? length : -1L;
    }

    public void doExecute() throws SQLException {
        int bsize = this.capacity < 0L ? 32000 : 32688;
        this.open();
        if (this.link instanceof java.io.InputStream) {
            java.io.InputStream is = (java.io.InputStream)this.link;
            ByteBuffer ib = ByteBuffer.allocate(bsize);
            try {
                int i;
                for (long size = this.capacity < 0L ? Long.MAX_VALUE : this.capacity; size > 0L && (i = is.read(ib.array())) > 0; size -= (long)i) {
                    ib.position(i).flip();
                    this.append(ib);
                }
            }
            catch (IOException ie) {
                throw new SQLException(ie.getMessage());
            }
        } else if (this.link == null) {
            this.setNull();
        } else {
            ex.exception((short)103);
        }
    }

    protected int append(ByteBuffer bb) throws SQLException {
        this.capacity = this.position + (long)bb.remaining();
        this.chn.lobPut(this.locator, this.position, this.limit, bb);
        this.position = this.capacity;
        this.limit = this.capacity;
        return bb.position();
    }

    final long capacity() {
        return this.capacity;
    }

    protected final void checkIsUse() throws SQLException {
        ex.test(this.link != null, (short)103, SQLStates.mFixmsg[31]);
    }

    final void clear() {
        this.position = 0L;
        this.limit = this.capacity;
        this.mark = -1L;
        this.link = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    protected void free(Object obj) {
        if (obj == this.link) {
            this.link = null;
        }
    }

    public synchronized java.io.InputStream getBinaryStream() throws SQLException {
        if (this.locator != 0L) {
            this.checkIsUse();
            this.link = new InputStream(this);
            return (InputStream)this.link;
        }
        return null;
    }

    public byte[] getBytes(long bpos, int length) throws SQLException {
        byte[] b = zerob;
        ex.test(bpos <= 0L, (short)85);
        this.position = --bpos;
        long remain = this.limit - this.position;
        int n = length = remain > (long)length ? length : (int)remain;
        if (length > 0) {
            b = new byte[length];
            this.chn.lobGet(this.locator, this.position, b, 0, length);
        }
        return b;
    }

    public int hashCode() {
        return (int)this.locator;
    }

    final void init(long locatorId, cmp channel) {
        this.chn = channel;
        if (this.locator != 0L && this.locator != locatorId) {
            this.capacity = -1L;
            this.clear();
        }
        this.locator = locatorId;
    }

    final boolean isNull() {
        return this.capacity == 0L && this.limit == 0L;
    }

    public long length() throws SQLException {
        ex.test(this.limit < 0L, (short)47);
        return this.limit;
    }

    final Object link() {
        return this.link;
    }

    final long locator() {
        return this.locator;
    }

    final long mark(int v) {
        this.mark = this.position + (long)v;
        return this.mark;
    }

    final long newsize() {
        return this.capacity - this.position;
    }

    final long offset() {
        return this.position;
    }

    final long oldsize() {
        return this.limit - this.position;
    }

    final long open() throws SQLException {
        ex.test(this.locator == 0L, (short)32);
        if (this.capacity == -1L) {
            this.capacity = this.chn.lobSize(this.locator);
            this.clear();
        }
        return this.capacity;
    }

    protected final long position() {
        return this.position;
    }

    public long position(byte[] pattern, long start) throws SQLException {
        ex.exception((short)30);
        return this.position;
    }

    public long position(java.sql.Blob pattern, long start) throws SQLException {
        ex.exception((short)30);
        return this.position;
    }

    synchronized void put(java.io.InputStream in, int offset, int length) throws SQLException {
        this.checkIsUse();
        this.link = in;
    }

    int read(byte[] b, int offset, int length) throws SQLException {
        int size = -1;
        long rem = this.remaining();
        if (rem > 0L) {
            length = rem >= (long)length ? length : (int)rem;
            size = this.chn.lobGet(this.locator, this.position, b, offset, length);
            this.position += (long)size;
        }
        return size;
    }

    public final long remaining() {
        return this.limit - this.position;
    }

    final long reset() {
        this.position = this.mark;
        return this.position;
    }

    public synchronized java.io.OutputStream setBinaryStream(long pos) throws SQLException {
        this.checkIsUse();
        ex.test(pos > this.capacity, (short)32, SQLStates.mFixmsg[32]);
        this.position = pos;
        this.link = new OutputStream(this);
        return (OutputStream)this.link;
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    public synchronized int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        ByteBuffer bb = ByteBuffer.wrap(bytes, offset, len);
        ex.test(--pos < 0L, (short)85);
        this.capacity = pos + (long)len;
        this.position = pos;
        this.chn.lobPut(this.locator, this.position, this.limit, bb);
        this.clear();
        return bb.position();
    }

    void setNull() throws SQLException {
        if (this.locator != 0L) {
            this.chn.lobFree(this.locator);
            this.locator = 0L;
            this.capacity = -1L;
            this.clear();
        }
    }

    protected long skip(long n) throws IOException {
        if ((n += this.position) > this.capacity) {
            throw new EOFException(SQLStates.mFixmsg[33]);
        }
        this.position = n;
        return this.position;
    }

    public String toString() {
        return this.locator + ":[" + this.position + "/" + this.limit + "/" + this.capacity + "]";
    }

    public synchronized void truncate(long len) throws SQLException {
        this.checkIsUse();
        this.capacity = len;
        this.chn.lobTruncate(this.locator, this.limit, len);
        this.clear();
    }

    class OutputStream
    extends java.io.OutputStream {
        ByteBuffer bb;
        Blob lob;

        OutputStream(Blob b) throws SQLException {
            ex.test(b.locator() == 0L, (short)21);
            this.bb = ByteBuffer.allocate(1400);
            this.lob = b;
        }

        public void close() throws IOException {
            this.flush();
            this.lob.free(this);
            this.lob = null;
            this.bb = null;
        }

        public void flush() throws IOException {
            if (this.bb.position() > 0) {
                try {
                    this.bb.flip();
                    this.lob.append(this.bb);
                    this.bb.clear();
                }
                catch (SQLException se) {
                    throw new IOException(se.getMessage());
                }
            }
        }

        public void write(byte[] b, int offset, int length) throws IOException {
            if (length > this.bb.remaining()) {
                this.flush();
                if (length > this.bb.remaining()) {
                    ByteBuffer wbb = ByteBuffer.wrap(b, offset, length);
                    try {
                        this.lob.append(wbb);
                    }
                    catch (SQLException se) {
                        throw new IOException(se.getMessage());
                    }
                } else {
                    this.bb.put(b, offset, length);
                }
            } else {
                this.bb.put(b, offset, length);
            }
        }

        public void write(int b) throws IOException {
            if (this.bb.remaining() == 0) {
                this.flush();
            }
            this.bb.put((byte)b);
        }
    }

    class InputStream
    extends java.io.InputStream {
        ByteBuffer bb;
        Blob lob;

        InputStream(Blob b) throws SQLException {
            ex.test(b.locator() == 0L, (short)21);
            this.lob = b;
            this.bb = ByteBuffer.allocate(32688);
            this.bb.limit(0);
        }

        public int available() throws IOException {
            long rem = this.lob.remaining() + (long)this.bb.remaining();
            return rem < Integer.MAX_VALUE ? (int)rem : Integer.MAX_VALUE;
        }

        public void close() throws IOException {
            this.lob.free(this);
            this.lob = null;
            this.bb = null;
        }

        public synchronized void mark(int aReadlimit) {
            this.lob.mark(-this.bb.limit());
        }

        public int read() throws IOException {
            return this.remaining() > 0 ? (int)this.bb.get() : -1;
        }

        public int read(byte[] b, int offset, int length) throws IOException {
            int sum = 0;
            int v = this.remaining();
            while (length > 0 && v > 0) {
                int len = v > length ? length : v;
                this.bb.get(b, offset, len);
                offset += len;
                length -= len;
                sum += len;
                v = this.remaining();
            }
            return sum > 0 ? sum : -1;
        }

        private final int remaining() throws IOException {
            int size = this.bb.remaining();
            if (size == 0) {
                try {
                    size = this.lob.read(this.bb.array(), 0, this.bb.capacity());
                    if (size > 0) {
                        this.bb.clear().limit(size);
                    }
                }
                catch (SQLException e) {
                    throw new IOException(e.getMessage());
                }
            }
            return size;
        }

        public synchronized void reset() throws IOException {
            this.lob.reset();
        }

        public long skip(long n) throws IOException {
            if (n <= 0L) {
                return 0L;
            }
            if ((n -= (long)this.bb.remaining()) > 0L) {
                this.bb.limit(0);
                return this.lob.skip(n);
            }
            n = -n;
            this.bb.position((int)((long)this.bb.position() + n));
            return n;
        }
    }
}

