/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.Geometry;
import Altibase.jdbc.driver.GeometryList;
import Altibase.jdbc.driver.LineString;
import Altibase.jdbc.driver.aTokenizer;
import java.sql.SQLException;

public class Polygon
extends GeometryList {
    static final long serialVersionUID = 1L;

    public Polygon() throws SQLException {
        super((byte)3, 0);
    }

    public Polygon(LineString[] lines) throws SQLException {
        super((byte)3, lines.length);
        for (int i = 0; i < this.capacity; ++i) {
            LineString p = lines[i];
            super.add(i, p);
            this.mGeometrySize += p.getSize();
            this.resetMBR(p);
        }
    }

    public Polygon(String s) throws SQLException {
        super((byte)3);
        s = s.trim().toUpperCase();
        if (s.startsWith(this.mGeometryName)) {
            s = s.substring(this.mGeometryName.length()).trim();
        }
        aTokenizer t = new aTokenizer(aTokenizer.removePara(s), ',');
        this.setSize(t.size());
        for (int i = 0; i < this.capacity; ++i) {
            LineString p = new LineString(t.getToken(i));
            this.mGeometrySize += p.getSize();
            this.add(p);
            this.resetMBR(p);
        }
    }

    public Object clone() {
        try {
            LineString[] ary = new LineString[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                ary[i] = (LineString)((LineString)this.get(i)).clone();
            }
            return new Polygon(ary);
        }
        catch (SQLException se) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Polygon) {
            Polygon p = (Polygon)obj;
            if (p.size() != this.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (((Geometry)this.get(i)).equals(p.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        int i;
        StringBuffer ret = new StringBuffer();
        for (i = 0; i < this.size() - 1; ++i) {
            ret.append(this.get(i).toString());
            ret.append(',');
        }
        ret.append(this.get(i).toString());
        return ret.toString();
    }
}

