/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.valang.functions;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springmodules.validation.valang.functions.Function;

public class BeanPropertyFunction
implements Function {
    private String field = null;

    public BeanPropertyFunction(String field) {
        this.field = field;
    }

    public String getField() {
        return this.field;
    }

    public Object getResult(Object target) {
        String fieldName = this.getField();
        if ("this".equals(fieldName)) {
            return target;
        }
        if (fieldName.startsWith("this.")) {
            fieldName = this.field.substring(5);
        }
        if (target instanceof Map) {
            return this.getValue((Map)target, this.split(fieldName));
        }
        if (target instanceof BeanWrapper) {
            return ((BeanWrapper)target).getPropertyValue(fieldName);
        }
        return new BeanWrapperImpl(target).getPropertyValue(fieldName);
    }

    private String[] split(String path) {
        return StringUtils.split((String)path, (char)'.');
    }

    private String[] pop(String[] path) {
        ArrayList<String> coll = new ArrayList<String>();
        for (int i = 1; i < path.length; ++i) {
            coll.add(path[i]);
        }
        return coll.toArray(new String[0]);
    }

    private String concat(String[] path) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < path.length; ++i) {
            sb.append(path[i]);
            sb.append(".");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private Object getValue(Map map, String[] path) {
        if (path.length > 0) {
            Object result = MapUtils.getObject((Map)map, (Object)path[0]);
            if (path.length > 1) {
                return new BeanPropertyFunction(this.concat(this.pop(path))).getResult(result);
            }
            return result;
        }
        return null;
    }
}

