/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

class ContextCache {
    private final Map<String, ApplicationContext> contextKeyToContextMap = new ConcurrentHashMap<String, ApplicationContext>();
    private int hitCount;
    private int missCount;

    ContextCache() {
    }

    void clear() {
        this.contextKeyToContextMap.clear();
    }

    void clearStatistics() {
        this.hitCount = 0;
        this.missCount = 0;
    }

    boolean contains(String key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.contextKeyToContextMap.containsKey(key);
    }

    ApplicationContext get(String key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        ApplicationContext context = this.contextKeyToContextMap.get(key);
        if (context == null) {
            this.incrementMissCount();
        } else {
            this.incrementHitCount();
        }
        return context;
    }

    private void incrementHitCount() {
        ++this.hitCount;
    }

    private void incrementMissCount() {
        ++this.missCount;
    }

    int getHitCount() {
        return this.hitCount;
    }

    int getMissCount() {
        return this.missCount;
    }

    void put(String key, ApplicationContext context) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)context, (String)"ApplicationContext must not be null");
        this.contextKeyToContextMap.put(key, context);
    }

    ApplicationContext remove(String key) {
        return this.contextKeyToContextMap.remove(key);
    }

    void setDirty(String key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        ApplicationContext context = this.remove(key);
        if (context instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)context).close();
        }
    }

    int size() {
        return this.contextKeyToContextMap.size();
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("size", this.size()).append("hitCount", this.getHitCount()).append("missCount", this.getMissCount()).toString();
    }
}

