/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.easymock.IArgumentMatcher;
import org.easymock.internal.Invocation;
import org.easymock.internal.matchers.Equals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpectedInvocation
implements Serializable {
    private static final long serialVersionUID = -5554816464613350531L;
    private final Invocation invocation;
    private final List<IArgumentMatcher> matchers;

    public ExpectedInvocation(Invocation invocation, List<IArgumentMatcher> matchers) {
        this.invocation = invocation;
        this.matchers = this.createMissingMatchers(invocation, matchers);
    }

    private List<IArgumentMatcher> createMissingMatchers(Invocation invocation, List<IArgumentMatcher> matchers) {
        if (matchers != null) {
            if (matchers.size() != invocation.getArguments().length) {
                throw new IllegalStateException("" + invocation.getArguments().length + " matchers expected, " + matchers.size() + " recorded.\n" + "This exception usually occurs when matchers are mixed with raw values when recording a method:\n" + "\tfoo(5, eq(6));\t// wrong\n" + "You need to use no matcher at all or a matcher for every single param:\n" + "\tfoo(eq(5), eq(6));\t// right\n" + "\tfoo(5, 6);\t// also right");
            }
            return matchers;
        }
        ArrayList<IArgumentMatcher> result = new ArrayList<IArgumentMatcher>();
        for (Object argument : invocation.getArguments()) {
            result.add(new Equals(argument));
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        ExpectedInvocation other = (ExpectedInvocation)o;
        return this.invocation.equals(other.invocation) && (this.matchers == null && other.matchers == null || this.matchers != null && ((Object)this.matchers).equals(other.matchers));
    }

    public int hashCode() {
        throw new UnsupportedOperationException("hashCode() is not implemented");
    }

    public boolean matches(Invocation actual) {
        return this.invocation.getMock().equals(actual.getMock()) && this.invocation.getMethod().equals(actual.getMethod()) && this.matches(actual.getArguments());
    }

    private boolean matches(Object[] arguments) {
        if (arguments.length != this.matchers.size()) {
            return false;
        }
        for (int i = 0; i < arguments.length; ++i) {
            if (this.matchers.get(i).matches(arguments[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.invocation.getMockAndMethodName());
        result.append("(");
        Iterator<IArgumentMatcher> it = this.matchers.iterator();
        while (it.hasNext()) {
            it.next().appendTo(result);
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        result.append(")");
        return result.toString();
    }

    public Method getMethod() {
        return this.invocation.getMethod();
    }
}

