/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.ReportListener;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.dfa.report.ReportTree;
import net.sourceforge.pmd.stat.Metric;
import net.sourceforge.pmd.util.NumericConstants;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Report {
    private static final RuleViolation.RuleViolationComparator COMPARATOR = new RuleViolation.RuleViolationComparator();
    private final ReportTree violationTree = new ReportTree();
    private final Set<IRuleViolation> violations = new TreeSet<IRuleViolation>(COMPARATOR);
    private final Set<Metric> metrics = new HashSet<Metric>();
    private final List<ReportListener> listeners = new ArrayList<ReportListener>();
    private final List<ProcessingError> errors = new ArrayList<ProcessingError>();
    private Map<Integer, String> linesToExclude = new HashMap<Integer, String>();
    private long start;
    private long end;
    private List<SuppressedViolation> suppressedRuleViolations = new ArrayList<SuppressedViolation>();

    public void exclude(Map<Integer, String> lines) {
        this.linesToExclude = lines;
    }

    public Map<String, Integer> getCountSummary() {
        HashMap<String, Integer> summary = new HashMap<String, Integer>();
        Iterator<IRuleViolation> iter = this.violationTree.iterator();
        while (iter.hasNext()) {
            Integer o;
            IRuleViolation rv = iter.next();
            String key = "";
            if (rv.getPackageName() != null && rv.getPackageName().length() != 0) {
                key = new StringBuffer().append(rv.getPackageName()).append('.').append(rv.getClassName()).toString();
            }
            if ((o = (Integer)summary.get(key)) == null) {
                summary.put(key, NumericConstants.ONE);
                continue;
            }
            summary.put(key, Integer_.valueOf((int)(o + 1)));
        }
        return summary;
    }

    public ReportTree getViolationTree() {
        return this.violationTree;
    }

    public Map<String, Integer> getSummary() {
        HashMap<String, Integer> summary = new HashMap<String, Integer>();
        for (IRuleViolation rv : this.violations) {
            String name = rv.getRule().getName();
            if (!summary.containsKey(name)) {
                summary.put(name, NumericConstants.ZERO);
            }
            Integer count = (Integer)summary.get(name);
            summary.put(name, Integer_.valueOf((int)(count + 1)));
        }
        return summary;
    }

    public void addListener(ReportListener listener) {
        this.listeners.add(listener);
    }

    public List<SuppressedViolation> getSuppressedRuleViolations() {
        return this.suppressedRuleViolations;
    }

    public void addRuleViolation(IRuleViolation violation) {
        int line = violation.getBeginLine();
        if (this.linesToExclude.containsKey(Integer_.valueOf((int)line))) {
            this.suppressedRuleViolations.add(new SuppressedViolation(violation, true, this.linesToExclude.get(Integer_.valueOf((int)line))));
            return;
        }
        if (violation.isSuppressed()) {
            this.suppressedRuleViolations.add(new SuppressedViolation(violation, false, null));
            return;
        }
        this.violations.add(violation);
        this.violationTree.addRuleViolation(violation);
        for (ReportListener listener : this.listeners) {
            listener.ruleViolationAdded(violation);
        }
    }

    public void addMetric(Metric metric) {
        this.metrics.add(metric);
        for (ReportListener listener : this.listeners) {
            listener.metricAdded(metric);
        }
    }

    public void addError(ProcessingError error) {
        this.errors.add(error);
    }

    public void merge(Report r) {
        Iterator<ProcessingError> i = r.errors();
        while (i.hasNext()) {
            this.addError(i.next());
        }
        Iterator<Metric> m = r.metrics();
        while (m.hasNext()) {
            this.addMetric(m.next());
        }
        Iterator<IRuleViolation> v = r.iterator();
        while (v.hasNext()) {
            IRuleViolation violation = v.next();
            this.violations.add(violation);
            this.violationTree.addRuleViolation(violation);
        }
        Iterator<SuppressedViolation> s = r.getSuppressedRuleViolations().iterator();
        while (s.hasNext()) {
            this.suppressedRuleViolations.add(s.next());
        }
    }

    public boolean hasMetrics() {
        return !this.metrics.isEmpty();
    }

    public Iterator<Metric> metrics() {
        return this.metrics.iterator();
    }

    public boolean isEmpty() {
        return !this.violations.iterator().hasNext() && this.errors.isEmpty();
    }

    public boolean treeIsEmpty() {
        return !this.violationTree.iterator().hasNext();
    }

    public Iterator<IRuleViolation> treeIterator() {
        return this.violationTree.iterator();
    }

    public Iterator<IRuleViolation> iterator() {
        return this.violations.iterator();
    }

    public Iterator<ProcessingError> errors() {
        return this.errors.iterator();
    }

    public int treeSize() {
        return this.violationTree.size();
    }

    public int size() {
        return this.violations.size();
    }

    public void start() {
        this.start = System.currentTimeMillis();
    }

    public void end() {
        this.end = System.currentTimeMillis();
    }

    public long getElapsedTimeInMillis() {
        return this.end - this.start;
    }

    public static class SuppressedViolation {
        private final IRuleViolation rv;
        private final boolean isNOPMD;
        private final String userMessage;

        public SuppressedViolation(IRuleViolation rv, boolean isNOPMD, String userMessage) {
            this.isNOPMD = isNOPMD;
            this.rv = rv;
            this.userMessage = userMessage;
        }

        public boolean suppressedByNOPMD() {
            return this.isNOPMD;
        }

        public boolean suppressedByAnnotation() {
            return !this.isNOPMD;
        }

        public IRuleViolation getRuleViolation() {
            return this.rv;
        }

        public String getUserMessage() {
            return this.userMessage;
        }
    }

    public static class ProcessingError {
        private final String msg;
        private final String file;

        public ProcessingError(String msg, String file) {
            this.msg = msg;
            this.file = file;
        }

        public String getMsg() {
            return this.msg;
        }

        public String getFile() {
            return this.file;
        }
    }

    public static class ReadableDuration {
        private final long duration;

        public ReadableDuration(long duration) {
            this.duration = duration;
        }

        public String getTime() {
            long seconds = 0L;
            long minutes = 0L;
            long hours = 0L;
            if (this.duration > 1000L) {
                seconds = this.duration / 1000L;
            }
            if (seconds > 60L) {
                minutes = seconds / 60L;
                seconds %= 60L;
            }
            if (minutes > 60L) {
                hours = minutes / 60L;
                minutes %= 60L;
            }
            StringBuffer res = new StringBuffer();
            if (hours > 0L) {
                res.append(hours).append("h ");
            }
            if (hours > 0L || minutes > 0L) {
                res.append(minutes).append("m ");
            }
            res.append(seconds).append('s');
            return res.toString();
        }
    }
}

