/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleReference;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetReference;
import net.sourceforge.retroweaver.runtime.java.lang.Boolean_;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleSetWriter {
    private final OutputStream outputStream;
    private final boolean outputNamespace;
    private Document document;
    private Set<String> ruleSetFileNames;

    public RuleSetWriter(OutputStream outputStream) {
        this(outputStream, true);
    }

    public RuleSetWriter(OutputStream outputStream, boolean outputNamespace) {
        this.outputStream = outputStream;
        this.outputNamespace = outputNamespace;
    }

    public void close() throws IOException {
        this.outputStream.flush();
        this.outputStream.close();
    }

    public void write(RuleSet ruleSet) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.document = documentBuilder.newDocument();
            this.ruleSetFileNames = new HashSet<String>();
            Element ruleSetElement = this.createRuleSetElement(ruleSet);
            this.document.appendChild(ruleSetElement);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            try {
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(this.document), new StreamResult(this.outputStream));
        }
        catch (DOMException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    private Element createRuleSetElement(RuleSet ruleSet) {
        Element ruleSetElement = this.document.createElement("ruleset");
        if (this.outputNamespace) {
            ruleSetElement.setAttribute("xmlns", "http://pmd.sf.net/ruleset/1.0.0");
            ruleSetElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://pmd.sf.net/ruleset/1.0.0 http://pmd.sf.net/ruleset_xml_schema.xsd");
            ruleSetElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:noNamespaceSchemaLocation", "http://pmd.sf.net/ruleset_xml_schema.xsd");
        }
        ruleSetElement.setAttribute("name", ruleSet.getName());
        if (ruleSet.getLanguage() != null) {
            ruleSetElement.setAttribute("language", ruleSet.getLanguage().getName());
        }
        Element descriptionElement = this.createDescriptionElement(ruleSet.getDescription());
        ruleSetElement.appendChild(descriptionElement);
        for (String excludePattern : ruleSet.getExcludePatterns()) {
            Element excludePatternElement = this.createExcludePatternElement(excludePattern);
            ruleSetElement.appendChild(excludePatternElement);
        }
        for (String includePattern : ruleSet.getIncludePatterns()) {
            Element includePatternElement = this.createIncludePatternElement(includePattern);
            ruleSetElement.appendChild(includePatternElement);
        }
        for (Rule rule : ruleSet.getRules()) {
            Element ruleElement = this.createRuleElement(rule);
            if (ruleElement == null) continue;
            ruleSetElement.appendChild(ruleElement);
        }
        return ruleSetElement;
    }

    private Element createDescriptionElement(String description) {
        return this.createTextElement("description", description);
    }

    private Element createExcludePatternElement(String excludePattern) {
        return this.createTextElement("exclude-pattern", excludePattern);
    }

    private Element createIncludePatternElement(String includePattern) {
        return this.createTextElement("include-pattern", includePattern);
    }

    private Element createRuleElement(Rule rule) {
        if (rule instanceof RuleReference) {
            RuleReference ruleReference = (RuleReference)rule;
            RuleSetReference ruleSetReference = ruleReference.getRuleSetReference();
            if (ruleSetReference.isAllRules()) {
                if (!this.ruleSetFileNames.contains(ruleSetReference.getRuleSetFileName())) {
                    this.ruleSetFileNames.add(ruleSetReference.getRuleSetFileName());
                    Element ruleSetReferenceElement = this.createRuleSetReferenceElement(ruleSetReference);
                    return ruleSetReferenceElement;
                }
                return null;
            }
            String name = ruleReference.getOverriddenName();
            String ref = new StringBuffer().append(ruleReference.getRuleSetReference().getRuleSetFileName()).append("/").append(ruleReference.getName()).toString();
            String message = ruleReference.getOverriddenMessage();
            String externalInfoUrl = ruleReference.getOverriddenExternalInfoUrl();
            String description = ruleReference.getOverriddenDescription();
            Integer priority = ruleReference.getOverriddenPriority();
            Properties properties = ruleReference.getOverriddenProperties();
            List<String> examples = ruleReference.getOverriddenExamples();
            return this.createSingleRuleElement(name, null, ref, message, externalInfoUrl, null, null, null, description, priority, properties, examples);
        }
        return this.createSingleRuleElement(rule.getName(), rule.getSince(), null, rule.getMessage(), rule.getExternalInfoUrl(), rule.getRuleClass(), Boolean_.valueOf((boolean)rule.usesDFA()), Boolean_.valueOf((boolean)rule.usesTypeResolution()), rule.getDescription(), Integer_.valueOf((int)rule.getPriority()), rule.getProperties(), rule.getExamples());
    }

    private Element createSingleRuleElement(String name, String since, String ref, String message, String externalInfoUrl, String clazz, Boolean dfa, Boolean typeResolution, String description, Integer priority, Properties properties, List<String> examples) {
        Element propertiesElement;
        Element ruleElement = this.document.createElement("rule");
        if (name != null) {
            ruleElement.setAttribute("name", name);
        }
        if (since != null) {
            ruleElement.setAttribute("since", since);
        }
        if (ref != null) {
            ruleElement.setAttribute("ref", ref);
        }
        if (message != null) {
            ruleElement.setAttribute("message", message);
        }
        if (externalInfoUrl != null) {
            ruleElement.setAttribute("externalInfoUrl", externalInfoUrl);
        }
        if (clazz != null) {
            ruleElement.setAttribute("class", clazz);
        }
        if (dfa != null) {
            ruleElement.setAttribute("dfa", dfa.toString());
        }
        if (typeResolution != null) {
            ruleElement.setAttribute("typeResolution", typeResolution.toString());
        }
        if (description != null) {
            Element descriptionElement = this.createDescriptionElement(description);
            ruleElement.appendChild(descriptionElement);
        }
        if (priority != null) {
            Element priorityElement = this.createPriorityElement(priority);
            ruleElement.appendChild(priorityElement);
        }
        if (properties != null && (propertiesElement = this.createPropertiesElement(properties)) != null) {
            ruleElement.appendChild(propertiesElement);
        }
        if (examples != null) {
            for (String example : examples) {
                Element exampleElement = this.createExampleElement(example);
                ruleElement.appendChild(exampleElement);
            }
        }
        return ruleElement;
    }

    private Element createRuleSetReferenceElement(RuleSetReference ruleSetReference) {
        Element ruleSetReferenceElement = this.document.createElement("rule");
        ruleSetReferenceElement.setAttribute("ref", ruleSetReference.getRuleSetFileName());
        for (String exclude : ruleSetReference.getExcludes()) {
            Element excludeElement = this.createExcludeElement(exclude);
            ruleSetReferenceElement.appendChild(excludeElement);
        }
        return ruleSetReferenceElement;
    }

    private Element createExcludeElement(String exclude) {
        return this.createTextElement("exclude", exclude);
    }

    private Element createExampleElement(String example) {
        return this.createCDATASectionElement("example", example);
    }

    private Element createPriorityElement(Integer priority) {
        return this.createTextElement("priority", priority.toString());
    }

    private Element createPropertiesElement(Properties properties) {
        if (properties != null && !properties.isEmpty()) {
            Element propertiesElement = this.document.createElement("properties");
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Element propertyElement = this.createPropertyElement(properties, (String)entry.getKey(), (String)entry.getValue());
                if (propertyElement == null) continue;
                propertiesElement.appendChild(propertyElement);
            }
            return propertiesElement;
        }
        return null;
    }

    private Element createPropertyElement(Properties properties, String key, String value) {
        Element propertyElement = this.document.createElement("property");
        propertyElement.setAttribute("name", key);
        if ("xpath".equals(key)) {
            if (properties.containsKey("pluginname")) {
                propertyElement.setAttribute("pluginname", properties.getProperty("pluginname"));
            }
            Element valueElement = this.createCDATASectionElement("value", value);
            propertyElement.appendChild(valueElement);
        } else if ("pluginname".equals(key)) {
            if (properties.containsKey("xpath")) {
                return null;
            }
            propertyElement.setAttribute("value", value);
        } else {
            propertyElement.setAttribute("value", value);
        }
        return propertyElement;
    }

    private Element createTextElement(String name, String value) {
        Element element = this.document.createElement(name);
        Text text = this.document.createTextNode(value);
        element.appendChild(text);
        return element;
    }

    private Element createCDATASectionElement(String name, String value) {
        Element element = this.document.createElement(name);
        CDATASection cdataSection = this.document.createCDATASection(value);
        element.appendChild(cdataSection);
        return element;
    }
}

