/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.ast.ASTBlock;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTReferenceType;
import net.sourceforge.pmd.ast.ASTTryStatement;
import net.sourceforge.pmd.ast.ASTType;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.properties.StringProperty;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloseResource
extends AbstractRule {
    private Set<String> types = new HashSet<String>();
    private Set<String> closeTargets = new HashSet<String>();
    private static final PropertyDescriptor closeTargetsDescriptor = new StringProperty("closeTargets", "Methods which may close this resource", "", 1.0f);
    private static final PropertyDescriptor typesDescriptor = new StringProperty("types", "Types that are affected by this rule", "", 2.0f);
    private static final Map<String, PropertyDescriptor> propertyDescriptorsByName = CloseResource.asFixedMap(new PropertyDescriptor[]{typesDescriptor, closeTargetsDescriptor});
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTTryStatement;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTName;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTLocalVariableDeclaration;

    @Override
    protected Map<String, PropertyDescriptor> propertiesByName() {
        return propertyDescriptorsByName;
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        StringTokenizer st;
        if (this.closeTargets.isEmpty() && this.getStringProperty(closeTargetsDescriptor) != null) {
            st = new StringTokenizer(this.getStringProperty(closeTargetsDescriptor), ",");
            while (st.hasMoreTokens()) {
                this.closeTargets.add(st.nextToken());
            }
        }
        if (this.types.isEmpty() && this.getStringProperty(typesDescriptor) != null) {
            st = new StringTokenizer(this.getStringProperty(typesDescriptor), ",");
            while (st.hasMoreTokens()) {
                this.types.add(st.nextToken());
            }
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTLocalVariableDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTLocalVariableDeclaration = new ASTLocalVariableDeclaration[0].getClass().getComponentType();
        }
        List vars = node.findChildrenOfType(clazz);
        ArrayList<ASTVariableDeclaratorId> ids = new ArrayList<ASTVariableDeclaratorId>();
        for (ASTLocalVariableDeclaration var : vars) {
            ASTClassOrInterfaceType clazz2;
            ASTReferenceType ref;
            ASTType type = var.getTypeNode();
            if (!(type.jjtGetChild(0) instanceof ASTReferenceType) || !((ref = (ASTReferenceType)type.jjtGetChild(0)).jjtGetChild(0) instanceof ASTClassOrInterfaceType) || !this.types.contains((clazz2 = (ASTClassOrInterfaceType)ref.jjtGetChild(0)).getImage())) continue;
            ASTVariableDeclaratorId id = (ASTVariableDeclaratorId)var.jjtGetChild(1).jjtGetChild(0);
            ids.add(id);
        }
        for (ASTVariableDeclaratorId x : ids) {
            this.ensureClosed((ASTLocalVariableDeclaration)x.jjtGetParent().jjtGetParent(), x, data);
        }
        return data;
    }

    private void ensureClosed(ASTLocalVariableDeclaration var, ASTVariableDeclaratorId id, Object data) {
        String target = new StringBuffer().append(id.getImage()).append(".close").toString();
        Node n = var;
        while (!(n instanceof ASTBlock)) {
            n = n.jjtGetParent();
        }
        ASTBlock top = (ASTBlock)n;
        ArrayList tryblocks = new ArrayList();
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTTryStatement;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTTryStatement = new ASTTryStatement[0].getClass().getComponentType();
        }
        top.findChildrenOfType(clazz, tryblocks, true);
        boolean closed = false;
        for (ASTTryStatement t : tryblocks) {
            if (t.getBeginLine() <= id.getBeginLine() || !t.hasFinally()) continue;
            ASTBlock f = (ASTBlock)t.getFinally().jjtGetChild(0);
            ArrayList names = new ArrayList();
            Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTName;
            if (clazz2 == null) {
                clazz2 = new ASTName[0].getClass().getComponentType();
            }
            f.findChildrenOfType(clazz2, names, true);
            for (ASTName oName : names) {
                String name = oName.getImage();
                if (!name.equals(target) && !this.closeTargets.contains(name)) continue;
                closed = true;
            }
        }
        if (!closed) {
            ASTType type = (ASTType)var.jjtGetChild(0);
            ASTReferenceType ref = (ASTReferenceType)type.jjtGetChild(0);
            ASTClassOrInterfaceType clazz3 = (ASTClassOrInterfaceType)ref.jjtGetChild(0);
            this.addViolation(data, id, clazz3.getImage());
        }
    }
}

