/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.design;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.ast.ASTConditionalAndExpression;
import net.sourceforge.pmd.ast.ASTConditionalExpression;
import net.sourceforge.pmd.ast.ASTConditionalOrExpression;
import net.sourceforge.pmd.ast.ASTDoStatement;
import net.sourceforge.pmd.ast.ASTExpression;
import net.sourceforge.pmd.ast.ASTForStatement;
import net.sourceforge.pmd.ast.ASTIfStatement;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTReturnStatement;
import net.sourceforge.pmd.ast.ASTStatement;
import net.sourceforge.pmd.ast.ASTSwitchLabel;
import net.sourceforge.pmd.ast.ASTSwitchStatement;
import net.sourceforge.pmd.ast.ASTTryStatement;
import net.sourceforge.pmd.ast.ASTWhileStatement;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleJavaNode;
import net.sourceforge.pmd.ast.SimpleJavaTypeNode;
import net.sourceforge.pmd.stat.DataPoint;
import net.sourceforge.pmd.stat.StatisticalRule;
import net.sourceforge.pmd.util.NumericConstants;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NpathComplexity
extends StatisticalRule {
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTExpression;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTConditionalOrExpression;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTConditionalAndExpression;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTStatement;

    private int complexityMultipleOf(SimpleJavaNode node, int npathStart, Object data) {
        int npath = npathStart;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            SimpleJavaNode simpleNode = (SimpleJavaNode)node.jjtGetChild(i);
            npath *= ((Integer)simpleNode.jjtAccept(this, data)).intValue();
        }
        return npath;
    }

    private int complexitySumOf(SimpleJavaNode node, int npathStart, Object data) {
        int npath = npathStart;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            SimpleJavaNode simpleNode = (SimpleJavaNode)node.jjtGetChild(i);
            npath += ((Integer)simpleNode.jjtAccept(this, data)).intValue();
        }
        return npath;
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        int npath = this.complexityMultipleOf(node, 1, data);
        DataPoint point = new DataPoint();
        point.setNode(node);
        point.setScore(1.0 * (double)npath);
        point.setMessage(this.getMessage());
        this.addDataPoint(point);
        return Integer_.valueOf((int)npath);
    }

    @Override
    public Object visit(SimpleJavaNode node, Object data) {
        int npath = this.complexityMultipleOf(node, 1, data);
        return Integer_.valueOf((int)npath);
    }

    @Override
    public Object visit(ASTIfStatement node, Object data) {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTExpression = new ASTExpression[0].getClass().getComponentType();
        }
        int boolCompIf = NpathComplexity.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(clazz));
        int complexity = 0;
        ArrayList<SimpleJavaNode> statementChildren = new ArrayList<SimpleJavaNode>();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            Class<?> clazz2 = node.jjtGetChild(i).getClass();
            Class<?> clazz3 = class$net$sourceforge$pmd$ast$ASTStatement;
            if (clazz3 == null) {
                clazz3 = new ASTStatement[0].getClass().getComponentType();
            }
            if (clazz2 != clazz3) continue;
            statementChildren.add((SimpleJavaNode)node.jjtGetChild(i));
        }
        if (statementChildren.isEmpty() || statementChildren.size() == 1 && node.hasElse() || statementChildren.size() != 1 && !node.hasElse()) {
            throw new IllegalStateException("If node has wrong number of children");
        }
        if (!node.hasElse()) {
            ++complexity;
        }
        for (SimpleJavaNode element : statementChildren) {
            complexity += ((Integer)element.jjtAccept(this, data)).intValue();
        }
        return Integer_.valueOf((int)(boolCompIf + complexity));
    }

    @Override
    public Object visit(ASTWhileStatement node, Object data) {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTExpression = new ASTExpression[0].getClass().getComponentType();
        }
        int boolCompWhile = NpathComplexity.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(clazz));
        Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTStatement;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$ast$ASTStatement = new ASTStatement[0].getClass().getComponentType();
        }
        Integer nPathWhile = (Integer)((SimpleJavaNode)node.getFirstChildOfType(clazz2)).jjtAccept(this, data);
        return Integer_.valueOf((int)(boolCompWhile + nPathWhile + 1));
    }

    @Override
    public Object visit(ASTDoStatement node, Object data) {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTExpression = new ASTExpression[0].getClass().getComponentType();
        }
        int boolCompDo = NpathComplexity.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(clazz));
        Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTStatement;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$ast$ASTStatement = new ASTStatement[0].getClass().getComponentType();
        }
        Integer nPathDo = (Integer)((SimpleJavaNode)node.getFirstChildOfType(clazz2)).jjtAccept(this, data);
        return Integer_.valueOf((int)(boolCompDo + nPathDo + 1));
    }

    @Override
    public Object visit(ASTForStatement node, Object data) {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTExpression = new ASTExpression[0].getClass().getComponentType();
        }
        int boolCompFor = NpathComplexity.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(clazz));
        Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTStatement;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$ast$ASTStatement = new ASTStatement[0].getClass().getComponentType();
        }
        Integer nPathFor = (Integer)((SimpleJavaNode)node.getFirstChildOfType(clazz2)).jjtAccept(this, data);
        return Integer_.valueOf((int)(boolCompFor + nPathFor + 1));
    }

    @Override
    public Object visit(ASTReturnStatement node, Object data) {
        ASTExpression expr;
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTExpression = new ASTExpression[0].getClass().getComponentType();
        }
        if ((expr = (ASTExpression)node.getFirstChildOfType(clazz)) == null) {
            return NumericConstants.ONE;
        }
        Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTConditionalAndExpression;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$ast$ASTConditionalAndExpression = new ASTConditionalAndExpression[0].getClass().getComponentType();
        }
        List andNodes = expr.findChildrenOfType(clazz2);
        Class<?> clazz3 = class$net$sourceforge$pmd$ast$ASTConditionalOrExpression;
        if (clazz3 == null) {
            clazz3 = class$net$sourceforge$pmd$ast$ASTConditionalOrExpression = new ASTConditionalOrExpression[0].getClass().getComponentType();
        }
        List orNodes = expr.findChildrenOfType(clazz3);
        int boolCompReturn = andNodes.size() + orNodes.size();
        if (boolCompReturn > 0) {
            return Integer_.valueOf((int)boolCompReturn);
        }
        return NumericConstants.ONE;
    }

    @Override
    public Object visit(ASTSwitchStatement node, Object data) {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTExpression = new ASTExpression[0].getClass().getComponentType();
        }
        int boolCompSwitch = NpathComplexity.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(clazz));
        int npath = 0;
        int caseRange = 0;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            SimpleJavaNode simpleNode = (SimpleJavaNode)node.jjtGetChild(i);
            if (simpleNode instanceof ASTSwitchLabel) {
                npath += caseRange;
                caseRange = 1;
                continue;
            }
            Integer complexity = (Integer)simpleNode.jjtAccept(this, data);
            caseRange *= complexity.intValue();
        }
        return Integer_.valueOf((int)(boolCompSwitch + (npath += caseRange)));
    }

    @Override
    public Object visit(ASTTryStatement node, Object data) {
        int npath = this.complexitySumOf(node, 0, data);
        return Integer_.valueOf((int)npath);
    }

    @Override
    public Object visit(ASTConditionalExpression node, Object data) {
        if (node.isTernary()) {
            int npath = this.complexitySumOf(node, 0, data);
            return Integer_.valueOf((int)(npath += 2));
        }
        return NumericConstants.ONE;
    }

    public static int sumExpressionComplexity(ASTExpression expr) {
        if (expr == null) {
            return 0;
        }
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTConditionalAndExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTConditionalAndExpression = new ASTConditionalAndExpression[0].getClass().getComponentType();
        }
        List andNodes = expr.findChildrenOfType(clazz);
        Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTConditionalOrExpression;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$ast$ASTConditionalOrExpression = new ASTConditionalOrExpression[0].getClass().getComponentType();
        }
        List orNodes = expr.findChildrenOfType(clazz2);
        int children = 0;
        for (SimpleJavaTypeNode element : orNodes) {
            children += element.jjtGetNumChildren();
            --children;
        }
        for (SimpleJavaTypeNode element : andNodes) {
            children += element.jjtGetNumChildren();
            --children;
        }
        return children;
    }

    @Override
    protected void makeViolations(RuleContext ctx, Set<DataPoint> p) {
        for (DataPoint point : p) {
            this.addViolation((Object)ctx, (Node)point.getNode(), new String[]{((ASTMethodDeclaration)point.getNode()).getMethodName(), String.valueOf((int)point.getScore())});
        }
    }
}

