/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.filter;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.util.filter.Filter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompoundFilter<T>
implements Filter<T> {
    protected List<Filter<T>> filters;

    public AbstractCompoundFilter() {
        this.filters = new ArrayList<Filter<T>>(2);
    }

    public AbstractCompoundFilter(Filter<T> ... filters) {
        this.filters = new ArrayList<Filter<T>>(filters.length);
        for (Filter<T> filter : filters) {
            this.filters.add(filter);
        }
    }

    public List<Filter<T>> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter<T>> filters) {
        this.filters = filters;
    }

    public void addFilter(Filter<T> filter) {
        this.filters.add(filter);
    }

    protected abstract String getOperator();

    public String toString() {
        StringBuffer builder = new StringBuffer();
        builder.append("(");
        for (int i = 0; i < this.filters.size(); ++i) {
            if (i > 0) {
                builder.append(" ");
                builder.append(this.getOperator());
                builder.append(" ");
            }
            builder.append(this.filters.get(i));
        }
        builder.append(")");
        return builder.toString();
    }
}

