/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.cryptography.impl;

import egovframework.rte.fdl.cryptography.impl.aria.ARIAEngine;
import egovframework.rte.fdl.cryptography.impl.aria.AnsiX923Padding;
import java.security.InvalidKeyException;

public class ARIACipher {
    String masterKey = null;

    public void setPassword(String masterKey) {
        this.masterKey = masterKey = masterKey.length() > 32 ? masterKey.substring(0, 32) : masterKey;
    }

    public byte[] encrypt(byte[] data) {
        try {
            AnsiX923Padding padding = new AnsiX923Padding();
            byte[] mk = padding.addPadding(this.masterKey.getBytes(), 32);
            ARIAEngine instance = new ARIAEngine(256);
            return instance.encrypt(data, mk);
        }
        catch (InvalidKeyException ike) {
            throw new RuntimeException(ike);
        }
    }

    public byte[] decrypt(byte[] encryptedData) {
        try {
            AnsiX923Padding padding = new AnsiX923Padding();
            byte[] mk = padding.addPadding(this.masterKey.getBytes(), 32);
            ARIAEngine instance = new ARIAEngine(256);
            return instance.decrypt(encryptedData, mk);
        }
        catch (InvalidKeyException ike) {
            throw new RuntimeException(ike);
        }
    }
}

