/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BatchStatus {
    COMPLETED,
    STARTING,
    STARTED,
    STOPPING,
    STOPPED,
    FAILED,
    ABANDONED,
    UNKNOWN;


    public static BatchStatus max(BatchStatus status1, BatchStatus status2) {
        return status1.isGreaterThan(status2) ? status1 : status2;
    }

    public boolean isRunning() {
        return this == STARTING || this == STARTED;
    }

    public boolean isUnsuccessful() {
        return this == FAILED || this.isGreaterThan(FAILED);
    }

    public BatchStatus upgradeTo(BatchStatus other) {
        if (this.isGreaterThan(STARTED) || other.isGreaterThan(STARTED)) {
            return BatchStatus.max(this, other);
        }
        if (this == COMPLETED || other == COMPLETED) {
            return COMPLETED;
        }
        return BatchStatus.max(this, other);
    }

    public boolean isGreaterThan(BatchStatus other) {
        return this.compareTo(other) > 0;
    }

    public boolean isLessThan(BatchStatus other) {
        return this.compareTo(other) < 0;
    }

    public boolean isLessThanOrEqualTo(BatchStatus other) {
        return this.compareTo(other) <= 0;
    }

    public static BatchStatus match(String value) {
        for (BatchStatus status : BatchStatus.values()) {
            if (!value.startsWith(status.toString())) continue;
            return status;
        }
        return COMPLETED;
    }
}

