/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.configuration.DuplicateJobException;
import org.springframework.batch.core.configuration.JobFactory;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapJobRegistry
implements JobRegistry {
    private Map<String, JobFactory> map = new HashMap<String, JobFactory>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(JobFactory jobFactory) throws DuplicateJobException {
        Assert.notNull((Object)jobFactory);
        String name = jobFactory.getJobName();
        Assert.notNull((Object)name, (String)"Job configuration must have a name.");
        Map<String, JobFactory> map = this.map;
        synchronized (map) {
            if (this.map.containsKey(name)) {
                throw new DuplicateJobException("A job configuration with this name [" + name + "] was already registered");
            }
            this.map.put(name, jobFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(String name) {
        Assert.notNull((Object)name, (String)"Job configuration must have a name.");
        Map<String, JobFactory> map = this.map;
        synchronized (map) {
            this.map.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Job getJob(String name) throws NoSuchJobException {
        Map<String, JobFactory> map = this.map;
        synchronized (map) {
            if (!this.map.containsKey(name)) {
                throw new NoSuchJobException("No job configuration with the name [" + name + "] was registered");
            }
            return this.map.get(name).createJob();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getJobNames() {
        Map<String, JobFactory> map = this.map;
        synchronized (map) {
            return Collections.unmodifiableCollection(new HashSet<String>(this.map.keySet()));
        }
    }
}

