/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.util.Map;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.support.SerializationUtils;
import org.springframework.batch.support.transaction.TransactionAwareProxyFactory;

public class MapExecutionContextDao
implements ExecutionContextDao {
    private Map<Long, ExecutionContext> contextsByStepExecutionId = TransactionAwareProxyFactory.createAppendOnlyTransactionalMap();
    private Map<Long, ExecutionContext> contextsByJobExecutionId = TransactionAwareProxyFactory.createAppendOnlyTransactionalMap();

    public void clear() {
        this.contextsByJobExecutionId.clear();
        this.contextsByStepExecutionId.clear();
    }

    private static ExecutionContext copy(ExecutionContext original) {
        return (ExecutionContext)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Object)original));
    }

    public ExecutionContext getExecutionContext(StepExecution stepExecution) {
        return MapExecutionContextDao.copy(this.contextsByStepExecutionId.get(stepExecution.getId()));
    }

    public void updateExecutionContext(StepExecution stepExecution) {
        ExecutionContext executionContext = stepExecution.getExecutionContext();
        if (executionContext != null) {
            this.contextsByStepExecutionId.put(stepExecution.getId(), MapExecutionContextDao.copy(executionContext));
        }
    }

    public ExecutionContext getExecutionContext(JobExecution jobExecution) {
        return MapExecutionContextDao.copy(this.contextsByJobExecutionId.get(jobExecution.getId()));
    }

    public void updateExecutionContext(JobExecution jobExecution) {
        ExecutionContext executionContext = jobExecution.getExecutionContext();
        if (executionContext != null) {
            this.contextsByJobExecutionId.put(jobExecution.getId(), MapExecutionContextDao.copy(executionContext));
        }
    }

    public void saveExecutionContext(JobExecution jobExecution) {
        this.updateExecutionContext(jobExecution);
    }

    public void saveExecutionContext(StepExecution stepExecution) {
        this.updateExecutionContext(stepExecution);
    }
}

