/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.cryptography.impl;

import egovframework.rte.fdl.cryptography.EgovDigestService;
import org.jasypt.digest.StandardByteDigester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EgovDigestServiceImpl
implements EgovDigestService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EgovDigestServiceImpl.class);
    private static final int DEFAULT_STRONG_ITERATIONS = 1000;
    private static final int DEFAULT_STRONG_SALT_SIZE = 8;
    private String algorithm = "SHA-256";
    private boolean plainDigest = false;
    private int strongIterations = 1000;
    private int strongSaltSizeBytes = 8;

    @Override
    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public void setPlainDigest(boolean plainDigest) {
        this.plainDigest = plainDigest;
    }

    @Override
    public boolean isPlainDigest() {
        return this.plainDigest;
    }

    @Override
    public byte[] digest(byte[] data) {
        StandardByteDigester digester = new StandardByteDigester();
        digester.setAlgorithm(this.algorithm);
        LOGGER.debug("Digest's algorithm : {}", (Object)this.algorithm);
        if (this.plainDigest) {
            digester.setIterations(1);
            digester.setSaltSizeBytes(0);
        } else {
            digester.setIterations(this.strongIterations);
            digester.setSaltSizeBytes(this.strongSaltSizeBytes);
        }
        return digester.digest(data);
    }

    @Override
    public boolean matches(byte[] messageByte, byte[] digestByte) {
        StandardByteDigester digester = new StandardByteDigester();
        digester.setAlgorithm(this.algorithm);
        LOGGER.debug("Digest's algorithm : {}", (Object)this.algorithm);
        if (this.plainDigest) {
            digester.setIterations(1);
            digester.setSaltSizeBytes(0);
        } else {
            digester.setIterations(this.strongIterations);
            digester.setSaltSizeBytes(this.strongSaltSizeBytes);
        }
        return digester.matches(messageByte, digestByte);
    }
}

